/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules;

import controller_msgs.msg.dds.RobotConfigurationData;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.tools.thread.CloseableAndDisposable;

public class ZeroPoseMockRobotConfigurationDataPublisherModule
implements Runnable,
CloseableAndDisposable {
    private final ROS2Node ros2Node = new ROS2NodeBuilder().build("ihmc_zero_pose_mock_node");
    private final ROS2Publisher<RobotConfigurationData> publisher;
    private final FullHumanoidRobotModel fullRobotModel;
    private final ForceSensorDefinition[] forceSensorDefinitions;
    private long timeStamp = 0L;
    private volatile boolean running = true;

    public ZeroPoseMockRobotConfigurationDataPublisherModule(DRCRobotModel robotModel) {
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.forceSensorDefinitions = this.fullRobotModel.getForceSensorDefinitions();
        this.publisher = this.ros2Node.createPublisher(HumanoidControllerAPI.getOutputTopic((String)robotModel.getSimpleRobotName()).withTypeName(RobotConfigurationData.class));
        Thread t = new Thread(this);
        t.start();
    }

    public void sendMockRobotConfiguration(long totalNsecs) {
        IMUDefinition[] imuDefinitions = this.fullRobotModel.getIMUDefinitions();
        RobotConfigurationData robotConfigurationData = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel), (ForceSensorDefinition[])this.forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        for (int sensorNumber = 0; sensorNumber < imuDefinitions.length; ++sensorNumber) {
            robotConfigurationData.getImuSensorData().add();
        }
        robotConfigurationData.setRobotMotionStatus(RobotMotionStatus.STANDING.toByte());
        robotConfigurationData.setWallTime(totalNsecs);
        robotConfigurationData.setMonotonicTime(totalNsecs);
        Vector3D translation = new Vector3D();
        Quaternion orientation = new Quaternion();
        robotConfigurationData.getRootPosition().set((Tuple3DReadOnly)translation);
        robotConfigurationData.getRootOrientation().set(orientation);
        this.publisher.publish((Object)robotConfigurationData);
    }

    @Override
    public void run() {
        while (this.running) {
            this.sendMockRobotConfiguration(this.timeStamp);
            this.timeStamp += 250000000L;
            ThreadTools.sleep((long)250L);
        }
    }

    public void closeAndDispose() {
        this.running = false;
        this.ros2Node.destroy();
    }
}

