/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public abstract class ToolboxController {
    protected static final boolean DEBUG = false;
    protected final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    protected final StatusMessageOutputManager statusOutputManager;
    private final YoBoolean initialize = new YoBoolean("initialize" + this.registry.getName(), this.registry);
    private ScheduledFuture<?> futureToListenTo;
    private final List<Runnable> updateThreadRunnables = new ArrayList<Runnable>();

    public ToolboxController(StatusMessageOutputManager statusOutputManager, YoRegistry parentRegistry) {
        this.statusOutputManager = statusOutputManager;
        parentRegistry.addChild(this.registry);
        this.requestInitialize();
    }

    public void requestInitialize() {
        this.initialize.set(true);
    }

    public void update() {
        if (this.initialize.getBooleanValue()) {
            if (!this.initialize()) {
                return;
            }
            this.initialize.set(false);
        }
        try {
            this.updateInternal();
            for (int i = 0; i < this.updateThreadRunnables.size(); ++i) {
                this.updateThreadRunnables.get(i).run();
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        if (this.futureToListenTo != null && this.futureToListenTo.isDone()) {
            try {
                this.futureToListenTo.get();
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace();
            }
            catch (InterruptedException exception) {
                exception.getCause().printStackTrace();
            }
            throw new RuntimeException("Toolbox controller thread crashed.");
        }
    }

    public void setFutureToListenTo(ScheduledFuture<?> future) {
        this.futureToListenTo = future;
    }

    public void notifyToolboxStateChange(ToolboxState newState) {
    }

    public boolean hasBeenInitialized() {
        return !this.initialize.getValue();
    }

    public <S extends Settable<S>> void reportMessage(S statusMessage) {
        this.statusOutputManager.reportStatusMessage(statusMessage);
    }

    public abstract boolean initialize();

    public abstract void updateInternal() throws Exception;

    public abstract boolean isDone();

    public void addUpdateThreadRunnable(Runnable runnable) {
        this.updateThreadRunnables.add(runnable);
    }
}

