/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.lidarScanPublisher;

import us.ihmc.communication.packets.ScanPointFilter;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.perception.depthData.PointCloudData;

public class ShadowScanPointFilter
implements ScanPointFilter {
    public static final double DEFAULT_SHADOW_ANGLE_THRESHOLD = Math.toRadians(12.0);
    private double shadowAngleThreshold = DEFAULT_SHADOW_ANGLE_THRESHOLD;
    private final Vector3D fromLidarToScanPoint = new Vector3D();
    private final Vector3D currentToNextScanPoint = new Vector3D();
    private final Vector3D previousToCurrentScanPoint = new Vector3D();
    private Point3DReadOnly sensorPosition;
    private PointCloudData pointCloudData;

    public void setShadowAngleThreshold(double shadowAngleThreshold) {
        this.shadowAngleThreshold = shadowAngleThreshold;
    }

    public void set(Point3DReadOnly sensorPosition, PointCloudData pointCloudData) {
        this.sensorPosition = sensorPosition;
        this.pointCloudData = pointCloudData;
    }

    public boolean test(int index, Point3DReadOnly currentScanPoint) {
        if (this.shadowAngleThreshold <= 0.0 || index == 0 || index == this.pointCloudData.getNumberOfPoints() - 1) {
            return true;
        }
        Point3D[] pointCloud = this.pointCloudData.getPointCloud();
        Point3D previousScanPoint = pointCloud[index - 1];
        this.fromLidarToScanPoint.sub((Tuple3DReadOnly)currentScanPoint, (Tuple3DReadOnly)this.sensorPosition);
        this.previousToCurrentScanPoint.sub((Tuple3DReadOnly)currentScanPoint, (Tuple3DReadOnly)previousScanPoint);
        if (this.fromLidarToScanPoint.dot((Tuple3DReadOnly)this.previousToCurrentScanPoint) < 0.0) {
            this.previousToCurrentScanPoint.negate();
        }
        if (this.fromLidarToScanPoint.angle((Vector3DReadOnly)this.previousToCurrentScanPoint) < this.shadowAngleThreshold) {
            return false;
        }
        Point3D nextScanPoint = pointCloud[index + 1];
        this.currentToNextScanPoint.sub((Tuple3DReadOnly)nextScanPoint, (Tuple3DReadOnly)currentScanPoint);
        if (this.fromLidarToScanPoint.dot((Tuple3DReadOnly)this.currentToNextScanPoint) < 0.0) {
            this.currentToNextScanPoint.negate();
        }
        return !(this.fromLidarToScanPoint.angle((Vector3DReadOnly)this.currentToNextScanPoint) < this.shadowAngleThreshold);
    }
}

