/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.lidarScanPublisher;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.net.URI;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.LidarScanMessage;
import perception_msgs.msg.dds.LidarScanParametersMessage;
import perception_msgs.msg.dds.SimulatedLidarScanPacket;
import scan_to_cloud.PointCloud2WithSource;
import sensor_msgs.PointCloud2;
import us.ihmc.avatar.networkProcessor.lidarScanPublisher.ScanPointFilterList;
import us.ihmc.avatar.networkProcessor.lidarScanPublisher.ShadowScanPointFilter;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.RangeScanPointFilter;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.net.ObjectConsumer;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.ScanPointFilter;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.idl.IDLSequence;
import us.ihmc.perception.depthData.CollisionBoxProvider;
import us.ihmc.perception.depthData.CollisionShapeTester;
import us.ihmc.perception.depthData.PointCloudData;
import us.ihmc.perception.filters.CollidingScanPointFilter;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.robotics.lidar.LidarScan;
import us.ihmc.robotics.lidar.LidarScanParameters;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataBuffer;
import us.ihmc.tools.thread.ExceptionHandlingThreadScheduler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class LidarScanPublisher {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int DEFAULT_MAX_NUMBER_OF_POINTS = 5000;
    private final String name = this.getClass().getSimpleName();
    private final ExceptionHandlingThreadScheduler executorService = new ExceptionHandlingThreadScheduler(this.name, DefaultExceptionHandler.PRINT_STACKTRACE);
    private ScheduledFuture<?> publisherTask;
    private final AtomicReference<PointCloudData> rosPointCloud2ToPublish = new AtomicReference<Object>(null);
    private final String robotName;
    private final FullRobotModel fullRobotModel;
    private final ReferenceFrame lidarSensorFrame;
    private ReferenceFrame scanPointsFrame = worldFrame;
    private final RobotConfigurationDataBuffer robotConfigurationDataBuffer = new RobotConfigurationDataBuffer();
    private RobotROSClockCalculator rosClockCalculator = null;
    private final ROS2Publisher<LidarScanMessage> lidarScanPublisher;
    private int maximumNumberOfPoints = 5000;
    private RangeScanPointFilter rangeFilter = null;
    private ShadowScanPointFilter shadowFilter = null;
    private CollidingScanPointFilter collisionFilter = null;
    private final ScanPointFilterList activeFilters = new ScanPointFilterList();
    private long publisherPeriodInMillisecond = 1L;
    private final Pose3D sensorPose = new Pose3D();
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();

    public LidarScanPublisher(String lidarName, FullRobotModelFactory modelFactory, ROS2Node ros2Node) {
        this(lidarName, modelFactory, ros2Node, ROS2QosProfile.RELIABLE());
    }

    public LidarScanPublisher(String lidarName, FullRobotModelFactory modelFactory, ROS2Node ros2Node, ROS2QosProfile qosProfile) {
        this(modelFactory, LidarScanPublisher.defaultSensorFrameFactory(lidarName), ros2Node, qosProfile);
    }

    public LidarScanPublisher(FullRobotModelFactory modelFactory, SensorFrameFactory sensorFrameFactory, ROS2Node ros2Node) {
        this(modelFactory, sensorFrameFactory, ros2Node, ROS2QosProfile.RELIABLE());
    }

    public LidarScanPublisher(FullRobotModelFactory modelFactory, SensorFrameFactory sensorFrameFactory, ROS2Node ros2Node, ROS2QosProfile qosProfile) {
        this(modelFactory.getRobotDefinition().getName(), modelFactory.createFullRobotModel(), sensorFrameFactory, ros2Node, qosProfile);
    }

    public LidarScanPublisher(String robotName, FullRobotModel fullRobotModel, SensorFrameFactory sensorFrameFactory, ROS2Node ros2Node) {
        this(robotName, fullRobotModel, sensorFrameFactory, ros2Node, ROS2QosProfile.RELIABLE());
    }

    public LidarScanPublisher(String robotName, FullRobotModel fullRobotModel, SensorFrameFactory sensorFrameFactory, ROS2Node ros2Node, ROS2QosProfile qosProfile) {
        this.robotName = robotName;
        this.fullRobotModel = fullRobotModel;
        this.lidarSensorFrame = sensorFrameFactory.setupSensorFrame(fullRobotModel);
        ros2Node.createSubscription(StateEstimatorAPI.getRobotConfigurationDataTopic((String)robotName), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
        this.lidarScanPublisher = ros2Node.createPublisher(PerceptionAPI.MULTISENSE_LIDAR_SCAN);
    }

    public void setMaximumNumberOfPoints(int maximumNumberOfPoints) {
        this.maximumNumberOfPoints = maximumNumberOfPoints;
    }

    public void setPublisherPeriodInMillisecond(long publisherPeriodInMillisecond) {
        this.publisherPeriodInMillisecond = publisherPeriodInMillisecond;
        if (this.publisherTask != null) {
            this.publisherTask.cancel(false);
            this.start();
        }
    }

    public void start() {
        this.publisherTask = this.executorService.schedule(this::readAndPublishInternal, this.publisherPeriodInMillisecond, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.publisherTask.cancel(false);
        this.executorService.shutdown();
    }

    public void setScanFrameToLidarSensorFrame() {
        this.scanPointsFrame = this.lidarSensorFrame;
    }

    public void setRangeFilter(double minRange, double maxRange) {
        if (this.rangeFilter == null) {
            this.rangeFilter = new RangeScanPointFilter();
            this.activeFilters.addFilter(this.rangeFilter);
        }
        this.rangeFilter.setMinRange(minRange);
        this.rangeFilter.setMaxRange(maxRange);
    }

    public void setShadowFilter() {
        this.setShadowFilter(ShadowScanPointFilter.DEFAULT_SHADOW_ANGLE_THRESHOLD);
    }

    public void setShadowFilter(double angleThreshold) {
        if (this.shadowFilter == null) {
            this.shadowFilter = new ShadowScanPointFilter();
            this.activeFilters.addFilter(this.shadowFilter);
        }
        this.shadowFilter.setShadowAngleThreshold(angleThreshold);
    }

    public void setSelfCollisionFilter(CollisionBoxProvider collisionBoxProvider) {
        if (this.collisionFilter != null) {
            return;
        }
        this.collisionFilter = new CollidingScanPointFilter(new CollisionShapeTester(this.fullRobotModel, collisionBoxProvider));
        this.activeFilters.addFilter((ScanPointFilter)this.collisionFilter);
    }

    public void receiveLidarFromROS(String lidarScanROSTopic, URI rosCoreURI) {
        String graphName = this.robotName + "/" + this.name;
        RosMainNode rosMainNode = new RosMainNode(rosCoreURI, graphName, true);
        this.receiveLidarFromROS(lidarScanROSTopic, rosMainNode);
    }

    public void receiveLidarFromROS(String lidarScanROSTopic, RosMainNode rosMainNode) {
        rosMainNode.attachSubscriber(lidarScanROSTopic, (RosTopicSubscriberInterface)this.createROSPointCloud2Subscriber());
    }

    public void receiveLidarFromROSAsPointCloud2WithSource(String lidarScanROSTopic, RosMainNode rosMainNode) {
        rosMainNode.attachSubscriber(lidarScanROSTopic, this.createROSPointCloud2WithSourceSubscriber());
    }

    public void receiveLidarFromSCS(ObjectCommunicator scsSensorsCommunicator) {
        scsSensorsCommunicator.attachListener(SimulatedLidarScanPacket.class, this.createSimulatedLidarScanPacketConsumer());
    }

    public void setScanFrameToWorldFrame() {
        this.scanPointsFrame = worldFrame;
    }

    public void setROSClockCalculator(RobotROSClockCalculator rosClockCalculator) {
        this.rosClockCalculator = rosClockCalculator;
    }

    private RosPointCloudSubscriber createROSPointCloud2Subscriber() {
        return new RosPointCloudSubscriber(){

            public void onNewMessage(PointCloud2 pointCloud) {
                LidarScanPublisher.this.rosPointCloud2ToPublish.set(new PointCloudData(pointCloud, LidarScanPublisher.this.maximumNumberOfPoints, false));
            }
        };
    }

    private RosTopicSubscriberInterface<PointCloud2WithSource> createROSPointCloud2WithSourceSubscriber() {
        return new AbstractRosTopicSubscriber<PointCloud2WithSource>("scan_to_cloud/PointCloud2WithSource"){

            public void onNewMessage(PointCloud2WithSource pointCloud) {
                LidarScanPublisher.this.rosPointCloud2ToPublish.set(new PointCloudData(pointCloud.getCloud(), LidarScanPublisher.this.maximumNumberOfPoints, false));
            }
        };
    }

    private ObjectConsumer<SimulatedLidarScanPacket> createSimulatedLidarScanPacketConsumer() {
        return new ObjectConsumer<SimulatedLidarScanPacket>(){
            private final RigidBodyTransform identityTransform = new RigidBodyTransform();

            public void consumeObject(SimulatedLidarScanPacket packet) {
                LidarScanParameters lidarScanParameters = MessageTools.toLidarScanParameters((LidarScanParametersMessage)packet.getLidarScanParameters());
                IDLSequence.Float ranges = packet.getRanges();
                int sensorId = packet.getSensorId();
                LidarScan scan = new LidarScan(lidarScanParameters, ranges.toArray(), sensorId);
                scan.setWorldTransforms(this.identityTransform, this.identityTransform);
                Point3D[] scanPoints = scan.toPointArray();
                long timestamp = packet.getLidarScanParameters().getTimestamp();
                LidarScanPublisher.this.rosPointCloud2ToPublish.set(new PointCloudData(timestamp, scanPoints, null));
            }
        };
    }

    public void updateScanData(PointCloudData scanDataToPublish) {
        this.rosPointCloud2ToPublish.set(scanDataToPublish);
    }

    public LidarScanMessage readAndPublish() {
        if (this.publisherTask != null) {
            throw new RuntimeException("The publisher is running using its own thread, cannot manually update it.");
        }
        return this.readAndPublishInternal();
    }

    private LidarScanMessage readAndPublishInternal() {
        PointCloudData pointCloudData = this.rosPointCloud2ToPublish.getAndSet(null);
        if (pointCloudData == null) {
            return null;
        }
        if (this.rosClockCalculator == null) {
            long robotTimestamp = pointCloudData.getTimestamp();
            this.robotConfigurationDataBuffer.updateFullRobotModelWithNewestData(this.fullRobotModel, null);
        } else {
            boolean success;
            long rosTimestamp = pointCloudData.getTimestamp();
            long robotTimestamp = this.rosClockCalculator.computeRobotMonotonicTime(rosTimestamp);
            if (robotTimestamp == -1L) {
                return null;
            }
            boolean waitForTimestamp = true;
            if (this.robotConfigurationDataBuffer.getNewestTimestamp() == -1L) {
                return null;
            }
            boolean bl = success = this.robotConfigurationDataBuffer.updateFullRobotModel(waitForTimestamp, robotTimestamp, this.fullRobotModel, null) != -1L;
            if (!success) {
                return null;
            }
        }
        if (!this.scanPointsFrame.isWorldFrame()) {
            this.scanPointsFrame.getTransformToDesiredFrame(this.transformToWorld, worldFrame);
            pointCloudData.applyTransform(this.transformToWorld);
        }
        this.sensorPose.set((RigidBodyTransformReadOnly)this.lidarSensorFrame.getTransformToRoot());
        if (this.shadowFilter != null) {
            this.shadowFilter.set((Point3DReadOnly)this.sensorPose.getPosition(), pointCloudData);
        }
        if (this.collisionFilter != null) {
            this.collisionFilter.update();
        }
        if (this.rangeFilter != null) {
            this.rangeFilter.setSensorPosition((Point3DReadOnly)this.sensorPose.getPosition());
        }
        LidarScanMessage message = pointCloudData.toLidarScanMessage((ScanPointFilter)this.activeFilters);
        message.getLidarPosition().set(this.sensorPose.getPosition());
        message.getLidarOrientation().set(this.sensorPose.getOrientation());
        this.lidarScanPublisher.publish((Object)message);
        return message;
    }

    public static SensorFrameFactory defaultSensorFrameFactory(String lidarName) {
        return fullRobotModel -> ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"lidarSensorFrame", (ReferenceFrame)fullRobotModel.getLidarBaseFrame(lidarName), (RigidBodyTransformReadOnly)fullRobotModel.getLidarBaseToSensorTransform(lidarName));
    }

    public static interface SensorFrameFactory {
        public ReferenceFrame setupSensorFrame(FullRobotModel var1);
    }
}

