/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.SensitivityBasedStabilityGradientCalculator;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StabilityMarginRegionCalculator;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.WholeBodyContactState;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class StabilityMarginKinematicsCostCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final WholeBodyContactState wholeBodyContactState;
    private final StabilityMarginRegionCalculator multiContactRegionCalculator;
    private final SensitivityBasedStabilityGradientCalculator stabilityGradientCalculator;
    private final FullHumanoidRobotModel fullRobotModel;
    private final BooleanProvider isUpperBodyLoadBearing;
    private final DoubleProvider minStabilityMargin;
    private final YoBoolean isEnabled = new YoBoolean("isStabilityObjectiveEnabled", this.registry);
    private final YoDouble desiredStabilityMarginVelocity = new YoDouble("desiredStabilityMarginVelocity", this.registry);
    private final YoDouble maxMarginToPenalize = new YoDouble("maxMarginToPenalize", this.registry);
    private final YoDouble stabilityMarginWeight = new YoDouble("stabilityMarginWeight", this.registry);
    private final FramePose3D pelvisControlFramePose = new FramePose3D();
    private final FramePose3D pelvisPose = new FramePose3D();
    private final SpatialVector desiredPelvisSpatialVelocity = new SpatialVector();

    public StabilityMarginKinematicsCostCalculator(WholeBodyContactState wholeBodyContactState, StabilityMarginRegionCalculator multiContactRegionCalculator, FullHumanoidRobotModel fullRobotModel, BooleanProvider isUpperBodyLoadBearing, DoubleProvider minStabilityMargin, CentroidalMomentumCalculator centroidalMomentumCalculator, YoRegistry parentRegistry) {
        this.wholeBodyContactState = wholeBodyContactState;
        this.multiContactRegionCalculator = multiContactRegionCalculator;
        this.fullRobotModel = fullRobotModel;
        this.isUpperBodyLoadBearing = isUpperBodyLoadBearing;
        this.minStabilityMargin = minStabilityMargin;
        this.desiredStabilityMarginVelocity.set(0.15);
        this.maxMarginToPenalize.set(0.12);
        this.stabilityMarginWeight.set(0.5);
        MovingReferenceFrame afterRootJointFrame = fullRobotModel.getPelvis().getParentJoint().getFrameAfterJoint();
        this.pelvisControlFramePose.setToZero((ReferenceFrame)afterRootJointFrame);
        this.pelvisControlFramePose.changeFrame((ReferenceFrame)fullRobotModel.getPelvis().getBodyFixedFrame());
        this.stabilityGradientCalculator = new SensitivityBasedStabilityGradientCalculator(fullRobotModel, wholeBodyContactState, multiContactRegionCalculator, centroidalMomentumCalculator, this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void setEnabled(boolean enable) {
        this.isEnabled.set(enable);
    }

    public void addPostureFeedbackCommands(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.isEnabled.getBooleanValue() || !this.isUpperBodyLoadBearing.getValue()) {
            return;
        }
        double stabilityMargin = this.multiContactRegionCalculator.getStabilityMargin();
        if (stabilityMargin > this.maxMarginToPenalize.getValue()) {
            return;
        }
        double deltaStabilityMargin = stabilityMargin - this.minStabilityMargin.getValue();
        double alpha = EuclidCoreTools.clamp((double)(deltaStabilityMargin / this.minStabilityMargin.getValue()), (double)0.0, (double)1.0);
        double weight = alpha * this.stabilityMarginWeight.getValue();
        this.stabilityGradientCalculator.update();
        DMatrixRMaj stabilityMarginGradient = this.stabilityGradientCalculator.getStabilityMarginGradient();
        double stabilityGradientMagnitude = CommonOps_DDRM.dot((DMatrixD1)stabilityMarginGradient, (DMatrixD1)stabilityMarginGradient);
        if (stabilityGradientMagnitude < 1.0E-5) {
            return;
        }
        double gradientScalar = this.desiredStabilityMarginVelocity.getValue() / stabilityGradientMagnitude;
        OneDoFJointBasics[] oneDoFJoints = this.wholeBodyContactState.getOneDoFJoints();
        for (int joint_idx = 0; joint_idx < this.wholeBodyContactState.getNumberOfJoints(); ++joint_idx) {
            OneDoFJointBasics joint = oneDoFJoints[joint_idx];
            OneDoFJointFeedbackControlCommand jointFeedbackCommand = bufferToPack.addOneDoFJointFeedbackControlCommand();
            jointFeedbackCommand.setJoint(joint);
            jointFeedbackCommand.setWeightForSolver(weight);
            int jointIndex = 6 + joint_idx;
            double qd_ff = gradientScalar * stabilityMarginGradient.get(jointIndex);
            jointFeedbackCommand.setInverseKinematics(joint.getQ(), qd_ff);
            jointFeedbackCommand.getGains().setKp(0.0);
            jointFeedbackCommand.getGains().setKd(0.0);
        }
        this.pelvisPose.setToZero((ReferenceFrame)this.fullRobotModel.getPelvis().getBodyFixedFrame());
        this.pelvisPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.desiredPelvisSpatialVelocity.set((DMatrix)stabilityMarginGradient);
        this.desiredPelvisSpatialVelocity.scale(gradientScalar);
        SpatialFeedbackControlCommand spatialFeedbackControlCommand = bufferToPack.addSpatialFeedbackControlCommand();
        spatialFeedbackControlCommand.set(this.fullRobotModel.getRootBody(), this.fullRobotModel.getPelvis());
        spatialFeedbackControlCommand.setInverseKinematics((FramePose3DReadOnly)this.pelvisPose, (SpatialVectorReadOnly)this.desiredPelvisSpatialVelocity);
        spatialFeedbackControlCommand.setWeightForSolver(weight);
        spatialFeedbackControlCommand.getControlFramePose().set((FramePose3DReadOnly)this.pelvisControlFramePose);
        spatialFeedbackControlCommand.getGains().getPositionGains().setProportionalGains(0.0);
        spatialFeedbackControlCommand.getGains().getPositionGains().setDerivativeGains(0.0);
        spatialFeedbackControlCommand.getGains().getOrientationGains().setProportionalGains(0.0);
        spatialFeedbackControlCommand.getGains().getOrientationGains().setDerivativeGains(0.0);
    }
}

