/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.List;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.HumanoidKinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxInputCollectionCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxOneDoFJointCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxSupportRegionCommand;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;

public class KinematicsToolboxModule
extends ToolboxModule {
    private static final boolean DEFAULT_SETUP_INITIAL_CONFIGURATION = true;
    private final HumanoidKinematicsToolboxController kinematicsToolBoxController;
    private final KinematicsToolboxController.RobotConfigurationDataBasedUpdater robotStateUpdater = new KinematicsToolboxController.RobotConfigurationDataBasedUpdater();

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node realtimeROS2Node) {
        this(robotModel, startYoVariableServer, 1, true, realtimeROS2Node);
    }

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer) {
        this(robotModel, startYoVariableServer, 1);
    }

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, int updatePeriodMilliseconds) {
        this(robotModel, startYoVariableServer, updatePeriodMilliseconds, true);
    }

    public KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, int updatePeriodMilliseconds, boolean setupInitialConfiguration) {
        this(robotModel, startYoVariableServer, updatePeriodMilliseconds, setupInitialConfiguration, null);
    }

    private KinematicsToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, int updatePeriodMilliseconds, boolean setupInitialConfiguration, RealtimeROS2Node realtimeROS2Node) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, updatePeriodMilliseconds, (ROS2Node)realtimeROS2Node);
        this.kinematicsToolBoxController = new HumanoidKinematicsToolboxController(this.commandInputManager, this.statusOutputManager, this.fullRobotModel, 0.001, this.yoGraphicsListRegistry, this.registry);
        this.kinematicsToolBoxController.setDesiredRobotStateUpdater(this.robotStateUpdater);
        if (setupInitialConfiguration) {
            this.kinematicsToolBoxController.setInitialRobotConfiguration(robotModel);
        }
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(this.fullRobotModel, (ReferenceFrames)this.kinematicsToolBoxController.getDesiredReferenceFrames()));
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        RobotConfigurationData robotConfigurationData = new RobotConfigurationData();
        ros2Node.createSubscription(StateEstimatorAPI.getRobotConfigurationDataTopic((String)this.robotName), s -> {
            if (this.kinematicsToolBoxController != null) {
                s.takeNextData((Object)robotConfigurationData, null);
                this.robotStateUpdater.setRobotConfigurationData(robotConfigurationData);
            }
        });
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        ros2Node.createSubscription(HumanoidControllerAPI.getTopic(CapturabilityBasedStatus.class, (String)this.robotName), s -> {
            if (this.kinematicsToolBoxController != null) {
                s.takeNextData((Object)capturabilityBasedStatus, null);
                this.kinematicsToolBoxController.updateCapturabilityBasedStatus(capturabilityBasedStatus);
            }
        });
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return KinematicsToolboxModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(KinematicsToolboxCenterOfMassCommand.class);
        commands.add(KinematicsToolboxRigidBodyCommand.class);
        commands.add(KinematicsToolboxOneDoFJointCommand.class);
        commands.add(KinematicsToolboxConfigurationCommand.class);
        commands.add(KinematicsToolboxSupportRegionCommand.class);
        commands.add(KinematicsToolboxPrivilegedConfigurationCommand.class);
        commands.add(KinematicsToolboxInputCollectionCommand.class);
        commands.add(HumanoidKinematicsToolboxConfigurationCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return KinematicsToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(KinematicsToolboxOutputStatus.class);
        return status;
    }

    @Override
    public KinematicsToolboxController getToolboxController() {
        return this.kinematicsToolBoxController;
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return KinematicsToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ToolboxAPIs.KINEMATICS_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return KinematicsToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ToolboxAPIs.KINEMATICS_TOOLBOX.withRobot(robotName).withInput();
    }
}

