/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.RobotConfigurationData;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsCollisionFrame;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsSolutionQualityCalculator;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxOptimizationSettings;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxPrivilegedConfigurationParameters;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.LinearMomentumConvexConstraint2DCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBPoint3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBQuaternion3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointTorqueMinimizationWeightCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointTorqueSoftLimitWeightCalculator;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxInputCollectionCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxOneDoFJointCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxSupportRegionCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class KinematicsToolboxController
extends ToolboxController {
    private static final double GRAVITY = 9.81;
    private static final double GLOBAL_PROPORTIONAL_GAIN = 1200.0;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected final double updateDT;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    protected final RigidBodyBasics rootBody;
    protected final FloatingJointBasics rootJoint;
    private final double totalRobotMass;
    protected final OneDoFJointBasics[] desiredOneDoFJoints;
    private final List<? extends RigidBodyBasics> controllableRigidBodies;
    protected final ReferenceFrame centerOfMassFrame;
    private final YoPIDSE3Gains spatialGains;
    private final YoPIDGains jointGains;
    private JointTorqueSoftLimitWeightCalculator jointTorqueMinimizationWeightCalculator;
    private final KinematicsToolboxOptimizationSettings optimizationSettings;
    private final InverseKinematicsOptimizationSettingsCommand activeOptimizationSettings;
    private final ControllerCoreCommandBuffer controllerCoreCommand;
    protected final WholeBodyControllerCore controllerCore;
    private final FeedbackControllerDataHolderReadOnly feedbackControllerDataHolder;
    private final KinematicsToolboxOutputStatus inverseKinematicsSolution;
    private final YoDouble timeLastSolutionPublished;
    private final YoDouble publishSolutionPeriod;
    private final YoDouble solutionQuality;
    private final KinematicsSolutionQualityCalculator solutionQualityCalculator;
    private final FeedbackControlCommandList allFeedbackControlCommands;
    private final YoDouble privilegedNullspaceAlpha;
    private double defaultPrivilegedNullspaceAlpha;
    private final YoDouble privilegedWeight;
    private double defaultPrivilegedWeight;
    private final YoDouble privilegedConfigurationGain;
    private double defaultPrivilegedConfigurationGain;
    private final YoDouble privilegedMaxVelocity;
    private double defaultPrivilegedMaxVelocity;
    protected TObjectDoubleHashMap<OneDoFJointBasics> initialRobotConfigurationMap;
    private boolean submitPrivilegedConfigurationCommand;
    private final PrivilegedConfigurationCommand privilegedConfigurationCommand;
    protected final CommandInputManager commandInputManager;
    private final List<RigidBodyBasics> rigidBodiesWithVisualization;
    private final Map<RigidBodyBasics, YoGraphicCoordinateSystem> desiredCoodinateSystems;
    private final Map<RigidBodyBasics, YoGraphicCoordinateSystem> currentCoodinateSystems;
    protected final YoFramePoint3D yoDesiredCenterOfMass;
    protected final YoFramePoint3D yoCurrentCenterOfMass;
    protected final YoGraphicPosition desiredCenterOfMassGraphic;
    protected final YoGraphicPosition currentCenterOfMassGraphic;
    protected IKRobotStateUpdater desiredRobotStateUpdater;
    private final FeedbackControlCommandBuffer userFBCommands;
    private final FeedbackControlCommandBuffer previousUserFBCommands;
    private final YoBoolean isUserProvidingSupportPolygon;
    private final List<FramePoint3DReadOnly> contactPointLocations;
    protected final ConvexPolygon2D supportPolygon;
    protected final RecyclingArrayList<Point2D> shrunkSupportPolygonVertices;
    private final ConvexPolygonScaler convexPolygonScaler;
    private final FrameConvexPolygon2D newSupportPolygon;
    protected final ConvexPolygon2D shrunkSupportPolygon;
    protected final FramePoint3D centerOfMass;
    private final YoDouble centerOfMassSafeMargin;
    private final double robotMass;
    protected final YoBoolean enableSupportPolygonConstraint;
    private final YoInteger numberOfActiveCommands;
    private final YoBoolean preserveUserCommandHistory;
    private final List<Collidable> robotCollidables;
    private final List<Collidable> staticCollidables;
    private final YoBoolean enableSelfCollisionAvoidance;
    private final YoBoolean enableStaticCollisionAvoidance;
    private final RecyclingArrayList<CollisionResult> collisionResults;
    private final RecyclingArrayList<KinematicsCollisionFrame> collisionFrames;
    private final YoDouble collisionActivationDistanceThreshold;
    private final YoDouble collisionMinDistance;
    private final YoDouble maxSelfCollisionResolutionVelocity;
    private final YoDouble maxStaticCollisionResolutionVelocity;
    private final int numberOfCollisionsToVisualize = 20;
    private final YoDouble[] yoCollisionDistances;
    private final YoFramePoint3D[] yoCollisionPointAs;
    private final YoFramePoint3D[] yoCollisionPointBs;
    private final YoFramePose3D[] yoCollisionFramePoses;
    protected final ThreadTimer threadTimer;
    private final YoBoolean minimizeAngularMomentum;
    private final YoBoolean minimizeLinearMomentum;
    private final YoVector3D angularMomentumWeight;
    private final YoVector3D linearMomentumWeight;
    private final MomentumCommand momentumCommand;
    private final YoBoolean minimizeAngularMomentumRate;
    private final YoBoolean minimizeLinearMomentumRate;
    private final YoVector3D angularMomentumRateWeight;
    private final YoVector3D linearMomentumRateWeight;
    private final MomentumCommand momentumCommandForRateMinimization;
    protected boolean firstTick;
    private final List<FBPoint3D> rigidBodyPositions;
    private final List<FBQuaternion3D> rigidBodyOrientations;

    public KinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FloatingJointBasics rootJoint, OneDoFJointBasics[] desiredOneDoFJoints, Collection<? extends RigidBodyBasics> controllableRigidBodies, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.spatialGains = new DefaultYoPIDSE3Gains("GenericSpatialGains", GainCoupling.XYZ, false, this.registry);
        this.jointGains = new YoPIDGains("GenericJointGains", this.registry);
        this.optimizationSettings = new KinematicsToolboxOptimizationSettings();
        this.activeOptimizationSettings = new InverseKinematicsOptimizationSettingsCommand();
        this.controllerCoreCommand = new ControllerCoreCommandBuffer();
        this.timeLastSolutionPublished = new YoDouble("timeLastSolutionPublished", this.registry);
        this.publishSolutionPeriod = new YoDouble("publishSolutionPeriod", this.registry);
        this.solutionQuality = new YoDouble("solutionQuality", this.registry);
        this.solutionQualityCalculator = new KinematicsSolutionQualityCalculator();
        this.allFeedbackControlCommands = new FeedbackControlCommandList();
        this.privilegedNullspaceAlpha = new YoDouble("privilegedNullspaceAlpha", this.registry);
        this.privilegedWeight = new YoDouble("privilegedWeight", this.registry);
        this.privilegedConfigurationGain = new YoDouble("privilegedConfigurationGain", this.registry);
        this.privilegedMaxVelocity = new YoDouble("privilegedMaxVelocity", this.registry);
        this.initialRobotConfigurationMap = null;
        this.submitPrivilegedConfigurationCommand = true;
        this.privilegedConfigurationCommand = new PrivilegedConfigurationCommand();
        this.rigidBodiesWithVisualization = new ArrayList<RigidBodyBasics>();
        this.desiredCoodinateSystems = new HashMap<RigidBodyBasics, YoGraphicCoordinateSystem>();
        this.currentCoodinateSystems = new HashMap<RigidBodyBasics, YoGraphicCoordinateSystem>();
        this.userFBCommands = new FeedbackControlCommandBuffer();
        this.previousUserFBCommands = new FeedbackControlCommandBuffer();
        this.isUserProvidingSupportPolygon = new YoBoolean("isUserProvidingSupportPolygon", this.registry);
        this.contactPointLocations = new ArrayList<FramePoint3DReadOnly>();
        this.supportPolygon = new ConvexPolygon2D();
        this.shrunkSupportPolygonVertices = new RecyclingArrayList(Point2D.class);
        this.convexPolygonScaler = new ConvexPolygonScaler();
        this.newSupportPolygon = new FrameConvexPolygon2D();
        this.shrunkSupportPolygon = new ConvexPolygon2D();
        this.centerOfMass = new FramePoint3D();
        this.centerOfMassSafeMargin = new YoDouble("centerOfMassSafeMargin", "Describes the minimum distance away from the support polygon's edges.", this.registry);
        this.enableSupportPolygonConstraint = new YoBoolean("enableSupportPolygonConstraint", this.registry);
        this.numberOfActiveCommands = new YoInteger("numberOfActiveCommands", this.registry);
        this.preserveUserCommandHistory = new YoBoolean("preserveUserCommandHistory", this.registry);
        this.robotCollidables = new ArrayList<Collidable>();
        this.staticCollidables = new ArrayList<Collidable>();
        this.enableSelfCollisionAvoidance = new YoBoolean("enableSelfCollisionAvoidance", this.registry);
        this.enableStaticCollisionAvoidance = new YoBoolean("enableStaticCollisionAvoidance", this.registry);
        this.collisionResults = new RecyclingArrayList(CollisionResult::new);
        this.collisionFrames = new RecyclingArrayList(SupplierBuilder.indexedSupplier(collisionIndex -> new KinematicsCollisionFrame("collisionFrame" + collisionIndex, worldFrame)));
        this.collisionActivationDistanceThreshold = new YoDouble("collisionActivationDistanceThreshold", this.registry);
        this.collisionMinDistance = new YoDouble("collisionMinDistance", this.registry);
        this.maxSelfCollisionResolutionVelocity = new YoDouble("maxSelfCollisionResolutionVelocity", this.registry);
        this.maxStaticCollisionResolutionVelocity = new YoDouble("maxStaticCollisionResolutionVelocity", this.registry);
        this.numberOfCollisionsToVisualize = 20;
        this.yoCollisionDistances = new YoDouble[20];
        this.yoCollisionPointAs = new YoFramePoint3D[20];
        this.yoCollisionPointBs = new YoFramePoint3D[20];
        this.yoCollisionFramePoses = new YoFramePose3D[20];
        this.minimizeAngularMomentum = new YoBoolean("minimizeAngularMomentum", this.registry);
        this.minimizeLinearMomentum = new YoBoolean("minimizeLinearMomentum", this.registry);
        this.angularMomentumWeight = new YoVector3D("angularMomentumWeight", this.registry);
        this.linearMomentumWeight = new YoVector3D("linearMomentumWeight", this.registry);
        this.momentumCommand = new MomentumCommand();
        this.minimizeAngularMomentumRate = new YoBoolean("minimizeAngularMomentumRate", this.registry);
        this.minimizeLinearMomentumRate = new YoBoolean("minimizeLinearMomentumRate", this.registry);
        this.angularMomentumRateWeight = new YoVector3D("angularMomentumRateWeight", this.registry);
        this.linearMomentumRateWeight = new YoVector3D("linearMomentumRateWeight", this.registry);
        this.momentumCommandForRateMinimization = new MomentumCommand();
        this.firstTick = true;
        this.rigidBodyPositions = new ArrayList<FBPoint3D>();
        this.rigidBodyOrientations = new ArrayList<FBQuaternion3D>();
        this.commandInputManager = commandInputManager;
        this.rootJoint = rootJoint;
        this.desiredOneDoFJoints = desiredOneDoFJoints;
        this.controllableRigidBodies = controllableRigidBodies == null ? null : new ArrayList<RigidBodyBasics>(controllableRigidBodies);
        this.updateDT = updateDT;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)desiredOneDoFJoints[0].getPredecessor());
        this.totalRobotMass = MultiBodySystemMissingTools.computeSubTreeMass((RigidBodyReadOnly)this.rootBody);
        this.centerOfMassFrame = new CenterOfMassReferenceFrame("centerOfMass", worldFrame, (RigidBodyReadOnly)this.rootBody);
        this.controllerCoreCommand.setControllerCoreMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        KinematicsToolboxPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters = new KinematicsToolboxPrivilegedConfigurationParameters();
        this.controllerCore = this.createControllerCore(controllableRigidBodies, jointPrivilegedConfigurationParameters);
        this.feedbackControllerDataHolder = this.controllerCore.getWholeBodyFeedbackControllerDataHolder();
        this.inverseKinematicsSolution = MessageTools.createKinematicsToolboxOutputStatus((OneDoFJointBasics[])desiredOneDoFJoints);
        this.inverseKinematicsSolution.setDestination(-1);
        this.robotMass = MultiBodySystemMissingTools.computeSubTreeMass((RigidBodyReadOnly)this.rootBody);
        this.centerOfMassSafeMargin.set(0.04);
        this.spatialGains.setPositionProportionalGains(1200.0);
        this.spatialGains.setPositionMaxFeedbackAndFeedbackRate(1500.0, Double.POSITIVE_INFINITY);
        this.spatialGains.setOrientationProportionalGains(1200.0);
        this.spatialGains.setOrientationMaxFeedbackAndFeedbackRate(1500.0, Double.POSITIVE_INFINITY);
        this.jointGains.setKp(1200.0);
        this.jointGains.setMaximumFeedbackAndMaximumFeedbackRate(1500.0, Double.POSITIVE_INFINITY);
        this.defaultPrivilegedNullspaceAlpha = jointPrivilegedConfigurationParameters.getNullspaceProjectionAlpha();
        this.defaultPrivilegedWeight = jointPrivilegedConfigurationParameters.getDefaultWeight();
        this.defaultPrivilegedConfigurationGain = jointPrivilegedConfigurationParameters.getDefaultConfigurationGain();
        this.defaultPrivilegedMaxVelocity = jointPrivilegedConfigurationParameters.getDefaultMaxVelocity();
        this.privilegedNullspaceAlpha.set(this.defaultPrivilegedNullspaceAlpha);
        this.privilegedWeight.set(this.defaultPrivilegedWeight);
        this.privilegedConfigurationGain.set(this.defaultPrivilegedConfigurationGain);
        this.privilegedMaxVelocity.set(this.defaultPrivilegedMaxVelocity);
        this.yoDesiredCenterOfMass = new YoFramePoint3D("desiredCenterOfMass", ReferenceFrame.getWorldFrame(), this.registry);
        this.yoCurrentCenterOfMass = new YoFramePoint3D("currentCenterOfMass", ReferenceFrame.getWorldFrame(), this.registry);
        this.desiredCenterOfMassGraphic = new YoGraphicPosition("desiredCoMGraphic", this.yoDesiredCenterOfMass, 0.02, YoAppearance.Red());
        this.currentCenterOfMassGraphic = new YoGraphicPosition("currentCoMGraphic", this.yoCurrentCenterOfMass, 0.02, YoAppearance.Black());
        yoGraphicsListRegistry.registerYoGraphic("CenterOfMass", (YoGraphic)this.desiredCenterOfMassGraphic);
        yoGraphicsListRegistry.registerYoGraphic("CenterOfMass", (YoGraphic)this.currentCenterOfMassGraphic);
        this.publishSolutionPeriod.set(0.01);
        this.preserveUserCommandHistory.set(true);
        this.threadTimer = new ThreadTimer("timer", updateDT, this.registry);
        this.minimizeAngularMomentum.set(false);
        this.angularMomentumWeight.set(0.125, 0.125, 0.125);
        this.enableSelfCollisionAvoidance.set(true);
        this.enableStaticCollisionAvoidance.set(true);
        this.collisionActivationDistanceThreshold.set(0.1);
        this.collisionMinDistance.set(0.001);
        this.maxSelfCollisionResolutionVelocity.set(0.1);
        this.maxStaticCollisionResolutionVelocity.set(100.0);
        this.setupCollisionVisualization();
    }

    private void setupCollisionVisualization() {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            YoDouble collisionDistance = new YoDouble("collision_" + i + "_distance", this.registry);
            YoFramePoint3D collisionPointA = new YoFramePoint3D("collision_" + i + "_pointA" + i, worldFrame, this.registry);
            YoFramePoint3D collisionPointB = new YoFramePoint3D("collision_" + i + "_pointB" + i, worldFrame, this.registry);
            YoFramePose3D collisionFramePose = new YoFramePose3D("collision_" + i + "_frame", worldFrame, this.registry);
            if (this.yoGraphicsListRegistry != null) {
                YoAppearanceRGBColor appearance = new YoAppearanceRGBColor(new Color(random.nextInt()), 0.7);
                this.yoGraphicsListRegistry.registerYoGraphic("Collisions", (YoGraphic)new YoGraphicPosition("collision_" + i + "_pointA", collisionPointA, 0.01, (AppearanceDefinition)appearance));
                this.yoGraphicsListRegistry.registerYoGraphic("Collisions", (YoGraphic)new YoGraphicPosition("collision_" + i + "_pointB", collisionPointB, 0.01, (AppearanceDefinition)appearance));
                this.yoGraphicsListRegistry.registerYoGraphic("Collisions", (YoGraphic)new YoGraphicCoordinateSystem("collision_" + i + "_frame", collisionFramePose, 0.1, (AppearanceDefinition)appearance));
            }
            this.yoCollisionDistances[i] = collisionDistance;
            this.yoCollisionPointAs[i] = collisionPointA;
            this.yoCollisionPointBs[i] = collisionPointB;
            this.yoCollisionFramePoses[i] = collisionFramePose;
        }
    }

    public void setInitialRobotConfiguration(Map<OneDoFJointBasics, Double> initialRobotConfigurationMap) {
        if (initialRobotConfigurationMap == null) {
            this.initialRobotConfigurationMap = null;
            return;
        }
        this.initialRobotConfigurationMap = new TObjectDoubleHashMap();
        initialRobotConfigurationMap.forEach((key, value) -> this.initialRobotConfigurationMap.put(key, value.doubleValue()));
    }

    public void setInitialRobotConfigurationNamedMap(Map<String, Double> jointNameToInitialJointPosition) {
        if (jointNameToInitialJointPosition == null) {
            this.initialRobotConfigurationMap = null;
            return;
        }
        this.initialRobotConfigurationMap = new TObjectDoubleHashMap();
        for (OneDoFJointBasics joint : this.desiredOneDoFJoints) {
            Double q_priv = jointNameToInitialJointPosition.get(joint.getName());
            if (q_priv == null) continue;
            this.initialRobotConfigurationMap.put((Object)joint, q_priv.doubleValue());
        }
    }

    public void registerRobotCollidable(Collidable collidable) {
        this.robotCollidables.add(collidable);
    }

    public void registerRobotCollidables(Collidable ... collidables) {
        for (Collidable collidable : collidables) {
            this.robotCollidables.add(collidable);
        }
    }

    public void registerRobotCollidables(Iterable<? extends Collidable> collidables) {
        for (Collidable collidable : collidables) {
            this.robotCollidables.add(collidable);
        }
    }

    public void registerStaticCollidable(Collidable collidable) {
        this.staticCollidables.add(collidable);
    }

    public void registerStaticCollidables(Collidable ... collidables) {
        this.staticCollidables.addAll(Arrays.asList(collidables));
    }

    public void registerStaticCollidables(Iterable<? extends Collidable> collidables) {
        for (Collidable collidable : collidables) {
            this.staticCollidables.add(collidable);
        }
    }

    public void setupVisualization(RigidBodyBasics ... rigidBodies) {
        AppearanceDefinition desiredAppearance = YoAppearance.Red();
        AppearanceDefinition currentAppearance = YoAppearance.Blue();
        for (RigidBodyBasics rigidBody : rigidBodies) {
            YoGraphicCoordinateSystem desiredCoodinateSystem = this.createCoodinateSystem(rigidBody, Type.DESIRED, desiredAppearance);
            YoGraphicCoordinateSystem currentCoodinateSystem = this.createCoodinateSystem(rigidBody, Type.CURRENT, currentAppearance);
            this.rigidBodiesWithVisualization.add(rigidBody);
            this.desiredCoodinateSystems.put(rigidBody, desiredCoodinateSystem);
            this.currentCoodinateSystems.put(rigidBody, currentCoodinateSystem);
            this.yoGraphicsListRegistry.registerYoGraphic("CoordinateSystems", (YoGraphic)desiredCoodinateSystem);
            this.yoGraphicsListRegistry.registerYoGraphic("CoordinateSystems", (YoGraphic)currentCoodinateSystem);
        }
    }

    private YoGraphicCoordinateSystem createCoodinateSystem(RigidBodyBasics endEffector, Type type, AppearanceDefinition appearanceDefinition) {
        String namePrefix = endEffector.getName() + type.getName();
        return new YoGraphicCoordinateSystem(namePrefix, "", this.registry, false, 0.2, appearanceDefinition);
    }

    private WholeBodyControllerCore createControllerCore(Collection<? extends RigidBodyBasics> controllableRigidBodies, JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters) {
        OneDoFJointBasics[] controlledJoints;
        if (this.rootJoint != null) {
            controlledJoints = new JointBasics[this.desiredOneDoFJoints.length + 1];
            controlledJoints[0] = this.rootJoint;
            System.arraycopy(this.desiredOneDoFJoints, 0, controlledJoints, 1, this.desiredOneDoFJoints.length);
        } else {
            controlledJoints = this.desiredOneDoFJoints;
        }
        WholeBodyControlCoreToolbox toolbox = new WholeBodyControlCoreToolbox(this.updateDT, 9.81, this.rootJoint, (JointBasics[])controlledJoints, this.centerOfMassFrame, (ControllerCoreOptimizationSettings)this.optimizationSettings, null, this.registry);
        toolbox.setJointPrivilegedConfigurationParameters(jointPrivilegedConfigurationParameters);
        this.jointTorqueMinimizationWeightCalculator = new JointTorqueSoftLimitWeightCalculator(toolbox.getJointIndexHandler());
        this.jointTorqueMinimizationWeightCalculator.setParameters(0.0, 0.001, 0.1);
        toolbox.setupForInverseKinematicsSolver((JointTorqueMinimizationWeightCalculator)this.jointTorqueMinimizationWeightCalculator);
        FeedbackControllerTemplate controllerCoreTemplate = this.createFeedbackControllerTemplate(controllableRigidBodies, 1);
        JointDesiredOutputList lowLevelControllerOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])this.desiredOneDoFJoints);
        return new WholeBodyControllerCore(toolbox, controllerCoreTemplate, lowLevelControllerOutput, this.registry);
    }

    private FeedbackControllerTemplate createFeedbackControllerTemplate(Collection<? extends RigidBodyBasics> controllableRigidBodies, int numberOfControllersPerBody) {
        FeedbackControllerTemplate template = new FeedbackControllerTemplate();
        template.setAllowDynamicControllerConstruction(true);
        template.enableCenterOfMassFeedbackController();
        List rigidBodies = controllableRigidBodies != null ? controllableRigidBodies : this.rootBody.subtreeList();
        rigidBodies.stream().forEach(rigidBody -> template.enableSpatialFeedbackController(rigidBody, numberOfControllersPerBody));
        SubtreeStreams.fromChildren(OneDoFJointBasics.class, (RigidBodyReadOnly)this.rootBody).forEach(arg_0 -> ((FeedbackControllerTemplate)template).enableOneDoFJointFeedbackController(arg_0));
        return template;
    }

    @Override
    public boolean initialize() {
        boolean success = this.initializeInternal();
        KinematicsToolboxOutputStatus status = new KinematicsToolboxOutputStatus();
        status.setJointNameHash(-1);
        status.setSolutionQuality(Double.NaN);
        status.setCurrentToolboxState(success ? (byte)1 : 2);
        this.reportMessage(status);
        return success;
    }

    protected boolean initializeInternal() {
        this.firstTick = true;
        this.controllerCore.initialize();
        this.resetInternalData();
        boolean wasRobotUpdated = this.desiredRobotStateUpdater.updateRobotConfiguration(this.rootJoint, this.desiredOneDoFJoints);
        if (!wasRobotUpdated) {
            this.commandInputManager.clearAllCommands();
        } else {
            this.initializePrivilegedConfiguration();
            this.updateTools();
        }
        return wasRobotUpdated;
    }

    protected void initializePrivilegedConfiguration() {
        if (this.initialRobotConfigurationMap != null) {
            this.initialRobotConfigurationMap.forEachEntry((joint, q_priv) -> {
                joint.setQ(q_priv);
                return true;
            });
        }
        this.snapPrivilegedConfigurationToCurrent();
    }

    protected void resetInternalData() {
        this.threadTimer.clear();
        this.userFBCommands.clear();
        this.previousUserFBCommands.clear();
        this.isUserProvidingSupportPolygon.set(false);
        this.enableSupportPolygonConstraint.set(true);
        this.inverseKinematicsSolution.getSupportRegion().clear();
    }

    @Override
    public void updateInternal() {
        this.threadTimer.start();
        this.controllerCoreCommand.clear();
        FeedbackControlCommandBuffer feedbackControlCommandBuffer = this.controllerCoreCommand.getFeedbackControlCommandList();
        InverseKinematicsCommandBuffer inverseKinematicsCommandBuffer = this.controllerCoreCommand.getInverseKinematicsCommandList();
        this.consumeUserCommands(feedbackControlCommandBuffer, inverseKinematicsCommandBuffer);
        this.getAdditionalFeedbackControlCommands(feedbackControlCommandBuffer);
        inverseKinematicsCommandBuffer.addInverseKinematicsOptimizationSettingsCommand().set(this.activeOptimizationSettings);
        if (this.submitPrivilegedConfigurationCommand) {
            inverseKinematicsCommandBuffer.addPrivilegedConfigurationCommand().set(this.privilegedConfigurationCommand);
            this.submitPrivilegedConfigurationCommand = false;
        }
        this.getAdditionalInverseKinematicsCommands(inverseKinematicsCommandBuffer);
        this.computeCollisionCommands((List<CollisionResult>)this.collisionResults, inverseKinematicsCommandBuffer);
        this.computeSupportPolygonFeedback(inverseKinematicsCommandBuffer);
        this.allFeedbackControlCommands.clear();
        this.allFeedbackControlCommands.addCommandList((FeedbackControlCommandList)feedbackControlCommandBuffer);
        if (this.minimizeAngularMomentum.getValue() || this.minimizeLinearMomentum.getValue()) {
            this.momentumCommand.setWeights((Tuple3DReadOnly)this.angularMomentumWeight, (Tuple3DReadOnly)this.linearMomentumWeight);
            if (!this.minimizeAngularMomentum.getValue()) {
                this.momentumCommand.setSelectionMatrixForLinearControl();
            } else if (!this.minimizeLinearMomentum.getValue()) {
                this.momentumCommand.setSelectionMatrixForAngularControl();
            } else {
                this.momentumCommand.setSelectionMatrixToIdentity();
            }
            inverseKinematicsCommandBuffer.addMomentumCommand().set(this.momentumCommand);
        }
        if (!this.firstTick && (this.minimizeAngularMomentumRate.getValue() || this.minimizeLinearMomentumRate.getValue())) {
            this.momentumCommandForRateMinimization.setWeights((Tuple3DReadOnly)this.angularMomentumRateWeight, (Tuple3DReadOnly)this.linearMomentumRateWeight);
            if (!this.minimizeAngularMomentumRate.getValue()) {
                this.momentumCommandForRateMinimization.setSelectionMatrixForLinearControl();
            } else if (!this.minimizeLinearMomentumRate.getValue()) {
                this.momentumCommandForRateMinimization.setSelectionMatrixForAngularControl();
            } else {
                this.momentumCommandForRateMinimization.setSelectionMatrixToIdentity();
            }
            inverseKinematicsCommandBuffer.addMomentumCommand().set(this.momentumCommandForRateMinimization);
        }
        this.controllerCore.compute((ControllerCoreCommandInterface)this.controllerCoreCommand);
        ControllerCoreOutput controllerCoreOutput = this.controllerCore.getControllerCoreOutput();
        this.momentumCommandForRateMinimization.setMomentum((FrameVector3DReadOnly)controllerCoreOutput.getAngularMomentum(), (FrameVector3DReadOnly)controllerCoreOutput.getLinearMomentum());
        this.solutionQuality.set(this.solutionQualityCalculator.calculateSolutionQuality(this.feedbackControllerDataHolder, this.totalRobotMass, 8.333333333333334E-4));
        if (!this.isUserControllingCenterOfMass()) {
            this.yoDesiredCenterOfMass.setToNaN();
        }
        this.yoCurrentCenterOfMass.set((FrameTuple3DReadOnly)this.centerOfMass);
        this.desiredCenterOfMassGraphic.update();
        this.currentCenterOfMassGraphic.update();
        KinematicsToolboxHelper.setRobotStateFromControllerCoreOutput((ControllerCoreOutputReadOnly)controllerCoreOutput, this.rootJoint, this.desiredOneDoFJoints);
        this.updateVisualization();
        this.inverseKinematicsSolution.setCurrentToolboxState((byte)3);
        MessageTools.packDesiredJointState((KinematicsToolboxOutputStatus)this.inverseKinematicsSolution, (FloatingJointReadOnly)this.rootJoint, (OneDoFJointReadOnly[])this.desiredOneDoFJoints);
        this.inverseKinematicsSolution.setSolutionQuality(this.solutionQuality.getDoubleValue());
        this.updateTools();
        this.computeCollisions();
        double currentTime = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        if (this.timeLastSolutionPublished.getValue() == 0.0 || currentTime - this.timeLastSolutionPublished.getValue() >= this.publishSolutionPeriod.getValue()) {
            this.reportMessage(this.inverseKinematicsSolution);
            this.timeLastSolutionPublished.set(currentTime);
        }
        this.firstTick = false;
        this.threadTimer.stop();
    }

    protected void updateTools() {
        this.rootBody.updateFramesRecursively();
        this.centerOfMassFrame.update();
    }

    private void consumeUserCommands(FeedbackControlCommandBuffer fbCommandBufferToPack, InverseKinematicsCommandBuffer ikCommandBufferToPack) {
        this.consumeUserConfigurationCommands();
        this.consumeUserMotionObjectiveCommands(fbCommandBufferToPack, ikCommandBufferToPack);
        this.consumeUserContactStateCommands();
    }

    private void consumeUserConfigurationCommands() {
        KinematicsToolboxConfigurationCommand command;
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxConfigurationCommand.class)) {
            int i;
            command = (KinematicsToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxConfigurationCommand.class);
            if (command.getJointVelocityWeight() <= 0.0) {
                this.activeOptimizationSettings.setJointVelocityWeight(this.optimizationSettings.getJointVelocityWeight());
            } else {
                this.activeOptimizationSettings.setJointVelocityWeight(command.getJointVelocityWeight());
            }
            if (command.getJointAccelerationWeight() < 0.0) {
                this.activeOptimizationSettings.setJointAccelerationWeight(this.optimizationSettings.getJointAccelerationWeight());
            } else {
                this.activeOptimizationSettings.setJointAccelerationWeight(command.getJointAccelerationWeight());
            }
            if (command.getDisableCollisionAvoidance()) {
                this.enableSelfCollisionAvoidance.set(false);
            }
            if (command.getEnableCollisionAvoidance()) {
                this.enableSelfCollisionAvoidance.set(true);
            }
            if (command.getDisableJointVelocityLimits()) {
                this.activeOptimizationSettings.setJointVelocityLimitMode(InverseKinematicsOptimizationSettingsCommand.ActivationState.DISABLED);
            }
            if (command.getEnableJointVelocityLimits()) {
                this.activeOptimizationSettings.setJointVelocityLimitMode(InverseKinematicsOptimizationSettingsCommand.ActivationState.ENABLED);
            }
            if (!command.getJointsToDeactivate().isEmpty()) {
                this.activeOptimizationSettings.getJointsToDeactivate().clear();
                for (i = 0; i < command.getJointsToDeactivate().size(); ++i) {
                    this.activeOptimizationSettings.getJointsToDeactivate().add((OneDoFJointBasics)command.getJointsToDeactivate().get(i));
                }
            }
            if (!command.getJointsToActivate().isEmpty()) {
                this.activeOptimizationSettings.getJointsToActivate().clear();
                for (i = 0; i < command.getJointsToActivate().size(); ++i) {
                    this.activeOptimizationSettings.getJointsToActivate().add((OneDoFJointBasics)command.getJointsToActivate().get(i));
                }
            }
            if (command.getDisableInputPersistence()) {
                this.setPreserveUserCommandHistory(false);
            } else if (command.getEnableInputPersistence()) {
                this.setPreserveUserCommandHistory(true);
            }
            if (command.getEnableSupportPolygonConstraint()) {
                this.enableSupportPolygonConstraint.set(true);
            } else if (command.getDisableSupportPolygonConstraint()) {
                this.enableSupportPolygonConstraint.set(false);
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxPrivilegedConfigurationCommand.class)) {
            command = (KinematicsToolboxPrivilegedConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxPrivilegedConfigurationCommand.class);
            KinematicsToolboxHelper.setRobotStateFromPrivilegedConfigurationData((KinematicsToolboxPrivilegedConfigurationCommand)command, this.rootJoint);
            if (command.hasPrivilegedJointAngles() || command.hasPrivilegedRootJointPosition() || command.hasPrivilegedRootJointOrientation()) {
                this.robotConfigurationReinitialized();
            }
            this.privilegedNullspaceAlpha.set(command.hasNullspaceAlpha() ? this.defaultPrivilegedNullspaceAlpha : command.getNullspaceAlpha());
            this.privilegedWeight.set(command.hasPrivilegedWeight() ? this.defaultPrivilegedWeight : command.getPrivilegedWeight());
            this.privilegedConfigurationGain.set(command.hasPrivilegedGain() ? this.defaultPrivilegedConfigurationGain : command.getPrivilegedGain());
            this.privilegedConfigurationCommand.setNullspaceAlpha(this.privilegedNullspaceAlpha.getDoubleValue());
            this.privilegedConfigurationCommand.setDefaultWeight(this.privilegedWeight.getDoubleValue());
            this.privilegedConfigurationCommand.setDefaultConfigurationGain(this.privilegedConfigurationGain.getDoubleValue());
            this.privilegedConfigurationCommand.setDefaultMaxVelocity(this.privilegedMaxVelocity.getDoubleValue());
            if (command.hasNullspaceAlpha() || command.hasPrivilegedWeight() || command.hasPrivilegedGain()) {
                this.submitPrivilegedConfigurationCommand = true;
            }
            if (command.hasPrivilegedJointAngles()) {
                this.snapPrivilegedConfigurationToCurrent();
            }
        }
    }

    private void consumeUserMotionObjectiveCommands(FeedbackControlCommandBuffer fbCommandBufferToPack, InverseKinematicsCommandBuffer ikCommandBufferToPack) {
        OneDoFJointFeedbackControlCommand previousCommand;
        int j;
        KinematicsToolboxRigidBodyCommand command;
        int i;
        List commands;
        KinematicsToolboxCenterOfMassCommand command2;
        this.previousUserFBCommands.set((FeedbackControlCommandList)this.userFBCommands);
        this.userFBCommands.clear();
        boolean noCommandReceived = true;
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxCenterOfMassCommand.class)) {
            noCommandReceived = false;
            command2 = (KinematicsToolboxCenterOfMassCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxCenterOfMassCommand.class);
            KinematicsToolboxHelper.consumeCenterOfMassCommand(command2, (PID3DGains)this.spatialGains.getPositionGains(), this.userFBCommands.addCenterOfMassFeedbackControlCommand());
            this.yoDesiredCenterOfMass.set((FrameTuple3DReadOnly)command2.getDesiredPosition());
            if (this.preserveUserCommandHistory.getValue()) {
                while (!this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty()) {
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().get(0));
                }
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxRigidBodyCommand.class)) {
            commands = this.commandInputManager.pollNewCommands(KinematicsToolboxRigidBodyCommand.class);
            for (i = 0; i < commands.size(); ++i) {
                noCommandReceived = false;
                command = (KinematicsToolboxRigidBodyCommand)commands.get(i);
                RigidBodyBasics endEffector = command.getEndEffector();
                SpatialFeedbackControlCommand rigidBodyCommand = this.userFBCommands.addSpatialFeedbackControlCommand();
                KinematicsToolboxHelper.consumeRigidBodyCommand(command, this.rootBody, (PIDSE3Gains)this.spatialGains, rigidBodyCommand);
                rigidBodyCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(rigidBodyCommand.getEndEffector()));
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (j = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().size() - 1; j >= 0; --j) {
                    previousCommand = (SpatialFeedbackControlCommand)this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().get(j);
                    if (previousCommand.getEndEffector() != endEffector) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand);
                }
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxOneDoFJointCommand.class)) {
            commands = this.commandInputManager.pollNewCommands(KinematicsToolboxOneDoFJointCommand.class);
            for (i = 0; i < commands.size(); ++i) {
                noCommandReceived = false;
                command = (KinematicsToolboxOneDoFJointCommand)commands.get(i);
                OneDoFJointBasics joint = command.getJoint();
                OneDoFJointFeedbackControlCommand jointCommand = this.userFBCommands.addOneDoFJointFeedbackControlCommand();
                KinematicsToolboxHelper.consumeJointCommand((KinematicsToolboxOneDoFJointCommand)command, (PIDGainsReadOnly)this.jointGains, jointCommand);
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (j = 0; j < this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().size(); ++j) {
                    previousCommand = (OneDoFJointFeedbackControlCommand)this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().get(j);
                    if (previousCommand.getJoint() != joint) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand);
                }
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxInputCollectionCommand.class)) {
            command2 = (KinematicsToolboxInputCollectionCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxInputCollectionCommand.class);
            RecyclingArrayList centerOfMassInputs = command2.getCenterOfMassInputs();
            for (int j2 = 0; j2 < centerOfMassInputs.size(); ++j2) {
                noCommandReceived = false;
                KinematicsToolboxCenterOfMassCommand input = (KinematicsToolboxCenterOfMassCommand)centerOfMassInputs.get(j2);
                KinematicsToolboxHelper.consumeCenterOfMassCommand(input, (PID3DGains)this.spatialGains.getPositionGains(), this.userFBCommands.addCenterOfMassFeedbackControlCommand());
                if (!this.preserveUserCommandHistory.getValue()) continue;
                while (!this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty()) {
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().get(0));
                }
            }
            RecyclingArrayList rigidBodyInputs = command2.getRigidBodyInputs();
            for (int j3 = 0; j3 < rigidBodyInputs.size(); ++j3) {
                noCommandReceived = false;
                KinematicsToolboxRigidBodyCommand input = (KinematicsToolboxRigidBodyCommand)rigidBodyInputs.get(j3);
                RigidBodyBasics endEffector = input.getEndEffector();
                SpatialFeedbackControlCommand rigidBodyCommand = this.userFBCommands.addSpatialFeedbackControlCommand();
                KinematicsToolboxHelper.consumeRigidBodyCommand(input, this.rootBody, (PIDSE3Gains)this.spatialGains, rigidBodyCommand);
                rigidBodyCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(rigidBodyCommand.getEndEffector()));
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (int k = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().size() - 1; k >= 0; --k) {
                    SpatialFeedbackControlCommand previousCommand2 = (SpatialFeedbackControlCommand)this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().get(k);
                    if (previousCommand2.getEndEffector() != endEffector) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand2);
                }
            }
            RecyclingArrayList jointInputs = command2.getJointInputs();
            for (int j4 = 0; j4 < jointInputs.size(); ++j4) {
                noCommandReceived = false;
                KinematicsToolboxOneDoFJointCommand input = (KinematicsToolboxOneDoFJointCommand)jointInputs.get(j4);
                OneDoFJointBasics joint = input.getJoint();
                OneDoFJointFeedbackControlCommand jointCommand = this.userFBCommands.addOneDoFJointFeedbackControlCommand();
                KinematicsToolboxHelper.consumeJointCommand(input, (PIDGainsReadOnly)this.jointGains, jointCommand);
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (int k = 0; k < this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().size(); ++k) {
                    OneDoFJointFeedbackControlCommand previousCommand3 = (OneDoFJointFeedbackControlCommand)this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().get(k);
                    if (previousCommand3.getJoint() != joint) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand3);
                }
            }
            if (command2.hasSupportRegionInput()) {
                KinematicsToolboxSupportRegionCommand supportRegionInput = command2.getSupportRegionInput();
                this.processUserSupportRegionInput(supportRegionInput);
            }
        }
        if (noCommandReceived) {
            fbCommandBufferToPack.addCommandList((FeedbackControlCommandList)this.previousUserFBCommands);
            this.numberOfActiveCommands.set(this.previousUserFBCommands.getNumberOfCommands());
            this.userFBCommands.set((FeedbackControlCommandList)this.previousUserFBCommands);
            this.previousUserFBCommands.clear();
        } else {
            if (this.preserveUserCommandHistory.getValue()) {
                this.userFBCommands.addCommandList((FeedbackControlCommandList)this.previousUserFBCommands);
            }
            this.previousUserFBCommands.clear();
            fbCommandBufferToPack.addCommandList((FeedbackControlCommandList)this.userFBCommands);
            this.numberOfActiveCommands.set(this.userFBCommands.getNumberOfCommands());
        }
    }

    private void consumeUserContactStateCommands() {
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxSupportRegionCommand.class)) {
            KinematicsToolboxSupportRegionCommand command = (KinematicsToolboxSupportRegionCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxSupportRegionCommand.class);
            this.processUserSupportRegionInput(command);
        }
    }

    private void processUserSupportRegionInput(KinematicsToolboxSupportRegionCommand command) {
        this.isUserProvidingSupportPolygon.set(command.getNumberOfContacts() > 0);
        if (command.getCenterOfMassMargin() >= 0.0) {
            this.centerOfMassSafeMargin.set(command.getCenterOfMassMargin());
        }
        this.contactPointLocations.clear();
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            this.contactPointLocations.add(command.getContactPoint(i).getVertexPosition());
        }
        if (!this.contactPointLocations.isEmpty()) {
            this.updateSupportPolygonConstraint(this.contactPointLocations);
        }
    }

    protected void updateSupportPolygonConstraint(List<? extends FramePoint3DReadOnly> contactPoints) {
        int i;
        if (!this.enableSupportPolygonConstraint.getValue()) {
            return;
        }
        this.newSupportPolygon.clear(worldFrame);
        for (i = 0; i < contactPoints.size(); ++i) {
            this.newSupportPolygon.addVertexMatchingFrame(contactPoints.get(i));
        }
        this.newSupportPolygon.update();
        if (this.newSupportPolygon.getNumberOfVertices() <= 2 || this.newSupportPolygon.getArea() < MathTools.square((double)0.01)) {
            this.shrunkSupportPolygon.clear();
            this.shrunkSupportPolygonVertices.clear();
            return;
        }
        if (!this.newSupportPolygon.epsilonEquals((EuclidGeometry)this.supportPolygon, 0.005)) {
            this.supportPolygon.set((Vertex2DSupplier)this.newSupportPolygon);
            this.convexPolygonScaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)this.supportPolygon, this.centerOfMassSafeMargin.getValue(), (ConvexPolygon2DBasics)this.shrunkSupportPolygon);
            this.shrunkSupportPolygonVertices.clear();
            for (i = 0; i < this.shrunkSupportPolygon.getNumberOfVertices(); ++i) {
                ((Point2D)this.shrunkSupportPolygonVertices.add()).set((Tuple2DReadOnly)this.shrunkSupportPolygon.getVertex(i));
            }
            for (i = this.shrunkSupportPolygonVertices.size() - 1; i >= 0; --i) {
                Point2DReadOnly nextVertex;
                Point2DReadOnly previousVertex;
                Point2DReadOnly vertex = (Point2DReadOnly)this.shrunkSupportPolygonVertices.get(i);
                if (!(EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)vertex, (Point2DReadOnly)(previousVertex = (Point2DReadOnly)ListWrappingIndexTools.getPrevious((int)i, this.shrunkSupportPolygonVertices)), (Point2DReadOnly)(nextVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)i, this.shrunkSupportPolygonVertices))) < 0.001)) continue;
                this.shrunkSupportPolygonVertices.remove(i);
            }
        }
    }

    private void computeSupportPolygonFeedback(InverseKinematicsCommandBuffer bufferToPack) {
        if (!this.enableSupportPolygonConstraint.getValue()) {
            return;
        }
        if (this.shrunkSupportPolygonVertices.isEmpty()) {
            return;
        }
        this.centerOfMass.setToZero(this.centerOfMassFrame);
        this.centerOfMass.changeFrame(worldFrame);
        double distanceThreshold = 0.25 * this.centerOfMassSafeMargin.getValue();
        for (int i = 0; i < this.shrunkSupportPolygonVertices.size(); ++i) {
            Point2DReadOnly vertex = (Point2DReadOnly)this.shrunkSupportPolygonVertices.get(i);
            Point2DReadOnly nextVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)i, this.shrunkSupportPolygonVertices);
            double signedDistanceToEdge = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((double)this.centerOfMass.getX(), (double)this.centerOfMass.getY(), (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex);
            if (!(signedDistanceToEdge > -distanceThreshold)) continue;
            LinearMomentumConvexConstraint2DCommand command = bufferToPack.addLinearMomentumConvexConstraint2DCommand();
            command.clear();
            Vector2D h0 = command.addLinearMomentumConstraintVertex();
            Vector2D h1 = command.addLinearMomentumConstraintVertex();
            h0.set(vertex.getX() - this.centerOfMass.getX(), vertex.getY() - this.centerOfMass.getY());
            h1.set(nextVertex.getX() - this.centerOfMass.getX(), nextVertex.getY() - this.centerOfMass.getY());
            h0.scale(this.robotMass / this.updateDT);
            h1.scale(this.robotMass / this.updateDT);
        }
    }

    private void computeCollisions() {
        EuclidFrameShape3DCollisionResult collisionData;
        CollisionResult collisionResult;
        Collidable collidableB;
        int collidableBIndex;
        Collidable collidableA;
        int collidableAIndex;
        this.collisionResults.clear();
        if (this.robotCollidables.isEmpty()) {
            return;
        }
        int collisionIndex = 0;
        if (this.enableSelfCollisionAvoidance.getValue()) {
            for (collidableAIndex = 0; collidableAIndex < this.robotCollidables.size(); ++collidableAIndex) {
                collidableA = this.robotCollidables.get(collidableAIndex);
                for (collidableBIndex = collidableAIndex + 1; collidableBIndex < this.robotCollidables.size(); ++collidableBIndex) {
                    collidableB = this.robotCollidables.get(collidableBIndex);
                    if (!collidableA.isCollidableWith(collidableB)) continue;
                    collisionResult = (CollisionResult)this.collisionResults.add();
                    collidableA.evaluateCollision(collidableB, collisionResult);
                    collisionData = collisionResult.getCollisionData();
                    if (collisionData.getSignedDistance() > this.collisionActivationDistanceThreshold.getValue()) continue;
                    if (collisionIndex < 20) {
                        this.yoCollisionDistances[collisionIndex].set(collisionData.getSignedDistance());
                        this.yoCollisionPointAs[collisionIndex].setMatchingFrame((FrameTuple3DReadOnly)collisionData.getPointOnA());
                        this.yoCollisionPointBs[collisionIndex].setMatchingFrame((FrameTuple3DReadOnly)collisionData.getPointOnB());
                    }
                    ++collisionIndex;
                }
            }
        }
        if (!this.staticCollidables.isEmpty() && this.enableStaticCollisionAvoidance.getValue()) {
            for (collidableAIndex = 0; collidableAIndex < this.robotCollidables.size(); ++collidableAIndex) {
                collidableA = this.robotCollidables.get(collidableAIndex);
                for (collidableBIndex = 0; collidableBIndex < this.staticCollidables.size(); ++collidableBIndex) {
                    collidableB = this.staticCollidables.get(collidableBIndex);
                    if (!collidableA.isCollidableWith(collidableB)) continue;
                    collisionResult = (CollisionResult)this.collisionResults.add();
                    collidableA.evaluateCollision(collidableB, collisionResult);
                    collisionData = collisionResult.getCollisionData();
                    if (collisionData.getSignedDistance() > this.collisionActivationDistanceThreshold.getValue()) continue;
                    if (collisionIndex < 20) {
                        this.yoCollisionDistances[collisionIndex].set(collisionData.getSignedDistance());
                        this.yoCollisionPointAs[collisionIndex].setMatchingFrame((FrameTuple3DReadOnly)collisionData.getPointOnA());
                        this.yoCollisionPointBs[collisionIndex].setMatchingFrame((FrameTuple3DReadOnly)collisionData.getPointOnB());
                    }
                    ++collisionIndex;
                }
            }
        }
    }

    public void computeCollisionCommands(List<CollisionResult> collisions, InverseKinematicsCommandBuffer bufferToPack) {
        boolean collisionsEnabled;
        boolean collisionsDetected = !collisions.isEmpty();
        boolean bl = collisionsEnabled = this.enableSelfCollisionAvoidance.getValue() || this.enableStaticCollisionAvoidance.getValue();
        if (!collisionsDetected || !collisionsEnabled) {
            return;
        }
        int collisionIndex = 0;
        this.collisionFrames.clear();
        for (int i = 0; i < collisions.size(); ++i) {
            CollisionResult collision = collisions.get(i);
            Collidable collidableA = collision.getCollidableA();
            Collidable collidableB = collision.getCollidableB();
            EuclidFrameShape3DCollisionResult collisionData = collision.getCollisionData();
            if (collisionData.getSignedDistance() > this.collisionActivationDistanceThreshold.getValue()) continue;
            if (collisionData.getPointOnA().containsNaN()) {
                LogTools.info((String)"Collision result contains NaN, skipping.");
                continue;
            }
            RigidBodyBasics bodyA = collidableA.getRigidBody();
            RigidBodyBasics bodyB = collidableB.getRigidBody();
            double sigma = -(collisionData.getSignedDistance() - this.collisionMinDistance.getValue());
            double sigmaDot = sigma / this.updateDT;
            sigmaDot = bodyB != null ? Math.min(sigmaDot, this.maxSelfCollisionResolutionVelocity.getValue()) : Math.min(sigmaDot, this.maxStaticCollisionResolutionVelocity.getValue());
            KinematicsCollisionFrame collisionFrame = (KinematicsCollisionFrame)((Object)this.collisionFrames.add());
            collisionFrame.update(collision, false);
            if (collisionIndex < 20) {
                this.yoCollisionFramePoses[collisionIndex].setFromReferenceFrame((ReferenceFrame)collisionFrame);
            }
            SpatialVelocityCommand command = bufferToPack.addSpatialVelocityCommand();
            if (bodyB != null) {
                command.set(bodyB, bodyA);
            } else {
                command.set(this.rootBody, bodyA);
            }
            command.getControlFramePose().setFromReferenceFrame((ReferenceFrame)collisionFrame);
            SelectionMatrix6D selectionMatrix = command.getSelectionMatrix();
            selectionMatrix.clearSelection();
            selectionMatrix.selectLinearZ(true);
            selectionMatrix.setSelectionFrames(null, (ReferenceFrame)collisionFrame);
            command.setConstraintType(ConstraintType.GEQ_INEQUALITY);
            command.getDesiredLinearVelocity().setZ(sigmaDot);
            ++collisionIndex;
        }
    }

    protected void robotConfigurationReinitialized() {
    }

    protected RigidBodyBasics getEndEffectorPrimaryBase(RigidBodyBasics endEffector) {
        return null;
    }

    private void updateVisualization() {
        YoGraphicCoordinateSystem coordinateSystem;
        RigidBodyBasics endEffector;
        int i;
        for (i = 0; i < this.rigidBodiesWithVisualization.size(); ++i) {
            endEffector = this.rigidBodiesWithVisualization.get(i);
            coordinateSystem = this.desiredCoodinateSystems.get(endEffector);
            this.feedbackControllerDataHolder.getPositionData(endEffector, this.rigidBodyPositions, Type.DESIRED);
            if (this.rigidBodyPositions.isEmpty()) {
                coordinateSystem.hide();
            } else {
                coordinateSystem.setPosition((FramePoint3DReadOnly)this.rigidBodyPositions.get(0));
            }
            this.feedbackControllerDataHolder.getOrientationData(endEffector, this.rigidBodyOrientations, Type.DESIRED);
            if (this.rigidBodyOrientations.isEmpty()) {
                coordinateSystem.hide();
                continue;
            }
            coordinateSystem.setOrientation((FrameQuaternionReadOnly)this.rigidBodyOrientations.get(0));
        }
        for (i = 0; i < this.rigidBodiesWithVisualization.size(); ++i) {
            endEffector = this.rigidBodiesWithVisualization.get(i);
            coordinateSystem = this.currentCoodinateSystems.get(endEffector);
            this.feedbackControllerDataHolder.getPositionData(endEffector, this.rigidBodyPositions, Type.CURRENT);
            if (this.rigidBodyPositions.isEmpty()) {
                coordinateSystem.hide();
            } else {
                coordinateSystem.setPosition((FramePoint3DReadOnly)this.rigidBodyPositions.get(0));
            }
            this.feedbackControllerDataHolder.getOrientationData(endEffector, this.rigidBodyOrientations, Type.CURRENT);
            if (this.rigidBodyOrientations.isEmpty()) {
                coordinateSystem.hide();
                continue;
            }
            coordinateSystem.setOrientation((FrameQuaternionReadOnly)this.rigidBodyOrientations.get(0));
        }
    }

    protected void snapPrivilegedConfigurationToCurrent() {
        this.privilegedConfigurationCommand.clear();
        for (int i = 0; i < this.desiredOneDoFJoints.length; ++i) {
            this.privilegedConfigurationCommand.addJoint(this.desiredOneDoFJoints[i], this.desiredOneDoFJoints[i].getQ());
        }
        this.privilegedConfigurationCommand.setDefaultWeight(this.privilegedWeight.getDoubleValue());
        this.privilegedConfigurationCommand.setDefaultConfigurationGain(this.privilegedConfigurationGain.getDoubleValue());
        this.privilegedConfigurationCommand.setDefaultMaxVelocity(this.privilegedMaxVelocity.getDoubleValue());
        this.submitPrivilegedConfigurationCommand = true;
    }

    public void setDesiredRobotStateUpdater(IKRobotStateUpdater desiredRobotStateUpdater) {
        this.desiredRobotStateUpdater = desiredRobotStateUpdater;
    }

    public boolean isUserControllingRigidBody(RigidBodyBasics rigidBody) {
        RecyclingArrayList currentFBCommands = this.userFBCommands.getSpatialFeedbackControlCommandBuffer();
        for (int i = 0; i < currentFBCommands.size(); ++i) {
            if (((SpatialFeedbackControlCommand)currentFBCommands.get(i)).getEndEffector() != rigidBody) continue;
            return true;
        }
        RecyclingArrayList previousFBCommands = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer();
        for (int i = 0; i < previousFBCommands.size(); ++i) {
            if (((SpatialFeedbackControlCommand)previousFBCommands.get(i)).getEndEffector() != rigidBody) continue;
            return true;
        }
        return false;
    }

    public boolean isUserControllingRigidBodyPosition(RigidBodyBasics rigidBody) {
        RecyclingArrayList currentFBCommands = this.userFBCommands.getSpatialFeedbackControlCommandBuffer();
        for (int i = 0; i < currentFBCommands.size(); ++i) {
            SelectionMatrix6D selectionMatrix;
            SpatialFeedbackControlCommand command = (SpatialFeedbackControlCommand)currentFBCommands.get(i);
            if (command.getEndEffector() != rigidBody || !(selectionMatrix = command.getSpatialAccelerationCommand().getSelectionMatrix()).isLinearPartActive()) continue;
            return true;
        }
        RecyclingArrayList previousFBCommands = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer();
        for (int i = 0; i < previousFBCommands.size(); ++i) {
            SelectionMatrix6D selectionMatrix;
            SpatialFeedbackControlCommand command = (SpatialFeedbackControlCommand)previousFBCommands.get(i);
            if (command.getEndEffector() != rigidBody || !(selectionMatrix = command.getSpatialAccelerationCommand().getSelectionMatrix()).isLinearPartActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isUserControllingJoint(OneDoFJointBasics joint) {
        RecyclingArrayList currentFBCommands = this.userFBCommands.getOneDoFJointFeedbackControlCommandBuffer();
        for (int i = 0; i < currentFBCommands.size(); ++i) {
            if (((OneDoFJointFeedbackControlCommand)currentFBCommands.get(i)).getJoint() != joint) continue;
            return true;
        }
        RecyclingArrayList previousFBCommands = this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer();
        for (int i = 0; i < previousFBCommands.size(); ++i) {
            if (((OneDoFJointFeedbackControlCommand)previousFBCommands.get(i)).getJoint() != joint) continue;
            return true;
        }
        return false;
    }

    public boolean isUserControllingCenterOfMass() {
        return !this.userFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty() || !this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty();
    }

    public boolean isUserProvidingSupportPolygon() {
        return this.isUserProvidingSupportPolygon.getValue();
    }

    public YoPIDSE3Gains getDefaultSpatialGains() {
        return this.spatialGains;
    }

    public YoPIDGains getDefaultJointGains() {
        return this.jointGains;
    }

    protected void getAdditionalFeedbackControlCommands(FeedbackControlCommandBuffer bufferToPack) {
    }

    protected void getAdditionalInverseKinematicsCommands(InverseKinematicsCommandBuffer bufferToPack) {
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public FloatingJointBasics getDesiredRootJoint() {
        return this.rootJoint;
    }

    public OneDoFJointBasics[] getDesiredOneDoFJoints() {
        return this.desiredOneDoFJoints;
    }

    public List<? extends RigidBodyBasics> getControllableRigidBodies() {
        return this.controllableRigidBodies;
    }

    public KinematicsToolboxOutputStatus getSolution() {
        return this.inverseKinematicsSolution;
    }

    public FeedbackControllerDataHolderReadOnly getFeedbackControllerDataHolder() {
        return this.feedbackControllerDataHolder;
    }

    public void setPublishingSolutionPeriod(double periodInSeconds) {
        this.publishSolutionPeriod.set(periodInSeconds);
    }

    public void setPreserveUserCommandHistory(boolean value) {
        this.preserveUserCommandHistory.set(value);
    }

    public void minimizeMomentum(boolean enableAngular, boolean enableLinear) {
        this.minimizeAngularMomentum(enableAngular);
        this.minimizeLinearMomentum(enableLinear);
    }

    public void minimizeAngularMomentum(boolean enable) {
        this.minimizeAngularMomentum.set(enable);
    }

    public void minimizeLinearMomentum(boolean enable) {
        this.minimizeLinearMomentum.set(enable);
    }

    public void setMomentumWeight(Tuple3DReadOnly angularWeight, Tuple3DReadOnly linearWeight) {
        this.setAngularMomentumWeight(angularWeight);
        this.setLinearMomentumWeight(linearWeight);
    }

    public void setAngularMomentumWeight(Tuple3DReadOnly weight) {
        this.angularMomentumWeight.set(weight);
    }

    public void setLinearMomentumWeight(Tuple3DReadOnly weight) {
        this.linearMomentumWeight.set(weight);
    }

    public void minimizeMomentumRate(boolean enableAngular, boolean enableLinear) {
        this.minimizeAngularMomentumRate(enableAngular);
        this.minimizeLinearMomentumRate(enableLinear);
    }

    public void minimizeAngularMomentumRate(boolean enable) {
        this.minimizeAngularMomentumRate.set(enable);
    }

    public void minimizeLinearMomentumRate(boolean enable) {
        this.minimizeLinearMomentumRate.set(enable);
    }

    public void setMomentumRateWeight(double angularWeight, double linearWeight) {
        this.setAngularMomentumRateWeight(angularWeight);
        this.setLinearMomentumRateWeight(linearWeight);
    }

    public void setMomentumRateWeight(Tuple3DReadOnly angularWeight, Tuple3DReadOnly linearWeight) {
        this.setAngularMomentumRateWeight(angularWeight);
        this.setLinearMomentumRateWeight(linearWeight);
    }

    public void setAngularMomentumRateWeight(double weight) {
        this.angularMomentumRateWeight.set(weight, weight, weight);
    }

    public void setAngularMomentumRateWeight(Tuple3DReadOnly weight) {
        this.angularMomentumRateWeight.set(weight);
    }

    public void setLinearMomentumRateWeight(double weight) {
        this.linearMomentumRateWeight.set(weight, weight, weight);
    }

    public void setLinearMomentumRateWeight(Tuple3DReadOnly weight) {
        this.linearMomentumRateWeight.set(weight);
    }

    public void setEnableSelfCollisionAvoidance(boolean enableSelfCollisionAvoidance) {
        this.enableSelfCollisionAvoidance.set(enableSelfCollisionAvoidance);
    }

    public void setEnableStaticCollisionAvoidance(boolean enableStaticCollisionAvoidance) {
        this.enableStaticCollisionAvoidance.set(enableStaticCollisionAvoidance);
    }

    public void setPrivilegedNullspaceAlpha(double privilegedNullspaceAlpha, boolean updateDefaultValue) {
        if (privilegedNullspaceAlpha < 0.0 || !Double.isFinite(privilegedNullspaceAlpha)) {
            LogTools.error((String)("Privileged nullspace alpha must be a positive finite number. Requested value: " + privilegedNullspaceAlpha));
            return;
        }
        if (updateDefaultValue) {
            this.defaultPrivilegedNullspaceAlpha = privilegedNullspaceAlpha;
        }
        this.privilegedNullspaceAlpha.set(privilegedNullspaceAlpha);
        this.privilegedConfigurationCommand.setNullspaceAlpha(privilegedNullspaceAlpha);
        this.submitPrivilegedConfigurationCommand = true;
    }

    public void setPrivilegedWeight(double privilegedWeight, boolean updateDefaultValue) {
        if (privilegedWeight < 0.0 || !Double.isFinite(privilegedWeight)) {
            LogTools.error((String)("Privileged weight must be a positive finite number. Requested value: " + privilegedWeight));
            return;
        }
        if (updateDefaultValue) {
            this.defaultPrivilegedWeight = privilegedWeight;
        }
        this.privilegedWeight.set(privilegedWeight);
        this.privilegedConfigurationCommand.setDefaultWeight(privilegedWeight);
        this.submitPrivilegedConfigurationCommand = true;
    }

    public void setPrivilegedConfigurationGain(double privilegedConfigurationGain, boolean updateDefaultValue) {
        if (privilegedConfigurationGain < 0.0 || !Double.isFinite(privilegedConfigurationGain)) {
            LogTools.error((String)("Privileged configuration gain must be a positive finite number. Requested value: " + privilegedConfigurationGain));
            return;
        }
        if (updateDefaultValue) {
            this.defaultPrivilegedConfigurationGain = privilegedConfigurationGain;
        }
        this.privilegedConfigurationGain.set(privilegedConfigurationGain);
        this.privilegedConfigurationCommand.setDefaultConfigurationGain(privilegedConfigurationGain);
        this.submitPrivilegedConfigurationCommand = true;
    }

    public void setPrivilegedMaxVelocity(double privilegedMaxVelocity, boolean updateDefaultValue) {
        if (privilegedMaxVelocity < 0.0 || !Double.isFinite(privilegedMaxVelocity)) {
            LogTools.error((String)("Privileged max velocity must be a positive finite number. Requested value: " + privilegedMaxVelocity));
            return;
        }
        if (updateDefaultValue) {
            this.defaultPrivilegedMaxVelocity = privilegedMaxVelocity;
        }
        this.privilegedMaxVelocity.set(privilegedMaxVelocity);
        this.privilegedConfigurationCommand.setDefaultMaxVelocity(privilegedMaxVelocity);
        this.submitPrivilegedConfigurationCommand = true;
    }

    public InverseKinematicsOptimizationSettingsCommand getActiveOptimizationSettings() {
        return this.activeOptimizationSettings;
    }

    public JointTorqueSoftLimitWeightCalculator getJointTorqueMinimizationWeightCalculator() {
        return this.jointTorqueMinimizationWeightCalculator;
    }

    public double getUpdateDT() {
        return this.updateDT;
    }

    public YoDouble getCenterOfMassSafeMargin() {
        return this.centerOfMassSafeMargin;
    }

    public TObjectDoubleHashMap<OneDoFJointBasics> getInitialRobotConfigurationMap() {
        return this.initialRobotConfigurationMap;
    }

    public static interface IKRobotStateUpdater {
        public boolean updateRobotConfiguration(FloatingJointBasics var1, OneDoFJointBasics[] var2);

        public static IKRobotStateUpdater wrap(RobotConfigurationData robotConfigurationData) {
            return (rootJoint, oneDoFJoints) -> {
                KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(robotConfigurationData, rootJoint, oneDoFJoints);
                return true;
            };
        }
    }

    public static class RobotConfigurationDataBasedUpdater
    implements IKRobotStateUpdater {
        private final ConcurrentCopier<RobotConfigurationData> concurrentRobotConfigurationDataCopier = new ConcurrentCopier(RobotConfigurationData::new);
        protected final RobotConfigurationData robotConfigurationDataInternal = new RobotConfigurationData();

        @Override
        public boolean updateRobotConfiguration(FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints) {
            RobotConfigurationData robotConfigurationData = (RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForReading();
            if (robotConfigurationData == null) {
                return false;
            }
            this.robotConfigurationDataInternal.set(robotConfigurationData);
            KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(this.robotConfigurationDataInternal, rootJoint, oneDoFJoints);
            return true;
        }

        public void setRobotConfigurationData(RobotConfigurationData newConfigurationData) {
            ((RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForWriting()).set(newConfigurationData);
            this.concurrentRobotConfigurationDataCopier.commit();
        }

        public RobotConfigurationData getLastRobotConfigurationData() {
            RobotConfigurationData robotConfigurationData = (RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForReading();
            if (robotConfigurationData == null) {
                return null;
            }
            this.robotConfigurationDataInternal.set(robotConfigurationData);
            return this.robotConfigurationDataInternal;
        }
    }
}

