/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.StabilityMarginKinematicsCostCalculator;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StabilityMarginRegionCalculator;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.WholeBodyContactState;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.WholeBodyContactStateInterface;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.PoseReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.HumanoidKinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.yoVariables.euclid.YoVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class HumanoidKinematicsToolboxController
extends KinematicsToolboxController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final Vector3D zeroVector = new Vector3D();
    private static final double FOOT_COEFFICIENT_OF_FRICTION = 0.8;
    private static final double HAND_COEFFICIENT_OF_FRICTION = 0.4;
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final CommonHumanoidReferenceFrames desiredReferenceFrames;
    private final TIntObjectHashMap<RigidBodyBasics> rigidBodyHashCodeMap = new TIntObjectHashMap();
    private final TIntObjectHashMap<OneDoFJointBasics> jointHashCodeMap = new TIntObjectHashMap();
    private final Map<RigidBodyBasics, RigidBodyBasics> endEffectorToPrimaryBaseMap = new HashMap<RigidBodyBasics, RigidBodyBasics>();
    private final YoBoolean enableAutoSupportPolygon = new YoBoolean("enableAutoSupportPolygon", this.registry);
    private final SideDependentList<YoBoolean> isFootInSupport = new SideDependentList();
    private final SideDependentList<YoFramePose3D> initialFootPoses = new SideDependentList();
    private final SideDependentList<YoBoolean> isHandInSupport = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> initialHandPositions = new SideDependentList();
    private final SideDependentList<FramePoint3D> handContactPointInBodyFrame = new SideDependentList((Object)new FramePoint3D(), (Object)new FramePoint3D());
    private final YoBoolean isUpperBodyLoadBearing = new YoBoolean("isUpperBodyLoadBearing", this.registry);
    private final YoFramePoint3D centerOfMassPositionToHold = new YoFramePoint3D("centerOfMassPositionToHold", worldFrame, this.registry);
    private final YoVector2D centerOfMassOffset = new YoVector2D("centerOfMassOffset", this.registry);
    private final YoBoolean holdCenterOfMassXYPosition = new YoBoolean("holdCenterOfMassXYPosition", this.registry);
    private final YoDouble supportRigidBodyWeight = new YoDouble("supportRigidBodyWeight", this.registry);
    private final YoDouble momentumWeight = new YoDouble("momentumWeight", this.registry);
    private final HashMap<String, YoDouble> jointLimitReductionFactors = new HashMap();
    private final ConcurrentCopier<CapturabilityBasedStatus> concurrentCapturabilityBasedStatusCopier = new ConcurrentCopier(CapturabilityBasedStatus::new);
    private boolean hasCapturabilityBasedStatus = false;
    private final CapturabilityBasedStatus capturabilityBasedStatusInternal = new CapturabilityBasedStatus();
    private final YoBoolean enableJointLimitReduction = new YoBoolean("enableJointLimitReduction", this.registry);
    private final ExecutionTimer executionTimer = new ExecutionTimer("ikTotal", this.registry);
    private final StabilityMarginRegionCalculator multiContactRegionCalculator;
    private final WholeBodyContactState wholeBodyContactState;
    private StabilityMarginKinematicsCostCalculator stabilityCostCalculator;
    private final FramePoint3D tempContactPoint = new FramePoint3D();
    private final FrameVector3D tempContactNormal = new FrameVector3D();
    private final RigidBodyTransform rootJointTransform = new RigidBodyTransform();
    private final RigidBodyTransform rotationRelocation = new RigidBodyTransform();
    private final RigidBodyTransform initialTransform = new RigidBodyTransform();
    private final RigidBodyTransform desiredTransform = new RigidBodyTransform();
    private final Point3D tempMidFeet = new Point3D();
    private final Vector2D tempOffset = new Vector2D();
    private final RecyclingArrayList<FramePoint3D> activeContactPointPositions = new RecyclingArrayList(FramePoint3D::new);
    private final PoseReferenceFrame desiredFootFrame = new PoseReferenceFrame("desiredFootFrame", ReferenceFrame.getWorldFrame());

    public HumanoidKinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(commandInputManager, statusOutputManager, desiredFullRobotModel, HumanoidKinematicsToolboxController.createListOfControllableRigidBodies(desiredFullRobotModel), updateDT, yoGraphicsListRegistry, parentRegistry);
    }

    public HumanoidKinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, Collection<? extends RigidBodyBasics> controllableRigidBodies, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(commandInputManager, statusOutputManager, desiredFullRobotModel.getRootJoint(), FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)desiredFullRobotModel), controllableRigidBodies, updateDT, yoGraphicsListRegistry, parentRegistry);
        this.desiredFullRobotModel = desiredFullRobotModel;
        this.desiredReferenceFrames = new HumanoidReferenceFrames(desiredFullRobotModel, this.centerOfMassFrame, null);
        desiredFullRobotModel.getElevator().subtreeStream().forEach(rigidBody -> this.rigidBodyHashCodeMap.put(rigidBody.hashCode(), rigidBody));
        Arrays.stream(this.desiredOneDoFJoints).forEach(joint -> this.jointHashCodeMap.put(joint.hashCode(), joint));
        this.supportRigidBodyWeight.set(200.0);
        this.momentumWeight.set(0.001);
        this.multiContactRegionCalculator = StabilityMarginRegionCalculator.createForCoPStabilityMargin((String)"", (double)desiredFullRobotModel.getTotalMass(), (ReferenceFrame)this.desiredReferenceFrames.getCenterOfMassFrame(), (ReferenceFrame)this.desiredReferenceFrames.getMidFeetZUpFrame(), (YoRegistry)this.registry, (YoGraphicsListRegistry)yoGraphicsListRegistry);
        this.multiContactRegionCalculator.setupForStabilityMarginCalculation(() -> this.centerOfMass);
        this.wholeBodyContactState = new WholeBodyContactState(this.desiredOneDoFJoints, (JointBasics)this.rootJoint);
        if (desiredFullRobotModel.getChest() != null && desiredFullRobotModel.getHand(RobotSide.LEFT) != null && desiredFullRobotModel.getHand(RobotSide.RIGHT) != null) {
            CentroidalMomentumCalculator centroidalMomentumCalculator = this.controllerCore.getToolbox().getCentroidalMomentumCalculator();
            this.stabilityCostCalculator = new StabilityMarginKinematicsCostCalculator(this.wholeBodyContactState, this.multiContactRegionCalculator, desiredFullRobotModel, (BooleanProvider)this.isUpperBodyLoadBearing, (DoubleProvider)this.getCenterOfMassSafeMargin(), centroidalMomentumCalculator, this.registry);
        }
        for (RobotSide robotSide : RobotSide.values) {
            if (desiredFullRobotModel.getHand(robotSide) != null) {
                this.setupVisualization(desiredFullRobotModel.getHand(robotSide));
            }
            this.setupVisualization(desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        for (RobotSide robotSide : RobotSide.values) {
            String side = robotSide.getCamelCaseNameForMiddleOfExpression();
            String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            this.isFootInSupport.put((Enum)robotSide, (Object)new YoBoolean("is" + side + "FootInSupport", this.registry));
            this.initialFootPoses.put((Enum)robotSide, (Object)new YoFramePose3D(sidePrefix + "FootInitial", worldFrame, this.registry));
            this.isHandInSupport.put((Enum)robotSide, (Object)new YoBoolean("is" + side + "HandInSupport", this.registry));
            this.initialHandPositions.put((Enum)robotSide, (Object)new YoFramePoint3D(sidePrefix + "HandInitial", worldFrame, this.registry));
        }
        for (RobotSide robotSide : RobotSide.values) {
            this.endEffectorToPrimaryBaseMap.put(desiredFullRobotModel.getChest(), desiredFullRobotModel.getHand(robotSide));
            this.endEffectorToPrimaryBaseMap.put(desiredFullRobotModel.getPelvis(), desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        this.populateDefaultJointLimitReductionFactors();
    }

    private void populateDefaultJointLimitReductionFactors() {
        for (int i = 0; i < this.desiredOneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.desiredOneDoFJoints[i];
            YoDouble limitReductionFactor = new YoDouble(joint.getName() + "LimitReductionFactor", this.registry);
            this.jointLimitReductionFactors.put(joint.getName(), limitReductionFactor);
        }
        double defaultHipJointReduction = 0.05;
        for (RobotSide robotSide : RobotSide.values) {
            this.setJointLimitReductionFactor(this.desiredFullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_PITCH).getName(), defaultHipJointReduction);
            this.setJointLimitReductionFactor(this.desiredFullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_ROLL).getName(), defaultHipJointReduction);
            this.setJointLimitReductionFactor(this.desiredFullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_YAW).getName(), defaultHipJointReduction);
        }
    }

    private void setJointLimitReductionFactor(String jointName, double jointLimitReductionFactor) {
        if (this.jointLimitReductionFactors.containsKey(jointName)) {
            this.jointLimitReductionFactors.get(jointName).set(jointLimitReductionFactor);
        }
    }

    private static Collection<RigidBodyBasics> createListOfControllableRigidBodies(FullHumanoidRobotModel desiredFullRobotModel) {
        ArrayList<RigidBodyBasics> listOfControllableRigidBodies = new ArrayList<RigidBodyBasics>();
        listOfControllableRigidBodies.add(desiredFullRobotModel.getHead());
        listOfControllableRigidBodies.add(desiredFullRobotModel.getChest());
        listOfControllableRigidBodies.add(desiredFullRobotModel.getPelvis());
        for (RobotSide robotSide : RobotSide.values) {
            listOfControllableRigidBodies.add(desiredFullRobotModel.getHand(robotSide));
            listOfControllableRigidBodies.add(desiredFullRobotModel.getForearm(robotSide));
            listOfControllableRigidBodies.add(desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        listOfControllableRigidBodies.removeIf(Objects::isNull);
        return listOfControllableRigidBodies;
    }

    public void setInitialRobotConfiguration(DRCRobotModel robotModel) {
        HashMap<OneDoFJointBasics, Double> privilegedConfiguration = new HashMap<OneDoFJointBasics, Double>();
        RobotInitialSetup<HumanoidFloatingRootJointRobot> defaultRobotInitialSetup = robotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        FullHumanoidRobotModel robot = robotModel.createFullRobotModel();
        defaultRobotInitialSetup.initializeFullRobotModel(robot);
        for (OneDoFJointBasics joint : this.getDesiredOneDoFJoints()) {
            double q_priv = robot.getOneDoFJointByName(joint.getName()).getQ();
            privilegedConfiguration.put(joint, q_priv);
        }
        this.setInitialRobotConfiguration(privilegedConfiguration);
    }

    public void setCollisionModel(RobotCollisionModel collisionModel) {
        if (collisionModel != null) {
            this.registerRobotCollidables(collisionModel.getRobotCollidables(this.getDesiredFullRobotModel().getElevator()));
        }
    }

    @Override
    public boolean initialize() {
        this.firstTick = true;
        KinematicsToolboxOutputStatus status = new KinematicsToolboxOutputStatus();
        status.setJointNameHash(-1);
        status.setSolutionQuality(Double.NaN);
        this.resetInternalData();
        boolean wasRobotUpdated = this.desiredRobotStateUpdater.updateRobotConfiguration(this.rootJoint, this.desiredOneDoFJoints);
        if (!wasRobotUpdated) {
            this.commandInputManager.clearAllCommands();
            status.setCurrentToolboxState((byte)2);
            this.reportMessage(status);
            return false;
        }
        this.updateContactInfo();
        if (this.initialRobotConfigurationMap != null) {
            this.computeSupportZUpTransform(this.desiredFullRobotModel, this.initialTransform);
            this.initializePrivilegedConfiguration();
            this.rootJoint.getJointPose().setToZero();
            this.desiredFullRobotModel.updateFrames();
            this.computeSupportZUpTransform(this.desiredFullRobotModel, this.desiredTransform);
            this.rootJointTransform.setAndInvert((RigidBodyTransformReadOnly)this.desiredTransform);
            this.rootJointTransform.multiply((RigidBodyTransformReadOnly)this.initialTransform);
            this.rotationRelocation.setAndInvert((RigidBodyTransformReadOnly)this.rootJoint.getJointPose());
            this.rotationRelocation.multiply((RigidBodyTransformReadOnly)this.desiredTransform);
            this.rootJointTransform.multiplyInvertOther((RigidBodyTransformReadOnly)this.rotationRelocation);
            this.rootJointTransform.preMultiply((RigidBodyTransformReadOnly)this.rotationRelocation);
            this.rootJoint.getJointPose().set((RigidBodyTransformReadOnly)this.rootJointTransform);
        } else {
            this.initializePrivilegedConfiguration();
        }
        this.updateCoMPositionAndFootPoses();
        this.updateCoMPositionToHold();
        this.enableAutoSupportPolygon.set(true);
        this.holdCenterOfMassXYPosition.set(true);
        this.enableJointLimitReduction.set(true);
        this.getSolution().setLeftFootInContact(true);
        this.getSolution().setRightFootInContact(true);
        status.setCurrentToolboxState((byte)1);
        this.reportMessage(status);
        return true;
    }

    private void updateContactInfo() {
        CapturabilityBasedStatus capturabilityBasedStatus = (CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForReading();
        boolean bl = this.hasCapturabilityBasedStatus = capturabilityBasedStatus != null;
        if (this.hasCapturabilityBasedStatus) {
            this.capturabilityBasedStatusInternal.set(capturabilityBasedStatus);
        }
        if (this.hasCapturabilityBasedStatus) {
            this.processCapturabilityBasedStatus(capturabilityBasedStatus);
        } else {
            for (RobotSide robotSide : RobotSide.values) {
                ((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).set(true);
                ((YoBoolean)this.isHandInSupport.get((Enum)robotSide)).set(false);
            }
            this.isUpperBodyLoadBearing.set(false);
        }
    }

    private void computeSupportZUpTransform(FullHumanoidRobotModel fullRobotModel, RigidBodyTransform transformToPack) {
        if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.LEFT)).getValue()) {
            if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
                HumanoidKinematicsToolboxController.computeMidZUpTransform((ReferenceFrame)fullRobotModel.getSoleFrame((Enum)RobotSide.LEFT), (ReferenceFrame)fullRobotModel.getSoleFrame((Enum)RobotSide.RIGHT), (RigidBodyTransformBasics)transformToPack);
            } else {
                HumanoidKinematicsToolboxController.computeZUpTransform((ReferenceFrame)fullRobotModel.getSoleFrame((Enum)RobotSide.LEFT), (RigidBodyTransformBasics)transformToPack);
            }
        } else if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
            HumanoidKinematicsToolboxController.computeZUpTransform((ReferenceFrame)fullRobotModel.getSoleFrame((Enum)RobotSide.RIGHT), (RigidBodyTransformBasics)transformToPack);
        } else {
            throw new IllegalArgumentException("We have a flying robot here, such scenario is not handled.");
        }
    }

    private static void computeMidZUpTransform(ReferenceFrame frameA, ReferenceFrame frameB, RigidBodyTransformBasics transformToPack) {
        RigidBodyTransform transformA = frameA.getTransformToRoot();
        RigidBodyTransform transformB = frameB.getTransformToRoot();
        transformToPack.getTranslation().interpolate((Tuple3DReadOnly)transformA.getTranslation(), (Tuple3DReadOnly)transformB.getTranslation(), 0.5);
        transformToPack.getRotation().setToYawOrientation(AngleTools.computeAngleAverage((double)transformA.getRotation().getYaw(), (double)transformB.getRotation().getYaw()));
    }

    private static void computeZUpTransform(ReferenceFrame frame, RigidBodyTransformBasics transformToPack) {
        RigidBodyTransform transform = frame.getTransformToRoot();
        transformToPack.getTranslation().set((Tuple3DReadOnly)transform.getTranslation());
        transformToPack.getRotation().setToYawOrientation(transform.getRotation().getYaw());
    }

    @Override
    public void updateInternal() {
        this.executionTimer.startMeasurement();
        if (this.commandInputManager.isNewCommandAvailable(HumanoidKinematicsToolboxConfigurationCommand.class)) {
            HumanoidKinematicsToolboxConfigurationCommand command = (HumanoidKinematicsToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(HumanoidKinematicsToolboxConfigurationCommand.class);
            this.holdCenterOfMassXYPosition.set(command.holdCurrentCenterOfMassXYPosition());
            this.enableJointLimitReduction.set(command.enableJointLimitReduction());
            if (this.stabilityCostCalculator != null) {
                this.stabilityCostCalculator.setEnabled(command.enableStabilityObjective());
            }
            if (command.hasCustomJointRestrictionLimits()) {
                int i;
                for (i = 0; i < this.desiredOneDoFJoints.length; ++i) {
                    this.jointLimitReductionFactors.get(this.desiredOneDoFJoints[i].getName()).set(0.0);
                }
                for (i = 0; i < command.getNumberOfCustomJointRestrictionLimits(); ++i) {
                    OneDoFJointBasics joint = (OneDoFJointBasics)this.jointHashCodeMap.get(command.getJointLimitReductionHashCode(i));
                    if (joint == null) continue;
                    double jointLimitReductionFactor = command.getJointRestrictionLimitFactor(i);
                    this.jointLimitReductionFactors.get(joint.getName()).set(jointLimitReductionFactor);
                }
            }
        }
        super.updateInternal();
        if (!this.isUserProvidingSupportPolygon() && this.isUpperBodyLoadBearing.getValue()) {
            this.wholeBodyContactState.updateActuationConstraintVector();
            this.wholeBodyContactState.updateActuationConstraintMatrix();
            this.multiContactRegionCalculator.updateContactState((WholeBodyContactStateInterface)this.wholeBodyContactState);
            this.multiContactRegionCalculator.performUpdateForNextVertex();
            if (this.multiContactRegionCalculator.hasSolvedWholeRegion()) {
                this.activeContactPointPositions.clear();
                this.getSolution().getSupportRegion().clear();
                for (int i = 0; i < this.multiContactRegionCalculator.getNumberOfVertices(); ++i) {
                    ((FramePoint3D)this.activeContactPointPositions.add()).set((FrameTuple2DReadOnly)this.multiContactRegionCalculator.getOptimizedVertex(i));
                    ((Point3D)this.getSolution().getSupportRegion().add()).set((Tuple2DReadOnly)this.multiContactRegionCalculator.getOptimizedVertex(i));
                }
                this.updateSupportPolygonConstraint((List<? extends FramePoint3DReadOnly>)this.activeContactPointPositions);
            }
        }
        this.executionTimer.stopMeasurement();
    }

    @Override
    protected void updateTools() {
        this.desiredReferenceFrames.updateFrames();
        this.centerOfMass.setMatchingFrame(this.desiredReferenceFrames.getCenterOfMassFrame(), 0.0, 0.0, 0.0);
    }

    protected void updateCoMPositionAndFootPoses() {
        this.updateTools();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.desiredFullRobotModel.getFoot((Enum)robotSide);
            ((YoFramePose3D)this.initialFootPoses.get((Enum)robotSide)).setFromReferenceFrame((ReferenceFrame)foot.getBodyFixedFrame());
        }
    }

    public void updateInitialFootPose(RobotSide robotSide) {
        RigidBodyBasics foot = this.desiredFullRobotModel.getFoot((Enum)robotSide);
        double initialFootHeight = ((YoFramePose3D)this.initialFootPoses.get((Enum)robotSide)).getTranslationZ();
        ((YoFramePose3D)this.initialFootPoses.get((Enum)robotSide)).setFromReferenceFrame((ReferenceFrame)foot.getBodyFixedFrame());
        ((YoFramePose3D)this.initialFootPoses.get((Enum)robotSide)).getTranslation().setZ(initialFootHeight);
    }

    protected void updateCoMPositionToHold() {
        if (this.shrunkSupportPolygon.isUpToDate() && !this.shrunkSupportPolygon.isEmpty()) {
            this.tempMidFeet.set((Tuple2DReadOnly)this.shrunkSupportPolygon.getCentroid(), 0.0);
        } else {
            this.tempMidFeet.setToZero();
            for (RobotSide robotSide : RobotSide.values) {
                RigidBodyTransform soleFramePose = this.desiredFullRobotModel.getSoleFrame((Enum)robotSide).getTransformToRoot();
                this.tempMidFeet.scaleAdd(0.5, (Tuple3DReadOnly)soleFramePose.getTranslation(), (Tuple3DReadOnly)this.tempMidFeet);
            }
        }
        double averageYaw = 0.0;
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyTransform soleFramePose = this.desiredFullRobotModel.getSoleFrame((Enum)robotSide).getTransformToRoot();
            averageYaw += soleFramePose.getRotation().getYaw();
        }
        averageYaw *= 0.5;
        averageYaw = EuclidCoreTools.trimAngleMinusPiToPi((double)averageYaw);
        RotationMatrixTools.applyYawRotation((double)averageYaw, (Tuple2DReadOnly)this.centerOfMassOffset, (Tuple2DBasics)this.tempOffset);
        this.centerOfMassPositionToHold.setX(this.tempMidFeet.getX() + this.tempOffset.getX());
        this.centerOfMassPositionToHold.setY(this.tempMidFeet.getY() + this.tempOffset.getY());
    }

    private void addHoldSupportEndEffectorCommands(FeedbackControlCommandBuffer bufferToPack) {
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.desiredFullRobotModel.getFoot((Enum)robotSide);
            if (((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).getBooleanValue() && !this.isUserControllingRigidBody(foot)) {
                SpatialFeedbackControlCommand feedbackControlCommand = bufferToPack.addSpatialFeedbackControlCommand();
                feedbackControlCommand.set(this.rootBody, foot);
                feedbackControlCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(foot));
                feedbackControlCommand.resetControlFrame();
                feedbackControlCommand.resetControlBaseFrame();
                feedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.getDefaultSpatialGains());
                feedbackControlCommand.setSelectionMatrixToIdentity();
                feedbackControlCommand.setWeightForSolver(this.supportRigidBodyWeight.getValue());
                feedbackControlCommand.setInverseKinematics((FramePose3DReadOnly)this.initialFootPoses.get((Enum)robotSide), KinematicsToolboxHelper.zeroVector6D);
            }
            RigidBodyBasics hand = this.desiredFullRobotModel.getHand(robotSide);
            if (!((YoBoolean)this.isHandInSupport.get((Enum)robotSide)).getBooleanValue() || this.isUserControllingRigidBodyPosition(hand)) continue;
            PointFeedbackControlCommand feedbackControlCommand = bufferToPack.addPointFeedbackControlCommand();
            feedbackControlCommand.set(this.rootBody, hand);
            feedbackControlCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(hand));
            feedbackControlCommand.setBodyFixedPointToControl((FramePoint3DReadOnly)this.handContactPointInBodyFrame.get((Enum)robotSide));
            feedbackControlCommand.resetControlBaseFrame();
            feedbackControlCommand.setGains((PID3DGainsReadOnly)this.getDefaultSpatialGains().getPositionGains());
            feedbackControlCommand.setSelectionMatrixToIdentity();
            feedbackControlCommand.setWeightForSolver(this.supportRigidBodyWeight.getValue());
            feedbackControlCommand.setInverseKinematics((FramePoint3DReadOnly)this.initialHandPositions.get((Enum)robotSide), KinematicsToolboxHelper.zeroVector3D);
        }
    }

    private void addHoldCenterOfMassXYCommand(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdCenterOfMassXYPosition.getBooleanValue()) {
            return;
        }
        if (this.isUserControllingCenterOfMass()) {
            this.holdCenterOfMassXYPosition.set(false);
            return;
        }
        this.updateCoMPositionToHold();
        CenterOfMassFeedbackControlCommand feedbackControlCommand = bufferToPack.addCenterOfMassFeedbackControlCommand();
        feedbackControlCommand.setGains((PID3DGains)this.getDefaultSpatialGains().getPositionGains());
        feedbackControlCommand.setWeightForSolver(this.momentumWeight.getDoubleValue());
        feedbackControlCommand.setSelectionMatrixForLinearXYControl();
        feedbackControlCommand.setInverseKinematics((FramePoint3DReadOnly)this.centerOfMassPositionToHold, KinematicsToolboxHelper.zeroVector3D);
    }

    private void addJointLimitReductionCommand(InverseKinematicsCommandBuffer bufferToPack) {
        if (!this.enableJointLimitReduction.getValue()) {
            return;
        }
        JointLimitReductionCommand jointLimitReductionCommand = bufferToPack.addJointLimitReductionCommand();
        jointLimitReductionCommand.clear();
        for (int i = 0; i < this.desiredOneDoFJoints.length; ++i) {
            double reductionFactor = this.jointLimitReductionFactors.get(this.desiredOneDoFJoints[i].getName()).getValue();
            if (reductionFactor <= 0.0 || reductionFactor > 1.0) continue;
            jointLimitReductionCommand.addReductionFactor(this.desiredOneDoFJoints[i], reductionFactor);
        }
    }

    private void processCapturabilityBasedStatus(CapturabilityBasedStatus capturabilityBasedStatus) {
        int i;
        for (RobotSide robotside : RobotSide.values) {
            ((YoBoolean)this.isFootInSupport.get((Enum)robotside)).set(HumanoidMessageTools.unpackIsSupportFoot((CapturabilityBasedStatus)capturabilityBasedStatus, (RobotSide)robotside));
            ((YoBoolean)this.isHandInSupport.get((Enum)robotside)).set(HumanoidMessageTools.unpackIsSupportHand((CapturabilityBasedStatus)capturabilityBasedStatus, (RobotSide)robotside, (FullHumanoidRobotModel)this.desiredFullRobotModel, (FramePoint3DBasics)((FramePoint3DBasics)this.handContactPointInBodyFrame.get((Enum)robotside))));
            if (!((YoBoolean)this.isHandInSupport.get((Enum)robotside)).getBooleanValue()) continue;
            ((YoFramePoint3D)this.initialHandPositions.get((Enum)robotside)).setMatchingFrame((FrameTuple3DReadOnly)this.handContactPointInBodyFrame.get((Enum)robotside));
        }
        this.isUpperBodyLoadBearing.set(((YoBoolean)this.isHandInSupport.get((Enum)RobotSide.LEFT)).getValue() || ((YoBoolean)this.isHandInSupport.get((Enum)RobotSide.RIGHT)).getValue());
        if (this.isUserProvidingSupportPolygon()) {
            return;
        }
        if (this.isUpperBodyLoadBearing.getValue()) {
            this.initializeWholeBodyContactState();
        }
        this.activeContactPointPositions.clear();
        IDLSequence.Object leftFootSupportPolygon2d = capturabilityBasedStatus.getLeftFootSupportPolygon3d();
        IDLSequence.Object rightFootSupportPolygon2d = capturabilityBasedStatus.getRightFootSupportPolygon3d();
        for (i = 0; i < leftFootSupportPolygon2d.size(); ++i) {
            ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)leftFootSupportPolygon2d.get(i));
        }
        for (i = 0; i < rightFootSupportPolygon2d.size(); ++i) {
            ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)rightFootSupportPolygon2d.get(i));
        }
        this.updateSupportPolygonConstraint((List<? extends FramePoint3DReadOnly>)this.activeContactPointPositions);
    }

    private void initializeWholeBodyContactState() {
        this.multiContactRegionCalculator.clear();
        this.wholeBodyContactState.clear();
        if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.LEFT)).getValue()) {
            this.packFootContactPoints(RobotSide.LEFT, (List<Point3D>)this.capturabilityBasedStatusInternal.getLeftFootSupportPolygon3d());
        }
        if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
            this.packFootContactPoints(RobotSide.RIGHT, (List<Point3D>)this.capturabilityBasedStatusInternal.getRightFootSupportPolygon3d());
        }
        if (((YoBoolean)this.isHandInSupport.get((Enum)RobotSide.LEFT)).getValue()) {
            this.packHandContactPoint(RobotSide.LEFT, (Vector3DBasics)this.capturabilityBasedStatusInternal.getLeftHandContactNormal());
        }
        if (((YoBoolean)this.isHandInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
            this.packHandContactPoint(RobotSide.RIGHT, (Vector3DBasics)this.capturabilityBasedStatusInternal.getRightHandContactNormal());
        }
        this.wholeBodyContactState.update();
        this.multiContactRegionCalculator.updateContactState((WholeBodyContactStateInterface)this.wholeBodyContactState, true);
    }

    private void packFootContactPoints(RobotSide robotSide, List<Point3D> contactPoints) {
        for (int i = 0; i < contactPoints.size(); ++i) {
            this.tempContactPoint.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)contactPoints.get(i));
            this.tempContactNormal.setIncludingFrame((ReferenceFrame)this.desiredFullRobotModel.getSoleFrame((Enum)robotSide), (Tuple3DReadOnly)Axis3D.Z);
            this.wholeBodyContactState.addContactPoint(this.desiredFullRobotModel.getFoot((Enum)robotSide), (FrameTuple3DReadOnly)this.tempContactPoint, (FrameVector3DReadOnly)this.tempContactNormal, 0.8);
        }
    }

    private void packHandContactPoint(RobotSide robotSide, Vector3DBasics contactNormalInWorld) {
        this.tempContactNormal.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)contactNormalInWorld);
        this.wholeBodyContactState.addContactPoint(this.desiredFullRobotModel.getHand(robotSide), (FrameTuple3DReadOnly)this.handContactPointInBodyFrame.get((Enum)robotSide), (FrameVector3DReadOnly)this.tempContactNormal, 0.4);
    }

    @Override
    protected void robotConfigurationReinitialized() {
        this.updateCoMPositionAndFootPoses();
    }

    public void updateFootSupportState(boolean isLeftFootInSupport, boolean isRightFootInSupport) {
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        if (isLeftFootInSupport) {
            capturabilityBasedStatus.getLeftFootSupportPolygon3d().add();
        }
        if (isRightFootInSupport) {
            capturabilityBasedStatus.getRightFootSupportPolygon3d().add();
        }
        this.updateCapturabilityBasedStatus(capturabilityBasedStatus);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        ((CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForWriting()).set(newStatus);
        this.concurrentCapturabilityBasedStatusCopier.commit();
    }

    public void setCenterOfMassOffset(Vector2DReadOnly offset) {
        this.centerOfMassOffset.set((Tuple2DReadOnly)offset);
    }

    @Override
    protected RigidBodyBasics getEndEffectorPrimaryBase(RigidBodyBasics endEffector) {
        return this.endEffectorToPrimaryBaseMap.get(endEffector);
    }

    @Override
    protected void getAdditionalFeedbackControlCommands(FeedbackControlCommandBuffer bufferToPack) {
        this.addHoldSupportEndEffectorCommands(bufferToPack);
        this.addHoldCenterOfMassXYCommand(bufferToPack);
        if (this.stabilityCostCalculator != null) {
            this.stabilityCostCalculator.addPostureFeedbackCommands(bufferToPack);
        }
    }

    @Override
    protected void getAdditionalInverseKinematicsCommands(InverseKinematicsCommandBuffer bufferToPack) {
        this.addJointLimitReductionCommand(bufferToPack);
    }

    public YoDouble getMomentumWeight() {
        return this.momentumWeight;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.desiredFullRobotModel;
    }

    public CommonHumanoidReferenceFrames getDesiredReferenceFrames() {
        return this.desiredReferenceFrames;
    }

    public void setIsFootInSupport(RobotSide side, boolean value) {
        ((YoBoolean)this.isFootInSupport.get((Enum)side)).set(value);
        this.getSolution().setLeftFootInContact(((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.LEFT)).getValue());
        this.getSolution().setRightFootInContact(((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue());
    }

    public void updateSupportPolygon(SideDependentList<Boolean> isFootInSupport, double footLength, double footWidth, boolean overrideContactState) {
        this.activeContactPointPositions.clear();
        double halfLength = footLength / 2.0;
        double halfWidth = footWidth / 2.0;
        Point2D[] footCorners = new Point2D[]{new Point2D(-halfLength, -halfWidth), new Point2D(halfLength, -halfWidth), new Point2D(halfLength, halfWidth), new Point2D(-halfLength, halfWidth)};
        for (RobotSide side : RobotSide.values) {
            if (!((Boolean)isFootInSupport.get((Enum)side)).booleanValue() && !overrideContactState) continue;
            FramePose3D footPose = new FramePose3D();
            if (((Boolean)isFootInSupport.get((Enum)side)).booleanValue()) {
                footPose.set((FramePose3DReadOnly)this.initialFootPoses.get((Enum)side));
            } else if (overrideContactState) {
                RigidBodyBasics foot = this.desiredFullRobotModel.getFoot((Enum)side);
                footPose.setFromReferenceFrame((ReferenceFrame)foot.getBodyFixedFrame());
            }
            this.desiredFootFrame.setPoseAndUpdate((FramePose3DReadOnly)footPose);
            for (Point2D corner : footCorners) {
                FramePoint3D cornerInFoot = new FramePoint3D((ReferenceFrame)this.desiredFootFrame, corner.getX(), corner.getY(), ((YoFramePose3D)this.initialFootPoses.get((Enum)side)).getTranslationZ());
                cornerInFoot.changeFrame(worldFrame);
                ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame((FrameTuple3DReadOnly)cornerInFoot);
            }
        }
        this.updateSupportPolygonConstraint((List<? extends FramePoint3DReadOnly>)this.activeContactPointPositions);
        this.updateCoMPositionToHold();
    }
}

