/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import java.util.Arrays;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataBasics;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.euclid.QuaternionCalculus;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialAcceleration;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoKinematicsToolboxOutputStatus
implements KSTOutputDataBasics {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final String namePrefix;
    private final int numberOfJoints;
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final YoEnum<Status> currentToolboxState;
    private final YoInteger jointNameHash;
    private final YoFramePose3D rootJointPose;
    private final YoDouble[] jointAngles;
    private final YoFixedFrameTwist rootJointVelocity;
    private final YoDouble[] jointVelocities;
    private YoFixedFrameSpatialAcceleration rootJointAcceleration;
    private YoDouble[] jointAccelerations;
    private final Vector4D quaternionDot = new Vector4D();
    private final QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
    private MultiBodySystemStateIntegrator integrator;

    public YoKinematicsToolboxOutputStatus(String namePrefix, FullHumanoidRobotModel fullRobotModel, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.rootJoint = fullRobotModel.getRootJoint();
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.currentToolboxState = new YoEnum(namePrefix + "CurrentToolboxState", this.registry, Status.class, true);
        this.jointNameHash = new YoInteger(namePrefix + "JointNameHash", this.registry);
        this.jointNameHash.set(Arrays.hashCode(this.oneDoFJoints));
        this.numberOfJoints = this.oneDoFJoints.length;
        this.jointAngles = new YoDouble[this.numberOfJoints];
        this.jointVelocities = new YoDouble[this.numberOfJoints];
        for (int i = 0; i < this.numberOfJoints; ++i) {
            String jointName = this.oneDoFJoints[i].getName();
            this.jointAngles[i] = new YoDouble("q_d_" + namePrefix + "_" + jointName, this.registry);
            this.jointVelocities[i] = new YoDouble("qd_d_" + namePrefix + "_" + jointName, this.registry);
        }
        this.rootJointPose = new YoFramePose3D(namePrefix + "Desired" + this.rootJoint.getName(), worldFrame, this.registry);
        this.rootJointVelocity = new YoFixedFrameTwist(namePrefix + "DesiredVelocity" + this.rootJoint.getName(), (ReferenceFrame)this.rootJoint.getFrameAfterJoint(), worldFrame, (ReferenceFrame)this.rootJoint.getFrameAfterJoint(), this.registry);
    }

    public void createAccelerationState() {
        this.rootJointAcceleration = new YoFixedFrameSpatialAcceleration(this.namePrefix + "DesiredAcceleration" + this.rootJoint.getName(), (ReferenceFrame)this.rootJoint.getFrameAfterJoint(), worldFrame, (ReferenceFrame)this.rootJoint.getFrameAfterJoint(), this.registry);
        this.jointAccelerations = new YoDouble[this.numberOfJoints];
        for (int i = 0; i < this.numberOfJoints; ++i) {
            String jointName = this.oneDoFJoints[i].getName();
            this.jointAccelerations[i] = new YoDouble("qdd_d_" + this.namePrefix + "_" + jointName, this.registry);
        }
    }

    public void setToNaN() {
        this.currentToolboxState.set(null);
        for (YoDouble desiredJointAngle : this.jointAngles) {
            desiredJointAngle.setToNaN();
        }
        for (YoDouble desiredJointVelocity : this.jointVelocities) {
            desiredJointVelocity.setToNaN();
        }
        this.rootJointPose.setToNaN();
        this.rootJointVelocity.setToNaN();
        if (this.jointAccelerations != null) {
            for (YoDouble desiredJointAcceleration : this.jointAccelerations) {
                desiredJointAcceleration.setToNaN();
            }
            this.rootJointAcceleration.setToNaN();
        }
    }

    public void set(YoKinematicsToolboxOutputStatus other) {
        if (this.jointNameHash.getValue() != other.jointNameHash.getValue()) {
            throw new IllegalArgumentException("Incompatible status");
        }
        this.currentToolboxState.set((Enum)((Status)other.currentToolboxState.getEnumValue()));
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.jointAngles[i].set(other.jointAngles[i].getValue());
            this.jointVelocities[i].set(other.jointVelocities[i].getValue());
        }
        this.rootJointPose.set((FramePose3DReadOnly)other.rootJointPose);
        this.rootJointVelocity.set(other.rootJointVelocity);
    }

    public void scaleVelocities(double scaleFactor) {
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.jointVelocities[i].set(this.jointVelocities[i].getValue() * scaleFactor);
        }
        this.rootJointVelocity.scale(scaleFactor);
    }

    public void setVelocitiesByFiniteDifference(KSTOutputDataReadOnly previous, KSTOutputDataReadOnly current, double duration) {
        if (previous.getJointNameHash() != current.getJointNameHash() || previous.getJointNameHash() != this.jointNameHash.getValue()) {
            throw new RuntimeException("Output status are not compatible.");
        }
        for (int i = 0; i < this.numberOfJoints; ++i) {
            double qd = (current.getJointPosition(i) - previous.getJointPosition(i)) / duration;
            if (!Double.isFinite(qd)) {
                qd = 0.0;
            }
            this.jointVelocities[i].set(qd);
        }
        this.rootJointVelocity.getLinearPart().sub((Tuple3DReadOnly)current.getRootJointPosition(), (Tuple3DReadOnly)current.getRootJointPosition());
        this.rootJointVelocity.getLinearPart().scale(1.0 / duration);
        if (this.rootJointVelocity.containsNaN()) {
            this.rootJointVelocity.setToZero();
        } else {
            this.rootJointPose.getOrientation().inverseTransform((Tuple3DBasics)this.rootJointVelocity.getLinearPart());
        }
        this.quaternionDot.sub((Tuple4DReadOnly)current.getRootJointOrientation(), (Tuple4DReadOnly)previous.getRootJointOrientation());
        this.quaternionDot.scale(1.0 / duration);
        if (this.quaternionDot.containsNaN()) {
            this.quaternionDot.setToZero();
            this.rootJointVelocity.setToZero();
        } else {
            this.quaternionCalculus.computeAngularVelocityInRotatedFrame((QuaternionReadOnly)this.rootJointPose.getOrientation(), (Vector4DReadOnly)this.quaternionDot, (Vector3DBasics)this.rootJointVelocity.getAngularPart());
        }
    }

    public void integrate(double dt) {
        if (this.integrator == null) {
            this.integrator = new MultiBodySystemStateIntegrator();
        }
        this.integrator.setIntegrationDT(dt);
        if (!this.hasAccelerationData()) {
            for (int i = 0; i < this.getNumberOfJoints(); ++i) {
                this.jointAngles[i].add(this.jointVelocities[i].getValue() * dt);
            }
            this.integrator.integrate((Vector3DReadOnly)this.rootJointVelocity.getAngularPart(), (Orientation3DReadOnly)this.rootJointPose.getOrientation(), (Orientation3DBasics)this.rootJointPose.getOrientation());
            this.integrator.integrate((Orientation3DReadOnly)this.rootJointPose.getOrientation(), (Vector3DReadOnly)this.rootJointVelocity.getLinearPart(), (Tuple3DReadOnly)this.rootJointPose.getPosition(), (Tuple3DBasics)this.rootJointPose.getPosition());
        } else {
            for (int i = 0; i < this.getNumberOfJoints(); ++i) {
                this.jointAngles[i].add(this.jointVelocities[i].getValue() * dt + 0.5 * dt * dt * this.jointAccelerations[i].getValue());
                this.jointVelocities[i].add(this.jointAccelerations[i].getValue() * dt);
            }
            this.integrator.doubleIntegrate((FixedFrameSpatialAccelerationBasics)this.rootJointAcceleration, (FixedFrameTwistBasics)this.rootJointVelocity, (Pose3DBasics)this.rootJointPose);
        }
    }

    @Override
    public int getJointNameHash() {
        return this.jointNameHash.getValue();
    }

    @Override
    public boolean hasAccelerationData() {
        return this.jointAccelerations != null;
    }

    @Override
    public Point3DBasics getRootJointPosition() {
        return this.rootJointPose.getPosition();
    }

    @Override
    public QuaternionBasics getRootJointOrientation() {
        return this.rootJointPose.getOrientation();
    }

    @Override
    public Vector3DBasics getRootJointLinearVelocity() {
        return this.rootJointVelocity.getLinearPart();
    }

    @Override
    public Vector3DBasics getRootJointAngularVelocity() {
        return this.rootJointVelocity.getAngularPart();
    }

    @Override
    public Vector3DBasics getRootJointLinearAcceleration() {
        if (this.rootJointAcceleration == null) {
            return null;
        }
        return this.rootJointAcceleration.getLinearPart();
    }

    @Override
    public Vector3DBasics getRootJointAngularAcceleration() {
        if (this.rootJointAcceleration == null) {
            return null;
        }
        return this.rootJointAcceleration.getAngularPart();
    }

    @Override
    public int getNumberOfJoints() {
        return this.numberOfJoints;
    }

    @Override
    public double getJointPosition(int jointIndex) {
        return this.jointAngles[jointIndex].getValue();
    }

    @Override
    public double getJointVelocity(int jointIndex) {
        return this.jointVelocities[jointIndex].getValue();
    }

    @Override
    public double getJointAcceleration(int jointIndex) {
        if (this.jointAccelerations == null) {
            return 0.0;
        }
        return this.jointAccelerations[jointIndex].getValue();
    }

    @Override
    public void setJointPosition(int jointIndex, double position) {
        this.jointAngles[jointIndex].set(position);
    }

    @Override
    public void setJointVelocity(int jointIndex, double velocity) {
        this.jointVelocities[jointIndex].set(velocity);
    }

    @Override
    public void setJointAcceleration(int jointIndex, double acceleration) {
        if (this.jointAccelerations == null) {
            return;
        }
        this.jointAccelerations[jointIndex].set(acceleration);
    }

    public FloatingJointBasics getRootJoint() {
        return this.rootJoint;
    }

    public OneDoFJointBasics[] getOneDoFJoints() {
        return this.oneDoFJoints;
    }

    public static enum Status {
        NO_STATUS,
        INITIALIZE_SUCCESSFUL,
        INITIALIZE_FAILURE_MISSING_RCD,
        RUNNING;

        public static final Status[] values;

        public static Status fromByte(byte enumAsByte) {
            if (enumAsByte == -1) {
                return null;
            }
            return values[enumAsByte];
        }

        public static byte toByte(Status status) {
            if (status == null) {
                return -1;
            }
            return (byte)status.ordinal();
        }

        static {
            values = Status.values();
        }
    }
}

