/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;

public class KSTOutputProcessors
implements KSTOutputProcessor {
    private final List<KSTOutputProcessor> outputProcessors = new ArrayList<KSTOutputProcessor>();

    public void add(KSTOutputProcessor outputProcessor) {
        this.outputProcessors.add(outputProcessor);
    }

    @Override
    public void initialize() {
        for (int i = 0; i < this.outputProcessors.size(); ++i) {
            this.outputProcessors.get(i).initialize();
        }
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        KSTOutputDataReadOnly previousOutput = latestOutput;
        for (int i = 0; i < this.outputProcessors.size(); ++i) {
            KSTOutputProcessor outputProcessor = this.outputProcessors.get(i);
            outputProcessor.update(time, wasStreaming, isStreaming, previousOutput);
            previousOutput = outputProcessor.getProcessedOutput();
        }
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        if (this.outputProcessors.isEmpty()) {
            return null;
        }
        return this.outputProcessors.get(this.outputProcessors.size() - 1).getProcessedOutput();
    }
}

