/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import java.util.Arrays;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public interface KSTOutputDataReadOnly {
    public int getJointNameHash();

    public boolean hasAccelerationData();

    public Point3DReadOnly getRootJointPosition();

    public QuaternionReadOnly getRootJointOrientation();

    default public Vector3DReadOnly getRootJointLinearVelocity() {
        return null;
    }

    default public Vector3DReadOnly getRootJointAngularVelocity() {
        return null;
    }

    default public Vector3DReadOnly getRootJointLinearAcceleration() {
        return null;
    }

    default public Vector3DReadOnly getRootJointAngularAcceleration() {
        return null;
    }

    public int getNumberOfJoints();

    public double getJointPosition(int var1);

    default public double getJointVelocity(int jointIndex) {
        return 0.0;
    }

    default public double getJointAcceleration(int jointIndex) {
        return 0.0;
    }

    default public void updateRobot(FloatingJointBasics rootJointToUpdate, OneDoFJointBasics[] jointsToUpdate) {
        int i;
        if (this.getJointNameHash() != Arrays.hashCode(jointsToUpdate)) {
            throw new RuntimeException("The robots are different.");
        }
        rootJointToUpdate.getJointPose().getPosition().set((Tuple3DReadOnly)this.getRootJointPosition());
        rootJointToUpdate.getJointPose().getOrientation().set(this.getRootJointOrientation());
        rootJointToUpdate.getJointTwist().getLinearPart().set((Tuple3DReadOnly)this.getRootJointLinearVelocity());
        rootJointToUpdate.getJointTwist().getAngularPart().set((Tuple3DReadOnly)this.getRootJointAngularVelocity());
        for (i = 0; i < jointsToUpdate.length; ++i) {
            jointsToUpdate[i].setQ(this.getJointPosition(i));
            jointsToUpdate[i].setQd(this.getJointVelocity(i));
        }
        if (this.hasAccelerationData()) {
            rootJointToUpdate.getJointAcceleration().getLinearPart().set((Tuple3DReadOnly)this.getRootJointLinearAcceleration());
            rootJointToUpdate.getJointAcceleration().getAngularPart().set((Tuple3DReadOnly)this.getRootJointAngularAcceleration());
            for (i = 0; i < jointsToUpdate.length; ++i) {
                jointsToUpdate[i].setQdd(this.getJointAcceleration(i));
            }
        }
    }

    default public void checkCompatibility(KSTOutputDataReadOnly other) {
        if (this.getJointNameHash() != other.getJointNameHash()) {
            throw new IllegalArgumentException("Joint name hash does not match, cannot set data from different robot.");
        }
        if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
            throw new IllegalArgumentException("Number of joints does not match, cannot set data from different robot.");
        }
    }

    public static KSTOutputDataReadOnly wrap(final KinematicsToolboxOutputStatus outputStatus) {
        return new KSTOutputDataReadOnly(){

            @Override
            public int getJointNameHash() {
                return outputStatus.getJointNameHash();
            }

            @Override
            public boolean hasAccelerationData() {
                return false;
            }

            @Override
            public Point3DReadOnly getRootJointPosition() {
                return outputStatus.getDesiredRootPosition();
            }

            @Override
            public QuaternionReadOnly getRootJointOrientation() {
                return outputStatus.getDesiredRootOrientation();
            }

            @Override
            public Vector3DReadOnly getRootJointLinearVelocity() {
                return outputStatus.getDesiredRootLinearVelocity();
            }

            @Override
            public Vector3DReadOnly getRootJointAngularVelocity() {
                return outputStatus.getDesiredRootAngularVelocity();
            }

            @Override
            public int getNumberOfJoints() {
                return outputStatus.getDesiredJointAngles().size();
            }

            @Override
            public double getJointPosition(int jointIndex) {
                return outputStatus.getDesiredJointAngles().get(jointIndex);
            }

            @Override
            public double getJointVelocity(int jointIndex) {
                return outputStatus.getDesiredJointVelocities().get(jointIndex);
            }
        };
    }
}

