/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import java.util.Arrays;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;

public interface KSTOutputDataBasics
extends KSTOutputDataReadOnly {
    public Point3DBasics getRootJointPosition();

    public QuaternionBasics getRootJointOrientation();

    default public Vector3DBasics getRootJointLinearVelocity() {
        return null;
    }

    default public Vector3DBasics getRootJointAngularVelocity() {
        return null;
    }

    default public Vector3DBasics getRootJointLinearAcceleration() {
        return null;
    }

    default public Vector3DBasics getRootJointAngularAcceleration() {
        return null;
    }

    public void setJointPosition(int var1, double var2);

    default public void setJointVelocity(int jointIndex, double velocity) {
    }

    default public void setJointAcceleration(int jointIndex, double acceleration) {
    }

    default public void set(KSTOutputDataReadOnly other) {
        int i;
        this.checkCompatibility(other);
        this.getRootJointPosition().set((Tuple3DReadOnly)other.getRootJointPosition());
        this.getRootJointOrientation().set(other.getRootJointOrientation());
        this.getRootJointLinearVelocity().set((Tuple3DReadOnly)other.getRootJointLinearVelocity());
        this.getRootJointAngularVelocity().set((Tuple3DReadOnly)other.getRootJointAngularVelocity());
        for (i = 0; i < this.getNumberOfJoints(); ++i) {
            this.setJointPosition(i, other.getJointPosition(i));
            this.setJointVelocity(i, other.getJointVelocity(i));
        }
        if (this.hasAccelerationData()) {
            if (other.hasAccelerationData()) {
                this.getRootJointLinearAcceleration().set((Tuple3DReadOnly)other.getRootJointLinearAcceleration());
                this.getRootJointAngularAcceleration().set((Tuple3DReadOnly)other.getRootJointAngularAcceleration());
                for (i = 0; i < this.getNumberOfJoints(); ++i) {
                    this.setJointAcceleration(i, other.getJointAcceleration(i));
                }
            } else {
                this.setAccelerationToZero();
            }
        }
    }

    default public void setConfiguration(KSTOutputDataReadOnly other) {
        this.checkCompatibility(other);
        this.getRootJointPosition().set((Tuple3DReadOnly)other.getRootJointPosition());
        this.getRootJointOrientation().set(other.getRootJointOrientation());
        for (int i = 0; i < this.getNumberOfJoints(); ++i) {
            this.setJointPosition(i, other.getJointPosition(i));
        }
    }

    default public void interpolate(KSTOutputDataReadOnly end, double alpha) {
        this.interpolate(this, end, alpha);
    }

    default public void interpolate(KSTOutputDataReadOnly start, KSTOutputDataReadOnly end, double alpha) {
        this.checkCompatibility(start);
        this.checkCompatibility(end);
        this.getRootJointPosition().interpolate((Tuple3DReadOnly)start.getRootJointPosition(), (Tuple3DReadOnly)end.getRootJointPosition(), alpha);
        this.getRootJointOrientation().interpolate(start.getRootJointOrientation(), end.getRootJointOrientation(), alpha);
        this.getRootJointLinearVelocity().interpolate((Tuple3DReadOnly)start.getRootJointLinearVelocity(), (Tuple3DReadOnly)end.getRootJointLinearVelocity(), alpha);
        this.getRootJointAngularVelocity().interpolate((Tuple3DReadOnly)start.getRootJointAngularVelocity(), (Tuple3DReadOnly)end.getRootJointAngularVelocity(), alpha);
        for (int i = 0; i < this.getNumberOfJoints(); ++i) {
            this.setJointPosition(i, EuclidCoreTools.interpolate((double)start.getJointPosition(i), (double)end.getJointPosition(i), (double)alpha));
            this.setJointVelocity(i, EuclidCoreTools.interpolate((double)start.getJointVelocity(i), (double)end.getJointVelocity(i), (double)alpha));
        }
        if (this.hasAccelerationData()) {
            boolean hasStartAcceleration = start.hasAccelerationData();
            boolean hasEndAcceleration = end.hasAccelerationData();
            if (!hasStartAcceleration && !hasEndAcceleration) {
                this.setAccelerationToZero();
            } else {
                Vector3DReadOnly startLinearRootAcceleration = hasStartAcceleration ? start.getRootJointLinearAcceleration() : EuclidCoreTools.zeroVector3D;
                Vector3DReadOnly startAngularRootAcceleration = hasStartAcceleration ? start.getRootJointAngularAcceleration() : EuclidCoreTools.zeroVector3D;
                Vector3DReadOnly endLinearRootAcceleration = hasEndAcceleration ? end.getRootJointLinearAcceleration() : EuclidCoreTools.zeroVector3D;
                Vector3DReadOnly endAngularRootAcceleration = hasEndAcceleration ? end.getRootJointAngularAcceleration() : EuclidCoreTools.zeroVector3D;
                this.getRootJointLinearAcceleration().interpolate((Tuple3DReadOnly)startLinearRootAcceleration, (Tuple3DReadOnly)endLinearRootAcceleration, alpha);
                this.getRootJointAngularAcceleration().interpolate((Tuple3DReadOnly)startAngularRootAcceleration, (Tuple3DReadOnly)endAngularRootAcceleration, alpha);
                for (int i = 0; i < this.getNumberOfJoints(); ++i) {
                    double qdd_start = hasStartAcceleration ? start.getJointAcceleration(i) : 0.0;
                    double qdd_end = hasEndAcceleration ? end.getJointAcceleration(i) : 0.0;
                    double qdd = EuclidCoreTools.interpolate((double)qdd_start, (double)qdd_end, (double)alpha);
                    this.setJointAcceleration(i, qdd);
                }
            }
        }
    }

    default public void setAccelerationToZero() {
        this.getRootJointLinearAcceleration().setToZero();
        this.getRootJointAngularAcceleration().setToZero();
        for (int i = 0; i < this.getNumberOfJoints(); ++i) {
            this.setJointAcceleration(i, 0.0);
        }
    }

    default public void setFromRobot(FloatingJointReadOnly rootJoint, OneDoFJointReadOnly[] joints) {
        int i;
        if (this.getJointNameHash() != Arrays.hashCode(joints)) {
            throw new IllegalArgumentException("Joint name hash does not match, cannot set data from different robot.");
        }
        this.getRootJointPosition().set((Tuple3DReadOnly)rootJoint.getJointPose().getPosition());
        this.getRootJointOrientation().set(rootJoint.getJointPose().getOrientation());
        this.getRootJointLinearVelocity().set((Tuple3DReadOnly)rootJoint.getJointTwist().getLinearPart());
        this.getRootJointAngularVelocity().set((Tuple3DReadOnly)rootJoint.getJointTwist().getAngularPart());
        for (i = 0; i < this.getNumberOfJoints(); ++i) {
            this.setJointPosition(i, joints[i].getQ());
            this.setJointVelocity(i, joints[i].getQd());
        }
        if (this.hasAccelerationData()) {
            this.getRootJointLinearAcceleration().set((Tuple3DReadOnly)rootJoint.getJointAcceleration().getLinearPart());
            this.getRootJointAngularAcceleration().set((Tuple3DReadOnly)rootJoint.getJointAcceleration().getAngularPart());
            for (i = 0; i < this.getNumberOfJoints(); ++i) {
                this.setJointAcceleration(i, joints[i].getQdd());
            }
        }
    }

    public static KSTOutputDataBasics wrap(final KinematicsToolboxOutputStatus outputStatus) {
        return new KSTOutputDataBasics(){

            @Override
            public int getJointNameHash() {
                return outputStatus.getJointNameHash();
            }

            @Override
            public boolean hasAccelerationData() {
                return false;
            }

            @Override
            public Point3DBasics getRootJointPosition() {
                return outputStatus.getDesiredRootPosition();
            }

            @Override
            public QuaternionBasics getRootJointOrientation() {
                return outputStatus.getDesiredRootOrientation();
            }

            @Override
            public Vector3DBasics getRootJointLinearVelocity() {
                return outputStatus.getDesiredRootLinearVelocity();
            }

            @Override
            public Vector3DBasics getRootJointAngularVelocity() {
                return outputStatus.getDesiredRootAngularVelocity();
            }

            @Override
            public int getNumberOfJoints() {
                return outputStatus.getDesiredJointAngles().size();
            }

            @Override
            public double getJointPosition(int jointIndex) {
                return outputStatus.getDesiredJointAngles().get(jointIndex);
            }

            @Override
            public double getJointVelocity(int jointIndex) {
                return outputStatus.getDesiredJointVelocities().get(jointIndex);
            }

            @Override
            public void setJointPosition(int jointIndex, double position) {
                outputStatus.getDesiredJointAngles().set(jointIndex, (float)position);
            }

            @Override
            public void setJointVelocity(int jointIndex, double velocity) {
                outputStatus.getDesiredJointVelocities().set(jointIndex, (float)velocity);
            }
        };
    }
}

