/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.YoKinematicsToolboxOutputStatus;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KSTLowPassFilteredOutputProcessor
implements KSTOutputProcessor {
    private final YoKinematicsToolboxOutputStatus filteredRobotState;
    private final DoubleProvider breakFrequency;
    private final double updateDT;
    private boolean resetFilter = false;

    public KSTLowPassFilteredOutputProcessor(KSTTools tools, DoubleProvider breakFrequency, YoRegistry registry) {
        this.breakFrequency = breakFrequency;
        this.updateDT = tools.getToolboxControllerPeriod();
        FullHumanoidRobotModel desiredFullRobotModel = tools.getDesiredFullRobotModel();
        this.filteredRobotState = new YoKinematicsToolboxOutputStatus("lpf", desiredFullRobotModel, registry);
        this.filteredRobotState.createAccelerationState();
    }

    @Override
    public void initialize() {
        this.resetFilter = true;
        this.filteredRobotState.setToNaN();
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        if (this.resetFilter) {
            this.filteredRobotState.set(latestOutput);
            this.resetFilter = false;
        } else {
            double alphaFilter = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.breakFrequency.getValue(), (double)this.updateDT);
            this.filteredRobotState.interpolate(latestOutput, this.filteredRobotState, alphaFilter);
        }
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        return this.filteredRobotState;
    }
}

