/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.YoKinematicsToolboxOutputStatus;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class KSTFiniteDifferenceOutputProcessor
implements KSTOutputProcessor {
    private final BooleanProvider computeSignal;
    private final YoDouble previousTime;
    private final YoKinematicsToolboxOutputStatus previousRobotState;
    private final YoKinematicsToolboxOutputStatus outputRobotState;

    public KSTFiniteDifferenceOutputProcessor(KSTTools tools, BooleanProvider computeSignal, YoRegistry registry) {
        this.computeSignal = computeSignal;
        this.outputRobotState = new YoKinematicsToolboxOutputStatus("finiteDifference", tools.getDesiredFullRobotModel(), registry);
        this.previousTime = new YoDouble("previousTime", registry);
        this.previousRobotState = new YoKinematicsToolboxOutputStatus("previous", tools.getDesiredFullRobotModel(), registry);
    }

    @Override
    public void initialize() {
        this.previousTime.set(Double.NaN);
        this.previousRobotState.setToNaN();
        this.outputRobotState.setToNaN();
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        if (this.computeSignal.getValue()) {
            double dt = time - this.previousTime.getDoubleValue();
            this.outputRobotState.setConfiguration(latestOutput);
            this.outputRobotState.setVelocitiesByFiniteDifference(this.previousRobotState, latestOutput, dt);
            this.previousTime.set(time);
            this.previousRobotState.set(latestOutput);
        } else {
            this.outputRobotState.setConfiguration(latestOutput);
        }
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        return this.outputRobotState;
    }
}

