/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.YoKinematicsToolboxOutputStatus;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KSTFBOutputProcessor
implements KSTOutputProcessor {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoPDGains gains;
    private final YoKinematicsToolboxOutputStatus outputRobotState;
    private final double updateDT;
    private boolean firstTick = true;
    private final Quaternion diff = new Quaternion();
    private final SpatialVector feedbackPosition = new SpatialVector();
    private final SpatialVector feedbackVelocity = new SpatialVector();

    public KSTFBOutputProcessor(KSTTools tools, YoRegistry registry) {
        this.gains = new YoPDGains("Output", registry);
        this.gains.createDerivativeGainUpdater(false);
        this.gains.setKp(tools.getParameters().getOutputFeedbackGain());
        this.gains.setZeta(tools.getParameters().getOutputFeedbackDampingRatio());
        this.updateDT = tools.getToolboxControllerPeriod();
        this.outputRobotState = new YoKinematicsToolboxOutputStatus("feedback", tools.getDesiredFullRobotModel(), registry);
        this.outputRobotState.createAccelerationState();
    }

    @Override
    public void initialize() {
        this.outputRobotState.setToNaN();
        this.firstTick = true;
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        if (this.firstTick) {
            this.outputRobotState.set(latestOutput);
            this.firstTick = false;
            return;
        }
        this.outputRobotState.checkCompatibility(latestOutput);
        this.feedbackPosition.getLinearPart().sub((Tuple3DReadOnly)latestOutput.getRootJointPosition(), (Tuple3DReadOnly)this.outputRobotState.getRootJointPosition());
        this.outputRobotState.getRootJointOrientation().inverseTransform((Tuple3DBasics)this.feedbackPosition.getLinearPart());
        this.diff.difference((QuaternionReadOnly)this.outputRobotState.getRootJointOrientation(), latestOutput.getRootJointOrientation());
        this.diff.normalizeAndLimitToPi();
        this.diff.getRotationVector((Vector3DBasics)this.feedbackPosition.getAngularPart());
        this.feedbackPosition.scale(this.gains.getKp());
        this.feedbackVelocity.getLinearPart().sub((Tuple3DReadOnly)latestOutput.getRootJointLinearVelocity(), (Tuple3DReadOnly)this.outputRobotState.getRootJointLinearVelocity());
        this.feedbackVelocity.getAngularPart().sub((Tuple3DReadOnly)latestOutput.getRootJointAngularVelocity(), (Tuple3DReadOnly)this.outputRobotState.getRootJointAngularVelocity());
        this.feedbackVelocity.scale(this.gains.getKd());
        this.outputRobotState.getRootJointLinearAcceleration().add((Tuple3DReadOnly)this.feedbackPosition.getLinearPart(), (Tuple3DReadOnly)this.feedbackVelocity.getLinearPart());
        this.outputRobotState.getRootJointAngularAcceleration().add((Tuple3DReadOnly)this.feedbackPosition.getAngularPart(), (Tuple3DReadOnly)this.feedbackVelocity.getAngularPart());
        for (int i = 0; i < this.outputRobotState.getNumberOfJoints(); ++i) {
            double qDDotMax;
            double q_err = latestOutput.getJointPosition(i) - this.outputRobotState.getJointPosition(i);
            double qd_err = latestOutput.getJointVelocity(i) - this.outputRobotState.getJointVelocity(i);
            double qdd = this.gains.getKp() * q_err + this.gains.getKd() * qd_err;
            double qMin = this.outputRobotState.getOneDoFJoints()[i].getJointLimitLower();
            double qMax = this.outputRobotState.getOneDoFJoints()[i].getJointLimitUpper();
            double qdMin = this.outputRobotState.getOneDoFJoints()[i].getVelocityLimitLower();
            double qdMax = this.outputRobotState.getOneDoFJoints()[i].getVelocityLimitUpper();
            double qDDotMin = KSTTools.computeJointMinAcceleration(qMin, qdMin, this.outputRobotState.getJointPosition(i), this.outputRobotState.getJointVelocity(i), this.updateDT);
            if (Double.isFinite(qDDotMin)) {
                qdd = Math.max(qdd, qDDotMin);
            }
            if (Double.isFinite(qDDotMax = KSTTools.computeJointMaxAcceleration(qMax, qdMax, this.outputRobotState.getJointPosition(i), this.outputRobotState.getJointVelocity(i), this.updateDT))) {
                qdd = Math.min(qdd, qDDotMax);
            }
            this.outputRobotState.setJointAcceleration(i, qdd);
        }
        this.outputRobotState.integrate(this.updateDT);
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        return this.outputRobotState;
    }
}

