/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.YoKinematicsToolboxOutputStatus;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KSTDownscaleVelocityOutputProcessor
implements KSTOutputProcessor {
    private final KSTTools tools;
    private final DoubleProvider downscaleFactor;
    private final YoKinematicsToolboxOutputStatus outputRobotState;

    public KSTDownscaleVelocityOutputProcessor(KSTTools tools, DoubleProvider downscaleFactor, YoRegistry registry) {
        this.tools = tools;
        this.downscaleFactor = downscaleFactor;
        FullHumanoidRobotModel desiredFullRobotModel = tools.getDesiredFullRobotModel();
        this.outputRobotState = new YoKinematicsToolboxOutputStatus("downscaled", desiredFullRobotModel, registry);
    }

    @Override
    public void initialize() {
        this.outputRobotState.setToNaN();
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        this.outputRobotState.set(latestOutput);
        this.outputRobotState.scaleVelocities(this.downscaleFactor.getValue());
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        return this.outputRobotState;
    }
}

