/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTBlendingOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTDownscaleVelocityOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTFBOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTLowPassFilteredOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessors;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.YoKinematicsToolboxOutputStatus;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class KSTCompiledOutputProcessor
implements KSTOutputProcessor {
    private final YoKinematicsToolboxOutputStatus ikRobotState;
    private final YoKinematicsToolboxOutputStatus outputRobotState;
    private final KSTOutputProcessors outputProcessors = new KSTOutputProcessors();
    private final YoDouble outputLPFBreakFrequency;
    private final YoDouble outputJointVelocityScale;

    public KSTCompiledOutputProcessor(KSTTools tools, DoubleProvider streamingBlendingDuration, BooleanProvider isPublishing, YoRegistry registry) {
        this.outputLPFBreakFrequency = new YoDouble("outputLPFBreakFrequency", registry);
        this.outputJointVelocityScale = new YoDouble("outputJointVelocityScale", registry);
        FullHumanoidRobotModel desiredFullRobotModel = tools.getDesiredFullRobotModel();
        this.ikRobotState = new YoKinematicsToolboxOutputStatus("IK", desiredFullRobotModel, registry);
        this.outputRobotState = new YoKinematicsToolboxOutputStatus("output", desiredFullRobotModel, registry);
        this.outputRobotState.createAccelerationState();
        KinematicsStreamingToolboxParameters parameters = tools.getParameters();
        this.outputJointVelocityScale.set(parameters.getOutputJointVelocityScale());
        this.outputLPFBreakFrequency.set(parameters.getOutputLPFBreakFrequency());
        this.outputProcessors.add(new KSTDownscaleVelocityOutputProcessor(tools, (DoubleProvider)this.outputJointVelocityScale, registry));
        this.outputProcessors.add(new KSTFBOutputProcessor(tools, registry));
        this.outputProcessors.add(new KSTLowPassFilteredOutputProcessor(tools, (DoubleProvider)this.outputLPFBreakFrequency, registry));
        this.outputProcessors.add(new KSTBlendingOutputProcessor(tools, streamingBlendingDuration, registry));
    }

    @Override
    public void initialize() {
        this.ikRobotState.setToNaN();
        this.outputRobotState.setToNaN();
        this.outputProcessors.initialize();
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        this.ikRobotState.set(latestOutput);
        this.outputProcessors.update(time, wasStreaming, isStreaming, latestOutput);
        this.outputRobotState.set(this.outputProcessors.getProcessedOutput());
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        return this.outputRobotState;
    }
}

