/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.YoKinematicsToolboxOutputStatus;
import us.ihmc.commons.MathTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class KSTBlendingOutputProcessor
implements KSTOutputProcessor {
    private final YoKinematicsToolboxOutputStatus initialRobotState;
    private final YoKinematicsToolboxOutputStatus blendedRobotState;
    private final YoDouble streamingStartTime;
    private final DoubleProvider streamingBlendingDuration;
    private final KSTTools tools;
    private final KinematicsStreamingToolboxParameters parameters;

    public KSTBlendingOutputProcessor(KSTTools tools, DoubleProvider streamingBlendingDuration, YoRegistry registry) {
        this.parameters = tools.getParameters();
        this.tools = tools;
        this.streamingStartTime = new YoDouble("streamingStartTime", registry);
        this.streamingBlendingDuration = streamingBlendingDuration;
        FullHumanoidRobotModel desiredFullRobotModel = tools.getDesiredFullRobotModel();
        this.initialRobotState = new YoKinematicsToolboxOutputStatus("initial", desiredFullRobotModel, registry);
        this.blendedRobotState = new YoKinematicsToolboxOutputStatus("blended", desiredFullRobotModel, registry);
        this.blendedRobotState.createAccelerationState();
    }

    @Override
    public void initialize() {
        this.streamingStartTime.set(Double.NaN);
        this.initialRobotState.setToNaN();
        this.blendedRobotState.setToNaN();
    }

    @Override
    public void update(double time, boolean wasStreaming, boolean isStreaming, KSTOutputDataReadOnly latestOutput) {
        if (isStreaming) {
            double timeInBlending;
            if (!wasStreaming) {
                this.tools.getCurrentState(this.initialRobotState);
                this.streamingStartTime.set(time);
            }
            if ((timeInBlending = time - this.streamingStartTime.getValue()) < this.streamingBlendingDuration.getValue()) {
                double alpha = MathTools.clamp((double)(timeInBlending / this.streamingBlendingDuration.getValue()), (double)0.0, (double)1.0);
                this.blendedRobotState.interpolate(this.initialRobotState, latestOutput, alpha);
            } else {
                this.blendedRobotState.set(latestOutput);
            }
        }
    }

    @Override
    public KSTOutputDataReadOnly getProcessedOutput() {
        return this.blendedRobotState;
    }

    public DoubleProvider getBlendingDuration() {
        return this.streamingBlendingDuration;
    }
}

