/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input.KSTInputStateEstimator;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.yoVariables.euclid.filters.AlphaFilteredYoFramePoint3D;
import us.ihmc.yoVariables.euclid.filters.AlphaFilteredYoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class KSTInputFirstOrderStateEstimator
implements KSTInputStateEstimator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Map<RigidBodyReadOnly, SingleEndEffectorEstimator> inputPoseEstimators = new HashMap<RigidBodyReadOnly, SingleEndEffectorEstimator>();
    private final SingleEndEffectorEstimator[] inputPoseEstimatorsArray;
    private final CenterOfMassEstimator centerOfMassEstimator;
    private final YoDouble inputVelocityDecayDuration = new YoDouble("inputVelocityDecayDuration", this.registry);
    private final YoDouble inputsFilterBreakFrequency = new YoDouble("inputsFilterBreakFrequency", this.registry);
    private final double updateDT;

    public KSTInputFirstOrderStateEstimator(Collection<? extends RigidBodyReadOnly> endEffectors, KinematicsStreamingToolboxParameters parameters, double updateDT, YoRegistry parentRegistry) {
        this.updateDT = updateDT;
        DoubleProvider inputsAlphaProvider = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.inputsFilterBreakFrequency.getValue(), (double)updateDT);
        for (RigidBodyReadOnly rigidBodyReadOnly : endEffectors) {
            this.inputPoseEstimators.put(rigidBodyReadOnly, new SingleEndEffectorEstimator(rigidBodyReadOnly, inputsAlphaProvider, this.registry));
        }
        this.inputPoseEstimatorsArray = this.inputPoseEstimators.values().toArray(new SingleEndEffectorEstimator[0]);
        this.centerOfMassEstimator = new CenterOfMassEstimator(inputsAlphaProvider, this.registry);
        this.inputsFilterBreakFrequency.set(parameters.getInputPoseLPFBreakFrequency());
        this.inputVelocityDecayDuration.set(parameters.getInputVelocityDecayDuration());
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void reset() {
        for (SingleEndEffectorEstimator inputPoseEstimator : this.inputPoseEstimatorsArray) {
            inputPoseEstimator.reset();
        }
        this.centerOfMassEstimator.reset();
    }

    @Override
    public void update(double time, boolean isNewInput, double defaultLinearRateLimitation, double defaultAngularRateLimitation, KinematicsStreamingToolboxInputCommand latestInputCommand, KinematicsStreamingToolboxInputCommand previousRawInputCommand) {
        this.updateVelocity(isNewInput, latestInputCommand, previousRawInputCommand);
        this.updatePose(isNewInput, latestInputCommand);
    }

    @Override
    public FramePose3DReadOnly getEstimatedPose(RigidBodyReadOnly endEffector) {
        SingleEndEffectorEstimator inputPoseEstimator = this.inputPoseEstimators.get(endEffector);
        if (inputPoseEstimator == null) {
            return null;
        }
        return inputPoseEstimator.getOutputPose();
    }

    @Override
    public FramePoint3DReadOnly getEstimatedCoMPosition() {
        return this.centerOfMassEstimator.getOutputPosition();
    }

    private void updatePose(boolean isNewInput, KinematicsStreamingToolboxInputCommand inputCommandToFilter) {
        if (isNewInput) {
            for (int i = 0; i < inputCommandToFilter.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand input = inputCommandToFilter.getInput(i);
                SingleEndEffectorEstimator inputPoseEstimator = this.inputPoseEstimators.get(input.getEndEffector());
                if (inputPoseEstimator == null) continue;
                inputPoseEstimator.updateInput((FramePose3DReadOnly)input.getDesiredPose());
            }
            if (inputCommandToFilter.hasCenterOfMassInput()) {
                this.centerOfMassEstimator.updateInput((FramePoint3DReadOnly)inputCommandToFilter.getCenterOfMassInput().getDesiredPosition());
            }
        } else {
            for (int i = 0; i < inputCommandToFilter.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand input = inputCommandToFilter.getInput(i);
                SingleEndEffectorEstimator inputPoseEstimator = this.inputPoseEstimators.get(input.getEndEffector());
                if (inputPoseEstimator == null) continue;
                inputPoseEstimator.extrapolateInput(this.updateDT);
            }
            if (inputCommandToFilter.hasCenterOfMassInput()) {
                this.centerOfMassEstimator.extrapolateInput(this.updateDT);
            }
        }
    }

    private void updateVelocity(boolean isNewInput, KinematicsStreamingToolboxInputCommand currentRawInputCommand, KinematicsStreamingToolboxInputCommand previousRawInputCommand) {
        if (previousRawInputCommand == null) {
            for (SingleEndEffectorEstimator singleEndEffectorEstimator : this.inputPoseEstimatorsArray) {
                singleEndEffectorEstimator.resetVelocity();
            }
            this.centerOfMassEstimator.resetVelocity();
        } else if (isNewInput) {
            SingleEndEffectorEstimator inputPoseEstimator;
            int i;
            double timeInterval = Conversions.nanosecondsToSeconds((long)(currentRawInputCommand.getTimestamp() - previousRawInputCommand.getTimestamp()));
            for (i = 0; i < currentRawInputCommand.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand currentInput = currentRawInputCommand.getInput(i);
                inputPoseEstimator = this.inputPoseEstimators.get(currentInput.getEndEffector());
                if (inputPoseEstimator == null) continue;
                KinematicsToolboxRigidBodyCommand previousInput = previousRawInputCommand.getInputFor(currentInput.getEndEffector());
                if (previousInput == null) {
                    inputPoseEstimator.resetVelocity();
                    continue;
                }
                inputPoseEstimator.estimateVelocity(timeInterval, (FramePose3DReadOnly)previousInput.getDesiredPose(), (FramePose3DReadOnly)currentInput.getDesiredPose());
            }
            for (i = 0; i < previousRawInputCommand.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand previousInput = previousRawInputCommand.getInput(i);
                if (currentRawInputCommand.getInputFor(previousInput.getEndEffector()) != null || (inputPoseEstimator = this.inputPoseEstimators.get(previousInput.getEndEffector())) == null) continue;
                inputPoseEstimator.resetVelocity();
            }
            if (currentRawInputCommand.hasCenterOfMassInput() && previousRawInputCommand.hasCenterOfMassInput()) {
                KinematicsToolboxCenterOfMassCommand currentCoMInput = currentRawInputCommand.getCenterOfMassInput();
                KinematicsToolboxCenterOfMassCommand previousCoMInput = previousRawInputCommand.getCenterOfMassInput();
                this.centerOfMassEstimator.estimateVelocity(timeInterval, (FramePoint3DReadOnly)previousCoMInput.getDesiredPosition(), (FramePoint3DReadOnly)currentCoMInput.getDesiredPosition());
            } else {
                this.centerOfMassEstimator.resetVelocity();
            }
        } else {
            for (SingleEndEffectorEstimator singleEndEffectorEstimator : this.inputPoseEstimatorsArray) {
                singleEndEffectorEstimator.decayInputVelocity(this.updateDT / this.inputVelocityDecayDuration.getValue());
            }
            this.centerOfMassEstimator.decayInputVelocity(this.updateDT / this.inputVelocityDecayDuration.getValue());
        }
    }

    private static class SingleEndEffectorEstimator {
        private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        private final YoFramePose3D rawInputPose;
        private final YoFramePose3D rawExtrapolatedInputPose;
        private final AlphaFilteredYoFramePose3D filteredExtrapolatedInputPose;
        private final YoFixedFrameSpatialVector rawInputSpatialVelocity;
        private final YoFixedFrameSpatialVector decayingInputSpatialVelocity;
        private final YoDouble inputVelocityDecayFactor;

        public SingleEndEffectorEstimator(RigidBodyReadOnly endEffector, DoubleProvider inputsAlphaProvider, YoRegistry registry) {
            String namePrefix = endEffector.getName() + "Input_FOF_";
            this.rawInputPose = new YoFramePose3D(new YoFramePoint3D(namePrefix + "RawPosition", worldFrame, registry), new YoFrameQuaternion(namePrefix + "RawOrientation", worldFrame, registry));
            this.rawExtrapolatedInputPose = new YoFramePose3D(new YoFramePoint3D(namePrefix + "RawExtrapolatedPosition", worldFrame, registry), new YoFrameQuaternion(namePrefix + "RawExtrapolatedOrientation", worldFrame, registry));
            this.filteredExtrapolatedInputPose = new AlphaFilteredYoFramePose3D(new YoFramePoint3D(namePrefix + "FilteredExtrapolatedPosition", worldFrame, registry), new YoFrameQuaternion(namePrefix + "FilteredExtrapolatedOrientation", worldFrame, registry), (FramePose3DReadOnly)this.rawExtrapolatedInputPose, inputsAlphaProvider, registry);
            this.rawInputSpatialVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "RawAngularVelocity", worldFrame, registry), new YoFrameVector3D(namePrefix + "RawLinearVelocity", worldFrame, registry));
            this.decayingInputSpatialVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "DecayingAngularVelocity", worldFrame, registry), new YoFrameVector3D(namePrefix + "DecayingLinearVelocity", worldFrame, registry));
            this.inputVelocityDecayFactor = new YoDouble(namePrefix + "InputVelocityDecayFactor", registry);
        }

        public void reset() {
            this.rawInputPose.setToNaN();
            this.rawExtrapolatedInputPose.setToNaN();
            this.filteredExtrapolatedInputPose.setToNaN();
            this.filteredExtrapolatedInputPose.reset();
            this.resetVelocity();
        }

        public void resetVelocity() {
            this.rawInputSpatialVelocity.setToZero();
            this.decayingInputSpatialVelocity.setToZero();
            this.inputVelocityDecayFactor.set(0.0);
        }

        public void updateInput(FramePose3DReadOnly pose) {
            this.rawInputPose.set(pose);
            this.rawExtrapolatedInputPose.set(pose);
            this.filteredExtrapolatedInputPose.update();
        }

        public void extrapolateInput(double integrationDT) {
            KSTTools.integrateLinearVelocity(integrationDT, (FramePoint3DReadOnly)this.rawExtrapolatedInputPose.getPosition(), (FrameVector3DReadOnly)this.decayingInputSpatialVelocity.getLinearPart(), (FixedFramePoint3DBasics)this.rawExtrapolatedInputPose.getPosition());
            KSTTools.integrateAngularVelocity(integrationDT, (FrameQuaternionReadOnly)this.rawExtrapolatedInputPose.getOrientation(), (FrameVector3DReadOnly)this.decayingInputSpatialVelocity.getAngularPart(), false, (FixedFrameQuaternionBasics)this.rawExtrapolatedInputPose.getOrientation());
            this.filteredExtrapolatedInputPose.update();
        }

        public void decayInputVelocity(double decayIncrement) {
            double alpha = Math.min(1.0, this.inputVelocityDecayFactor.getDoubleValue() + decayIncrement);
            this.inputVelocityDecayFactor.set(alpha);
            this.decayingInputSpatialVelocity.getLinearPart().interpolate((FrameTuple3DReadOnly)this.rawInputSpatialVelocity.getLinearPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
            this.decayingInputSpatialVelocity.getAngularPart().interpolate((FrameTuple3DReadOnly)this.rawInputSpatialVelocity.getAngularPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
        }

        public void estimateVelocity(double dt, FramePose3DReadOnly previousPose, FramePose3DReadOnly currentPose) {
            KSTTools.computeSpatialVelocity(dt, previousPose, currentPose, (FixedFrameSpatialVectorBasics)this.rawInputSpatialVelocity);
            this.decayingInputSpatialVelocity.set((SpatialVectorReadOnly)this.rawInputSpatialVelocity);
            this.inputVelocityDecayFactor.set(0.0);
        }

        public FramePose3DReadOnly getOutputPose() {
            return this.filteredExtrapolatedInputPose;
        }
    }

    private static class CenterOfMassEstimator {
        private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        private final YoFramePoint3D rawInputPosition;
        private final YoFramePoint3D rawExtrapolatedInputPosition;
        private final AlphaFilteredYoFramePoint3D filteredExtrapolatedInputPosition;
        private final YoFrameVector3D rawInputLinearVelocity;
        private final YoFrameVector3D decayingInputLinearVelocity;
        private final YoDouble inputVelocityDecayFactor;

        public CenterOfMassEstimator(DoubleProvider inputsAlphaProvider, YoRegistry registry) {
            this.rawInputPosition = new YoFramePoint3D("CoMInput_FOF_RawPosition", worldFrame, registry);
            this.rawExtrapolatedInputPosition = new YoFramePoint3D("CoMInput_FOF_RawExtrapolatedPosition", worldFrame, registry);
            this.filteredExtrapolatedInputPosition = new AlphaFilteredYoFramePoint3D("CoMInput_FOF_FilteredExtrapolatedPosition", "", registry, inputsAlphaProvider, (FrameTuple3DReadOnly)this.rawExtrapolatedInputPosition);
            this.rawInputLinearVelocity = new YoFrameVector3D("CoMInput_FOF_RawLinearVelocity", worldFrame, registry);
            this.decayingInputLinearVelocity = new YoFrameVector3D("CoMInput_FOF_DecayingLinearVelocity", worldFrame, registry);
            this.inputVelocityDecayFactor = new YoDouble("CoMInput_FOF_InputVelocityDecayFactor", registry);
        }

        public void reset() {
            this.rawInputPosition.setToNaN();
            this.rawExtrapolatedInputPosition.setToNaN();
            this.filteredExtrapolatedInputPosition.setToNaN();
            this.filteredExtrapolatedInputPosition.reset();
            this.resetVelocity();
        }

        private void resetVelocity() {
            this.rawInputLinearVelocity.setToZero();
            this.decayingInputLinearVelocity.setToZero();
            this.inputVelocityDecayFactor.set(0.0);
        }

        public void updateInput(FramePoint3DReadOnly position) {
            this.rawInputPosition.set((FrameTuple3DReadOnly)position);
            this.rawExtrapolatedInputPosition.set((FrameTuple3DReadOnly)position);
            this.filteredExtrapolatedInputPosition.update();
        }

        public void extrapolateInput(double integrationDT) {
            KSTTools.integrateLinearVelocity(integrationDT, (FramePoint3DReadOnly)this.rawInputPosition, (FrameVector3DReadOnly)this.rawInputLinearVelocity, (FixedFramePoint3DBasics)this.rawExtrapolatedInputPosition);
            this.filteredExtrapolatedInputPosition.update();
        }

        public void decayInputVelocity(double decayIncrement) {
            double alpha = Math.min(1.0, this.inputVelocityDecayFactor.getDoubleValue() + decayIncrement);
            this.inputVelocityDecayFactor.set(alpha);
            this.decayingInputLinearVelocity.interpolate((FrameTuple3DReadOnly)this.rawInputLinearVelocity, (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
        }

        public void estimateVelocity(double dt, FramePoint3DReadOnly previousPosition, FramePoint3DReadOnly currentPosition) {
            KSTTools.computeLinearVelocity(dt, previousPosition, currentPosition, (FixedFrameVector3DBasics)this.rawInputLinearVelocity);
            this.decayingInputLinearVelocity.set((FrameTuple3DReadOnly)this.rawInputLinearVelocity);
            this.inputVelocityDecayFactor.set(0.0);
        }

        public FramePoint3DReadOnly getOutputPosition() {
            return this.rawInputPosition;
        }
    }
}

