/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input;

import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.log.LogTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.referenceFrames.MidFootZUpGroundFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class KSTInputFilter {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final String namePrefix = "inputFilter";
    private final YoVector3D bbxSize = new YoVector3D("inputFilterBBXSize", this.registry);
    private final YoFramePoint3D bbxOffset;
    private final YoFramePoint3D bbxPosition = new YoFramePoint3D("inputFilterBBXPosition", worldFrame, this.registry);
    private final YoFrameQuaternion bbxOrientation = new YoFrameQuaternion("inputFilterBBXOrientation", worldFrame, this.registry);
    private final MidFootZUpGroundFrame midFeetZUpFrame;
    private final YoBoolean enableBBXFilter = new YoBoolean("inputFilterEnableBBXFilter", this.registry);
    private final YoDouble maxLinearDelta = new YoDouble("inputFilterMaxLinearDelta", this.registry);
    private final YoDouble maxAngularDelta = new YoDouble("inputFilterMaxAngularDelta", this.registry);
    private final YoDouble maxLinearVelocity = new YoDouble("inputFilterMaxLinearVelocity", this.registry);
    private final YoDouble maxAngularVelocity = new YoDouble("inputFilterMaxAngularVelocity", this.registry);
    private final Box3D boundingBox = new Box3D();

    public KSTInputFilter(FullHumanoidRobotModel fullRobotModel, KinematicsStreamingToolboxParameters parameters, YoRegistry parentRegistry) {
        this.midFeetZUpFrame = new MidFootZUpGroundFrame("midFeetZUpFrame", (ReferenceFrame)fullRobotModel.getSoleFrame((Enum)RobotSide.LEFT), (ReferenceFrame)fullRobotModel.getSoleFrame((Enum)RobotSide.RIGHT));
        this.enableBBXFilter.set(parameters.isUseBBXInputFilter());
        if (parameters.getInputFilterBBXSize() != null) {
            this.bbxSize.set((Tuple3DReadOnly)parameters.getInputFilterBBXSize());
        }
        this.bbxOffset = new YoFramePoint3D("inputFilterBBXCenter", (ReferenceFrame)this.midFeetZUpFrame, this.registry);
        if (parameters.getInputFilterBBXCenter() != null) {
            this.bbxOffset.set((Tuple3DReadOnly)parameters.getInputFilterBBXCenter());
        }
        this.maxLinearDelta.set(parameters.getInputFilterMaxLinearDelta());
        this.maxAngularDelta.set(parameters.getInputFilterMaxAngularDelta());
        this.maxLinearVelocity.set(parameters.getInputFilterMaxLinearVelocity());
        this.maxAngularVelocity.set(parameters.getInputFilterMaxAngularVelocity());
        parentRegistry.addChild(this.registry);
    }

    public void update() {
        this.midFeetZUpFrame.update();
        this.bbxPosition.setMatchingFrame((FrameTuple3DReadOnly)this.bbxOffset);
        this.bbxOrientation.setToYawOrientation(this.midFeetZUpFrame.getTransformToRoot().getRotation().getYaw());
        this.boundingBox.getPose().set((Orientation3DReadOnly)this.bbxOrientation, (Tuple3DReadOnly)this.bbxPosition);
        this.boundingBox.getSize().set((Tuple3DReadOnly)this.bbxSize);
    }

    public boolean isInputValid(KinematicsToolboxCenterOfMassCommand input, KinematicsToolboxCenterOfMassCommand previousInput) {
        double linearDelta;
        if (this.enableBBXFilter.getValue() && !this.boundingBox.isPointInside((Point3DReadOnly)input.getDesiredPosition())) {
            LogTools.warn((String)"Invalid CoM input. Input outside bounding box");
            return false;
        }
        if (previousInput != null && (linearDelta = input.getDesiredPosition().distance((FramePoint3DReadOnly)previousInput.getDesiredPosition())) > this.maxLinearDelta.getValue()) {
            LogTools.warn((String)"Invalid CoM input. Linear delta {} > maximum delta {}", (Object)linearDelta, (Object)this.maxLinearDelta.getValue());
            return false;
        }
        if (input.getDesiredPosition().containsNaN()) {
            LogTools.warn((String)"NaN position for CoM command");
            return false;
        }
        if (input.getHasDesiredVelocity()) {
            if (input.getDesiredVelocity().containsNaN()) {
                LogTools.warn((String)"NaN velocity for CoM command");
                return false;
            }
            double linearVelocity = input.getDesiredVelocity().norm();
            if (linearVelocity > this.maxLinearVelocity.getValue()) {
                return false;
            }
        }
        return true;
    }

    public boolean isInputValid(KinematicsToolboxRigidBodyCommand input, KinematicsToolboxRigidBodyCommand previousInput) {
        if (this.enableBBXFilter.getValue() && !this.boundingBox.isPointInside((Point3DReadOnly)input.getDesiredPose().getPosition())) {
            LogTools.warn((String)"Invalid rigid body input -  {}. Input outside bounding box", (Object)input.getEndEffector().getName());
            return false;
        }
        if (previousInput != null) {
            double linearDelta = input.getDesiredPose().getPositionDistance((FramePose3DReadOnly)previousInput.getDesiredPose());
            if (linearDelta > this.maxLinearDelta.getValue()) {
                LogTools.warn((String)"Invalid rigid body input. Linear delta {} > maximum delta {}", (Object)linearDelta, (Object)this.maxLinearDelta.getValue());
                return false;
            }
            double angularDelta = input.getDesiredPose().getOrientationDistance((FramePose3DReadOnly)previousInput.getDesiredPose());
            if (angularDelta > this.maxAngularDelta.getValue()) {
                LogTools.warn((String)"Invalid rigid body input. Angular delta {} > maximum delta {}", (Object)angularDelta, (Object)this.maxAngularDelta.getValue());
                return false;
            }
        }
        if (input.getDesiredPose().containsNaN()) {
            LogTools.warn((String)"NaN pose for end-effector: {}", (Object)input.getEndEffector().getName());
            return false;
        }
        if (input.getHasDesiredVelocity()) {
            if (input.getDesiredVelocity().containsNaN()) {
                LogTools.warn((String)"NaN velocity for end-effector: {}", (Object)input.getEndEffector().getName());
                return false;
            }
            double linearVelocity = input.getDesiredVelocity().getLinearPart().norm();
            if (linearVelocity > this.maxLinearVelocity.getValue()) {
                LogTools.warn((String)"Linear velocity limit exceeded for end-effector: {}", (Object)input.getEndEffector().getName());
                return false;
            }
            double angularVelocity = input.getDesiredVelocity().getAngularPart().norm();
            if (angularVelocity > this.maxAngularVelocity.getValue()) {
                LogTools.warn((String)"Angular velocity limit exceeded for end-effector: {}", (Object)input.getEndEffector().getName());
                return false;
            }
        }
        return true;
    }
}

