/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input.KSTInputStateEstimator;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class KSTInputFBControllerStateEstimator
implements KSTInputStateEstimator {
    private static final boolean ENABLE_C1_FILTER = false;
    public static final double SAFE_INPUT_PERIOD_TO_CORRECTION_FACTOR = 1.5;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Map<RigidBodyReadOnly, SingleEndEffectorStateEstimatorBase> inputPoseEstimators = new LinkedHashMap<RigidBodyReadOnly, SingleEndEffectorStateEstimatorBase>();
    private final SingleEndEffectorStateEstimatorBase[] endEffectorEstimatorsArray;
    private final CenterOfMassEstimator centerOfMassEstimator;
    private final YoDouble correctionDuration = new YoDouble("correctionDuration", this.registry);
    private final YoDouble rawVelocityAlpha = new YoDouble("rawVelocityAlpha", this.registry);
    private final YoDouble maxDeltaLinearVelocity = new YoDouble("maxDeltaLinearVelocity", this.registry);
    private final YoDouble maxDeltaAngularVelocity = new YoDouble("maxDeltaAngularVelocity", this.registry);
    private final double updateDT;
    private final DoubleProvider inputPeriod;
    private final YoDouble inputVelocityDecayDuration = new YoDouble("inputVelocityDecayDuration", this.registry);

    public KSTInputFBControllerStateEstimator(Collection<? extends RigidBodyReadOnly> endEffectors, KinematicsStreamingToolboxParameters parameters, double updateDT, DoubleProvider inputPeriod, YoRegistry parentRegistry) {
        this.updateDT = updateDT;
        this.inputPeriod = inputPeriod;
        for (RigidBodyReadOnly rigidBodyReadOnly : endEffectors) {
            this.inputPoseEstimators.put(rigidBodyReadOnly, new SingleEndEffectorC0Estimator(rigidBodyReadOnly));
        }
        this.endEffectorEstimatorsArray = this.inputPoseEstimators.values().toArray(new SingleEndEffectorStateEstimatorBase[0]);
        this.centerOfMassEstimator = new CenterOfMassEstimator();
        this.correctionDuration.set(parameters.getInputPoseCorrectionDuration());
        this.rawVelocityAlpha.set(parameters.getInputVelocityRawAlpha());
        this.inputVelocityDecayDuration.set(parameters.getInputVelocityDecayDuration());
        this.maxDeltaLinearVelocity.set(2.0);
        this.maxDeltaAngularVelocity.set(2.0);
        this.inputVelocityDecayDuration.set(parameters.getInputVelocityDecayDuration());
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void reset() {
        for (SingleEndEffectorStateEstimatorBase estimator : this.endEffectorEstimatorsArray) {
            estimator.reset();
        }
        this.centerOfMassEstimator.reset();
    }

    @Override
    public void update(double time, boolean isNewInput, double defaultLinearRateLimitation, double defaultAngularRateLimitation, KinematicsStreamingToolboxInputCommand latestInputCommand, KinematicsStreamingToolboxInputCommand previousRawInputCommand) {
        double minCorrectionDuration = 2.0 * this.updateDT;
        if (this.inputPeriod.getValue() > this.updateDT) {
            minCorrectionDuration = Math.max(minCorrectionDuration, 1.5 * this.inputPeriod.getValue());
        }
        if (!Double.isFinite(this.correctionDuration.getValue()) || this.correctionDuration.getValue() < minCorrectionDuration) {
            this.correctionDuration.set(minCorrectionDuration);
        }
        if (isNewInput) {
            for (int i = 0; i < latestInputCommand.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand input = latestInputCommand.getInput(i);
                SingleEndEffectorStateEstimatorBase inputPoseEstimator = this.inputPoseEstimators.get(input.getEndEffector());
                if (inputPoseEstimator == null) continue;
                inputPoseEstimator.update(time, defaultLinearRateLimitation, defaultAngularRateLimitation, latestInputCommand.getTimestamp(), input);
            }
            if (latestInputCommand.hasCenterOfMassInput()) {
                KinematicsToolboxCenterOfMassCommand input = latestInputCommand.getCenterOfMassInput();
                this.centerOfMassEstimator.update(time, defaultLinearRateLimitation, latestInputCommand.getTimestamp(), input);
            }
        } else {
            for (int i = 0; i < latestInputCommand.getNumberOfInputs(); ++i) {
                KinematicsToolboxRigidBodyCommand input = latestInputCommand.getInput(i);
                SingleEndEffectorStateEstimatorBase inputPoseEstimator = this.inputPoseEstimators.get(input.getEndEffector());
                if (inputPoseEstimator == null) continue;
                inputPoseEstimator.predict(time);
            }
            if (latestInputCommand.hasCenterOfMassInput()) {
                this.centerOfMassEstimator.predict(time);
            }
        }
    }

    @Override
    public FramePose3DReadOnly getEstimatedPose(RigidBodyReadOnly endEffector) {
        SingleEndEffectorStateEstimatorBase inputPoseEstimator = this.inputPoseEstimators.get(endEffector);
        return inputPoseEstimator != null ? inputPoseEstimator.getEstimatedPose() : null;
    }

    @Override
    public SpatialVectorReadOnly getEstimatedVelocity(RigidBodyReadOnly endEffector) {
        SingleEndEffectorStateEstimatorBase inputPoseEstimator = this.inputPoseEstimators.get(endEffector);
        return inputPoseEstimator != null ? inputPoseEstimator.getEstimatedVelocity() : null;
    }

    @Override
    public FramePoint3DReadOnly getEstimatedCoMPosition() {
        return this.centerOfMassEstimator.getEstimatedPosition();
    }

    @Override
    public FrameVector3DReadOnly getEstimatedCoMVelocity() {
        return this.centerOfMassEstimator.getEstimatedVelocity();
    }

    private class SingleEndEffectorC0Estimator
    implements SingleEndEffectorStateEstimatorBase {
        private final YoFramePose3D estimatedPose;
        private final YoFixedFrameSpatialVector estimatedVelocity;
        private final YoFixedFrameSpatialVector estimatedDecayingVelocity;
        private final YoFixedFrameSpatialVector correctiveVelocity;
        private final YoDouble lastUpdateTime;
        private final YoLong lastInputTimestamp;
        private final YoFramePose3D rawInputPose;
        private final YoFixedFrameSpatialVector rawInputVelocity;
        private final YoFixedFrameSpatialVector clampedInputVelocity;
        private final YoFixedFrameSpatialVector debugInputVelocity;
        private final YoDouble nextTimeTriggerForDecay;
        private final YoDouble inputVelocityDecayFactor;
        private final Vector3D rawLinearDeltaVelocity = new Vector3D();
        private final Vector3D rawAngularDeltaVelocity = new Vector3D();
        private final Quaternion tempError = new Quaternion();

        public SingleEndEffectorC0Estimator(RigidBodyReadOnly endEffector) {
            String namePrefix = endEffector.getName() + "_FBC_";
            this.estimatedPose = new YoFramePose3D(new YoFramePoint3D(namePrefix + "EstimatedPosition", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameQuaternion(namePrefix + "EstimatedOrientation", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.estimatedVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "EstimatedAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "EstimatedLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.estimatedDecayingVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "EstimatedDecayingAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "EstimatedDecayingLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.correctiveVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "CorrectiveAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "CorrectiveLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.debugInputVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "DebugAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "DebugLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.lastUpdateTime = new YoDouble(namePrefix + "LastUpdateTime", KSTInputFBControllerStateEstimator.this.registry);
            this.lastInputTimestamp = new YoLong(namePrefix + "LastInputTimestamp", KSTInputFBControllerStateEstimator.this.registry);
            this.rawInputPose = new YoFramePose3D(new YoFramePoint3D(namePrefix + "RawInputPosition", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameQuaternion(namePrefix + "RawInputOrientation", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.rawInputVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "RawInputAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "RawInputLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.clampedInputVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "ClampedInputAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "ClampedInputLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.nextTimeTriggerForDecay = new YoDouble(namePrefix + "NextTimeTriggerForDecay", KSTInputFBControllerStateEstimator.this.registry);
            this.inputVelocityDecayFactor = new YoDouble(namePrefix + "InputVelocityDecayFactor", KSTInputFBControllerStateEstimator.this.registry);
        }

        @Override
        public void reset() {
            this.estimatedPose.setToZero();
            this.estimatedVelocity.setToZero();
            this.estimatedDecayingVelocity.setToZero();
            this.correctiveVelocity.setToZero();
            this.debugInputVelocity.setToZero();
            this.lastUpdateTime.set(Double.NaN);
            this.lastInputTimestamp.set(Long.MIN_VALUE);
            this.rawInputPose.setToZero();
            this.rawInputVelocity.setToZero();
            this.nextTimeTriggerForDecay.set(0.0);
            this.inputVelocityDecayFactor.set(0.0);
            this.clampedInputVelocity.setToZero();
        }

        @Override
        public void update(double time, double defaultLinearRateLimitation, double defaultAngularRateLimitation, long inputTimestamp, KinematicsToolboxRigidBodyCommand input) {
            if (input.getLinearRateLimitation() > 0.0) {
                defaultLinearRateLimitation = input.getLinearRateLimitation();
            }
            if (input.getAngularRateLimitation() > 0.0) {
                defaultAngularRateLimitation = input.getAngularRateLimitation();
            }
            FramePose3D pose = input.getDesiredPose();
            if (this.lastUpdateTime.isNaN()) {
                this.estimatedPose.set((FramePose3DReadOnly)pose);
                this.correctiveVelocity.setToZero();
                if (!input.getHasDesiredVelocity()) {
                    this.estimatedVelocity.setToZero();
                    this.rawInputVelocity.setToZero();
                    this.estimatedDecayingVelocity.setToZero();
                } else {
                    this.estimatedVelocity.setMatchingFrame((SpatialVectorReadOnly)input.getDesiredVelocity());
                    this.estimatedVelocity.getLinearPart().clipToMaxNorm(defaultLinearRateLimitation);
                    this.estimatedVelocity.getAngularPart().clipToMaxNorm(defaultAngularRateLimitation);
                    this.rawInputVelocity.setMatchingFrame((SpatialVectorReadOnly)input.getDesiredVelocity());
                    this.estimatedDecayingVelocity.set((SpatialVectorReadOnly)this.estimatedVelocity);
                }
            } else {
                this.correctiveVelocity.getLinearPart().sub((FrameTuple3DReadOnly)pose.getPosition(), (FrameTuple3DReadOnly)this.estimatedPose.getPosition());
                this.tempError.difference((QuaternionReadOnly)this.estimatedPose.getOrientation(), (QuaternionReadOnly)pose.getOrientation());
                this.tempError.normalizeAndLimitToPi();
                this.tempError.getRotationVector((Vector3DBasics)this.correctiveVelocity.getAngularPart());
                this.correctiveVelocity.scale(1.0 / KSTInputFBControllerStateEstimator.this.correctionDuration.getValue());
                this.estimatedPose.getOrientation().transform((FixedFrameTuple3DBasics)this.correctiveVelocity.getAngularPart());
                if (!input.getHasDesiredVelocity()) {
                    double timeInterval = Conversions.nanosecondsToSeconds((long)(inputTimestamp - this.lastInputTimestamp.getLongValue()));
                    KSTTools.computeSpatialVelocity(timeInterval, (FramePose3DReadOnly)this.rawInputPose, (FramePose3DReadOnly)pose, (FixedFrameSpatialVectorBasics)this.rawInputVelocity);
                    this.rawInputPose.getOrientation().transform((FixedFrameTuple3DBasics)this.rawInputVelocity.getAngularPart());
                } else {
                    double timeInterval = Conversions.nanosecondsToSeconds((long)(inputTimestamp - this.lastInputTimestamp.getLongValue()));
                    KSTTools.computeSpatialVelocity(timeInterval, (FramePose3DReadOnly)this.rawInputPose, (FramePose3DReadOnly)pose, (FixedFrameSpatialVectorBasics)this.debugInputVelocity);
                    this.rawInputPose.getOrientation().transform((FixedFrameTuple3DBasics)this.debugInputVelocity.getAngularPart());
                    this.rawInputVelocity.setMatchingFrame((SpatialVectorReadOnly)input.getDesiredVelocity());
                }
                if (this.rawInputVelocity.containsNaN()) {
                    this.rawInputVelocity.setToZero();
                    this.clampedInputVelocity.setToZero();
                } else {
                    this.rawLinearDeltaVelocity.sub((Tuple3DReadOnly)this.rawInputVelocity.getLinearPart(), (Tuple3DReadOnly)this.clampedInputVelocity.getLinearPart());
                    this.rawAngularDeltaVelocity.sub((Tuple3DReadOnly)this.rawInputVelocity.getAngularPart(), (Tuple3DReadOnly)this.clampedInputVelocity.getAngularPart());
                    this.rawLinearDeltaVelocity.clipToMaxNorm(KSTInputFBControllerStateEstimator.this.maxDeltaLinearVelocity.getValue());
                    this.rawAngularDeltaVelocity.clipToMaxNorm(KSTInputFBControllerStateEstimator.this.maxDeltaAngularVelocity.getValue());
                    this.clampedInputVelocity.getLinearPart().add((Tuple3DReadOnly)this.rawLinearDeltaVelocity);
                    this.clampedInputVelocity.getAngularPart().add((Tuple3DReadOnly)this.rawAngularDeltaVelocity);
                }
                this.estimatedVelocity.set((SpatialVectorReadOnly)this.clampedInputVelocity);
                this.estimatedVelocity.scale(KSTInputFBControllerStateEstimator.this.rawVelocityAlpha.getValue());
                this.estimatedVelocity.add((SpatialVectorReadOnly)this.correctiveVelocity);
                this.estimatedVelocity.getLinearPart().clipToMaxNorm(defaultLinearRateLimitation);
                this.estimatedVelocity.getAngularPart().clipToMaxNorm(defaultAngularRateLimitation);
                this.estimatedDecayingVelocity.set((SpatialVectorReadOnly)this.estimatedVelocity);
                KSTTools.integrateLinearVelocity(KSTInputFBControllerStateEstimator.this.updateDT, (FramePoint3DReadOnly)this.estimatedPose.getPosition(), (FrameVector3DReadOnly)this.estimatedDecayingVelocity.getLinearPart(), (FixedFramePoint3DBasics)this.estimatedPose.getPosition());
                KSTTools.integrateAngularVelocity(KSTInputFBControllerStateEstimator.this.updateDT, (FrameQuaternionReadOnly)this.estimatedPose.getOrientation(), (FrameVector3DReadOnly)this.estimatedDecayingVelocity.getAngularPart(), false, (FixedFrameQuaternionBasics)this.estimatedPose.getOrientation());
            }
            this.lastUpdateTime.set(time);
            this.lastInputTimestamp.set(inputTimestamp);
            this.rawInputPose.set((FramePose3DReadOnly)pose);
            this.nextTimeTriggerForDecay.set(time + KSTInputFBControllerStateEstimator.this.correctionDuration.getValue());
            this.inputVelocityDecayFactor.set(0.0);
        }

        @Override
        public void predict(double time) {
            if (time > this.nextTimeTriggerForDecay.getValue()) {
                double alpha = Math.min(1.0, this.inputVelocityDecayFactor.getValue() + KSTInputFBControllerStateEstimator.this.updateDT / KSTInputFBControllerStateEstimator.this.inputVelocityDecayDuration.getValue());
                this.inputVelocityDecayFactor.set(alpha);
                this.estimatedDecayingVelocity.getLinearPart().interpolate((FrameTuple3DReadOnly)this.estimatedVelocity.getLinearPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
                this.estimatedDecayingVelocity.getAngularPart().interpolate((FrameTuple3DReadOnly)this.estimatedVelocity.getAngularPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
            }
            KSTTools.integrateLinearVelocity(KSTInputFBControllerStateEstimator.this.updateDT, (FramePoint3DReadOnly)this.estimatedPose.getPosition(), (FrameVector3DReadOnly)this.estimatedDecayingVelocity.getLinearPart(), (FixedFramePoint3DBasics)this.estimatedPose.getPosition());
            KSTTools.integrateAngularVelocity(KSTInputFBControllerStateEstimator.this.updateDT, (FrameQuaternionReadOnly)this.estimatedPose.getOrientation(), (FrameVector3DReadOnly)this.estimatedDecayingVelocity.getAngularPart(), false, (FixedFrameQuaternionBasics)this.estimatedPose.getOrientation());
        }

        @Override
        public FramePose3DReadOnly getEstimatedPose() {
            return this.estimatedPose;
        }

        @Override
        public SpatialVectorReadOnly getEstimatedVelocity() {
            return this.estimatedDecayingVelocity;
        }
    }

    private static interface SingleEndEffectorStateEstimatorBase {
        public void reset();

        public void update(double var1, double var3, double var5, long var7, KinematicsToolboxRigidBodyCommand var9);

        public void predict(double var1);

        public FramePose3DReadOnly getEstimatedPose();

        public SpatialVectorReadOnly getEstimatedVelocity();
    }

    private class CenterOfMassEstimator {
        private final YoFramePoint3D estimatedPosition;
        private final YoFrameVector3D estimatedVelocity;
        private final YoFrameVector3D estimatedDecayingVelocity;
        private final YoFrameVector3D correctiveVelocity;
        private final YoDouble lastUpdateTime;
        private final YoLong lastInputTimestamp;
        private final YoFramePoint3D rawInputPosition;
        private final YoFrameVector3D rawInputVelocity;
        private final YoFrameVector3D debugInputVelocity;
        private final YoDouble nextTimeTriggerForDecay;
        private final YoDouble inputVelocityDecayFactor;

        public CenterOfMassEstimator() {
            String namePrefix = "CoM_FBC_";
            this.estimatedPosition = new YoFramePoint3D(namePrefix + "EstimatedPosition", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.estimatedVelocity = new YoFrameVector3D(namePrefix + "EstimatedVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.estimatedDecayingVelocity = new YoFrameVector3D(namePrefix + "EstimatedDecayingVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.correctiveVelocity = new YoFrameVector3D(namePrefix + "CorrectiveVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.debugInputVelocity = new YoFrameVector3D(namePrefix + "DebugInputVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.lastUpdateTime = new YoDouble(namePrefix + "LastUpdateTime", KSTInputFBControllerStateEstimator.this.registry);
            this.lastInputTimestamp = new YoLong(namePrefix + "LastInputTimestamp", KSTInputFBControllerStateEstimator.this.registry);
            this.rawInputPosition = new YoFramePoint3D(namePrefix + "RawInputPosition", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.rawInputVelocity = new YoFrameVector3D(namePrefix + "RawInputVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry);
            this.nextTimeTriggerForDecay = new YoDouble(namePrefix + "NextTimeTriggerForDecay", KSTInputFBControllerStateEstimator.this.registry);
            this.inputVelocityDecayFactor = new YoDouble(namePrefix + "InputVelocityDecayFactor", KSTInputFBControllerStateEstimator.this.registry);
        }

        public void reset() {
            this.estimatedPosition.setToZero();
            this.estimatedVelocity.setToZero();
            this.estimatedDecayingVelocity.setToZero();
            this.correctiveVelocity.setToZero();
            this.debugInputVelocity.setToZero();
            this.lastUpdateTime.set(Double.NaN);
            this.lastInputTimestamp.set(Long.MIN_VALUE);
            this.rawInputPosition.setToZero();
            this.rawInputVelocity.setToZero();
            this.nextTimeTriggerForDecay.set(0.0);
            this.inputVelocityDecayFactor.set(0.0);
        }

        public void update(double time, double defaultLinearRateLimitation, long inputTimestamp, KinematicsToolboxCenterOfMassCommand input) {
            if (input.getLinearRateLimitation() > 0.0) {
                defaultLinearRateLimitation = input.getLinearRateLimitation();
            }
            FramePoint3D position = input.getDesiredPosition();
            if (this.lastUpdateTime.isNaN()) {
                this.estimatedPosition.set((FrameTuple3DReadOnly)position);
                this.correctiveVelocity.setToZero();
                if (!input.getHasDesiredVelocity()) {
                    this.estimatedVelocity.setToZero();
                    this.estimatedDecayingVelocity.setToZero();
                } else {
                    this.estimatedVelocity.set((FrameTuple3DReadOnly)input.getDesiredVelocity());
                    this.estimatedDecayingVelocity.set((FrameTuple3DReadOnly)this.estimatedVelocity);
                }
            } else {
                this.correctiveVelocity.sub((FrameTuple3DReadOnly)position, (FrameTuple3DReadOnly)this.estimatedPosition);
                this.correctiveVelocity.scale(1.0 / KSTInputFBControllerStateEstimator.this.correctionDuration.getValue());
                if (!input.getHasDesiredVelocity()) {
                    double timeInterval = Conversions.nanosecondsToSeconds((long)(inputTimestamp - this.lastInputTimestamp.getLongValue()));
                    KSTTools.computeLinearVelocity(timeInterval, (FramePoint3DReadOnly)this.rawInputPosition, (FramePoint3DReadOnly)position, (FixedFrameVector3DBasics)this.rawInputVelocity);
                } else {
                    double timeInterval = Conversions.nanosecondsToSeconds((long)(inputTimestamp - this.lastInputTimestamp.getLongValue()));
                    KSTTools.computeLinearVelocity(timeInterval, (FramePoint3DReadOnly)this.rawInputPosition, (FramePoint3DReadOnly)position, (FixedFrameVector3DBasics)this.debugInputVelocity);
                    this.rawInputVelocity.setMatchingFrame((FrameTuple3DReadOnly)input.getDesiredVelocity());
                }
                if (this.rawInputVelocity.containsNaN()) {
                    this.rawInputVelocity.setToZero();
                }
                this.estimatedVelocity.set((FrameTuple3DReadOnly)this.rawInputVelocity);
                this.estimatedVelocity.scale(KSTInputFBControllerStateEstimator.this.rawVelocityAlpha.getValue());
                this.estimatedVelocity.add((FrameTuple3DReadOnly)this.correctiveVelocity);
                this.estimatedVelocity.clipToMaxNorm(defaultLinearRateLimitation);
                this.estimatedDecayingVelocity.set((FrameTuple3DReadOnly)this.estimatedVelocity);
                KSTTools.integrateLinearVelocity(KSTInputFBControllerStateEstimator.this.updateDT, (FramePoint3DReadOnly)this.estimatedPosition, (FrameVector3DReadOnly)this.estimatedDecayingVelocity, (FixedFramePoint3DBasics)this.estimatedPosition);
            }
            this.lastUpdateTime.set(time);
            this.lastInputTimestamp.set(inputTimestamp);
            this.rawInputPosition.set((FrameTuple3DReadOnly)position);
            this.nextTimeTriggerForDecay.set(time + KSTInputFBControllerStateEstimator.this.correctionDuration.getValue());
            this.inputVelocityDecayFactor.set(0.0);
        }

        public void predict(double time) {
            if (time > this.nextTimeTriggerForDecay.getValue()) {
                double alpha = Math.min(1.0, this.inputVelocityDecayFactor.getValue() + KSTInputFBControllerStateEstimator.this.updateDT / KSTInputFBControllerStateEstimator.this.inputVelocityDecayDuration.getValue());
                this.inputVelocityDecayFactor.set(alpha);
                this.estimatedDecayingVelocity.interpolate((FrameTuple3DReadOnly)this.estimatedVelocity, (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, alpha);
            }
            KSTTools.integrateLinearVelocity(KSTInputFBControllerStateEstimator.this.updateDT, (FramePoint3DReadOnly)this.estimatedPosition, (FrameVector3DReadOnly)this.estimatedDecayingVelocity, (FixedFramePoint3DBasics)this.estimatedPosition);
        }

        public FramePoint3DReadOnly getEstimatedPosition() {
            return this.estimatedPosition;
        }

        public FrameVector3DReadOnly getEstimatedVelocity() {
            return this.estimatedDecayingVelocity;
        }
    }

    private class SingleEndEffectorC1Estimator
    implements SingleEndEffectorStateEstimatorBase {
        private final YoFramePose3D estimatedPose;
        private final YoFixedFrameSpatialVector estimatedVelocity;
        private final YoFixedFrameSpatialVector estimatedAcceleration;
        private final YoFixedFrameSpatialVector estimatedDecayingVelocity;
        private final YoFixedFrameSpatialVector estimatedDecayingAcceleration;
        private final YoDouble maxLinearVelocity;
        private final YoDouble maxAngularVelocity;
        private final YoDouble lastUpdateTime;
        private final YoLong lastInputTimestamp;
        private final YoFramePose3D rawInputPose;
        private final YoFixedFrameSpatialVector rawInputVelocity;
        private final YoFixedFrameSpatialVector clampedInputVelocity;
        private final YoFixedFrameSpatialVector debugInputVelocity;
        private final YoDouble nextTimeTriggerForDecay;
        private final YoDouble inputVelocityDecayFactor;
        private final Vector3D rawLinearDeltaVelocity = new Vector3D();
        private final Vector3D rawAngularDeltaVelocity = new Vector3D();
        private final Vector3D positionVectorError = new Vector3D();
        private final Vector3D linearVelocityVectorError = new Vector3D();
        private final Quaternion quaternionError = new Quaternion();
        private final Vector3D rotationVectorErrorBodyFrame = new Vector3D();
        private final Vector3D angularVelocityErrorBodyFrame = new Vector3D();
        private final Vector3D angularAccelerationBodyFrame = new Vector3D();
        private final Vector3D rotationVectorUpdate = new Vector3D();
        private final Quaternion orientationUpdate = new Quaternion();

        public SingleEndEffectorC1Estimator(RigidBodyReadOnly endEffector) {
            String namePrefix = endEffector.getName() + "_FBC_";
            this.estimatedPose = new YoFramePose3D(new YoFramePoint3D(namePrefix + "EstimatedPosition", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameQuaternion(namePrefix + "EstimatedOrientation", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.estimatedVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "EstimatedAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "EstimatedLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.estimatedAcceleration = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "EstimatedAngularAcceleration", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "EstimatedLinearAcceleration", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.estimatedDecayingVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "EstimatedDecayingAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "EstimatedDecayingLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.estimatedDecayingAcceleration = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "EstimatedDecayingAngularAcceleration", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "EstimatedDecayingLinearAcceleration", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.maxLinearVelocity = new YoDouble(namePrefix + "MaxLinearVelocity", KSTInputFBControllerStateEstimator.this.registry);
            this.maxAngularVelocity = new YoDouble(namePrefix + "MaxAngularVelocity", KSTInputFBControllerStateEstimator.this.registry);
            this.debugInputVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "DebugAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "DebugLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.lastUpdateTime = new YoDouble(namePrefix + "LastUpdateTime", KSTInputFBControllerStateEstimator.this.registry);
            this.lastInputTimestamp = new YoLong(namePrefix + "LastInputTimestamp", KSTInputFBControllerStateEstimator.this.registry);
            this.rawInputPose = new YoFramePose3D(new YoFramePoint3D(namePrefix + "RawInputPosition", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameQuaternion(namePrefix + "RawInputOrientation", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.rawInputVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "RawInputAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "RawInputLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.clampedInputVelocity = new YoFixedFrameSpatialVector(new YoFrameVector3D(namePrefix + "ClampedInputAngularVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry), new YoFrameVector3D(namePrefix + "ClampedInputLinearVelocity", worldFrame, KSTInputFBControllerStateEstimator.this.registry));
            this.nextTimeTriggerForDecay = new YoDouble(namePrefix + "NextTimeTriggerForDecay", KSTInputFBControllerStateEstimator.this.registry);
            this.inputVelocityDecayFactor = new YoDouble(namePrefix + "InputVelocityDecayFactor", KSTInputFBControllerStateEstimator.this.registry);
        }

        @Override
        public void reset() {
            this.estimatedPose.setToZero();
            this.estimatedVelocity.setToZero();
            this.estimatedAcceleration.setToZero();
            this.estimatedDecayingVelocity.setToZero();
            this.estimatedDecayingAcceleration.setToZero();
            this.maxLinearVelocity.set(Double.POSITIVE_INFINITY);
            this.maxAngularVelocity.set(Double.POSITIVE_INFINITY);
            this.debugInputVelocity.setToZero();
            this.lastUpdateTime.set(Double.NaN);
            this.lastInputTimestamp.set(Long.MIN_VALUE);
            this.rawInputPose.setToZero();
            this.rawInputVelocity.setToZero();
            this.nextTimeTriggerForDecay.set(0.0);
            this.inputVelocityDecayFactor.set(0.0);
            this.clampedInputVelocity.setToZero();
        }

        @Override
        public void update(double time, double defaultLinearRateLimitation, double defaultAngularRateLimitation, long inputTimestamp, KinematicsToolboxRigidBodyCommand input) {
            if (input.getLinearRateLimitation() > 0.0) {
                defaultLinearRateLimitation = input.getLinearRateLimitation();
            }
            if (input.getAngularRateLimitation() > 0.0) {
                defaultAngularRateLimitation = input.getAngularRateLimitation();
            }
            this.maxLinearVelocity.set(defaultLinearRateLimitation);
            this.maxAngularVelocity.set(defaultAngularRateLimitation);
            FramePose3D inputPose = input.getDesiredPose();
            if (this.lastUpdateTime.isNaN()) {
                this.estimatedPose.set((FramePose3DReadOnly)inputPose);
                if (!input.getHasDesiredVelocity()) {
                    this.estimatedVelocity.setToZero();
                    this.rawInputVelocity.setToZero();
                } else {
                    this.estimatedVelocity.setMatchingFrame((SpatialVectorReadOnly)input.getDesiredVelocity());
                    this.estimatedVelocity.getLinearPart().clipToMaxNorm(defaultLinearRateLimitation);
                    this.estimatedVelocity.getAngularPart().clipToMaxNorm(defaultAngularRateLimitation);
                    this.rawInputVelocity.setMatchingFrame((SpatialVectorReadOnly)input.getDesiredVelocity());
                }
                this.estimatedAcceleration.setToZero();
                this.estimatedDecayingVelocity.set((SpatialVectorReadOnly)this.estimatedVelocity);
                this.estimatedDecayingAcceleration.setToZero();
            } else {
                if (!input.getHasDesiredVelocity()) {
                    double timeInterval = Conversions.nanosecondsToSeconds((long)(inputTimestamp - this.lastInputTimestamp.getLongValue()));
                    KSTTools.computeSpatialVelocity(timeInterval, (FramePose3DReadOnly)this.rawInputPose, (FramePose3DReadOnly)inputPose, (FixedFrameSpatialVectorBasics)this.rawInputVelocity);
                    this.rawInputPose.getOrientation().transform((FixedFrameTuple3DBasics)this.rawInputVelocity.getAngularPart());
                } else {
                    double timeInterval = Conversions.nanosecondsToSeconds((long)(inputTimestamp - this.lastInputTimestamp.getLongValue()));
                    KSTTools.computeSpatialVelocity(timeInterval, (FramePose3DReadOnly)this.rawInputPose, (FramePose3DReadOnly)inputPose, (FixedFrameSpatialVectorBasics)this.debugInputVelocity);
                    this.rawInputPose.getOrientation().transform((FixedFrameTuple3DBasics)this.debugInputVelocity.getAngularPart());
                    this.rawInputVelocity.setMatchingFrame((SpatialVectorReadOnly)input.getDesiredVelocity());
                }
                if (this.rawInputVelocity.containsNaN()) {
                    this.rawInputVelocity.setToZero();
                    this.clampedInputVelocity.setToZero();
                } else {
                    this.rawLinearDeltaVelocity.sub((Tuple3DReadOnly)this.rawInputVelocity.getLinearPart(), (Tuple3DReadOnly)this.clampedInputVelocity.getLinearPart());
                    this.rawAngularDeltaVelocity.sub((Tuple3DReadOnly)this.rawInputVelocity.getAngularPart(), (Tuple3DReadOnly)this.clampedInputVelocity.getAngularPart());
                    this.rawLinearDeltaVelocity.clipToMaxNorm(KSTInputFBControllerStateEstimator.this.maxDeltaLinearVelocity.getValue());
                    this.rawAngularDeltaVelocity.clipToMaxNorm(KSTInputFBControllerStateEstimator.this.maxDeltaAngularVelocity.getValue());
                    this.clampedInputVelocity.getLinearPart().add((Tuple3DReadOnly)this.rawLinearDeltaVelocity);
                    this.clampedInputVelocity.getAngularPart().add((Tuple3DReadOnly)this.rawAngularDeltaVelocity);
                }
                this.estimatedVelocity.set((SpatialVectorReadOnly)this.estimatedDecayingVelocity);
                this.estimateAcceleration((FramePose3DReadOnly)inputPose, (SpatialVectorReadOnly)this.clampedInputVelocity, (FramePose3DReadOnly)this.estimatedPose, (SpatialVectorReadOnly)this.estimatedVelocity, (FixedFrameSpatialVectorBasics)this.estimatedAcceleration);
                this.doubleIntegrateAcceleration(0.0, defaultAngularRateLimitation, defaultLinearRateLimitation);
            }
            this.nextTimeTriggerForDecay.set(time + KSTInputFBControllerStateEstimator.this.correctionDuration.getValue());
            this.inputVelocityDecayFactor.set(0.0);
            this.lastUpdateTime.set(time);
            this.rawInputPose.set((FramePose3DReadOnly)inputPose);
            this.lastInputTimestamp.set(inputTimestamp);
        }

        private void doubleIntegrateAcceleration(double decayFactor, double maxAngularVelocity, double maxLinearVelocity) {
            this.estimatedDecayingAcceleration.getLinearPart().interpolate((FrameTuple3DReadOnly)this.estimatedAcceleration.getLinearPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, decayFactor);
            this.estimatedDecayingAcceleration.getAngularPart().interpolate((FrameTuple3DReadOnly)this.estimatedAcceleration.getAngularPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, decayFactor);
            YoFrameVector3D linearAccelerationWorldFrame = this.estimatedDecayingAcceleration.getLinearPart();
            YoFrameVector3D angularAccelerationWorldFrame = this.estimatedDecayingAcceleration.getAngularPart();
            YoFrameVector3D linearVelocityWorldFrame = this.estimatedVelocity.getLinearPart();
            YoFrameVector3D angularVelocityWorldFrame = this.estimatedVelocity.getAngularPart();
            SingleEndEffectorC1Estimator.clampAcceleration((Vector3DBasics)linearAccelerationWorldFrame, KSTInputFBControllerStateEstimator.this.updateDT, (Vector3DReadOnly)linearVelocityWorldFrame, maxLinearVelocity);
            SingleEndEffectorC1Estimator.clampAcceleration((Vector3DBasics)angularAccelerationWorldFrame, KSTInputFBControllerStateEstimator.this.updateDT, (Vector3DReadOnly)angularVelocityWorldFrame, maxAngularVelocity);
            YoFramePoint3D position = this.estimatedPose.getPosition();
            YoFrameQuaternion orientation = this.estimatedPose.getOrientation();
            linearVelocityWorldFrame.scaleAdd(KSTInputFBControllerStateEstimator.this.updateDT, (FrameTuple3DReadOnly)linearAccelerationWorldFrame, (FrameTuple3DReadOnly)linearVelocityWorldFrame);
            this.estimatedDecayingVelocity.getLinearPart().interpolate((FrameTuple3DReadOnly)this.estimatedVelocity.getLinearPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, decayFactor);
            linearVelocityWorldFrame = this.estimatedDecayingVelocity.getLinearPart();
            position.scaleAdd(-0.5 * KSTInputFBControllerStateEstimator.this.updateDT * KSTInputFBControllerStateEstimator.this.updateDT, (FrameTuple3DReadOnly)linearAccelerationWorldFrame, (FrameTuple3DReadOnly)position);
            position.scaleAdd(KSTInputFBControllerStateEstimator.this.updateDT, (FrameTuple3DReadOnly)linearVelocityWorldFrame, (FrameTuple3DReadOnly)position);
            angularVelocityWorldFrame.scaleAdd(KSTInputFBControllerStateEstimator.this.updateDT, (FrameTuple3DReadOnly)angularAccelerationWorldFrame, (FrameTuple3DReadOnly)angularVelocityWorldFrame);
            this.estimatedDecayingVelocity.getAngularPart().interpolate((FrameTuple3DReadOnly)this.estimatedVelocity.getAngularPart(), (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D, decayFactor);
            angularVelocityWorldFrame = this.estimatedVelocity.getAngularPart();
            this.rotationVectorUpdate.setAndScale(-0.5 * KSTInputFBControllerStateEstimator.this.updateDT * KSTInputFBControllerStateEstimator.this.updateDT, (Tuple3DReadOnly)angularAccelerationWorldFrame);
            this.rotationVectorUpdate.scaleAdd(KSTInputFBControllerStateEstimator.this.updateDT, (Tuple3DReadOnly)angularVelocityWorldFrame, (Tuple3DReadOnly)this.rotationVectorUpdate);
            this.orientationUpdate.setRotationVector((Vector3DReadOnly)this.rotationVectorUpdate);
            orientation.prepend((Orientation3DReadOnly)this.orientationUpdate);
        }

        private static void clampAcceleration(Vector3DBasics acceleration, double dt, Vector3DReadOnly velocity, double maxVelocity) {
            double vz;
            double vy;
            double vx = velocity.getX() + acceleration.getX() * dt;
            double norm = EuclidCoreTools.norm((double)vx, (double)(vy = velocity.getY() + acceleration.getY() * dt), (double)(vz = velocity.getZ() + acceleration.getZ() * dt));
            if (norm > maxVelocity) {
                acceleration.set(vx, vy, vz);
                acceleration.scale(maxVelocity / norm);
                acceleration.sub((Tuple3DReadOnly)velocity);
                acceleration.scale(1.0 / dt);
            }
        }

        private void estimateAcceleration(FramePose3DReadOnly inputPose, SpatialVectorReadOnly inputVelocity, FramePose3DReadOnly previousPose, SpatialVectorReadOnly previousVelocity, FixedFrameSpatialVectorBasics outputAcceleration) {
            FixedFrameVector3DBasics estimatedLinearAccelerationWorldFrame = outputAcceleration.getLinearPart();
            FixedFrameVector3DBasics estimatedAngularAccelerationWorldFrame = outputAcceleration.getAngularPart();
            double kp = 2.0 / (KSTInputFBControllerStateEstimator.this.correctionDuration.getValue() * KSTInputFBControllerStateEstimator.this.correctionDuration.getValue());
            double kd = 2.0 / KSTInputFBControllerStateEstimator.this.correctionDuration.getValue();
            this.positionVectorError.sub((Tuple3DReadOnly)inputPose.getPosition(), (Tuple3DReadOnly)previousPose.getPosition());
            this.positionVectorError.scale(kp);
            this.linearVelocityVectorError.scaleSub(KSTInputFBControllerStateEstimator.this.rawVelocityAlpha.getValue(), (Tuple3DReadOnly)inputVelocity.getLinearPart(), (Tuple3DReadOnly)previousVelocity.getLinearPart());
            this.linearVelocityVectorError.scale(kd);
            estimatedLinearAccelerationWorldFrame.add((Tuple3DReadOnly)this.positionVectorError, (Tuple3DReadOnly)this.linearVelocityVectorError);
            this.quaternionError.difference((QuaternionReadOnly)previousPose.getOrientation(), (QuaternionReadOnly)inputPose.getOrientation());
            this.quaternionError.getRotationVector((Vector3DBasics)this.rotationVectorErrorBodyFrame);
            this.angularVelocityErrorBodyFrame.scaleSub(KSTInputFBControllerStateEstimator.this.rawVelocityAlpha.getValue(), (Tuple3DReadOnly)inputVelocity.getAngularPart(), (Tuple3DReadOnly)previousVelocity.getAngularPart());
            previousPose.inverseTransform((Vector3DBasics)this.angularVelocityErrorBodyFrame);
            this.rotationVectorErrorBodyFrame.scale(kp);
            this.angularVelocityErrorBodyFrame.scale(kd);
            this.angularAccelerationBodyFrame.add((Tuple3DReadOnly)this.rotationVectorErrorBodyFrame, (Tuple3DReadOnly)this.angularVelocityErrorBodyFrame);
            previousPose.transform((Vector3DReadOnly)this.angularAccelerationBodyFrame, (Vector3DBasics)estimatedAngularAccelerationWorldFrame);
        }

        @Override
        public void predict(double time) {
            double decayFactor = 0.0;
            if (time > this.nextTimeTriggerForDecay.getValue()) {
                decayFactor = Math.min(1.0, this.inputVelocityDecayFactor.getValue() + KSTInputFBControllerStateEstimator.this.updateDT / KSTInputFBControllerStateEstimator.this.inputVelocityDecayDuration.getValue());
                this.inputVelocityDecayFactor.set(decayFactor);
            }
            this.doubleIntegrateAcceleration(decayFactor, this.maxAngularVelocity.getValue(), this.maxLinearVelocity.getValue());
            this.lastUpdateTime.set(time);
        }

        @Override
        public FramePose3DReadOnly getEstimatedPose() {
            return this.estimatedPose;
        }

        @Override
        public SpatialVectorReadOnly getEstimatedVelocity() {
            return this.estimatedVelocity;
        }
    }
}

