/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInitialConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.commons.UnitConversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;

public class KinematicsStreamingToolboxParameters {
    protected ClockType clockType;
    protected double toolboxUpdatePeriod;
    protected double timeThresholdForSleeping;
    protected double streamIntegrationDuration;
    protected double centerOfMassSafeMargin;
    protected final Vector2D centerOfMassOffset = new Vector2D();
    protected double centerOfMassHoldWeight;
    protected double centerOfMassTrackingWeight;
    protected double publishingSolutionPeriod;
    protected double holdArmWeight;
    protected double holdNeckWeight;
    protected final Vector3D holdPelvisLinearWeight = new Vector3D();
    protected final Vector3D holdPelvisAngularWeight = new Vector3D();
    protected final Vector3D holdChestAngularWeight = new Vector3D();
    protected double lockPelvisWeight;
    protected double lockChestWeight;
    protected Vector3D defaultLinearWeight = new Vector3D();
    protected Vector3D defaultAngularWeight = new Vector3D();
    protected Vector3D defaultPelvisLinearWeight = new Vector3D();
    protected Vector3D defaultPelvisAngularWeight = new Vector3D();
    protected Vector3D defaultChestLinearWeight = new Vector3D();
    protected Vector3D defaultChestAngularWeight = new Vector3D();
    protected Vector3D defaultHandLinearWeight = new Vector3D();
    protected Vector3D defaultHandAngularWeight = new Vector3D();
    protected double defaultLinearGain;
    protected double defaultAngularGain;
    protected double defaultSingleJointGain;
    protected double defaultLinearRateLimit;
    protected double defaultAngularRateLimit;
    protected double outputJointVelocityScale;
    protected double outputFeedbackGain;
    protected double outputFeedbackDampingRatio;
    protected double outputLPFBreakFrequency;
    protected boolean minimizeAngularMomentum;
    protected boolean minimizeLinearMomentum;
    protected Vector3D angularMomentumWeight;
    protected Vector3D linearMomentumWeight;
    protected boolean minimizeAngularMomentumRate;
    protected boolean minimizeLinearMomentumRate;
    protected Vector3D angularMomentumRateWeight;
    protected Vector3D linearMomentumRateWeight;
    protected double defaultStreamingBlendingDuration;
    protected double inputPoseLPFBreakFrequency;
    protected double inputWeightDecayDuration;
    protected double inputVelocityDecayDuration;
    protected double inputVelocityRawAlpha;
    protected double inputPoseCorrectionDuration;
    protected boolean useBBXInputFilter;
    protected Vector3D inputFilterBBXSize;
    protected Point3D inputFilterBBXCenter;
    protected double inputFilterMaxLinearDelta;
    protected double inputFilterMaxAngularDelta;
    protected double inputFilterMaxLinearVelocity;
    protected double inputFilterMaxAngularVelocity;
    protected boolean useStreamingPublisher;
    protected double publishingPeriod;
    protected InputStateEstimatorType inputStateEstimatorType;
    protected Map<String, Double> initialConfigurationMap;
    protected Map<String, Double> jointCustomPositionUpperLimits;
    protected Map<String, Double> jointCustomPositionLowerLimits;
    protected final KinematicsStreamingToolboxConfigurationMessage defaultConfiguration = new KinematicsStreamingToolboxConfigurationMessage();
    protected final KinematicsStreamingToolboxInitialConfigurationMessage defaultInitialConfiguration = new KinematicsStreamingToolboxInitialConfigurationMessage();
    protected final KinematicsToolboxConfigurationMessage defaultSolverConfiguration = new KinematicsToolboxConfigurationMessage();
    protected double solverNullspaceAlpha;
    protected double solverPrivilegedDefaultWeight;
    protected double solverPrivilegedDefaultGain;
    protected final List<String> inactiveJoints = new ArrayList<String>();

    public static KinematicsStreamingToolboxParameters defaultParameters() {
        KinematicsStreamingToolboxParameters parameters = new KinematicsStreamingToolboxParameters();
        parameters.setDefault();
        return parameters;
    }

    public void setDefault() {
        this.clockType = ClockType.CPU_CLOCK;
        this.toolboxUpdatePeriod = 0.003;
        this.timeThresholdForSleeping = 3.0;
        this.useStreamingPublisher = true;
        this.publishingPeriod = 0.006;
        this.streamIntegrationDuration = 2.0 * this.publishingPeriod;
        this.holdChestAngularWeight.set(1.0, 1.0, 0.5);
        this.holdPelvisLinearWeight.set(10.0, 10.0, 20.0);
        this.holdPelvisAngularWeight.set(1.0, 1.0, 1.0);
        this.holdArmWeight = 10.0;
        this.holdNeckWeight = 10.0;
        this.centerOfMassSafeMargin = 0.01;
        this.centerOfMassHoldWeight = 0.001;
        this.centerOfMassTrackingWeight = 0.001;
        this.publishingSolutionPeriod = UnitConversions.hertzToSeconds((double)60.0);
        this.lockPelvisWeight = 1000.0;
        this.lockChestWeight = 1000.0;
        this.defaultLinearWeight.set(20.0, 20.0, 20.0);
        this.defaultAngularWeight.set(2.5, 2.5, 2.5);
        this.defaultPelvisLinearWeight.set(this.defaultLinearWeight);
        this.defaultPelvisAngularWeight.set(this.defaultAngularWeight);
        this.defaultChestLinearWeight.set(this.defaultLinearWeight);
        this.defaultChestAngularWeight.set(this.defaultAngularWeight);
        this.defaultHandLinearWeight.set(this.defaultLinearWeight);
        this.defaultHandAngularWeight.set(this.defaultAngularWeight);
        this.defaultLinearGain = 50.0;
        this.defaultAngularGain = 50.0;
        this.defaultSingleJointGain = 50.0;
        this.defaultLinearRateLimit = 10.0;
        this.defaultAngularRateLimit = 100.0;
        this.minimizeAngularMomentum = true;
        this.minimizeLinearMomentum = true;
        this.angularMomentumWeight = new Vector3D(0.2, 0.2, 0.2);
        this.linearMomentumWeight = new Vector3D(0.01, 0.01, 0.0);
        this.minimizeAngularMomentumRate = true;
        this.minimizeLinearMomentumRate = true;
        this.angularMomentumRateWeight = new Vector3D(1.0, 1.0, 1.0);
        this.linearMomentumRateWeight = new Vector3D(1.0, 1.0, 1.0);
        this.defaultStreamingBlendingDuration = 2.0;
        this.inputPoseLPFBreakFrequency = 15.0;
        this.inputPoseCorrectionDuration = 0.05;
        this.inputWeightDecayDuration = 3.0;
        this.inputVelocityDecayDuration = 0.5;
        this.inputVelocityRawAlpha = 0.65;
        this.inputStateEstimatorType = InputStateEstimatorType.FBC_STYLE;
        this.useBBXInputFilter = true;
        this.inputFilterBBXSize = new Vector3D(2.0, 2.8, 2.6);
        this.inputFilterBBXCenter = new Point3D(0.4, 0.0, 1.25);
        this.outputJointVelocityScale = 0.5;
        this.outputFeedbackGain = 500.0;
        this.outputFeedbackDampingRatio = 1.0;
        this.outputLPFBreakFrequency = 10.0;
        this.defaultConfiguration.setLockPelvis(false);
        this.defaultConfiguration.setLockChest(false);
        this.defaultConfiguration.setEnableLeftArmJointspace(true);
        this.defaultConfiguration.setEnableRightArmJointspace(true);
        this.defaultConfiguration.setEnableNeckJointspace(true);
        this.defaultConfiguration.setEnableLeftHandTaskspace(false);
        this.defaultConfiguration.setEnableRightHandTaskspace(false);
        this.defaultConfiguration.setEnableChestTaskspace(true);
        this.defaultConfiguration.setEnablePelvisTaskspace(true);
        this.defaultConfiguration.setEnableCenterOfMassControl(false);
        this.defaultConfiguration.setLeftHandTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultConfiguration.setRightHandTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultConfiguration.setChestTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultConfiguration.setPelvisTrajectoryFrameId((long)ReferenceFrame.getWorldFrame().getFrameNameHashCode());
        this.defaultSolverConfiguration.setJointVelocityWeight(0.05);
        this.defaultSolverConfiguration.setJointAccelerationWeight(0.0);
        this.defaultSolverConfiguration.setEnableJointVelocityLimits(true);
        this.solverNullspaceAlpha = -1.0;
        this.solverPrivilegedDefaultWeight = -1.0;
        this.solverPrivilegedDefaultGain = -1.0;
        this.inputFilterMaxLinearDelta = 0.5;
        this.inputFilterMaxAngularDelta = Double.POSITIVE_INFINITY;
        this.inputFilterMaxLinearVelocity = 6.0;
        this.inputFilterMaxAngularVelocity = Double.POSITIVE_INFINITY;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public double getToolboxUpdatePeriod() {
        return this.toolboxUpdatePeriod;
    }

    public double getTimeThresholdForSleeping() {
        return this.timeThresholdForSleeping;
    }

    public double getStreamIntegrationDuration() {
        return this.streamIntegrationDuration;
    }

    public double getCenterOfMassSafeMargin() {
        return this.centerOfMassSafeMargin;
    }

    public double getCenterOfMassHoldWeight() {
        return this.centerOfMassHoldWeight;
    }

    public double getCenterOfMassTrackingWeight() {
        return this.centerOfMassTrackingWeight;
    }

    public double getPublishingSolutionPeriod() {
        return this.publishingSolutionPeriod;
    }

    public double getHoldArmWeight() {
        return this.holdArmWeight;
    }

    public double getHoldNeckWeight() {
        return this.holdNeckWeight;
    }

    public Vector3D getHoldPelvisLinearWeight() {
        return this.holdPelvisLinearWeight;
    }

    public Vector3D getHoldPelvisAngularWeight() {
        return this.holdPelvisAngularWeight;
    }

    public Vector3D getHoldChestAngularWeight() {
        return this.holdChestAngularWeight;
    }

    public double getLockPelvisWeight() {
        return this.lockPelvisWeight;
    }

    public double getLockChestWeight() {
        return this.lockChestWeight;
    }

    public Vector3D getDefaultLinearWeight() {
        return this.defaultLinearWeight;
    }

    public Vector3D getDefaultAngularWeight() {
        return this.defaultAngularWeight;
    }

    public Vector3D getDefaultPelvisLinearWeight() {
        return this.defaultPelvisLinearWeight;
    }

    public Vector3D getDefaultPelvisAngularWeight() {
        return this.defaultPelvisAngularWeight;
    }

    public Vector3D getDefaultChestLinearWeight() {
        return this.defaultChestLinearWeight;
    }

    public Vector3D getDefaultChestAngularWeight() {
        return this.defaultChestAngularWeight;
    }

    public Vector3D getDefaultHandLinearWeight() {
        return this.defaultHandLinearWeight;
    }

    public Vector3D getDefaultHandAngularWeight() {
        return this.defaultHandAngularWeight;
    }

    public double getDefaultLinearGain() {
        return this.defaultLinearGain;
    }

    public double getDefaultAngularGain() {
        return this.defaultAngularGain;
    }

    public double getDefaultSingleJointGain() {
        return this.defaultSingleJointGain;
    }

    public double getDefaultLinearRateLimit() {
        return this.defaultLinearRateLimit;
    }

    public double getDefaultAngularRateLimit() {
        return this.defaultAngularRateLimit;
    }

    public double getOutputJointVelocityScale() {
        return this.outputJointVelocityScale;
    }

    public double getOutputFeedbackGain() {
        return this.outputFeedbackGain;
    }

    public double getOutputFeedbackDampingRatio() {
        return this.outputFeedbackDampingRatio;
    }

    public double getOutputLPFBreakFrequency() {
        return this.outputLPFBreakFrequency;
    }

    public boolean isMinimizeAngularMomentum() {
        return this.minimizeAngularMomentum;
    }

    public boolean isMinimizeLinearMomentum() {
        return this.minimizeLinearMomentum;
    }

    public Vector3D getAngularMomentumWeight() {
        return this.angularMomentumWeight;
    }

    public Vector3D getLinearMomentumWeight() {
        return this.linearMomentumWeight;
    }

    public boolean isMinimizeAngularMomentumRate() {
        return this.minimizeAngularMomentumRate;
    }

    public boolean isMinimizeLinearMomentumRate() {
        return this.minimizeLinearMomentumRate;
    }

    public Vector3D getAngularMomentumRateWeight() {
        return this.angularMomentumRateWeight;
    }

    public Vector3D getLinearMomentumRateWeight() {
        return this.linearMomentumRateWeight;
    }

    public double getDefaultStreamingBlendingDuration() {
        return this.defaultStreamingBlendingDuration;
    }

    public double getInputPoseLPFBreakFrequency() {
        return this.inputPoseLPFBreakFrequency;
    }

    public double getInputWeightDecayDuration() {
        return this.inputWeightDecayDuration;
    }

    public double getInputVelocityDecayDuration() {
        return this.inputVelocityDecayDuration;
    }

    public double getInputVelocityRawAlpha() {
        return this.inputVelocityRawAlpha;
    }

    public double getInputPoseCorrectionDuration() {
        return this.inputPoseCorrectionDuration;
    }

    public boolean isUseBBXInputFilter() {
        return this.useBBXInputFilter;
    }

    public Vector3D getInputFilterBBXSize() {
        return this.inputFilterBBXSize;
    }

    public Point3D getInputFilterBBXCenter() {
        return this.inputFilterBBXCenter;
    }

    public double getInputFilterMaxLinearDelta() {
        return this.inputFilterMaxLinearDelta;
    }

    public double getInputFilterMaxAngularDelta() {
        return this.inputFilterMaxAngularDelta;
    }

    public double getInputFilterMaxLinearVelocity() {
        return this.inputFilterMaxLinearVelocity;
    }

    public double getInputFilterMaxAngularVelocity() {
        return this.inputFilterMaxAngularVelocity;
    }

    public boolean getUseStreamingPublisher() {
        return this.useStreamingPublisher;
    }

    public double getPublishingPeriod() {
        return this.publishingPeriod;
    }

    public InputStateEstimatorType getInputStateEstimatorType() {
        return this.inputStateEstimatorType;
    }

    public Map<String, Double> getJointCustomPositionUpperLimits() {
        return this.jointCustomPositionUpperLimits;
    }

    public Map<String, Double> getJointCustomPositionLowerLimits() {
        return this.jointCustomPositionLowerLimits;
    }

    public Map<String, Double> getInitialConfigurationMap() {
        return this.initialConfigurationMap;
    }

    public KinematicsStreamingToolboxConfigurationMessage getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public KinematicsToolboxConfigurationMessage getDefaultSolverConfiguration() {
        return this.defaultSolverConfiguration;
    }

    public double getSolverNullspaceAlpha() {
        return this.solverNullspaceAlpha;
    }

    public double getSolverPrivilegedDefaultWeight() {
        return this.solverPrivilegedDefaultWeight;
    }

    public double getSolverPrivilegedDefaultGain() {
        return this.solverPrivilegedDefaultGain;
    }

    public void setClockType(ClockType clockType) {
        this.clockType = clockType;
    }

    public void setToolboxUpdatePeriod(double toolboxUpdatePeriod) {
        this.toolboxUpdatePeriod = toolboxUpdatePeriod;
    }

    public void setTimeThresholdForSleeping(double timeThresholdForSleeping) {
        this.timeThresholdForSleeping = timeThresholdForSleeping;
    }

    public void setStreamIntegrationDuration(double streamIntegrationDuration) {
        this.streamIntegrationDuration = streamIntegrationDuration;
    }

    public void setCenterOfMassSafeMargin(double centerOfMassSafeMargin) {
        this.centerOfMassSafeMargin = centerOfMassSafeMargin;
    }

    public void setCenterOfMassOffset(Vector2D offset) {
        this.centerOfMassOffset.set(offset);
    }

    public Vector2D getCenterOfMassOffset() {
        return this.centerOfMassOffset;
    }

    public void setCenterOfMassHoldWeight(double centerOfMassHoldWeight) {
        this.centerOfMassHoldWeight = centerOfMassHoldWeight;
    }

    public void setPublishingSolutionPeriod(double publishingSolutionPeriod) {
        this.publishingSolutionPeriod = publishingSolutionPeriod;
    }

    public void setHoldArmWeight(double holdArmWeight) {
        this.holdArmWeight = holdArmWeight;
    }

    public void setHoldNeckWeight(double holdNeckWeight) {
        this.holdNeckWeight = holdNeckWeight;
    }

    public void setHoldPelvisLinearWeight(double xWeight, double yWeight, double zWeight) {
        this.holdPelvisLinearWeight.set(xWeight, yWeight, zWeight);
    }

    public void setHoldPelvisAngularWeight(double xWeight, double yWeight, double zWeight) {
        this.holdPelvisAngularWeight.set(xWeight, yWeight, zWeight);
    }

    public void setHoldChestAngularWeight(double xWeight, double yWeight, double zWeight) {
        this.holdChestAngularWeight.set(xWeight, yWeight, zWeight);
    }

    public void setLockPelvisWeight(double lockPelvisWeight) {
        this.lockPelvisWeight = lockPelvisWeight;
    }

    public void setLockChestWeight(double lockChestWeight) {
        this.lockChestWeight = lockChestWeight;
    }

    public void setDefaultLinearWeight(double defaultLinearWeight) {
        this.defaultLinearWeight = new Vector3D(defaultLinearWeight, defaultLinearWeight, defaultLinearWeight);
    }

    public void setDefaultLinearWeight(Tuple3DReadOnly defaultLinearWeight) {
        this.defaultLinearWeight = new Vector3D(defaultLinearWeight);
    }

    public void setDefaultAngularWeight(double defaultAngularWeight) {
        this.defaultAngularWeight = new Vector3D(defaultAngularWeight, defaultAngularWeight, defaultAngularWeight);
    }

    public void setDefaultAngularWeight(Tuple3DReadOnly defaultAngularWeight) {
        this.defaultAngularWeight = new Vector3D(defaultAngularWeight);
    }

    public void setDefaultPelvisLinearWeight(double defaultPelvisLinearWeight) {
        this.defaultPelvisLinearWeight = new Vector3D(defaultPelvisLinearWeight, defaultPelvisLinearWeight, defaultPelvisLinearWeight);
    }

    public void setDefaultPelvisLinearWeight(Tuple3DReadOnly defaultPelvisLinearWeight) {
        this.defaultPelvisLinearWeight = new Vector3D(defaultPelvisLinearWeight);
    }

    public void setDefaultPelvisAngularWeight(double defaultPelvisAngularWeight) {
        this.defaultPelvisAngularWeight = new Vector3D(defaultPelvisAngularWeight, defaultPelvisAngularWeight, defaultPelvisAngularWeight);
    }

    public void setDefaultPelvisAngularWeight(Tuple3DReadOnly defaultPelvisAngularWeight) {
        this.defaultPelvisAngularWeight = new Vector3D(defaultPelvisAngularWeight);
    }

    public void setDefaultChestLinearWeight(double defaultChestLinearWeight) {
        this.defaultChestLinearWeight = new Vector3D(defaultChestLinearWeight, defaultChestLinearWeight, defaultChestLinearWeight);
    }

    public void setDefaultChestLinearWeight(Tuple3DReadOnly defaultChestLinearWeight) {
        this.defaultChestLinearWeight = new Vector3D(defaultChestLinearWeight);
    }

    public void setDefaultChestAngularWeight(double defaultChestAngularWeight) {
        this.defaultChestAngularWeight = new Vector3D(defaultChestAngularWeight, defaultChestAngularWeight, defaultChestAngularWeight);
    }

    public void setDefaultChestAngularWeight(Tuple3DReadOnly defaultChestAngularWeight) {
        this.defaultChestAngularWeight = new Vector3D(defaultChestAngularWeight);
    }

    public void setDefaultHandLinearWeight(double defaultHandLinearWeight) {
        this.defaultHandLinearWeight = new Vector3D(defaultHandLinearWeight, defaultHandLinearWeight, defaultHandLinearWeight);
    }

    public void setDefaultHandLinearWeight(Tuple3DReadOnly defaultHandLinearWeight) {
        this.defaultHandLinearWeight = new Vector3D(defaultHandLinearWeight);
    }

    public void setDefaultHandAngularWeight(double defaultHandAngularWeight) {
        this.defaultHandAngularWeight = new Vector3D(defaultHandAngularWeight, defaultHandAngularWeight, defaultHandAngularWeight);
    }

    public void setDefaultHandAngularWeight(Tuple3DReadOnly defaultHandAngularWeight) {
        this.defaultHandAngularWeight = new Vector3D(defaultHandAngularWeight);
    }

    public void setDefaultLinearGain(double defaultLinearGain) {
        this.defaultLinearGain = defaultLinearGain;
    }

    public void setDefaultAngularGain(double defaultAngularGain) {
        this.defaultAngularGain = defaultAngularGain;
    }

    public void setDefaultSingleJointGain(double defaultSingleJointGain) {
        this.defaultSingleJointGain = defaultSingleJointGain;
    }

    public void setDefaultLinearRateLimit(double defaultLinearRateLimit) {
        this.defaultLinearRateLimit = defaultLinearRateLimit;
    }

    public void setDefaultAngularRateLimit(double defaultAngularRateLimit) {
        this.defaultAngularRateLimit = defaultAngularRateLimit;
    }

    public void setOutputJointVelocityScale(double outputJointVelocityScale) {
        this.outputJointVelocityScale = outputJointVelocityScale;
    }

    public void setOutputFeedbackGain(double outputFeedbackGain) {
        this.outputFeedbackGain = outputFeedbackGain;
    }

    public void setOutputFeedbackDampingRatio(double outputFeedbackDampingRatio) {
        this.outputFeedbackDampingRatio = outputFeedbackDampingRatio;
    }

    public void setOutputLPFBreakFrequency(double outputLPFBreakFrequency) {
        this.outputLPFBreakFrequency = outputLPFBreakFrequency;
    }

    public void setMinimizeAngularMomentum(boolean minimizeAngularMomentum) {
        this.minimizeAngularMomentum = minimizeAngularMomentum;
    }

    public void setMinimizeLinearMomentum(boolean minimizeLinearMomentum) {
        this.minimizeLinearMomentum = minimizeLinearMomentum;
    }

    public void setAngularMomentumWeight(double angularMomentumWeight) {
        this.angularMomentumWeight = new Vector3D(angularMomentumWeight, angularMomentumWeight, angularMomentumWeight);
    }

    public void setLinearMomentumWeight(double linearMomentumWeight) {
        this.linearMomentumWeight = new Vector3D(linearMomentumWeight, linearMomentumWeight, linearMomentumWeight);
    }

    public void setAngularMomentumWeight(Vector3D angularMomentumWeight) {
        this.angularMomentumWeight = angularMomentumWeight;
    }

    public void setLinearMomentumWeight(Vector3D linearMomentumWeight) {
        this.linearMomentumWeight = linearMomentumWeight;
    }

    public void setMinimizeAngularMomentumRate(boolean minimizeAngularMomentumRate) {
        this.minimizeAngularMomentumRate = minimizeAngularMomentumRate;
    }

    public void setMinimizeLinearMomentumRate(boolean minimizeLinearMomentumRate) {
        this.minimizeLinearMomentumRate = minimizeLinearMomentumRate;
    }

    public void setAngularMomentumRateWeight(double angularMomentumRateWeight) {
        this.angularMomentumRateWeight = new Vector3D(angularMomentumRateWeight, angularMomentumRateWeight, angularMomentumRateWeight);
    }

    public void setAngularMomentumRateWeight(Tuple3DReadOnly angularMomentumRateWeight) {
        this.angularMomentumRateWeight = new Vector3D(angularMomentumRateWeight);
    }

    public void setLinearMomentumRateWeight(double linearMomentumRateWeight) {
        this.linearMomentumRateWeight = new Vector3D(linearMomentumRateWeight, linearMomentumRateWeight, linearMomentumRateWeight);
    }

    public void setLinearMomentumRateWeight(Tuple3DReadOnly linearMomentumRateWeight) {
        this.linearMomentumRateWeight = new Vector3D(linearMomentumRateWeight);
    }

    public void setDefaultStreamingBlendingDuration(double defaultStreamingBlendingDuration) {
        this.defaultStreamingBlendingDuration = defaultStreamingBlendingDuration;
    }

    public void setInputPoseLPFBreakFrequency(double inputPoseLPFBreakFrequency) {
        this.inputPoseLPFBreakFrequency = inputPoseLPFBreakFrequency;
    }

    public void setInputWeightDecayDuration(double inputWeightDecayDuration) {
        this.inputWeightDecayDuration = inputWeightDecayDuration;
    }

    public void setInputVelocityDecayDuration(double inputVelocityDecayDuration) {
        this.inputVelocityDecayDuration = inputVelocityDecayDuration;
    }

    public void setInputVelocityRawAlpha(double inputVelocityRawAlpha) {
        this.inputVelocityRawAlpha = inputVelocityRawAlpha;
    }

    public void setInputPoseCorrectionDuration(double inputPoseCorrectionDuration) {
        this.inputPoseCorrectionDuration = inputPoseCorrectionDuration;
    }

    public void setUseBBXInputFilter(boolean useBBXInputFilter) {
        this.useBBXInputFilter = useBBXInputFilter;
    }

    public void setInputBBXFilterCenter(double x, double y, double z) {
        if (this.inputFilterBBXCenter == null) {
            this.inputFilterBBXCenter = new Point3D();
        }
        this.inputFilterBBXCenter.set(x, y, z);
    }

    public void setInputFilterBBXCenter(Point3D inputFilterBBXCenter) {
        this.inputFilterBBXCenter = inputFilterBBXCenter;
    }

    public void setInputBBXFilterSize(double x, double y, double z) {
        if (this.inputFilterBBXSize == null) {
            this.inputFilterBBXSize = new Vector3D();
        }
        this.inputFilterBBXSize.set(x, y, z);
    }

    public void setInputFilterBBXSize(Vector3D inputFilterBBXSize) {
        this.inputFilterBBXSize = inputFilterBBXSize;
    }

    public void setInputFilterMaxLinearDelta(double inputFilterMaxLinearDelta) {
        this.inputFilterMaxLinearDelta = inputFilterMaxLinearDelta;
    }

    public void setInputFilterMaxAngularDelta(double inputFilterMaxAngularDelta) {
        this.inputFilterMaxAngularDelta = inputFilterMaxAngularDelta;
    }

    public void setInputFilterMaxLinearVelocity(double inputFilterMaxLinearVelocity) {
        this.inputFilterMaxLinearVelocity = inputFilterMaxLinearVelocity;
    }

    public void setInputFilterMaxAngularVelocity(double inputFilterMaxAngularVelocity) {
        this.inputFilterMaxAngularVelocity = inputFilterMaxAngularVelocity;
    }

    public void setUseStreamingPublisher(boolean useStreamingPublisher) {
        this.useStreamingPublisher = useStreamingPublisher;
    }

    public void setPublishingPeriod(double publishingPeriod) {
        this.publishingPeriod = publishingPeriod;
    }

    public void setInputStateEstimatorType(InputStateEstimatorType inputStateEstimatorType) {
        this.inputStateEstimatorType = inputStateEstimatorType;
    }

    public void setJointCustomPositionUpperLimits(Map<String, Double> jointCustomPositionUpperLimits) {
        this.jointCustomPositionUpperLimits = jointCustomPositionUpperLimits;
    }

    public void setJointCustomPositionLowerLimits(Map<String, Double> jointCustomPositionLowerLimits) {
        this.jointCustomPositionLowerLimits = jointCustomPositionLowerLimits;
    }

    public void setInitialConfigurationMap(Map<String, Double> initialConfigurationMap) {
        this.initialConfigurationMap = initialConfigurationMap;
    }

    public void setSolverNullspaceAlpha(double solverNullspaceAlpha) {
        this.solverNullspaceAlpha = solverNullspaceAlpha;
    }

    public void setSolverPrivilegedDefaultWeight(double solverPrivilegedDefaultWeight) {
        this.solverPrivilegedDefaultWeight = solverPrivilegedDefaultWeight;
    }

    public void setSolverPrivilegedDefaultGain(double solverPrivilegedDefaultGain) {
        this.solverPrivilegedDefaultGain = solverPrivilegedDefaultGain;
    }

    public Map<String, Double> createInitialConfiguration(DRCRobotModel robotModel) {
        HashMap<String, Double> initialConfiguration = new HashMap<String, Double>();
        RobotInitialSetup<HumanoidFloatingRootJointRobot> defaultRobotInitialSetup = robotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        FullHumanoidRobotModel robot = robotModel.createFullRobotModel();
        HumanoidJointNameMap jointMap = robotModel.getJointMap();
        defaultRobotInitialSetup.initializeFullRobotModel(robot);
        for (OneDoFJointBasics joint : robot.getOneDoFJoints()) {
            initialConfiguration.put(joint.getName(), joint.getQ());
        }
        return this.initialConfigurationMap;
    }

    public void restrictZeroCrossover(DRCRobotModel robotModel, String jointName) {
        boolean adjustLowerLimit;
        double positionUpperLimit;
        OneDoFJointDefinition joint = robotModel.getRobotDefinition().getOneDoFJointDefinition(jointName);
        if (joint == null) {
            return;
        }
        double positionLowerLimit = joint.getPositionLowerLimit();
        if (positionLowerLimit * (positionUpperLimit = joint.getPositionUpperLimit()) > 0.0) {
            return;
        }
        double tolerance = 0.1;
        boolean bl = adjustLowerLimit = Math.abs(positionLowerLimit) < Math.abs(positionUpperLimit);
        if (adjustLowerLimit) {
            if (this.jointCustomPositionLowerLimits == null) {
                this.jointCustomPositionLowerLimits = new HashMap<String, Double>();
            }
            this.jointCustomPositionLowerLimits.put(jointName, tolerance);
        } else {
            if (this.jointCustomPositionUpperLimits == null) {
                this.jointCustomPositionUpperLimits = new HashMap<String, Double>();
            }
            this.jointCustomPositionUpperLimits.put(jointName, -tolerance);
        }
    }

    public void setJointLimit(String jointName, boolean isUpperLimit, double value) {
        if (isUpperLimit) {
            if (this.jointCustomPositionUpperLimits == null) {
                this.jointCustomPositionUpperLimits = new HashMap<String, Double>();
            }
            this.jointCustomPositionUpperLimits.put(jointName, value);
        } else {
            if (this.jointCustomPositionLowerLimits == null) {
                this.jointCustomPositionLowerLimits = new HashMap<String, Double>();
            }
            this.jointCustomPositionLowerLimits.put(jointName, value);
        }
    }

    public List<String> getInactiveJoints() {
        return this.inactiveJoints;
    }

    public static enum ClockType {
        CPU_CLOCK,
        FIXED_DT;

    }

    public static enum InputStateEstimatorType {
        FIRST_ORDER_LPF,
        FBC_STYLE;

    }
}

