/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxContactConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInitialConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.ControllerAPI;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxContactConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInitialConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KinematicsStreamingToolboxModule
extends ToolboxModule {
    protected final KinematicsStreamingToolboxController controller;
    private ROS2Publisher<WholeBodyTrajectoryMessage> trajectoryMessagePublisher;
    private ROS2Publisher<WholeBodyStreamingMessage> streamingMessagePublisher;
    KinematicsToolboxController.RobotConfigurationDataBasedUpdater robotStateUpdater = new KinematicsToolboxController.RobotConfigurationDataBasedUpdater();

    public KinematicsStreamingToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer) {
        this(robotModel, KinematicsStreamingToolboxParameters.defaultParameters(), startYoVariableServer);
    }

    public KinematicsStreamingToolboxModule(DRCRobotModel robotModel, KinematicsStreamingToolboxParameters parameters, boolean startYoVariableServer) {
        this(robotModel, parameters, startYoVariableServer, null);
    }

    public KinematicsStreamingToolboxModule(DRCRobotModel robotModel, KinematicsStreamingToolboxParameters parameters, boolean startYoVariableServer, YoRegistry childRegistry) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, (int)(parameters.getToolboxUpdatePeriod() * 1000.0));
        this.setTimeWithoutInputsBeforeGoingToSleep(parameters.getTimeThresholdForSleeping());
        this.controller = new KinematicsStreamingToolboxController(this.commandInputManager, this.statusOutputManager, parameters, this.fullRobotModel, robotModel, this.yoGraphicsListRegistry, this.registry);
        this.controller.setRobotStateUpdater(this.robotStateUpdater);
        this.controller.setCollisionModel(robotModel.getHumanoidRobotKinematicsCollisionModel());
        List<String> inactiveJoints = parameters.getInactiveJoints();
        for (int i = 0; i < inactiveJoints.size(); ++i) {
            this.controller.getActiveOptimizationSettings().deactivateJoint(this.controller.getDesiredFullRobotModel().getOneDoFJointByName(inactiveJoints.get(i)));
        }
        Map<String, Double> initialConfiguration = KinematicsStreamingToolboxModule.fromStandPrep(robotModel);
        if (initialConfiguration != null) {
            this.controller.setInitialRobotConfigurationNamedMap(initialConfiguration);
        }
        this.controller.setTrajectoryMessagePublisher(arg_0 -> this.trajectoryMessagePublisher.publish(arg_0));
        this.controller.setStreamingMessagePublisher(arg_0 -> this.streamingMessagePublisher.publish(arg_0));
        if (childRegistry != null) {
            this.registry.addChild(childRegistry);
        }
        this.startYoVariableServer();
        if (this.yoVariableServer != null) {
            JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator((RobotVisualizer)this.yoVariableServer);
            jvmStatisticsGenerator.start();
        }
        this.controller.setCenterOfMassOffset((Vector2DReadOnly)parameters.getCenterOfMassOffset());
    }

    private static Map<String, Double> fromStandPrep(DRCRobotModel robotModel) {
        WholeBodySetpointParameters standPrepParameters = robotModel.getHighLevelControllerParameters().getStandPrepParameters();
        if (standPrepParameters == null) {
            return null;
        }
        HashMap<String, Double> initialConfigurationMap = new HashMap<String, Double>();
        FullHumanoidRobotModel fullRobotModel = robotModel.createFullRobotModel();
        for (OneDoFJointBasics joint : fullRobotModel.getOneDoFJoints()) {
            String jointName = joint.getName();
            initialConfigurationMap.put(jointName, standPrepParameters.getSetpoint(jointName));
        }
        return initialConfigurationMap;
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        this.trajectoryMessagePublisher = ros2Node.createPublisher(HumanoidControllerAPI.getTopic(WholeBodyTrajectoryMessage.class, (String)this.robotName));
        this.streamingMessagePublisher = ros2Node.createPublisher(HumanoidControllerAPI.getTopic(WholeBodyStreamingMessage.class, (String)this.robotName));
        RobotConfigurationData robotConfigurationData = new RobotConfigurationData();
        ros2Node.createSubscription(StateEstimatorAPI.getRobotConfigurationDataTopic((String)this.robotName), s -> {
            s.takeNextData((Object)robotConfigurationData, null);
            if (this.robotStateUpdater != null) {
                this.robotStateUpdater.setRobotConfigurationData(robotConfigurationData);
            }
        });
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        ros2Node.createSubscription(HumanoidControllerAPI.getTopic(CapturabilityBasedStatus.class, (String)this.robotName), s -> {
            if (this.controller != null) {
                s.takeNextData((Object)capturabilityBasedStatus, null);
                this.controller.updateCapturabilityBasedStatus(capturabilityBasedStatus);
            }
        });
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return KinematicsStreamingToolboxModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(KinematicsStreamingToolboxInputCommand.class);
        commands.add(KinematicsStreamingToolboxConfigurationCommand.class);
        commands.add(KinematicsToolboxConfigurationCommand.class);
        commands.add(KinematicsToolboxPrivilegedConfigurationCommand.class);
        commands.add(KinematicsStreamingToolboxInitialConfigurationCommand.class);
        commands.add(KinematicsStreamingToolboxContactConfigurationCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return KinematicsStreamingToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(KinematicsToolboxOutputStatus.class);
        status.add(ControllerCrashNotificationPacket.class);
        return status;
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return KinematicsStreamingToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ToolboxAPIs.KINEMATICS_STREAMING_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return KinematicsStreamingToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ToolboxAPIs.KINEMATICS_STREAMING_TOOLBOX.withRobot(robotName).withInput();
    }

    public static ROS2Topic<ToolboxStateMessage> getInputStateTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getInputTopic(robotName).withTypeName(ToolboxStateMessage.class);
    }

    public static ROS2Topic<KinematicsStreamingToolboxInputMessage> getInputCommandTopic(String robotName) {
        return KinematicsStreamingToolboxModule.getInputTopic(robotName).withTypeName(KinematicsStreamingToolboxInputMessage.class);
    }

    public static ROS2Topic<KinematicsStreamingToolboxConfigurationMessage> getInputStreamingConfigurationTopic(String robotName) {
        return ControllerAPI.getTopic(KinematicsStreamingToolboxModule.getInputTopic(robotName), KinematicsStreamingToolboxConfigurationMessage.class);
    }

    public static ROS2Topic<KinematicsToolboxConfigurationMessage> getInputToolboxConfigurationTopic(String robotName) {
        return ControllerAPI.getTopic(KinematicsStreamingToolboxModule.getInputTopic(robotName), KinematicsToolboxConfigurationMessage.class);
    }

    public static ROS2Topic<KinematicsStreamingToolboxInitialConfigurationMessage> getInputStreamingInitialConfigurationTopic(String robotName) {
        return ControllerAPI.getTopic(KinematicsStreamingToolboxModule.getInputTopic(robotName), KinematicsStreamingToolboxInitialConfigurationMessage.class);
    }

    public static ROS2Topic<KinematicsStreamingToolboxContactConfigurationMessage> getInputStreamingContactConfigurationTopic(String robotName) {
        return ControllerAPI.getTopic(KinematicsStreamingToolboxModule.getInputTopic(robotName), KinematicsStreamingToolboxContactConfigurationMessage.class);
    }

    public static ROS2Topic<KinematicsToolboxOutputStatus> getOutputStatusTopic(String robotName) {
        return ControllerAPI.getTopic(KinematicsStreamingToolboxModule.getOutputTopic(robotName), KinematicsToolboxOutputStatus.class);
    }

    public static ROS2Topic<ControllerCrashNotificationPacket> getOutputCrashNotificationTopic(String robotName) {
        return ControllerAPI.getTopic(KinematicsStreamingToolboxModule.getOutputTopic(robotName), ControllerCrashNotificationPacket.class);
    }
}

