/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.CapturabilityBasedStatusPubSubType;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotConfigurationDataPubSubType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.mutable.MutableInt;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessage;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessagePubSubType;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessagePubSubType;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxMessageLogger;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxModule;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class KinematicsStreamingToolboxMessageReplay {
    private final List<KinematicsStreamingToolboxMessageSet> messages;
    private final JSONSerializer<RobotConfigurationData> robotConfigurationDataSerializer = new JSONSerializer((TopicDataType)new RobotConfigurationDataPubSubType());
    private final JSONSerializer<CapturabilityBasedStatus> capturabilityBasedStatusSerializer = new JSONSerializer((TopicDataType)new CapturabilityBasedStatusPubSubType());
    private final JSONSerializer<KinematicsToolboxConfigurationMessage> kinematicsToolboxConfigurationMessageSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxConfigurationMessagePubSubType());
    private final JSONSerializer<KinematicsStreamingToolboxInputMessage> kinematicsStreamingToolboxInputMessageSerializer = new JSONSerializer((TopicDataType)new KinematicsStreamingToolboxInputMessagePubSubType());
    private final ROS2Publisher<RobotConfigurationData> robotConfigurationDataPublisher;
    private final ROS2Publisher<CapturabilityBasedStatus> capturabilityBasedStatusPublisher;
    private final ROS2Publisher<KinematicsToolboxConfigurationMessage> kinematicsToolboxConfigurationPublisher;
    private final ROS2Publisher<KinematicsStreamingToolboxInputMessage> kinematicsStreamingToolboxInputPublisher;
    private final ROS2Publisher<ToolboxStateMessage> toolboxStatePublisher;
    private final MutableInt counter = new MutableInt();
    private double timeOffsetSeconds;
    private final RealtimeROS2Node ros2Node;

    public KinematicsStreamingToolboxMessageReplay(String robotName, InputStream inputStream) throws IOException {
        this.messages = this.loadMessages(inputStream);
        String name = this.getClass().getSimpleName();
        this.ros2Node = new ROS2NodeBuilder().buildRealtime("ihmc_" + name);
        ROS2Topic controllerOutputTopic = HumanoidControllerAPI.getOutputTopic((String)robotName);
        this.robotConfigurationDataPublisher = this.ros2Node.createPublisher(controllerOutputTopic.withTypeName(RobotConfigurationData.class));
        this.capturabilityBasedStatusPublisher = this.ros2Node.createPublisher(controllerOutputTopic.withTypeName(CapturabilityBasedStatus.class));
        ROS2Topic<?> toolboxInputTopic = KinematicsStreamingToolboxModule.getInputTopic(robotName);
        this.kinematicsToolboxConfigurationPublisher = this.ros2Node.createPublisher(toolboxInputTopic.withTypeName(KinematicsToolboxConfigurationMessage.class));
        this.kinematicsStreamingToolboxInputPublisher = this.ros2Node.createPublisher(toolboxInputTopic.withTypeName(KinematicsStreamingToolboxInputMessage.class));
        this.toolboxStatePublisher = this.ros2Node.createPublisher(toolboxInputTopic.withTypeName(ToolboxStateMessage.class));
        this.ros2Node.spin();
    }

    public void replayAllMessages() {
        this.sendToolboxStateMessage(ToolboxState.WAKE_UP);
        ThreadTools.sleep((long)1L);
        for (int i = 0; i < this.messages.size(); ++i) {
            this.sendMessagesAtIndex(i);
            if (i == this.messages.size() - 1) continue;
            int timeDifferenceMillis = (int)(1.0E-6 * (double)(this.messages.get((int)(i + 1)).timestamp - this.messages.get((int)i).timestamp));
            ThreadTools.sleep((long)timeDifferenceMillis);
        }
        this.sendToolboxStateMessage(ToolboxState.SLEEP);
    }

    public void initialize(double timeSeconds) {
        this.counter.setValue(0);
        this.timeOffsetSeconds = timeSeconds - Conversions.nanosecondsToSeconds((long)this.messages.get((int)0).timestamp);
    }

    public boolean update(double timeSeconds) {
        if (this.counter.getValue() >= this.messages.size()) {
            return false;
        }
        double nextMessageTime = Conversions.nanosecondsToSeconds((long)this.messages.get((int)this.counter.getValue().intValue()).timestamp) + this.timeOffsetSeconds;
        if (nextMessageTime < timeSeconds) {
            this.sendMessagesAtIndex(this.counter.getValue());
            this.counter.increment();
        }
        return this.counter.getValue() < this.messages.size();
    }

    public void close() {
        this.ros2Node.destroy();
    }

    private void sendMessagesAtIndex(int i) {
        KinematicsStreamingToolboxMessageSet messageSet = this.messages.get(i);
        if (messageSet.kinematicsToolboxConfigurationMessage != null) {
            this.kinematicsToolboxConfigurationPublisher.publish((Object)messageSet.kinematicsToolboxConfigurationMessage);
        }
        if (messageSet.kinematicsStreamingToolboxInputMessage != null) {
            this.kinematicsStreamingToolboxInputPublisher.publish((Object)messageSet.kinematicsStreamingToolboxInputMessage);
        }
    }

    private void sendToolboxStateMessage(ToolboxState toolboxState) {
        ToolboxStateMessage toolboxStateMessage = new ToolboxStateMessage();
        toolboxStateMessage.setRequestedToolboxState(toolboxState.toByte());
        this.toolboxStatePublisher.publish((Object)toolboxStateMessage);
    }

    private List<KinematicsStreamingToolboxMessageSet> loadMessages(InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(inputStream);
        int size = jsonNode.size();
        ArrayList<KinematicsStreamingToolboxMessageSet> allMessages = new ArrayList<KinematicsStreamingToolboxMessageSet>();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = jsonNode.get(i);
            KinematicsStreamingToolboxMessageSet messageSet = new KinematicsStreamingToolboxMessageSet(childNode.get("Timestamp").asLong());
            if (childNode.has(KinematicsStreamingToolboxMessageLogger.robotConfigurationDataName)) {
                messageSet.robotConfigurationData = (RobotConfigurationData)this.robotConfigurationDataSerializer.deserialize(childNode.get(KinematicsStreamingToolboxMessageLogger.robotConfigurationDataName).toString());
            }
            if (childNode.has(KinematicsStreamingToolboxMessageLogger.capturabilityBasedStatusName)) {
                messageSet.capturabilityBasedStatus = (CapturabilityBasedStatus)this.capturabilityBasedStatusSerializer.deserialize(childNode.get(KinematicsStreamingToolboxMessageLogger.capturabilityBasedStatusName).toString());
            }
            if (childNode.has(KinematicsStreamingToolboxMessageLogger.kinematicsToolboxConfigurationMessageName)) {
                messageSet.kinematicsToolboxConfigurationMessage = (KinematicsToolboxConfigurationMessage)this.kinematicsToolboxConfigurationMessageSerializer.deserialize(childNode.get(KinematicsStreamingToolboxMessageLogger.kinematicsToolboxConfigurationMessageName).toString());
            }
            if (childNode.has(KinematicsStreamingToolboxMessageLogger.kinematicsStreamingToolboxInputMessageName)) {
                messageSet.kinematicsStreamingToolboxInputMessage = (KinematicsStreamingToolboxInputMessage)this.kinematicsStreamingToolboxInputMessageSerializer.deserialize(childNode.get(KinematicsStreamingToolboxMessageLogger.kinematicsStreamingToolboxInputMessageName).toString());
            }
            allMessages.add(messageSet);
        }
        return allMessages;
    }

    public RobotConfigurationData getInitialConfiguration() {
        for (int i = 0; i < this.messages.size(); ++i) {
            if (this.messages.get((int)i).robotConfigurationData == null) continue;
            return this.messages.get((int)i).robotConfigurationData;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        String robotName = "Valkyrie";
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("JSON log", "*.json"));
        int chooserState = fileChooser.showOpenDialog(null);
        if (chooserState == 0) {
            FileInputStream inputStream = new FileInputStream(fileChooser.getSelectedFile());
            new KinematicsStreamingToolboxMessageReplay(robotName, inputStream).replayAllMessages();
        }
    }

    private class KinematicsStreamingToolboxMessageSet {
        private final long timestamp;
        private RobotConfigurationData robotConfigurationData = null;
        private CapturabilityBasedStatus capturabilityBasedStatus = null;
        private KinematicsToolboxConfigurationMessage kinematicsToolboxConfigurationMessage = null;
        private KinematicsStreamingToolboxInputMessage kinematicsStreamingToolboxInputMessage = null;

        KinematicsStreamingToolboxMessageSet(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

