/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.List;
import java.util.Map;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTSleepState;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTStreamingState;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class KinematicsStreamingToolboxController
extends ToolboxController {
    private final KSTTools tools;
    private final ExecutionTimer executionTimer;
    private KSTTimeProvider timeProvider;
    private final YoDouble time;
    private final StateMachine<KSTState, State> stateMachine;
    private final KSTSleepState sleepState;
    private final KSTStreamingState streamingState;
    private final YoBoolean isDone;
    private final Class[] commandTypesToForward;

    public KinematicsStreamingToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, KinematicsStreamingToolboxParameters parameters, FullHumanoidRobotModel desiredFullRobotModel, DRCRobotModel robotModel, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.executionTimer = new ExecutionTimer("IKStreamingTimer", this.registry);
        this.time = new YoDouble("time", this.registry);
        this.isDone = new YoBoolean("isDone", this.registry);
        if (parameters.getClockType() == KinematicsStreamingToolboxParameters.ClockType.CPU_CLOCK) {
            this.timeProvider = KSTTimeProvider.createCPUClockBased();
        } else if (parameters.getClockType() == KinematicsStreamingToolboxParameters.ClockType.FIXED_DT) {
            this.timeProvider = KSTTimeProvider.createFixedDT(parameters.getToolboxUpdatePeriod());
        } else {
            throw new RuntimeException("Unknown clock type: " + String.valueOf((Object)parameters.getClockType()));
        }
        this.tools = new KSTTools(commandInputManager, statusOutputManager, parameters, desiredFullRobotModel, robotModel, (DoubleProvider)this.time, yoGraphicsListRegistry, this.registry);
        this.sleepState = new KSTSleepState(this.tools);
        this.streamingState = new KSTStreamingState(this.tools);
        this.stateMachine = this.createStateMachine((DoubleProvider)this.time);
        this.isDone.set(false);
        if (parameters.getInitialConfigurationMap() != null) {
            this.setInitialRobotConfigurationNamedMap(parameters.getInitialConfigurationMap());
        }
        List<Class<? extends Command<?, ?>>> ikSolverCommands = KinematicsToolboxModule.supportedCommands();
        this.commandTypesToForward = (Class[])commandInputManager.getListOfSupportedCommands().stream().filter(ikSolverCommands::contains).toArray(Class[]::new);
    }

    public void setTimeProvider(KSTTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public void setInitialRobotConfiguration(DRCRobotModel robotModel) {
        this.tools.getIKController().setInitialRobotConfiguration(robotModel);
    }

    public void setInitialRobotConfigurationNamedMap(Map<String, Double> initialConfiguration) {
        this.tools.getIKController().setInitialRobotConfigurationNamedMap(initialConfiguration);
    }

    public void setCollisionModel(RobotCollisionModel collisionModel) {
        this.tools.getIKController().setCollisionModel(collisionModel);
    }

    private StateMachine<KSTState, State> createStateMachine(DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(KSTState.class);
        factory.setNamePrefix("mainStateMachine").setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addState((Enum)KSTState.SLEEP, (State)this.sleepState);
        factory.addState((Enum)KSTState.STREAMING, (State)this.streamingState);
        factory.addDoneTransition((Enum)KSTState.SLEEP, (Enum)KSTState.STREAMING);
        return factory.build((Enum)KSTState.SLEEP);
    }

    public void setTrajectoryMessagePublisher(WholeBodyTrajectoryMessagePublisher outputPublisher) {
        this.tools.setTrajectoryMessagerPublisher(outputPublisher);
    }

    public void setStreamingMessagePublisher(WholeBodyStreamingMessagePublisher outputPublisher) {
        this.tools.setStreamingMessagePublisher(outputPublisher);
    }

    public void setCenterOfMassOffset(Vector2DReadOnly offset) {
        this.tools.setCenterOfMassOffset(offset);
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        this.timeProvider.initialize();
        this.time.set(this.timeProvider.getTime());
        return true;
    }

    @Override
    public void updateInternal() {
        try {
            this.executionTimer.startMeasurement();
            this.timeProvider.update();
            this.time.set(this.timeProvider.getTime());
            this.forwardCommandsToIKSolver();
            this.tools.update();
            this.stateMachine.doActionAndTransition();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                this.reportMessage(MessageTools.createControllerCrashNotificationPacket(null, (Throwable)e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.isDone.set(true);
        }
        finally {
            this.executionTimer.stopMeasurement();
        }
    }

    private void forwardCommandsToIKSolver() {
        for (Class commandType : this.commandTypesToForward) {
            if (!this.tools.getCommandInputManager().isNewCommandAvailable(commandType)) continue;
            this.tools.getIKCommandInputManager().submitCommands(this.tools.getCommandInputManager().pollNewCommands(commandType));
        }
    }

    @Override
    public void notifyToolboxStateChange(ToolboxState newState) {
        if (newState == ToolboxState.SLEEP) {
            this.stateMachine.performTransition((Enum)KSTState.SLEEP);
        }
    }

    @Override
    public boolean isDone() {
        return this.isDone.getValue();
    }

    KSTState getCurrentStateKey() {
        return (KSTState)this.stateMachine.getCurrentStateKey();
    }

    public void setRobotStateUpdater(KinematicsToolboxController.IKRobotStateUpdater robotStateUpdater) {
        this.tools.setRobotStateUpdater(robotStateUpdater);
    }

    public InverseKinematicsOptimizationSettingsCommand getActiveOptimizationSettings() {
        return this.tools.getIKController().getActiveOptimizationSettings();
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        this.tools.updateCapturabilityBasedStatus(newStatus);
    }

    public double getTime() {
        return this.time.getDoubleValue();
    }

    public KSTTools getTools() {
        return this.tools;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.tools.getDesiredFullRobotModel();
    }

    public static interface KSTTimeProvider {
        public void initialize();

        public void update();

        public double getTime();

        public static KSTTimeProvider createCPUClockBased() {
            return new KSTTimeProvider(){
                private long initialTimestamp = -1L;
                private double time = 0.0;

                @Override
                public void initialize() {
                    this.initialTimestamp = System.nanoTime();
                    this.time = 0.0;
                }

                @Override
                public void update() {
                    this.time = Conversions.nanosecondsToSeconds((long)(System.nanoTime() - this.initialTimestamp));
                }

                @Override
                public double getTime() {
                    return this.time;
                }
            };
        }

        public static KSTTimeProvider createFixedDT(final double dt) {
            return new KSTTimeProvider(){
                private double time = 0.0;

                @Override
                public void initialize() {
                    this.time = 0.0;
                }

                @Override
                public void update() {
                    this.time += dt;
                }

                @Override
                public double getTime() {
                    return this.time;
                }
            };
        }
    }

    public static enum KSTState {
        SLEEP,
        STREAMING;

        private static final KSTState[] values;

        public byte toByte() {
            return (byte)this.ordinal();
        }

        public static KSTState fromByte(byte enumAsByte) {
            if (enumAsByte == -1) {
                return null;
            }
            return values[enumAsByte];
        }

        static {
            values = KSTState.values();
        }
    }

    public static interface WholeBodyTrajectoryMessagePublisher {
        public void publish(WholeBodyTrajectoryMessage var1);
    }

    public static interface WholeBodyStreamingMessagePublisher {
        public void publish(WholeBodyStreamingMessage var1);
    }
}

