/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolbox_msgs.msg.dds.KinematicsToolboxOneDoFJointMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTStreamingMessageFactory;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input.KSTInputFilter;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataBasics;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.Notification;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxContactConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInitialConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxOutputConverter;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class KSTTools {
    private final CommandInputManager commandInputManager;
    private final CommandInputManager ikCommandInputManager;
    private final StatusMessageOutputManager statusOutputManager;
    private final KinematicsStreamingToolboxParameters parameters;
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final DRCRobotModel robotModel;
    private final DoubleProvider time;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final YoRegistry registry;
    private final FullHumanoidRobotModel currentFullRobotModel;
    private final FloatingJointBasics currentRootJoint;
    private final OneDoFJointBasics[] currentOneDoFJoint;
    private final HumanoidKinematicsToolboxController ikController;
    private final KSTStreamingMessageFactory streamingMessageFactory;
    private final KinematicsToolboxOutputConverter trajectoryMessageFactory;
    private final WholeBodyTrajectoryMessage wholeBodyTrajectoryMessage = new WholeBodyTrajectoryMessage();
    private final YoDouble streamIntegrationDuration;
    private KinematicsToolboxController.IKRobotStateUpdater robotStateUpdater;
    private final double toolboxControllerPeriod;
    private final YoDouble walkingControllerMonotonicTime;
    private final YoDouble walkingControllerWallTime;
    private final YoLong currentMessageId;
    private final YoBoolean hasNewInputCommand;
    private final YoBoolean hasPreviousInput;
    private final YoDouble latestInputReceivedTime;
    private final YoDouble previousInputReceivedTime;
    private KinematicsStreamingToolboxInputCommand latestInput = null;
    private KinematicsStreamingToolboxInputCommand previousInput = null;
    private final KinematicsStreamingToolboxConfigurationCommand configurationCommand = new KinematicsStreamingToolboxConfigurationCommand();
    private final KinematicsStreamingToolboxInitialConfigurationCommand initCommand = new KinematicsStreamingToolboxInitialConfigurationCommand();
    private final KinematicsStreamingToolboxContactConfigurationCommand contactCommand = new KinematicsStreamingToolboxContactConfigurationCommand();
    private final YoBoolean isNeckJointspaceOutputEnabled;
    private final YoBoolean isChestTaskspaceOutputEnabled;
    private final YoBoolean isPelvisTaskspaceOutputEnabled;
    private final YoBoolean isSpineJointspaceOutputEnabled;
    private final YoBoolean isCenterOfMassOutputEnabled;
    private final SideDependentList<YoBoolean> areHandTaskspaceOutputsEnabled = new SideDependentList();
    private final SideDependentList<YoBoolean> areArmJointspaceOutputsEnabled = new SideDependentList();
    private final SideDependentList<YoBoolean> areLegJointspaceOutputsEnabled = new SideDependentList();
    private final YoBoolean invalidUserInput;
    private final YoLong latestInputTimestampSource;
    private final YoDouble latestInputTimeSource;
    private final YoBoolean useStreamingPublisher;
    private final KSTInputFilter inputFilter;
    private final SideDependentList<Boolean> isFootInSupport = new SideDependentList();
    private final SideDependentList<Notification> startFootControl = new SideDependentList((Object)new Notification(), (Object)new Notification());
    private KinematicsStreamingToolboxController.WholeBodyTrajectoryMessagePublisher trajectoryMessagePublisher = m -> {};
    private KinematicsStreamingToolboxController.WholeBodyStreamingMessagePublisher streamingMessagePublisher = null;

    public KSTTools(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, KinematicsStreamingToolboxParameters parameters, FullHumanoidRobotModel desiredFullRobotModel, DRCRobotModel robotModel, DoubleProvider time, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        OneDoFJointBasics joint;
        this.commandInputManager = commandInputManager;
        this.statusOutputManager = statusOutputManager;
        this.parameters = parameters;
        this.desiredFullRobotModel = desiredFullRobotModel;
        this.robotModel = robotModel;
        this.toolboxControllerPeriod = parameters.getToolboxUpdatePeriod();
        this.time = time;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.registry = registry;
        this.walkingControllerMonotonicTime = new YoDouble("walkingControllerMonotonicTime", registry);
        this.walkingControllerWallTime = new YoDouble("walkingControllerWallTime", registry);
        this.currentFullRobotModel = robotModel.createFullRobotModel();
        this.currentRootJoint = this.currentFullRobotModel.getRootJoint();
        this.currentOneDoFJoint = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.currentFullRobotModel);
        if (parameters.getJointCustomPositionLowerLimits() != null) {
            for (Map.Entry<String, Double> entry : parameters.getJointCustomPositionLowerLimits().entrySet()) {
                joint = desiredFullRobotModel.getOneDoFJointByName(entry.getKey());
                if (joint == null) {
                    LogTools.warn((String)"Couldn't find joint {}", (Object)entry.getKey());
                    continue;
                }
                joint.setJointLimitLower(entry.getValue().doubleValue());
            }
        }
        if (parameters.getJointCustomPositionUpperLimits() != null) {
            for (Map.Entry<String, Double> entry : parameters.getJointCustomPositionUpperLimits().entrySet()) {
                joint = desiredFullRobotModel.getOneDoFJointByName(entry.getKey());
                if (joint == null) {
                    LogTools.warn((String)"Couldn't find joint {}", (Object)entry.getKey());
                    continue;
                }
                joint.setJointLimitUpper(entry.getValue().doubleValue());
            }
        }
        this.ikCommandInputManager = new CommandInputManager(HumanoidKinematicsToolboxController.class.getSimpleName(), KinematicsToolboxModule.supportedCommands(), 32);
        this.ikController = new HumanoidKinematicsToolboxController(this.ikCommandInputManager, statusOutputManager, desiredFullRobotModel, this.toolboxControllerPeriod, yoGraphicsListRegistry, registry);
        KinematicsStreamingToolboxCommandConverter commandConversionHelper = new KinematicsStreamingToolboxCommandConverter(desiredFullRobotModel, (ReferenceFrames)this.ikController.getDesiredReferenceFrames());
        commandInputManager.registerConversionHelper((CommandConversionInterface)commandConversionHelper);
        commandConversionHelper.process(this.configurationCommand, parameters.getDefaultConfiguration());
        this.ikCommandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(desiredFullRobotModel, (ReferenceFrames)this.ikController.getDesiredReferenceFrames()));
        this.ikController.setPreserveUserCommandHistory(false);
        this.inputFilter = new KSTInputFilter(this.currentFullRobotModel, parameters, registry);
        this.currentMessageId = new YoLong("currentMessageId", registry);
        this.currentMessageId.set(1L);
        this.streamingMessageFactory = new KSTStreamingMessageFactory((FullHumanoidRobotModelFactory)robotModel, registry);
        this.streamingMessageFactory.setEnableVelocity(true);
        this.streamingMessageFactory.setEnableAcceleration(true);
        this.trajectoryMessageFactory = new KinematicsToolboxOutputConverter((FullHumanoidRobotModelFactory)robotModel);
        this.streamIntegrationDuration = new YoDouble("streamIntegrationDuration", registry);
        this.streamIntegrationDuration.set(parameters.getStreamIntegrationDuration());
        this.hasNewInputCommand = new YoBoolean("hasNewInputCommand", registry);
        this.hasPreviousInput = new YoBoolean("hasPreviousInput", registry);
        this.latestInputReceivedTime = new YoDouble("latestInputReceivedTime", registry);
        this.previousInputReceivedTime = new YoDouble("previousInputReceivedTime", registry);
        this.flushInputCommands();
        this.isSpineJointspaceOutputEnabled = new YoBoolean("isSpineJointspaceOutputEnabled", registry);
        this.isNeckJointspaceOutputEnabled = new YoBoolean("isNeckJointspaceOutputEnabled", registry);
        this.isChestTaskspaceOutputEnabled = new YoBoolean("isChestTaskspaceOutputEnabled", registry);
        this.isPelvisTaskspaceOutputEnabled = new YoBoolean("isPelvisTaskspaceOutputEnabled", registry);
        this.isCenterOfMassOutputEnabled = new YoBoolean("isCenterOfMassOutputEnabled", registry);
        for (RobotSide robotSide : RobotSide.values) {
            YoBoolean isHandTaskspaceOutputEnabled = new YoBoolean("is" + robotSide.getPascalCaseName() + "HandTaskspaceOutputEnabled", registry);
            this.areHandTaskspaceOutputsEnabled.put((Enum)robotSide, (Object)isHandTaskspaceOutputEnabled);
            YoBoolean isArmJointspaceOutputEnabled = new YoBoolean("is" + robotSide.getPascalCaseName() + "ArmJointspaceOutputEnabled", registry);
            this.areArmJointspaceOutputsEnabled.put((Enum)robotSide, (Object)isArmJointspaceOutputEnabled);
            YoBoolean isLegJointspaceOutputEnabled = new YoBoolean("is" + robotSide.getPascalCaseName() + "LegJointspaceOutputEnabled", registry);
            this.areLegJointspaceOutputsEnabled.put((Enum)robotSide, (Object)isLegJointspaceOutputEnabled);
            this.isFootInSupport.put((Enum)robotSide, (Object)true);
        }
        this.invalidUserInput = new YoBoolean("invalidUserInput", registry);
        this.latestInputTimestampSource = new YoLong("latestInputTimestampSource", registry);
        this.latestInputTimeSource = new YoDouble("latestInputTimeSource", registry);
        this.useStreamingPublisher = new YoBoolean("useStreamingPublisher", registry);
        this.useStreamingPublisher.set(parameters.getUseStreamingPublisher());
    }

    public void update() {
        boolean wasRobotUpdated;
        this.inputFilter.update();
        if (this.commandInputManager.isNewCommandAvailable(KinematicsStreamingToolboxConfigurationCommand.class)) {
            this.configurationCommand.set((KinematicsStreamingToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsStreamingToolboxConfigurationCommand.class));
        }
        this.isSpineJointspaceOutputEnabled.set(this.configurationCommand.isSpineJointspaceEnabled());
        this.isNeckJointspaceOutputEnabled.set(this.configurationCommand.isNeckJointspaceEnabled());
        this.isChestTaskspaceOutputEnabled.set(this.configurationCommand.isChestTaskspaceEnabled());
        this.isPelvisTaskspaceOutputEnabled.set(this.configurationCommand.isPelvisTaskspaceEnabled());
        this.isCenterOfMassOutputEnabled.set(this.configurationCommand.isCenterOfMassTrajectoryEnabled());
        for (RobotSide robotSide : RobotSide.values) {
            ((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).set(this.configurationCommand.isHandTaskspaceEnabled(robotSide));
            ((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).set(this.configurationCommand.isArmJointspaceEnabled(robotSide));
            ((YoBoolean)this.areLegJointspaceOutputsEnabled.get((Enum)robotSide)).set(this.configurationCommand.isLegJointspaceEnabled(robotSide));
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsStreamingToolboxInitialConfigurationCommand.class)) {
            this.initCommand.set((KinematicsStreamingToolboxInitialConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsStreamingToolboxInitialConfigurationCommand.class));
            RobotSide[] initialConfigurationMap = new HashMap();
            List joints = this.initCommand.getJoints();
            TFloatArrayList initialJointAngles = this.initCommand.getInitialJointAngles();
            for (int i = 0; i < joints.size(); ++i) {
                String jointName = ((OneDoFJointBasics)joints.get(i)).getName();
                double q = initialJointAngles.get(i);
                initialConfigurationMap.put(jointName, q);
            }
            this.ikController.setInitialRobotConfigurationNamedMap((Map<String, Double>)initialConfigurationMap);
            this.ikController.initialize();
            this.resetFootContactNotification();
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsStreamingToolboxContactConfigurationCommand.class)) {
            this.contactCommand.set((KinematicsStreamingToolboxContactConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsStreamingToolboxContactConfigurationCommand.class));
            for (RobotSide side : RobotSide.values) {
                boolean isFootInContact = this.contactCommand.getIsFootInContact(side);
                if (isFootInContact && !((Boolean)this.isFootInSupport.get((Enum)side)).booleanValue()) {
                    this.ikController.updateInitialFootPose(side);
                }
                this.isFootInSupport.put((Enum)side, (Object)isFootInContact);
                this.ikController.setIsFootInSupport(side, (Boolean)this.isFootInSupport.get((Enum)side));
                if (((Boolean)this.isFootInSupport.get((Enum)side)).booleanValue()) continue;
                ((Notification)this.startFootControl.get((Enum)side)).set();
            }
            SteppingParameters steppingParameters = this.robotModel.getWalkingControllerParameters().getSteppingParameters();
            this.ikController.updateSupportPolygon(this.isFootInSupport, steppingParameters.getFootLength(), steppingParameters.getFootWidth(), true);
        }
        if (wasRobotUpdated = this.robotStateUpdater.updateRobotConfiguration(this.currentRootJoint, this.currentOneDoFJoint)) {
            KinematicsToolboxController.IKRobotStateUpdater initialJointAngles = this.robotStateUpdater;
            if (initialJointAngles instanceof KinematicsToolboxController.RobotConfigurationDataBasedUpdater) {
                KinematicsToolboxController.RobotConfigurationDataBasedUpdater rcdBasedUpdater = (KinematicsToolboxController.RobotConfigurationDataBasedUpdater)initialJointAngles;
                RobotConfigurationData lastRobotConfigurationData = rcdBasedUpdater.getLastRobotConfigurationData();
                this.walkingControllerMonotonicTime.set(Conversions.nanosecondsToSeconds((long)lastRobotConfigurationData.getMonotonicTime()));
                this.walkingControllerWallTime.set(Conversions.nanosecondsToSeconds((long)lastRobotConfigurationData.getWallTime()));
            }
            this.currentFullRobotModel.updateFrames();
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsStreamingToolboxInputCommand.class)) {
            KinematicsToolboxCenterOfMassCommand previousCenterOfMassInput;
            KinematicsToolboxCenterOfMassCommand latestCenterOfMassInput;
            if (this.latestInput != null) {
                if (this.previousInput == null) {
                    this.previousInput = new KinematicsStreamingToolboxInputCommand();
                }
                this.previousInput.set(this.latestInput);
                this.previousInputReceivedTime.set(this.latestInputReceivedTime.getValue());
                this.hasPreviousInput.set(true);
            }
            if (this.latestInput == null) {
                this.latestInput = new KinematicsStreamingToolboxInputCommand();
            }
            this.latestInput.set((KinematicsStreamingToolboxInputCommand)this.commandInputManager.pollNewestCommand(KinematicsStreamingToolboxInputCommand.class));
            for (int i = this.latestInput.getNumberOfInputs() - 1; i >= 0; --i) {
                KinematicsToolboxRigidBodyCommand previousEndEffectorInput;
                KinematicsToolboxRigidBodyCommand latestEndEffectorInput = this.latestInput.getInput(i);
                RigidBodyBasics endEffector = latestEndEffectorInput.getEndEffector();
                KinematicsToolboxRigidBodyCommand kinematicsToolboxRigidBodyCommand = previousEndEffectorInput = this.hasPreviousInput.getValue() ? this.previousInput.getInputFor(endEffector) : null;
                if (this.inputFilter.isInputValid(latestEndEffectorInput, previousEndEffectorInput)) continue;
                this.invalidUserInput.set(true);
            }
            if (this.latestInput.hasCenterOfMassInput() && !this.inputFilter.isInputValid(latestCenterOfMassInput = this.latestInput.getCenterOfMassInput(), previousCenterOfMassInput = this.hasPreviousInput.getValue() && this.previousInput.hasCenterOfMassInput() ? this.previousInput.getCenterOfMassInput() : null)) {
                this.invalidUserInput.set(true);
            }
            this.latestInputTimestampSource.set(this.latestInput.getTimestamp());
            this.latestInputTimeSource.set((double)this.latestInput.getTimestamp() * 1.0E-9);
            if (this.latestInput.getTimestamp() <= 0L) {
                this.latestInput.setTimestamp(Conversions.secondsToNanoseconds((double)this.time.getValue()));
            }
            this.latestInputReceivedTime.set(this.time.getValue());
            this.hasNewInputCommand.set(true);
        } else {
            this.hasNewInputCommand.set(false);
        }
    }

    public void resetUserInvalidInputFlag() {
        this.invalidUserInput.set(false);
    }

    public void resetFootContactNotification() {
        for (RobotSide side : RobotSide.values) {
            ((Notification)this.startFootControl.get((Enum)side)).clear();
        }
    }

    public boolean hasUserSubmittedInvalidInput() {
        return this.invalidUserInput.getValue();
    }

    public KinematicsStreamingToolboxParameters getParameters() {
        return this.parameters;
    }

    public double getTime() {
        return this.time.getValue();
    }

    public KinematicsStreamingToolboxConfigurationCommand getConfigurationCommand() {
        return this.configurationCommand;
    }

    public void getCurrentState(KSTOutputDataBasics currentStateToPack) {
        currentStateToPack.setFromRobot((FloatingJointReadOnly)this.currentRootJoint, (OneDoFJointReadOnly[])this.currentOneDoFJoint);
    }

    public boolean hasNewInputCommand() {
        return this.hasNewInputCommand.getValue() && !this.hasUserSubmittedInvalidInput();
    }

    public KinematicsStreamingToolboxInputCommand getLatestInput() {
        return this.latestInput;
    }

    public double getLatestInputReceivedTime() {
        return this.latestInputReceivedTime.getValue();
    }

    public boolean hasPreviousInput() {
        return this.hasPreviousInput.getValue();
    }

    public KinematicsStreamingToolboxInputCommand getPreviousInput() {
        return this.hasPreviousInput.getValue() ? this.previousInput : null;
    }

    public double getPreviousInputReceivedTime() {
        return this.previousInputReceivedTime.getValue();
    }

    public void flushInputCommands() {
        this.latestInput = null;
        this.commandInputManager.clearAllCommands();
        this.hasNewInputCommand.set(false);
        this.hasPreviousInput.set(false);
        this.latestInputReceivedTime.set(-1.0);
        this.previousInputReceivedTime.set(-1.0);
    }

    public void setTrajectoryMessagerPublisher(KinematicsStreamingToolboxController.WholeBodyTrajectoryMessagePublisher outputPublisher) {
        this.trajectoryMessagePublisher = outputPublisher;
    }

    public void setStreamingMessagePublisher(KinematicsStreamingToolboxController.WholeBodyStreamingMessagePublisher streamingMessagePublisher) {
        this.streamingMessagePublisher = streamingMessagePublisher;
    }

    public void setCenterOfMassOffset(Vector2DReadOnly offset) {
        this.ikController.setCenterOfMassOffset(offset);
    }

    public void streamToController(KSTOutputDataReadOnly outputToPublish, boolean finalizeTrajectory) {
        if (finalizeTrajectory) {
            this.trajectoryMessagePublisher.publish(this.setupFinalizeTrajectoryMessage(outputToPublish));
        } else if (this.streamingMessagePublisher == null || !this.useStreamingPublisher.getValue()) {
            this.trajectoryMessagePublisher.publish(this.setupTrajectoryMessage(outputToPublish));
        } else {
            this.streamingMessagePublisher.publish(this.setupStreamingMessage(outputToPublish));
        }
    }

    public WholeBodyStreamingMessage setupStreamingMessage(KSTOutputDataReadOnly solutionToConvert) {
        this.streamingMessageFactory.update(this.currentMessageId.getValue(), Conversions.secondsToNanoseconds((double)this.time.getValue()), this.streamIntegrationDuration.getValue(), solutionToConvert::updateRobot);
        for (RobotSide robotSide : RobotSide.values) {
            if (((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.streamingMessageFactory.computeHandStreamingMessage(robotSide, this.configurationCommand.getHandTrajectoryFrameId(robotSide));
            }
            if (((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.streamingMessageFactory.computeArmStreamingMessage(robotSide);
            }
            if (!((YoBoolean)this.areLegJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) continue;
            this.streamingMessageFactory.computeLegStreamingMessage(robotSide);
        }
        if (this.isSpineJointspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computeSpineStreamingMessage();
        }
        if (this.isNeckJointspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computeNeckStreamingMessage();
        }
        if (this.isChestTaskspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computeChestStreamingMessage(this.configurationCommand.getChestTrajectoryFrameId());
        }
        if (this.isPelvisTaskspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computePelvisStreamingMessage(this.configurationCommand.getPelvisTrajectoryFrameId());
        }
        if (this.isCenterOfMassOutputEnabled.getValue()) {
            this.streamingMessageFactory.computeCenterOfMassStreamingMessage();
        }
        this.streamingMessageFactory.getOutput().setHasCenterOfMassTrajectoryMessage(this.isCenterOfMassOutputEnabled.getValue());
        this.currentMessageId.increment();
        return this.streamingMessageFactory.getOutput();
    }

    public WholeBodyTrajectoryMessage setupTrajectoryMessage(KSTOutputDataReadOnly solutionToConvert) {
        HumanoidMessageTools.resetWholeBodyTrajectoryToolboxMessage((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.updateFullRobotModel(solutionToConvert::updateRobot);
        this.trajectoryMessageFactory.setMessageToCreate(this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.setTrajectoryTime(0.0);
        this.trajectoryMessageFactory.setEnableVelocity(true);
        for (RobotSide robotSide : RobotSide.values) {
            if (((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.trajectoryMessageFactory.computeHandTrajectoryMessage(robotSide, this.configurationCommand.getHandTrajectoryFrameId(robotSide));
            }
            if (!((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) continue;
            this.trajectoryMessageFactory.computeArmTrajectoryMessage(robotSide);
        }
        if (this.isNeckJointspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeNeckTrajectoryMessage();
        }
        if (this.isChestTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeChestTrajectoryMessage(this.configurationCommand.getChestTrajectoryFrameId());
        }
        if (this.isPelvisTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computePelvisTrajectoryMessage(this.configurationCommand.getPelvisTrajectoryFrameId());
        }
        this.wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage().setEnableUserPelvisControl(true);
        HumanoidMessageTools.configureForStreaming((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage, (double)this.streamIntegrationDuration.getValue(), (long)Conversions.secondsToNanoseconds((double)this.time.getValue()));
        KSTTools.setAllIDs(this.wholeBodyTrajectoryMessage, this.currentMessageId.getValue());
        this.currentMessageId.increment();
        return this.wholeBodyTrajectoryMessage;
    }

    public WholeBodyTrajectoryMessage setupFinalizeTrajectoryMessage(KSTOutputDataReadOnly solutionToConvert) {
        HumanoidMessageTools.resetWholeBodyTrajectoryToolboxMessage((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.updateFullRobotModel(solutionToConvert::updateRobot);
        this.trajectoryMessageFactory.setMessageToCreate(this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.setTrajectoryTime(0.5);
        for (RobotSide robotSide : RobotSide.values) {
            if (((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.trajectoryMessageFactory.computeHandTrajectoryMessage(robotSide);
            }
            if (!((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) continue;
            this.trajectoryMessageFactory.computeArmTrajectoryMessage(robotSide);
        }
        if (this.isNeckJointspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeNeckTrajectoryMessage();
        }
        if (this.isChestTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeChestTrajectoryMessage();
        }
        if (this.isPelvisTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computePelvisTrajectoryMessage();
        }
        if (this.isCenterOfMassOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeCenterOfMassTrajectoryMessage();
        }
        this.wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage().setEnableUserPelvisControl(false);
        HumanoidMessageTools.configureForOverriding((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage);
        KSTTools.setAllIDs(this.wholeBodyTrajectoryMessage, this.currentMessageId.getValue());
        this.currentMessageId.increment();
        return this.wholeBodyTrajectoryMessage;
    }

    private static void setAllIDs(WholeBodyTrajectoryMessage message, long id) {
        message.setSequenceId(id);
        message.getLeftHandTrajectoryMessage().setSequenceId(id);
        message.getRightHandTrajectoryMessage().setSequenceId(id);
        message.getLeftArmTrajectoryMessage().setSequenceId(id);
        message.getRightArmTrajectoryMessage().setSequenceId(id);
        message.getChestTrajectoryMessage().setSequenceId(id);
        message.getSpineTrajectoryMessage().setSequenceId(id);
        message.getPelvisTrajectoryMessage().setSequenceId(id);
        message.getLeftFootTrajectoryMessage().setSequenceId(id);
        message.getRightFootTrajectoryMessage().setSequenceId(id);
        message.getNeckTrajectoryMessage().setSequenceId(id);
        message.getHeadTrajectoryMessage().setSequenceId(id);
        message.setUniqueId(id);
        message.getLeftHandTrajectoryMessage().setUniqueId(id);
        message.getRightHandTrajectoryMessage().setUniqueId(id);
        message.getLeftArmTrajectoryMessage().setUniqueId(id);
        message.getRightArmTrajectoryMessage().setUniqueId(id);
        message.getChestTrajectoryMessage().setUniqueId(id);
        message.getSpineTrajectoryMessage().setUniqueId(id);
        message.getPelvisTrajectoryMessage().setUniqueId(id);
        message.getLeftFootTrajectoryMessage().setUniqueId(id);
        message.getRightFootTrajectoryMessage().setUniqueId(id);
        message.getNeckTrajectoryMessage().setUniqueId(id);
        message.getHeadTrajectoryMessage().setUniqueId(id);
        message.getLeftHandTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getRightHandTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getLeftArmTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getRightArmTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getChestTrajectoryMessage().getSo3Trajectory().getQueueingProperties().setMessageId(id);
        message.getSpineTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getPelvisTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getLeftFootTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getRightFootTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getNeckTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getHeadTrajectoryMessage().getSo3Trajectory().getQueueingProperties().setMessageId(id);
    }

    public void setRobotStateUpdater(KinematicsToolboxController.IKRobotStateUpdater robotStateUpdater) {
        this.robotStateUpdater = robotStateUpdater;
        this.ikController.setDesiredRobotStateUpdater(robotStateUpdater);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        this.ikController.updateCapturabilityBasedStatus(newStatus);
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }

    public CommandInputManager getIKCommandInputManager() {
        return this.ikCommandInputManager;
    }

    public StatusMessageOutputManager getStatusOutputManager() {
        return this.statusOutputManager;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.desiredFullRobotModel;
    }

    public FullHumanoidRobotModelFactory getFullRobotModelFactory() {
        return this.robotModel;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public KinematicsToolboxOutputConverter getOutputConverter() {
        return this.trajectoryMessageFactory;
    }

    public FullHumanoidRobotModel getCurrentFullRobotModel() {
        return this.currentFullRobotModel;
    }

    public HumanoidKinematicsToolboxController getIKController() {
        return this.ikController;
    }

    public double getToolboxControllerPeriod() {
        return this.toolboxControllerPeriod;
    }

    public boolean isFootInSupport(RobotSide side) {
        return (Boolean)this.isFootInSupport.get((Enum)side);
    }

    public Notification getStartFootControlNotification(RobotSide side) {
        return (Notification)this.startFootControl.get((Enum)side);
    }

    public static void copyJointDesiredPositions(OneDoFJointReadOnly[] joints, List<KinematicsToolboxOneDoFJointMessage> messagesToUpdate) {
        for (int i = 0; i < joints.length; ++i) {
            messagesToUpdate.get(i).setDesiredPosition(joints[i].getQ());
        }
    }

    public static void updateFullRobotModel(RobotConfigurationData robotConfigurationData, FullHumanoidRobotModel fullRobotModelToUpdate) {
        OneDoFJointBasics[] joints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModelToUpdate);
        ForceSensorDefinition[] forceSensorDefinitions = fullRobotModelToUpdate.getForceSensorDefinitions();
        IMUDefinition[] imuDefinitions = fullRobotModelToUpdate.getIMUDefinitions();
        int jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])joints, (ForceSensorDefinition[])forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        if (robotConfigurationData.getJointNameHash() != jointNameHash) {
            throw new RuntimeException("Joint names do not match for RobotConfigurationData");
        }
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            joints[jointIndex].setQ((double)robotConfigurationData.getJointAngles().get(jointIndex));
        }
        Pose3DBasics rootJointPose = fullRobotModelToUpdate.getRootJoint().getJointPose();
        rootJointPose.set((Tuple3DReadOnly)robotConfigurationData.getRootPosition(), (Orientation3DReadOnly)robotConfigurationData.getRootOrientation());
    }

    public static void copyRobotState(FullHumanoidRobotModel source, FullHumanoidRobotModel destination, JointStateType stateSelection) {
        MultiBodySystemTools.copyJointsState(Collections.singletonList(source.getRootJoint()), Collections.singletonList(destination.getRootJoint()), (JointStateType)stateSelection);
        MultiBodySystemTools.copyJointsState(Arrays.asList(source.getOneDoFJoints()), Arrays.asList(destination.getOneDoFJoints()), (JointStateType)stateSelection);
    }

    public static void computeSpatialVelocity(double dt, FramePose3DReadOnly previousPose, FramePose3DReadOnly currentPose, FixedFrameSpatialVectorBasics spatialVelocityToPack) {
        KSTTools.computeLinearVelocity(dt, previousPose.getPosition(), currentPose.getPosition(), spatialVelocityToPack.getLinearPart());
        KSTTools.computeAngularVelocity(dt, previousPose.getOrientation(), currentPose.getOrientation(), spatialVelocityToPack.getAngularPart());
    }

    public static void computeLinearVelocity(double dt, FramePoint3DReadOnly previousPosition, FramePoint3DReadOnly currentPosition, FixedFrameVector3DBasics linearVelocityToPack) {
        linearVelocityToPack.sub((FrameTuple3DReadOnly)currentPosition, (FrameTuple3DReadOnly)previousPosition);
        linearVelocityToPack.scale(1.0 / dt);
    }

    public static void computeAngularVelocity(double dt, FrameQuaternionReadOnly previousOrientation, FrameQuaternionReadOnly currentOrientation, FixedFrameVector3DBasics angularVelocityToPack) {
        previousOrientation.checkReferenceFrameMatch((ReferenceFrameHolder)currentOrientation);
        previousOrientation.checkReferenceFrameMatch((ReferenceFrameHolder)angularVelocityToPack);
        double qDot_x = currentOrientation.getX() - previousOrientation.getX();
        double qDot_y = currentOrientation.getY() - previousOrientation.getY();
        double qDot_z = currentOrientation.getZ() - previousOrientation.getZ();
        double qDot_s = currentOrientation.getS() - previousOrientation.getS();
        double qx = -currentOrientation.getX();
        double qy = -currentOrientation.getY();
        double qz = -currentOrientation.getZ();
        double qs = currentOrientation.getS();
        double wx = qs * qDot_x + qx * qDot_s + qy * qDot_z - qz * qDot_y;
        double wy = qs * qDot_y - qx * qDot_z + qy * qDot_s + qz * qDot_x;
        double wz = qs * qDot_z + qx * qDot_y - qy * qDot_x + qz * qDot_s;
        angularVelocityToPack.set(wx, wy, wz);
        angularVelocityToPack.scale(2.0 / dt);
    }

    public static void integrateLinearVelocity(double dt, FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly linearVelocity, FixedFramePoint3DBasics finalPosition) {
        finalPosition.scaleAdd(dt, (FrameTuple3DReadOnly)linearVelocity, (FrameTuple3DReadOnly)initialPosition);
    }

    public static void integrateAngularVelocity(double dt, FrameQuaternionReadOnly initialOrientation, FrameVector3DReadOnly angularVelocity, boolean isAngularVelocityLocal, FixedFrameQuaternionBasics finalOrientation) {
        double qInit_x = initialOrientation.getX();
        double qInit_y = initialOrientation.getY();
        double qInit_z = initialOrientation.getZ();
        double qInit_s = initialOrientation.getS();
        double x = angularVelocity.getX() * dt;
        double y = angularVelocity.getY() * dt;
        double z = angularVelocity.getZ() * dt;
        finalOrientation.setRotationVector(x, y, z);
        double qInt_x = finalOrientation.getX();
        double qInt_y = finalOrientation.getY();
        double qInt_z = finalOrientation.getZ();
        double qInt_s = finalOrientation.getS();
        if (isAngularVelocityLocal) {
            QuaternionTools.multiplyImpl((double)qInit_x, (double)qInit_y, (double)qInit_z, (double)qInit_s, (boolean)false, (double)qInt_x, (double)qInt_y, (double)qInt_z, (double)qInt_s, (boolean)false, (Orientation3DBasics)finalOrientation);
        } else {
            QuaternionTools.multiplyImpl((double)qInt_x, (double)qInt_y, (double)qInt_z, (double)qInt_s, (boolean)false, (double)qInit_x, (double)qInit_y, (double)qInit_z, (double)qInit_s, (boolean)false, (Orientation3DBasics)finalOrientation);
        }
    }

    public static double computeJointMinVelocity(double qMin, double q, double dt) {
        if (!Double.isInfinite(qMin)) {
            return (qMin - q) / dt;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double computeJointMaxVelocity(double qMax, double q, double dt) {
        if (!Double.isInfinite(qMax)) {
            return (qMax - q) / dt;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double computeJointMinAcceleration(double qMin, double q, double qDot, double dt) {
        return KSTTools.computeJointMinAcceleration(qMin, Double.NEGATIVE_INFINITY, q, qDot, dt);
    }

    public static double computeJointMinAcceleration(double qMin, double qDotMin, double q, double qDot, double dt) {
        double qDotMinPositionLimit = Double.isFinite(qMin) ? (qMin - q) / dt : Double.NEGATIVE_INFINITY;
        if (Double.isFinite(qDotMin = Double.isFinite(qDotMin) ? Math.max(qDotMin, qDotMinPositionLimit) : qDotMinPositionLimit)) {
            return 2.0 * (qDotMin - qDot) / dt;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double computeJointMaxAcceleration(double qMax, double q, double qDot, double dt) {
        return KSTTools.computeJointMaxAcceleration(qMax, Double.POSITIVE_INFINITY, q, qDot, dt);
    }

    public static double computeJointMaxAcceleration(double qMax, double qDotMax, double q, double qDot, double dt) {
        double qDotMaxPositionLimit = Double.isFinite(qMax) ? (qMax - q) / dt : Double.POSITIVE_INFINITY;
        if (Double.isFinite(qDotMax = Double.isFinite(qDotMax) ? Math.min(qDotMax, qDotMaxPositionLimit) : qDotMaxPositionLimit)) {
            return 2.0 * (qDotMax - qDot) / dt;
        }
        return Double.POSITIVE_INFINITY;
    }
}

