/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import ihmc_common_msgs.msg.dds.WeightMatrix3DMessage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import toolbox_msgs.msg.dds.KinematicsToolboxOneDoFJointMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input.KSTInputFBControllerStateEstimator;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input.KSTInputFirstOrderStateEstimator;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.input.KSTInputStateEstimator;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTCompiledOutputProcessor;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.output.KSTOutputDataReadOnly;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxMessageFactory;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.filters.AlphaFilteredYoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class KSTStreamingState
implements State {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final KSTTools tools;
    private final YoDouble defaultJointVelocityWeight = new YoDouble("defaultJointVelocityWeight", this.registry);
    private final YoDouble defaultJointAccelerationWeight = new YoDouble("defaultJointAccelerationWeight", this.registry);
    private final double toolboxControllerPeriod;
    private final YoDouble timeOfLastMessageSentToController = new YoDouble("timeOfLastMessageSentToController", this.registry);
    private final YoBoolean isPublishing = new YoBoolean("isPublishing", this.registry);
    private final YoDouble publishingPeriod = new YoDouble("publishingPeriod", this.registry);
    private final CommandInputManager ikCommandInputManager;
    private final List<KinematicsToolboxOneDoFJointMessage> defaultNeckJointMessages;
    private final KinematicsToolboxRigidBodyMessage defaultPelvisMessage = new KinematicsToolboxRigidBodyMessage();
    private final KinematicsToolboxRigidBodyMessage defaultChestMessage = new KinematicsToolboxRigidBodyMessage();
    private final SideDependentList<List<KinematicsToolboxOneDoFJointMessage>> defaultArmJointMessages = new SideDependentList();
    private final RigidBodyBasics head;
    private final OneDoFJointBasics[] neckJoints;
    private final RigidBodyBasics pelvis;
    private final RigidBodyBasics chest;
    private final SideDependentList<RigidBodyBasics> hands = new SideDependentList();
    private final SideDependentList<RigidBodyBasics> feet = new SideDependentList();
    private final SideDependentList<OneDoFJointBasics[]> armJoints = new SideDependentList();
    private final YoDouble lockPoseFilterBreakFrequency = new YoDouble("lockPoseFilterBreakFrequncy", this.registry);
    private final YoBoolean lockPelvis = new YoBoolean("lockPelvis", this.registry);
    private final YoBoolean lockChest = new YoBoolean("lockChest", this.registry);
    private final YoFramePose3D lockPelvisPose = new YoFramePose3D("lockPelvisPose", worldFrame, this.registry);
    private final AlphaFilteredYoFramePose3D lockPelvisPoseFiltered;
    private final YoFramePose3D lockChestPose = new YoFramePose3D("lockChestPose", worldFrame, this.registry);
    private final AlphaFilteredYoFramePose3D lockChestPoseFiltered;
    private final YoDouble holdArmWeight = new YoDouble("holdArmWeight", this.registry);
    private final YoDouble holdNeckWeight = new YoDouble("holdNeckWeight", this.registry);
    private final YoVector3D holdPelvisLinearWeight = new YoVector3D("holdPelvisLinearWeight", this.registry);
    private final YoVector3D holdPelvisAngularWeight = new YoVector3D("holdPelvisAngularWeight", this.registry);
    private final YoVector3D holdChestAngularWeight = new YoVector3D("holdChestAngularWeight", this.registry);
    private final YoDouble lockPelvisWeight = new YoDouble("lockPelvisWeight", this.registry);
    private final YoDouble lockChestWeight = new YoDouble("lockChestWeight", this.registry);
    private final YoDouble inputWeightDecayFactor;
    private final YoInteger numberOfDecayingInputs = new YoInteger("numberOfDecayingInputs", this.registry);
    private final YoBoolean isDemonstrationEpisode = new YoBoolean("isDemonstrationEpisode", this.registry);
    private final Map<RigidBodyBasics, YoDouble> rigidBodyControlStartTimeMap = new HashMap<RigidBodyBasics, YoDouble>();
    private final YoDouble[] rigidBodyControlStartTimeArray;
    private final YoDouble centerOfMassControlStartTime = new YoDouble("centerOfMassControlStartTime", this.registry);
    private final RecyclingArrayList<KinematicsToolboxRigidBodyCommand> decayingInputs = new RecyclingArrayList(KinematicsToolboxRigidBodyCommand::new);
    private final YoBoolean isStreaming = new YoBoolean("isStreaming", this.registry);
    private final YoBoolean wasStreaming = new YoBoolean("wasStreaming", this.registry);
    private final YoDouble defaultLinearGain = new YoDouble("defaultLinearGain", this.registry);
    private final YoDouble defaultAngularGain = new YoDouble("defaultAngularGain", this.registry);
    private final YoDouble defaultSingleJointGain = new YoDouble("defaultSingleJointGain", this.registry);
    private final YoDouble linearRateLimit = new YoDouble("linearRateLimit", this.registry);
    private final YoDouble angularRateLimit = new YoDouble("angularRateLimit", this.registry);
    private final YoDouble defaultLinearRateLimit = new YoDouble("defaultLinearRateLimit", this.registry);
    private final YoDouble defaultAngularRateLimit = new YoDouble("defaultAngularRateLimit", this.registry);
    private final YoVector3D defaultLinearWeight = new YoVector3D("defaultLinearWeight", this.registry);
    private final YoVector3D defaultAngularWeight = new YoVector3D("defaultAngularWeight", this.registry);
    private final YoVector3D defaultPelvisLinearWeight = new YoVector3D("defaultPelvisLinearWeight", this.registry);
    private final YoVector3D defaultPelvisAngularWeight = new YoVector3D("defaultPelvisAngularWeight", this.registry);
    private final YoVector3D defaultChestLinearWeight = new YoVector3D("defaultChestLinearWeight", this.registry);
    private final YoVector3D defaultChestAngularWeight = new YoVector3D("defaultChestAngularWeight", this.registry);
    private final YoVector3D defaultHandLinearWeight = new YoVector3D("defaultHandLinearWeight", this.registry);
    private final YoVector3D defaultHandAngularWeight = new YoVector3D("defaultHandAngularWeight", this.registry);
    private final Map<String, YoVector3D> defaultLinearWeightMap = new HashMap<String, YoVector3D>();
    private final Map<String, YoVector3D> defaultAngularWeightMap = new HashMap<String, YoVector3D>();
    private final YoDouble streamingBlendingDuration = new YoDouble("streamingBlendingDuration", this.registry);
    private final KSTOutputDataReadOnly ikSolution;
    private final KSTCompiledOutputProcessor outputProcessor;
    private final YoDouble timeOfLastInput = new YoDouble("timeOfLastInput", this.registry);
    private final YoDouble timeSinceLastInput = new YoDouble("timeSinceLastInput", this.registry);
    private final YoDouble rawInputFrequency = new YoDouble("rawInputFrequency", this.registry);
    private final AlphaFilteredYoVariable inputFrequency;
    private final HumanoidKinematicsToolboxController ikController;
    private final YoPIDSE3Gains ikSolverSpatialGains;
    private final YoPIDGains ikSolverJointGains;
    private final YoEnum<KinematicsStreamingToolboxParameters.InputStateEstimatorType> activeInputStateEstimator = new YoEnum("activeInputStateEstimator", this.registry, KinematicsStreamingToolboxParameters.InputStateEstimatorType.class);
    private final Map<KinematicsStreamingToolboxParameters.InputStateEstimatorType, KSTInputStateEstimator> inputStateEstimatorsMap = new EnumMap<KinematicsStreamingToolboxParameters.InputStateEstimatorType, KSTInputStateEstimator>(KinematicsStreamingToolboxParameters.InputStateEstimatorType.class);
    private final KSTInputStateEstimator[] inputStateEstimators;
    private final KinematicsStreamingToolboxInputCommand filteredInputs = new KinematicsStreamingToolboxInputCommand();
    private final List<RigidBodyBasics> uncontrolledRigidBodies = new ArrayList<RigidBodyBasics>();

    public KSTStreamingState(KSTTools tools) {
        KinematicsStreamingToolboxParameters parameters = tools.getParameters();
        this.tools = tools;
        this.toolboxControllerPeriod = tools.getToolboxControllerPeriod();
        this.ikController = tools.getIKController();
        this.ikSolverSpatialGains = this.ikController.getDefaultSpatialGains();
        this.ikSolverJointGains = this.ikController.getDefaultJointGains();
        this.ikController.getCenterOfMassSafeMargin().set(parameters.getCenterOfMassSafeMargin());
        this.ikController.setPublishingSolutionPeriod(parameters.getPublishingSolutionPeriod());
        this.ikController.getMomentumWeight().set(parameters.getCenterOfMassHoldWeight());
        this.ikController.minimizeMomentum(parameters.isMinimizeAngularMomentum(), parameters.isMinimizeLinearMomentum());
        this.ikController.setMomentumWeight((Tuple3DReadOnly)parameters.getAngularMomentumWeight(), (Tuple3DReadOnly)parameters.getLinearMomentumWeight());
        this.ikController.minimizeMomentumRate(parameters.isMinimizeAngularMomentumRate(), parameters.isMinimizeLinearMomentumRate());
        this.ikController.setMomentumRateWeight((Tuple3DReadOnly)parameters.getAngularMomentumRateWeight(), (Tuple3DReadOnly)parameters.getLinearMomentumRateWeight());
        FullHumanoidRobotModel desiredFullRobotModel = tools.getDesiredFullRobotModel();
        this.ikCommandInputManager = tools.getIKCommandInputManager();
        tools.getRegistry().addChild(this.registry);
        this.head = desiredFullRobotModel.getHead();
        this.pelvis = desiredFullRobotModel.getPelvis();
        this.chest = desiredFullRobotModel.getChest();
        this.neckJoints = this.head == null ? new OneDoFJointBasics[0] : MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)this.chest, (RigidBodyBasics)this.head);
        this.defaultNeckJointMessages = Stream.of(this.neckJoints).map(joint -> KinematicsToolboxMessageFactory.newOneDoFJointMessage((OneDoFJointReadOnly)joint, (double)10.0, (double)0.0)).collect(Collectors.toList());
        this.defaultPelvisMessage.setEndEffectorHashCode(this.pelvis.hashCode());
        this.defaultPelvisMessage.getDesiredOrientationInWorld().setToZero();
        this.defaultChestMessage.setEndEffectorHashCode(this.chest.hashCode());
        this.defaultChestMessage.getDesiredOrientationInWorld().setToZero();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics rigidBodyBasics = desiredFullRobotModel.getHand(robotSide);
            if (rigidBodyBasics == null) continue;
            OneDoFJointBasics[] joints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)this.chest, (RigidBodyBasics)rigidBodyBasics);
            this.hands.put((Enum)robotSide, (Object)rigidBodyBasics);
            this.armJoints.put((Enum)robotSide, (Object)joints);
            this.defaultArmJointMessages.put((Enum)robotSide, Stream.of(joints).map(joint -> KinematicsToolboxMessageFactory.newOneDoFJointMessage((OneDoFJointReadOnly)joint, (double)10.0, (double)0.0)).collect(Collectors.toList()));
            RigidBodyBasics foot = desiredFullRobotModel.getFoot((Enum)robotSide);
            if (foot == null) continue;
            this.feet.put((Enum)robotSide, (Object)foot);
        }
        this.defaultJointVelocityWeight.set(parameters.getDefaultSolverConfiguration().getJointVelocityWeight());
        this.defaultJointAccelerationWeight.set(parameters.getDefaultSolverConfiguration().getJointAccelerationWeight());
        this.holdArmWeight.set(parameters.getHoldArmWeight());
        this.holdNeckWeight.set(parameters.getHoldNeckWeight());
        this.holdPelvisLinearWeight.set((Tuple3DReadOnly)parameters.getHoldPelvisLinearWeight());
        this.holdPelvisAngularWeight.set((Tuple3DReadOnly)parameters.getHoldPelvisAngularWeight());
        this.holdChestAngularWeight.set((Tuple3DReadOnly)parameters.getHoldChestAngularWeight());
        this.lockPelvisWeight.set(parameters.getLockPelvisWeight());
        this.lockChestWeight.set(parameters.getLockChestWeight());
        this.defaultLinearWeight.set((Tuple3DReadOnly)parameters.getDefaultLinearWeight());
        this.defaultAngularWeight.set((Tuple3DReadOnly)parameters.getDefaultAngularWeight());
        this.defaultPelvisLinearWeight.set((Tuple3DReadOnly)parameters.getDefaultPelvisLinearWeight());
        this.defaultPelvisAngularWeight.set((Tuple3DReadOnly)parameters.getDefaultPelvisAngularWeight());
        this.defaultChestLinearWeight.set((Tuple3DReadOnly)parameters.getDefaultChestLinearWeight());
        this.defaultChestAngularWeight.set((Tuple3DReadOnly)parameters.getDefaultChestAngularWeight());
        this.defaultHandLinearWeight.set((Tuple3DReadOnly)parameters.getDefaultHandLinearWeight());
        this.defaultHandAngularWeight.set((Tuple3DReadOnly)parameters.getDefaultHandAngularWeight());
        this.defaultLinearWeightMap.put(this.pelvis.getName(), this.defaultPelvisLinearWeight);
        this.defaultAngularWeightMap.put(this.pelvis.getName(), this.defaultPelvisAngularWeight);
        this.defaultLinearWeightMap.put(this.chest.getName(), this.defaultChestLinearWeight);
        this.defaultAngularWeightMap.put(this.chest.getName(), this.defaultChestAngularWeight);
        for (RobotSide robotSide : RobotSide.values) {
            this.defaultLinearWeightMap.put(((RigidBodyBasics)this.hands.get((Enum)robotSide)).getName(), this.defaultHandLinearWeight);
            this.defaultAngularWeightMap.put(((RigidBodyBasics)this.hands.get((Enum)robotSide)).getName(), this.defaultHandAngularWeight);
        }
        this.publishingPeriod.set(parameters.getPublishingPeriod());
        this.ikSolution = KSTOutputDataReadOnly.wrap(this.ikController.getSolution());
        this.defaultLinearGain.set(parameters.getDefaultLinearGain());
        this.defaultAngularGain.set(parameters.getDefaultAngularGain());
        this.defaultSingleJointGain.set(parameters.getDefaultSingleJointGain());
        this.defaultLinearRateLimit.set(parameters.getDefaultLinearRateLimit());
        this.defaultAngularRateLimit.set(parameters.getDefaultAngularRateLimit());
        this.streamingBlendingDuration.set(parameters.getDefaultStreamingBlendingDuration());
        this.outputProcessor = new KSTCompiledOutputProcessor(tools, (DoubleProvider)this.streamingBlendingDuration, (BooleanProvider)this.isPublishing, this.registry);
        DoubleProvider alpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.lockPoseFilterBreakFrequency.getValue(), (double)this.toolboxControllerPeriod);
        this.lockPoseFilterBreakFrequency.set(0.25);
        this.lockPelvisPoseFiltered = new AlphaFilteredYoFramePose3D("lockPelvisPoseFiltered", "", (FramePose3DReadOnly)this.lockPelvisPose, alpha, this.registry);
        this.lockChestPoseFiltered = new AlphaFilteredYoFramePose3D("lockChestPoseFiltered", "", (FramePose3DReadOnly)this.lockChestPose, alpha, this.registry);
        YoDouble inputFrequencyAlpha = new YoDouble("inputFrequencyFilter", this.registry);
        inputFrequencyAlpha.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)2.0, (double)this.toolboxControllerPeriod));
        this.inputFrequency = new AlphaFilteredYoVariable("inputFrequency", this.registry, (DoubleProvider)inputFrequencyAlpha, this.rawInputFrequency);
        this.inputWeightDecayFactor = new YoDouble("inputDecayFactor", this.registry);
        this.inputWeightDecayFactor.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)(1.0 / parameters.getInputWeightDecayDuration()), (double)this.toolboxControllerPeriod));
        List<? extends RigidBodyBasics> controllableRigidBodies = this.ikController.getControllableRigidBodies();
        this.activeInputStateEstimator.set((Enum)parameters.getInputStateEstimatorType());
        this.inputStateEstimatorsMap.put(KinematicsStreamingToolboxParameters.InputStateEstimatorType.FIRST_ORDER_LPF, new KSTInputFirstOrderStateEstimator(controllableRigidBodies, parameters, this.toolboxControllerPeriod, this.registry));
        this.inputStateEstimatorsMap.put(KinematicsStreamingToolboxParameters.InputStateEstimatorType.FBC_STYLE, new KSTInputFBControllerStateEstimator(controllableRigidBodies, parameters, this.toolboxControllerPeriod, () -> 1.0 / this.inputFrequency.getValue(), this.registry));
        this.inputStateEstimators = this.inputStateEstimatorsMap.values().toArray(new KSTInputStateEstimator[0]);
        for (RigidBodyBasics rigidBodyBasics : controllableRigidBodies) {
            this.rigidBodyControlStartTimeMap.put(rigidBodyBasics, new YoDouble(rigidBodyBasics.getName() + "ControlStartTime", this.registry));
        }
        this.rigidBodyControlStartTimeArray = new YoDouble[controllableRigidBodies.size()];
        int index = 0;
        for (RigidBodyBasics rigidBodyBasics : controllableRigidBodies) {
            this.rigidBodyControlStartTimeArray[index++] = this.rigidBodyControlStartTimeMap.get(rigidBodyBasics);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onEntry() {
        void var3_6;
        this.isStreaming.set(false);
        this.wasStreaming.set(false);
        this.timeOfLastMessageSentToController.set(Double.NEGATIVE_INFINITY);
        this.ikSolverSpatialGains.setPositionProportionalGains(this.defaultLinearGain.getValue());
        this.ikSolverSpatialGains.setOrientationProportionalGains(this.defaultAngularGain.getValue());
        this.ikSolverSpatialGains.setPositionMaxFeedbackAndFeedbackRate(this.linearRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverSpatialGains.setOrientationMaxFeedbackAndFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverJointGains.setKp(this.defaultSingleJointGain.getValue());
        this.ikSolverJointGains.setMaximumFeedbackAndMaximumFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.tools.resetUserInvalidInputFlag();
        this.tools.resetFootContactNotification();
        KinematicsStreamingToolboxParameters kstParameters = this.tools.getParameters();
        kstParameters.getDefaultSolverConfiguration().setJointVelocityWeight(this.defaultJointVelocityWeight.getValue());
        kstParameters.getDefaultSolverConfiguration().setJointAccelerationWeight(this.defaultJointAccelerationWeight.getValue());
        this.ikCommandInputManager.submitMessage((Settable)kstParameters.getDefaultSolverConfiguration());
        if (kstParameters.getSolverNullspaceAlpha() > 0.0 && Double.isFinite(kstParameters.getSolverNullspaceAlpha())) {
            this.ikController.setPrivilegedNullspaceAlpha(kstParameters.getSolverNullspaceAlpha(), true);
        }
        if (kstParameters.getSolverPrivilegedDefaultWeight() > 0.0 && Double.isFinite(kstParameters.getSolverPrivilegedDefaultWeight())) {
            this.ikController.setPrivilegedWeight(kstParameters.getSolverPrivilegedDefaultWeight(), true);
        }
        if (kstParameters.getSolverPrivilegedDefaultGain() > 0.0 && Double.isFinite(kstParameters.getSolverPrivilegedDefaultGain())) {
            this.ikController.setPrivilegedConfigurationGain(kstParameters.getSolverPrivilegedDefaultGain(), true);
        }
        FullHumanoidRobotModel controllerFullRobotModel = this.tools.getCurrentFullRobotModel();
        for (OneDoFJointBasics oneDoFJointBasics : this.neckJoints) {
            oneDoFJointBasics.setQ(controllerFullRobotModel.getOneDoFJointByName(oneDoFJointBasics.getName()).getQ());
        }
        for (RobotSide robotSide : RobotSide.values) {
            if (this.armJoints.get((Enum)robotSide) == null) continue;
            for (OneDoFJointBasics armJoint : (OneDoFJointBasics[])this.armJoints.get((Enum)robotSide)) {
                armJoint.setQ(controllerFullRobotModel.getOneDoFJointByName(armJoint.getName()).getQ());
            }
        }
        boolean bl = false;
        while (var3_6 < this.neckJoints.length) {
            this.defaultNeckJointMessages.get((int)var3_6).setDesiredPosition(controllerFullRobotModel.getOneDoFJointByName(this.neckJoints[var3_6].getName()).getQ());
            this.defaultNeckJointMessages.get((int)var3_6).setWeight(this.holdNeckWeight.getValue());
            ++var3_6;
        }
        this.lockPelvis.set(this.tools.getConfigurationCommand().isLockPelvis());
        if (this.lockPelvis.getValue()) {
            this.lockPelvisPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getPelvis().getBodyFixedFrame());
            this.lockPelvisPoseFiltered.update();
            this.defaultPelvisMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockPelvisPoseFiltered.getPosition());
            this.defaultPelvisMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockPelvisPoseFiltered.getOrientation());
            this.defaultPelvisMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            this.defaultPelvisMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((double)this.lockPelvisWeight.getValue(), (WeightMatrix3DMessage)this.defaultPelvisMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((double)this.lockPelvisWeight.getValue(), (WeightMatrix3DMessage)this.defaultPelvisMessage.getAngularWeightMatrix());
        } else {
            this.lockPelvisPoseFiltered.reset();
            this.lockPelvisPose.setFromReferenceFrame((ReferenceFrame)this.pelvis.getBodyFixedFrame());
            this.defaultPelvisMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockPelvisPose.getPosition());
            this.defaultPelvisMessage.getDesiredOrientationInWorld().setToYawOrientation(this.lockPelvisPose.getYaw());
            this.defaultPelvisMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)false, (boolean)false, (boolean)true, (ReferenceFrame)worldFrame));
            this.defaultPelvisMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((Tuple3DReadOnly)this.holdPelvisLinearWeight, (WeightMatrix3DMessage)this.defaultPelvisMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((Tuple3DReadOnly)this.holdPelvisAngularWeight, (WeightMatrix3DMessage)this.defaultPelvisMessage.getAngularWeightMatrix());
        }
        this.lockChest.set(this.tools.getConfigurationCommand().isLockChest());
        if (this.lockChest.getValue()) {
            this.lockChestPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getChest().getBodyFixedFrame());
            this.lockChestPoseFiltered.update();
            this.defaultChestMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockChestPoseFiltered.getPosition());
            this.defaultChestMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockChestPoseFiltered.getOrientation());
            this.defaultChestMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            this.defaultChestMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((double)this.lockChestWeight.getValue(), (WeightMatrix3DMessage)this.defaultChestMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((double)this.lockChestWeight.getValue(), (WeightMatrix3DMessage)this.defaultChestMessage.getAngularWeightMatrix());
        } else {
            this.lockChestPoseFiltered.reset();
            this.lockChestPose.setFromReferenceFrame((ReferenceFrame)this.chest.getBodyFixedFrame());
            this.defaultChestMessage.getDesiredPositionInWorld().setToZero();
            this.defaultChestMessage.getDesiredOrientationInWorld().setToYawOrientation(this.lockChestPose.getYaw());
            this.defaultChestMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)false, (boolean)false, (boolean)false, (ReferenceFrame)worldFrame));
            this.defaultChestMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((boolean)true, (boolean)true, (boolean)true, (ReferenceFrame)worldFrame));
            MessageTools.packWeightMatrix3DMessage((double)0.0, (WeightMatrix3DMessage)this.defaultChestMessage.getLinearWeightMatrix());
            MessageTools.packWeightMatrix3DMessage((Tuple3DReadOnly)this.holdChestAngularWeight, (WeightMatrix3DMessage)this.defaultChestMessage.getAngularWeightMatrix());
        }
        for (RobotSide robotSide : RobotSide.values) {
            if (this.armJoints.get((Enum)robotSide) == null) continue;
            OneDoFJointBasics[] joints = (OneDoFJointBasics[])this.armJoints.get((Enum)robotSide);
            List defaultMessages = (List)this.defaultArmJointMessages.get((Enum)robotSide);
            for (int i = 0; i < joints.length; ++i) {
                ((KinematicsToolboxOneDoFJointMessage)defaultMessages.get(i)).setDesiredPosition(controllerFullRobotModel.getOneDoFJointByName(joints[i].getName()).getQ());
                ((KinematicsToolboxOneDoFJointMessage)defaultMessages.get(i)).setWeight(this.holdArmWeight.getValue());
            }
        }
        this.outputProcessor.initialize();
        this.timeOfLastInput.set(Double.NaN);
        this.timeSinceLastInput.set(Double.NaN);
        this.inputFrequency.reset();
        for (KSTInputStateEstimator kSTInputStateEstimator : this.inputStateEstimators) {
            kSTInputStateEstimator.reset();
        }
        for (YoDouble yoDouble : this.rigidBodyControlStartTimeArray) {
            yoDouble.setToNaN();
        }
        this.centerOfMassControlStartTime.setToNaN();
    }

    public void doAction(double timeInState) {
        FullHumanoidRobotModel controllerFullRobotModel = this.tools.getCurrentFullRobotModel();
        if (this.lockPelvis.getValue() && !this.tools.getConfigurationCommand().isPelvisTaskspaceEnabled()) {
            this.lockPelvisPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getPelvis().getBodyFixedFrame());
            this.lockPelvisPoseFiltered.update();
            this.defaultPelvisMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockPelvisPoseFiltered.getPosition());
            this.defaultPelvisMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockPelvisPoseFiltered.getOrientation());
        } else {
            this.lockPelvisPoseFiltered.reset();
        }
        if (this.lockChest.getValue() && !this.tools.getConfigurationCommand().isChestTaskspaceEnabled()) {
            this.lockChestPose.setFromReferenceFrame((ReferenceFrame)controllerFullRobotModel.getChest().getBodyFixedFrame());
            this.lockChestPoseFiltered.update();
            this.defaultChestMessage.getDesiredPositionInWorld().set((Tuple3DReadOnly)this.lockChestPoseFiltered.getPosition());
            this.defaultChestMessage.getDesiredOrientationInWorld().set((QuaternionReadOnly)this.lockChestPoseFiltered.getOrientation());
        } else {
            this.lockChestPoseFiltered.reset();
        }
        KinematicsStreamingToolboxInputCommand latestInput = this.tools.getLatestInput();
        if (this.tools.hasUserSubmittedInvalidInput()) {
            this.isStreaming.set(false);
        } else if (latestInput != null) {
            int i;
            this.isStreaming.set(latestInput.getStreamToController());
            if (latestInput.getStreamInitialBlendDuration() > 0.0) {
                this.streamingBlendingDuration.set(latestInput.getStreamInitialBlendDuration());
            } else {
                this.streamingBlendingDuration.set(this.tools.getParameters().getDefaultStreamingBlendingDuration());
            }
            this.isDemonstrationEpisode.set(latestInput.getIsDemonstrationEpisode());
            this.uncontrolledRigidBodies.clear();
            List<? extends RigidBodyBasics> controllableRigidBodies = this.ikController.getControllableRigidBodies();
            for (i = 0; i < controllableRigidBodies.size(); ++i) {
                this.uncontrolledRigidBodies.add(controllableRigidBodies.get(i));
            }
            for (i = 0; i < latestInput.getNumberOfInputs(); ++i) {
                YoDouble startTime;
                KinematicsToolboxRigidBodyCommand rigidBodyInput = latestInput.getInput(i);
                SelectionMatrix6D selectionMatrix = rigidBodyInput.getSelectionMatrix();
                WeightMatrix6D weightMatrix = rigidBodyInput.getWeightMatrix();
                this.setDefaultWeightsIfNeeded(rigidBodyInput, selectionMatrix, weightMatrix);
                RobotSide footSide = KSTStreamingState.getFootSide((RigidBodyReadOnly)rigidBodyInput.getEndEffector(), this.tools.getDesiredFullRobotModel());
                if (footSide != null && this.tools.getStartFootControlNotification(footSide).poll()) {
                    this.rigidBodyControlStartTimeMap.get(rigidBodyInput.getEndEffector()).set(timeInState - this.streamingBlendingDuration.getValue());
                }
                if ((startTime = this.rigidBodyControlStartTimeMap.get(rigidBodyInput.getEndEffector())).isNaN()) {
                    startTime.set(timeInState);
                }
                KSTStreamingState.blendWeightMatrix(rigidBodyInput.getWeightMatrix(), timeInState, startTime.getValue(), this.streamingBlendingDuration.getValue());
                this.uncontrolledRigidBodies.remove(rigidBodyInput.getEndEffector());
            }
            for (i = 0; i < this.uncontrolledRigidBodies.size(); ++i) {
                this.rigidBodyControlStartTimeMap.get(this.uncontrolledRigidBodies.get(i)).setToNaN();
            }
            if (latestInput.hasCenterOfMassInput()) {
                KinematicsToolboxCenterOfMassCommand centerOfMassInput = latestInput.getCenterOfMassInput();
                KSTStreamingState.setDefaultWeightIfNeeded(centerOfMassInput.getSelectionMatrix(), centerOfMassInput.getWeightMatrix(), (Tuple3DReadOnly)this.defaultLinearWeight);
                if (this.centerOfMassControlStartTime.isNaN()) {
                    this.centerOfMassControlStartTime.set(timeInState);
                }
                KSTStreamingState.blendWeightMatrix(centerOfMassInput.getWeightMatrix(), timeInState, this.centerOfMassControlStartTime.getValue(), this.streamingBlendingDuration.getValue());
            } else {
                this.centerOfMassControlStartTime.setToNaN();
            }
            if (!latestInput.getStreamToController() && latestInput.getNumberOfInputs() == 0 && this.tools.hasPreviousInput()) {
                KinematicsStreamingToolboxInputCommand previousInput = this.tools.getPreviousInput();
                latestInput.addInputs(previousInput.getInputs());
                if (previousInput.hasCenterOfMassInput()) {
                    latestInput.setCenterOfMassInput(previousInput.getCenterOfMassInput());
                } else {
                    latestInput.setUseCenterOfMassInput(false);
                }
                this.filteredInputs.set(latestInput);
            } else if (this.tools.hasNewInputCommand()) {
                this.filteredInputs.set(latestInput);
            }
            for (int i2 = this.filteredInputs.getNumberOfInputs() - 1; i2 >= 0; --i2) {
                RigidBodyBasics endEffector = this.filteredInputs.getInput(i2).getEndEffector();
                if (this.lockPelvis.getValue() && endEffector == this.pelvis) {
                    this.filteredInputs.removeInput(i2);
                    continue;
                }
                if (!this.lockChest.getValue() || endEffector != this.chest) continue;
                this.filteredInputs.removeInput(i2);
            }
            if (latestInput.getAngularRateLimitation() > 0.0) {
                this.angularRateLimit.set(latestInput.getAngularRateLimitation());
            } else {
                this.angularRateLimit.set(this.defaultAngularRateLimit.getValue());
            }
            if (latestInput.getLinearRateLimitation() > 0.0) {
                this.linearRateLimit.set(latestInput.getLinearRateLimitation());
            } else {
                this.linearRateLimit.set(this.defaultLinearRateLimit.getValue());
            }
            for (KSTInputStateEstimator inputStateEstimator : this.inputStateEstimators) {
                inputStateEstimator.update(this.tools.getTime(), this.tools.hasNewInputCommand(), this.linearRateLimit.getValue(), this.angularRateLimit.getValue(), this.filteredInputs, this.tools.getPreviousInput());
            }
            for (int i3 = 0; i3 < this.filteredInputs.getNumberOfInputs(); ++i3) {
                KinematicsToolboxRigidBodyCommand filteredInput = this.filteredInputs.getInput(i3);
                KSTInputStateEstimator inputStateEstimator = this.inputStateEstimatorsMap.get(this.activeInputStateEstimator.getValue());
                FramePose3DReadOnly estimatedPose = inputStateEstimator.getEstimatedPose((RigidBodyReadOnly)filteredInput.getEndEffector());
                SpatialVectorReadOnly estimatedVelocity = inputStateEstimator.getEstimatedVelocity((RigidBodyReadOnly)filteredInput.getEndEffector());
                if (estimatedPose != null) {
                    filteredInput.getDesiredPose().set(estimatedPose);
                }
                if (estimatedVelocity != null) {
                    filteredInput.getDesiredVelocity().set(estimatedVelocity);
                }
                this.ikCommandInputManager.submitCommand((Command)filteredInput);
            }
            if (this.filteredInputs.hasCenterOfMassInput()) {
                KinematicsToolboxCenterOfMassCommand centerOfMassInput = this.filteredInputs.getCenterOfMassInput();
                KSTInputStateEstimator inputStateEstimator = this.inputStateEstimatorsMap.get(this.activeInputStateEstimator.getValue());
                FramePoint3DReadOnly estimatedPose = inputStateEstimator.getEstimatedCoMPosition();
                FrameVector3DReadOnly estimatedVelocity = inputStateEstimator.getEstimatedCoMVelocity();
                if (estimatedPose != null) {
                    centerOfMassInput.getDesiredPosition().set((FrameTuple3DReadOnly)estimatedPose);
                }
                if (estimatedVelocity != null) {
                    centerOfMassInput.getDesiredVelocity().set((FrameTuple3DReadOnly)estimatedVelocity);
                }
                this.ikCommandInputManager.submitCommand((Command)centerOfMassInput);
            }
            if (!latestInput.hasInputFor(this.head)) {
                this.ikCommandInputManager.submitMessages(this.defaultNeckJointMessages);
            }
            if (!latestInput.hasInputFor(this.pelvis) || this.lockPelvis.getValue()) {
                this.ikCommandInputManager.submitMessage((Settable)this.defaultPelvisMessage);
            }
            if (!latestInput.hasInputFor(this.chest) || this.lockChest.getValue()) {
                this.ikCommandInputManager.submitMessage((Settable)this.defaultChestMessage);
            }
            RobotSide[] robotSideArray = RobotSide.values;
            int n = robotSideArray.length;
            for (int estimatedPose = 0; estimatedPose < n; ++estimatedPose) {
                RobotSide robotSide = robotSideArray[estimatedPose];
                if (this.hands.get((Enum)robotSide) == null || latestInput.hasInputFor((RigidBodyBasics)this.hands.get((Enum)robotSide))) continue;
                this.ikCommandInputManager.submitMessages((List)this.defaultArmJointMessages.get((Enum)robotSide));
            }
            if (this.tools.hasPreviousInput()) {
                this.handleInputsDecay(latestInput, this.tools.getPreviousInput());
                this.ikCommandInputManager.submitCommands(this.decayingInputs);
            }
        }
        this.ikSolverSpatialGains.setPositionMaxFeedbackAndFeedbackRate(this.linearRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverSpatialGains.setOrientationMaxFeedbackAndFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikSolverJointGains.setMaximumFeedbackAndMaximumFeedbackRate(this.angularRateLimit.getValue(), Double.POSITIVE_INFINITY);
        this.ikController.updateInternal();
        if (this.tools.hasNewInputCommand()) {
            if (Double.isFinite(this.timeSinceLastInput.getValue()) && this.timeSinceLastInput.getValue() > 0.0) {
                this.rawInputFrequency.set(1.0 / this.timeSinceLastInput.getValue());
                this.inputFrequency.update();
            }
            this.timeOfLastInput.set(timeInState);
        }
        if (Double.isFinite(this.timeOfLastInput.getValue())) {
            this.timeSinceLastInput.set(timeInState - this.timeOfLastInput.getValue());
        }
        if (latestInput != null) {
            if (latestInput.hasInputFor(this.head)) {
                KSTTools.copyJointDesiredPositions((OneDoFJointReadOnly[])this.neckJoints, this.defaultNeckJointMessages);
            }
            for (RobotSide robotSide : RobotSide.values) {
                if (this.hands.get((Enum)robotSide) == null || !latestInput.hasInputFor((RigidBodyBasics)this.hands.get((Enum)robotSide))) continue;
                KSTTools.copyJointDesiredPositions((OneDoFJointReadOnly[])this.armJoints.get((Enum)robotSide), (List)this.defaultArmJointMessages.get((Enum)robotSide));
            }
        }
        if (this.isStreaming.getValue()) {
            this.isPublishing.set(timeInState - this.timeOfLastMessageSentToController.getValue() >= this.publishingPeriod.getValue());
            if (this.isPublishing.getValue()) {
                this.timeOfLastMessageSentToController.set(timeInState);
            }
        } else if (this.wasStreaming.getValue()) {
            this.isPublishing.set(true);
            this.timeOfLastMessageSentToController.set(timeInState);
        } else {
            this.isPublishing.set(false);
            this.timeOfLastMessageSentToController.set(Double.NEGATIVE_INFINITY);
        }
        this.outputProcessor.update(timeInState, this.wasStreaming.getValue(), this.isStreaming.getValue(), this.ikSolution);
        if (this.isPublishing.getValue()) {
            this.tools.streamToController(this.outputProcessor.getProcessedOutput(), !this.isStreaming.getValue());
        }
        this.wasStreaming.set(this.isStreaming.getValue());
    }

    private void handleInputsDecay(KinematicsStreamingToolboxInputCommand latestInputs, KinematicsStreamingToolboxInputCommand previousInputs) {
        KinematicsToolboxRigidBodyCommand decayingInput;
        int i;
        for (i = this.decayingInputs.size() - 1; i >= 0; --i) {
            decayingInput = (KinematicsToolboxRigidBodyCommand)this.decayingInputs.get(i);
            String rigidBodyName = decayingInput.getEndEffector().getName();
            boolean isLeftFoot = rigidBodyName.contains(((RigidBodyBasics)this.feet.get((Enum)RobotSide.LEFT)).getName());
            boolean isRightFoot = rigidBodyName.contains(((RigidBodyBasics)this.feet.get((Enum)RobotSide.RIGHT)).getName());
            if (!latestInputs.hasInputFor(decayingInput.getEndEffector()) && (!isLeftFoot || !this.tools.isFootInSupport(RobotSide.LEFT)) && (!isRightFoot || !this.tools.isFootInSupport(RobotSide.RIGHT))) continue;
            this.decayingInputs.remove(i);
        }
        for (i = 0; i < previousInputs.getNumberOfInputs(); ++i) {
            KinematicsToolboxRigidBodyCommand previousInput = previousInputs.getInput(i);
            if (latestInputs.hasInputFor(previousInput.getEndEffector())) continue;
            boolean addInputToDecay = true;
            for (int j = 0; j < this.decayingInputs.size(); ++j) {
                if (previousInput.getEndEffector() != ((KinematicsToolboxRigidBodyCommand)this.decayingInputs.get(j)).getEndEffector()) continue;
                addInputToDecay = false;
                break;
            }
            if (!addInputToDecay) continue;
            ((KinematicsToolboxRigidBodyCommand)this.decayingInputs.add()).set(previousInput);
        }
        for (i = this.decayingInputs.size() - 1; i >= 0; --i) {
            decayingInput = (KinematicsToolboxRigidBodyCommand)this.decayingInputs.get(i);
            decayingInput.getWeightMatrix().scale(this.inputWeightDecayFactor.getValue());
            if (!(KSTStreamingState.findMaximumWeightValue(decayingInput.getWeightMatrix()) < 0.1)) continue;
            this.decayingInputs.remove(i);
        }
        this.numberOfDecayingInputs.set(this.decayingInputs.size());
    }

    private static double findMaximumWeightValue(WeightMatrix6D weightMatrix) {
        return Math.max(KSTStreamingState.findMaximumWeightValue(weightMatrix.getAngularPart()), KSTStreamingState.findMaximumWeightValue(weightMatrix.getLinearPart()));
    }

    private static double findMaximumWeightValue(WeightMatrix3D weightMatrix) {
        return EuclidCoreTools.max((double)weightMatrix.getX(), (double)weightMatrix.getY(), (double)weightMatrix.getZ());
    }

    private void setDefaultWeightsIfNeeded(KinematicsToolboxRigidBodyCommand rigidBodyInput, SelectionMatrix6D selectionMatrix, WeightMatrix6D weightMatrix) {
        Vector3DReadOnly defaultAngularWeight;
        Vector3DReadOnly defaultLinearWeight = (Vector3DReadOnly)this.defaultLinearWeightMap.get(rigidBodyInput.getEndEffector().getName());
        if (defaultLinearWeight == null) {
            defaultLinearWeight = this.defaultLinearWeight;
        }
        if ((defaultAngularWeight = (Vector3DReadOnly)this.defaultAngularWeightMap.get(rigidBodyInput.getEndEffector().getName())) == null) {
            defaultAngularWeight = this.defaultAngularWeight;
        }
        KSTStreamingState.setDefaultWeightIfNeeded(selectionMatrix.getLinearPart(), weightMatrix.getLinearPart(), (Tuple3DReadOnly)defaultLinearWeight);
        KSTStreamingState.setDefaultWeightIfNeeded(selectionMatrix.getAngularPart(), weightMatrix.getAngularPart(), (Tuple3DReadOnly)defaultAngularWeight);
    }

    private static void setDefaultWeightIfNeeded(SelectionMatrix3D selectionMatrix, WeightMatrix3D weightMatrix, Tuple3DReadOnly defaultWeight) {
        if (selectionMatrix.isXSelected() && (Double.isNaN(weightMatrix.getX()) || weightMatrix.getX() <= 0.0)) {
            weightMatrix.setXAxisWeight(defaultWeight.getX());
        }
        if (selectionMatrix.isYSelected() && (Double.isNaN(weightMatrix.getY()) || weightMatrix.getY() <= 0.0)) {
            weightMatrix.setYAxisWeight(defaultWeight.getY());
        }
        if (selectionMatrix.isZSelected() && (Double.isNaN(weightMatrix.getZ()) || weightMatrix.getZ() <= 0.0)) {
            weightMatrix.setZAxisWeight(defaultWeight.getZ());
        }
    }

    private static void blendWeightMatrix(WeightMatrix6D weightMatrix, double currentTime, double startTime, double blendingDuration) {
        KSTStreamingState.blendWeightMatrix(weightMatrix.getLinearPart(), currentTime, startTime, blendingDuration);
        KSTStreamingState.blendWeightMatrix(weightMatrix.getAngularPart(), currentTime, startTime, blendingDuration);
    }

    private static void blendWeightMatrix(WeightMatrix3D weightMatrix, double currentTime, double startTime, double blendingDuration) {
        double controlDuration = currentTime - startTime;
        if (controlDuration < blendingDuration) {
            double blendingFactor = MathTools.clamp((double)(controlDuration / blendingDuration), (double)0.0, (double)1.0);
            weightMatrix.scale(blendingFactor);
        }
    }

    private static RobotSide getFootSide(RigidBodyReadOnly rigidBody, FullHumanoidRobotModel fullHumanoidRobotModel) {
        for (RobotSide robotSide : RobotSide.values) {
            if (!rigidBody.equals(fullHumanoidRobotModel.getFoot((Enum)robotSide))) continue;
            return robotSide;
        }
        return null;
    }

    public void onExit(double timeInState) {
        this.tools.flushInputCommands();
    }
}

