/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import controller_msgs.msg.dds.JointspaceStreamingMessage;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import ihmc_common_msgs.msg.dds.EuclideanStreamingMessage;
import ihmc_common_msgs.msg.dds.SE3StreamingMessage;
import ihmc_common_msgs.msg.dds.SO3StreamingMessage;
import java.util.function.BiConsumer;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KSTTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class KSTStreamingMessageFactory {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final FullHumanoidRobotModel fullRobotModel;
    private final HumanoidReferenceFrames referenceFrames;
    private final SpatialAccelerationCalculator spatialAccelerationCalculator;
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final OneDoFJointBasics[] neckJoints;
    private final OneDoFJointBasics[] spineJoints;
    private final SideDependentList<OneDoFJointBasics[]> armJoints = new SideDependentList();
    private final SideDependentList<OneDoFJointBasics[]> legJoints = new SideDependentList();
    private final YoBoolean enableVelocity = new YoBoolean("enableVelocity", this.registry);
    private final YoBoolean enableAcceleration = new YoBoolean("enableAcceleration", this.registry);
    private final WholeBodyStreamingMessage output = new WholeBodyStreamingMessage();
    private final YoJointspaceStreamingMessage yoNeckStreamingMessage;
    private final YoJointspaceStreamingMessage yoSpineStreamingMessage;
    private final SideDependentList<YoJointspaceStreamingMessage> yoArmStreamingMessages = new SideDependentList();
    private final SideDependentList<YoJointspaceStreamingMessage> yoLegStreamingMessages = new SideDependentList();
    private final YoEuclideanStreamingMessage yoCenterOfMassStreamingMessage;
    private final YoSE3StreamingMessage yoPelvisStreamingMessage;
    private final YoSO3StreamingMessage yoChestStreamingMessage;
    private final SideDependentList<YoSE3StreamingMessage> yoHandStreamingMessages = new SideDependentList();
    private final FramePose3D desiredPose = new FramePose3D(worldFrame);
    private final SpatialVector desiredSpatialVelocity = new SpatialVector();
    private final SpatialVector desiredSpatialAcceleration = new SpatialVector();
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    private final FrameVector3D desiredAngularAcceleration = new FrameVector3D();

    public KSTStreamingMessageFactory(FullHumanoidRobotModelFactory fullRobotModelFactory, YoRegistry parentRegistry) {
        this.fullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.rootJoint = this.fullRobotModel.getRootJoint();
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        this.spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)this.fullRobotModel.getElevator(), worldFrame);
        RigidBodyBasics head = this.fullRobotModel.getHead();
        RigidBodyBasics chest = this.fullRobotModel.getChest();
        RigidBodyBasics pelvis = this.fullRobotModel.getPelvis();
        if (head == null) {
            this.neckJoints = null;
            this.yoNeckStreamingMessage = null;
        } else {
            this.neckJoints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)chest, (RigidBodyBasics)head);
            this.yoNeckStreamingMessage = new YoJointspaceStreamingMessage((OneDoFJointReadOnly[])this.neckJoints);
        }
        this.spineJoints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)pelvis, (RigidBodyBasics)chest);
        this.yoSpineStreamingMessage = new YoJointspaceStreamingMessage((OneDoFJointReadOnly[])this.spineJoints);
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.fullRobotModel.getFoot((Enum)robotSide);
            this.legJoints.put((Enum)robotSide, (Object)MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)pelvis, (RigidBodyBasics)foot));
            this.yoLegStreamingMessages.put((Enum)robotSide, (Object)new YoJointspaceStreamingMessage((OneDoFJointReadOnly[])this.legJoints.get((Enum)robotSide)));
            RigidBodyBasics hand = this.fullRobotModel.getHand(robotSide);
            if (hand == null) continue;
            this.armJoints.put((Enum)robotSide, (Object)MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)chest, (RigidBodyBasics)hand));
            this.yoArmStreamingMessages.put((Enum)robotSide, (Object)new YoJointspaceStreamingMessage((OneDoFJointReadOnly[])this.armJoints.get((Enum)robotSide)));
            this.yoHandStreamingMessages.put((Enum)robotSide, (Object)new YoSE3StreamingMessage((RigidBodyReadOnly)hand, this.registry));
        }
        this.yoCenterOfMassStreamingMessage = new YoEuclideanStreamingMessage("com", this.registry);
        this.yoPelvisStreamingMessage = new YoSE3StreamingMessage((RigidBodyReadOnly)pelvis, this.registry);
        this.yoChestStreamingMessage = new YoSO3StreamingMessage((RigidBodyReadOnly)chest, this.registry);
        parentRegistry.addChild(this.registry);
    }

    public WholeBodyStreamingMessage getOutput() {
        return this.output;
    }

    public void update(long id, long timestamp, double streamIntegrationDuration, BiConsumer<FloatingJointBasics, OneDoFJointBasics[]> robotUpdater) {
        HumanoidMessageTools.resetWholeBodyStreamingMessage((WholeBodyStreamingMessage)this.output);
        robotUpdater.accept(this.rootJoint, this.oneDoFJoints);
        this.referenceFrames.updateFrames();
        this.spatialAccelerationCalculator.reset();
        this.output.setStreamIntegrationDuration((float)streamIntegrationDuration);
        this.output.setEnableUserPelvisControl(true);
        this.output.setTimestamp(timestamp);
        this.output.setSequenceId(id);
        this.output.setUniqueId(id);
    }

    public void setEnableVelocity(boolean enable) {
        this.enableVelocity.set(enable);
    }

    public void setEnableAcceleration(boolean enable) {
        this.enableAcceleration.set(enable);
    }

    public void computeArmStreamingMessages() {
        this.checkIfDataHasBeenSet();
        for (RobotSide robotSide : RobotSide.values) {
            this.computeArmStreamingMessage(robotSide);
        }
    }

    public void computeArmStreamingMessage(RobotSide robotSide) {
        this.checkIfDataHasBeenSet();
        if (this.armJoints.get((Enum)robotSide) == null) {
            return;
        }
        JointspaceStreamingMessage streamingMessage = KSTStreamingMessageFactory.select(robotSide, this.output.getLeftArmStreamingMessage(), this.output.getRightArmStreamingMessage());
        KSTStreamingMessageFactory.computeJointspaceMessage((OneDoFJointReadOnly[])this.armJoints.get((Enum)robotSide), this.enableVelocity.getValue(), this.enableAcceleration.getValue(), this.output.getStreamIntegrationDuration(), streamingMessage);
        ((YoJointspaceStreamingMessage)this.yoArmStreamingMessages.get((Enum)robotSide)).setFromMessage(streamingMessage);
        if (robotSide == RobotSide.LEFT) {
            this.output.setHasLeftArmStreamingMessage(true);
        } else {
            this.output.setHasRightArmStreamingMessage(true);
        }
    }

    public void computeLegStreamingMessage(RobotSide robotSide) {
        this.checkIfDataHasBeenSet();
        if (this.legJoints.get((Enum)robotSide) == null) {
            return;
        }
        JointspaceStreamingMessage streamingMessage = KSTStreamingMessageFactory.select(robotSide, this.output.getLeftLegStreamingMessage(), this.output.getRightLegStreamingMessage());
        KSTStreamingMessageFactory.computeJointspaceMessage((OneDoFJointReadOnly[])this.legJoints.get((Enum)robotSide), this.enableVelocity.getValue(), this.enableAcceleration.getValue(), this.output.getStreamIntegrationDuration(), streamingMessage);
        ((YoJointspaceStreamingMessage)this.yoLegStreamingMessages.get((Enum)robotSide)).setFromMessage(streamingMessage);
        if (robotSide == RobotSide.LEFT) {
            this.output.setHasLeftLegStreamingMessage(true);
        } else {
            this.output.setHasRightLegStreamingMessage(true);
        }
    }

    public void computeHandStreamingMessages() {
        for (RobotSide robotSide : RobotSide.values) {
            this.computeHandStreamingMessage(robotSide);
        }
    }

    public void computeHandStreamingMessage(RobotSide robotSide) {
        this.computeHandStreamingMessage(robotSide, worldFrame);
    }

    public void computeHandStreamingMessage(RobotSide robotSide, ReferenceFrame trajectoryFrame) {
        this.computeHandStreamingMessage(robotSide, trajectoryFrame.getFrameNameHashCode());
    }

    public void computeHandStreamingMessage(RobotSide robotSide, long trajectoryFrameId) {
        this.checkIfDataHasBeenSet();
        RigidBodyBasics hand = this.fullRobotModel.getHand(robotSide);
        if (hand == null) {
            return;
        }
        MovingReferenceFrame handBodyFixedFrame = hand.getBodyFixedFrame();
        MovingReferenceFrame handControlFrame = this.fullRobotModel.getHandControlFrame(robotSide);
        this.desiredPose.setToZero((ReferenceFrame)handControlFrame);
        this.desiredPose.changeFrame((ReferenceFrame)handBodyFixedFrame);
        KSTStreamingMessageFactory.spatialVelocity(handControlFrame, worldFrame, this.enableVelocity.getValue(), (SpatialVectorBasics)this.desiredSpatialVelocity);
        KSTStreamingMessageFactory.spatialAcceleration((RigidBodyReadOnly)hand, (FramePoint3DReadOnly)this.desiredPose.getPosition(), worldFrame, this.spatialAccelerationCalculator, this.enableAcceleration.getValue(), (SpatialVectorBasics)this.desiredSpatialAcceleration);
        this.desiredPose.changeFrame(worldFrame);
        SE3StreamingMessage handStreamingMessage = KSTStreamingMessageFactory.select(robotSide, this.output.getLeftHandStreamingMessage(), this.output.getRightHandStreamingMessage());
        KSTStreamingMessageFactory.packCustomControlFrame((ReferenceFrame)handBodyFixedFrame, (ReferenceFrame)handControlFrame, handStreamingMessage);
        handStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId(trajectoryFrameId);
        handStreamingMessage.getFrameInformation().setDataReferenceFrameId((long)worldFrame.getFrameNameHashCode());
        KSTStreamingMessageFactory.packSE3TrajectoryPointMessage((Pose3DReadOnly)this.desiredPose, (SpatialVectorReadOnly)this.desiredSpatialVelocity, (SpatialVectorReadOnly)this.desiredSpatialAcceleration, handStreamingMessage);
        ((YoSE3StreamingMessage)this.yoHandStreamingMessages.get((Enum)robotSide)).setFromMessage(handStreamingMessage);
        if (robotSide == RobotSide.LEFT) {
            this.output.setHasLeftHandStreamingMessage(true);
        } else {
            this.output.setHasRightHandStreamingMessage(true);
        }
    }

    public void computeSpineStreamingMessage() {
        this.checkIfDataHasBeenSet();
        KSTStreamingMessageFactory.computeJointspaceMessage((OneDoFJointReadOnly[])this.spineJoints, this.enableVelocity.getValue(), this.enableAcceleration.getValue(), this.output.getStreamIntegrationDuration(), this.output.getSpineStreamingMessage());
        this.yoSpineStreamingMessage.setFromMessage(this.output.getSpineStreamingMessage());
        this.output.setHasSpineStreamingMessage(true);
    }

    public void computeNeckStreamingMessage() {
        if (this.neckJoints == null) {
            return;
        }
        this.checkIfDataHasBeenSet();
        KSTStreamingMessageFactory.computeJointspaceMessage((OneDoFJointReadOnly[])this.neckJoints, this.enableVelocity.getValue(), this.enableAcceleration.getValue(), this.output.getStreamIntegrationDuration(), this.output.getNeckStreamingMessage());
        this.yoNeckStreamingMessage.setFromMessage(this.output.getNeckStreamingMessage());
        this.output.setHasNeckStreamingMessage(true);
    }

    public void computeChestStreamingMessage() {
        this.computeChestStreamingMessage((ReferenceFrame)this.referenceFrames.getPelvisZUpFrame());
    }

    public void computeChestStreamingMessage(ReferenceFrame trajectoryFrame) {
        this.computeChestStreamingMessage(trajectoryFrame.getFrameNameHashCode());
    }

    public void computeChestStreamingMessage(long trajectoryFrameId) {
        this.checkIfDataHasBeenSet();
        RigidBodyBasics chest = this.fullRobotModel.getChest();
        MovingReferenceFrame chestBodyFixedFrame = chest.getBodyFixedFrame();
        this.desiredOrientation.setToZero((ReferenceFrame)chestBodyFixedFrame);
        this.desiredOrientation.changeFrame(worldFrame);
        KSTStreamingMessageFactory.angularVelocity(chestBodyFixedFrame, worldFrame, this.enableVelocity.getValue(), (FrameVector3DBasics)this.desiredAngularVelocity);
        KSTStreamingMessageFactory.angularAcceleration((RigidBodyReadOnly)chest, worldFrame, this.spatialAccelerationCalculator, this.enableAcceleration.getValue(), (FrameVector3DBasics)this.desiredAngularAcceleration);
        if (this.enableAcceleration.getValue()) {
            KSTStreamingMessageFactory.clampMaxAngularAcceleration((Vector3DReadOnly)this.desiredAngularVelocity, (Vector3DBasics)this.desiredAngularAcceleration, this.output.getStreamIntegrationDuration());
        } else if (this.enableVelocity.getValue()) {
            KSTStreamingMessageFactory.clampMaxAngularVelocity((Vector3DBasics)this.desiredAngularVelocity, this.output.getStreamIntegrationDuration());
        }
        SO3StreamingMessage chestStreamingMessage = this.output.getChestStreamingMessage();
        chestStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId(trajectoryFrameId);
        chestStreamingMessage.getFrameInformation().setDataReferenceFrameId((long)worldFrame.getFrameNameHashCode());
        KSTStreamingMessageFactory.packSO3TrajectoryPointMessage((Orientation3DReadOnly)this.desiredOrientation, (Vector3DReadOnly)this.desiredAngularVelocity, (Vector3DReadOnly)this.desiredAngularAcceleration, chestStreamingMessage);
        this.yoChestStreamingMessage.setFromMessage(chestStreamingMessage);
        this.output.setHasChestStreamingMessage(true);
    }

    public void computePelvisStreamingMessage() {
        this.computePelvisStreamingMessage(worldFrame);
    }

    public void computePelvisStreamingMessage(ReferenceFrame trajectoryFrame) {
        this.computePelvisStreamingMessage(trajectoryFrame.getFrameNameHashCode());
    }

    public void computePelvisStreamingMessage(long trajectoryFrameId) {
        this.checkIfDataHasBeenSet();
        RigidBodyBasics pelvis = this.fullRobotModel.getPelvis();
        MovingReferenceFrame pelvisBodyFixedFrame = pelvis.getBodyFixedFrame();
        MovingReferenceFrame pelvisControlFrame = this.fullRobotModel.getRootJoint().getFrameAfterJoint();
        this.desiredPose.setToZero((ReferenceFrame)pelvisControlFrame);
        this.desiredPose.changeFrame((ReferenceFrame)pelvisBodyFixedFrame);
        KSTStreamingMessageFactory.spatialVelocity(pelvisControlFrame, worldFrame, this.enableVelocity.getValue(), (SpatialVectorBasics)this.desiredSpatialVelocity);
        KSTStreamingMessageFactory.spatialAcceleration((RigidBodyReadOnly)pelvis, (FramePoint3DReadOnly)this.desiredPose.getPosition(), worldFrame, this.spatialAccelerationCalculator, this.enableAcceleration.getValue(), (SpatialVectorBasics)this.desiredSpatialAcceleration);
        this.desiredPose.changeFrame(worldFrame);
        if (this.enableAcceleration.getValue()) {
            KSTStreamingMessageFactory.clampMaxAngularAcceleration((Vector3DReadOnly)this.desiredSpatialVelocity.getAngularPart(), (Vector3DBasics)this.desiredSpatialAcceleration.getAngularPart(), this.output.getStreamIntegrationDuration());
        } else if (this.enableVelocity.getValue()) {
            KSTStreamingMessageFactory.clampMaxAngularVelocity((Vector3DBasics)this.desiredSpatialVelocity.getAngularPart(), this.output.getStreamIntegrationDuration());
        }
        SE3StreamingMessage pelvisStreamingMessage = this.output.getPelvisStreamingMessage();
        pelvisStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId(trajectoryFrameId);
        pelvisStreamingMessage.getFrameInformation().setDataReferenceFrameId((long)worldFrame.getFrameNameHashCode());
        KSTStreamingMessageFactory.packSE3TrajectoryPointMessage((Pose3DReadOnly)this.desiredPose, (SpatialVectorReadOnly)this.desiredSpatialVelocity, (SpatialVectorReadOnly)this.desiredSpatialAcceleration, pelvisStreamingMessage);
        this.yoPelvisStreamingMessage.setFromMessage(pelvisStreamingMessage);
        this.output.setHasPelvisStreamingMessage(true);
    }

    public void computeCenterOfMassStreamingMessage() {
        this.checkIfDataHasBeenSet();
        this.desiredPose.setToZero(this.referenceFrames.getCenterOfMassFrame());
        this.desiredPose.changeFrame(worldFrame);
        KSTStreamingMessageFactory.spatialVelocity((MovingReferenceFrame)this.referenceFrames.getCenterOfMassFrame(), worldFrame, this.enableVelocity.getValue(), (SpatialVectorBasics)this.desiredSpatialVelocity);
        EuclideanStreamingMessage centerOfMassStreamingMessage = this.output.getCenterOfMassTrajectoryMessage();
        centerOfMassStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId((long)worldFrame.getFrameNameHashCode());
        centerOfMassStreamingMessage.getFrameInformation().setDataReferenceFrameId((long)worldFrame.getFrameNameHashCode());
        KSTStreamingMessageFactory.packEuclideanTrajectoryPointMessage((Point3DReadOnly)this.desiredPose.getPosition(), (FrameVector3DReadOnly)this.desiredSpatialVelocity.getLinearPart(), centerOfMassStreamingMessage);
        this.yoCenterOfMassStreamingMessage.setFromMessage(centerOfMassStreamingMessage);
        this.output.setHasCenterOfMassTrajectoryMessage(true);
    }

    private static <T> T select(RobotSide robotSide, T left, T right) {
        return robotSide == RobotSide.LEFT ? left : right;
    }

    private static void computeJointspaceMessage(OneDoFJointReadOnly[] joints, boolean enableVelocity, boolean enableAcceleration, double integrationDuration, JointspaceStreamingMessage messageToPack) {
        messageToPack.getPositions().reset();
        messageToPack.getVelocities().reset();
        messageToPack.getAccelerations().reset();
        for (OneDoFJointReadOnly joint : joints) {
            double qdd;
            double qd;
            double epsilon = 1.0E-5;
            double qMin = joint.getJointLimitLower() + epsilon;
            double qMax = joint.getJointLimitUpper() - epsilon;
            double q = MathTools.clamp((double)joint.getQ(), (double)qMin, (double)qMax);
            if (enableVelocity) {
                if (enableAcceleration) {
                    qd = joint.getQd();
                    double qddMin = KSTTools.computeJointMinAcceleration(qMin, q, qd, integrationDuration);
                    double qddMax = KSTTools.computeJointMaxAcceleration(qMax, q, qd, integrationDuration);
                    qdd = MathTools.clamp((double)joint.getQdd(), (double)qddMin, (double)qddMax);
                } else {
                    double qdMax = KSTTools.computeJointMaxVelocity(qMax, q, integrationDuration);
                    double qdMin = KSTTools.computeJointMinVelocity(qMin, q, integrationDuration);
                    qd = MathTools.clamp((double)joint.getQd(), (double)qdMin, (double)qdMax);
                    qdd = 0.0;
                }
            } else {
                qd = 0.0;
                qdd = 0.0;
            }
            messageToPack.getPositions().add((float)q);
            messageToPack.getVelocities().add((float)qd);
            messageToPack.getAccelerations().add((float)qdd);
        }
    }

    private static void clampMaxAngularVelocity(Vector3DBasics angularVelocityToPack, double streamIntegrationDuration) {
        double maxAngularVelocity = 3.1405926535897932 / streamIntegrationDuration;
        angularVelocityToPack.clipToMaxNorm(maxAngularVelocity);
    }

    private static void clampMaxAngularAcceleration(Vector3DReadOnly angularVelocity, Vector3DBasics angularAccelerationToPack, double streamIntegrationDuration) {
        double rotX = angularVelocity.getX() + 0.5 * streamIntegrationDuration * angularAccelerationToPack.getX();
        double rotY = angularVelocity.getY() + 0.5 * streamIntegrationDuration * angularAccelerationToPack.getY();
        double rotZ = angularVelocity.getZ() + 0.5 * streamIntegrationDuration * angularAccelerationToPack.getZ();
        double maxRot = 3.1405926535897932 / streamIntegrationDuration;
        double normRot = EuclidCoreTools.norm((double)rotX, (double)rotY, (double)rotZ);
        if (normRot > maxRot) {
            angularAccelerationToPack.set((rotX *= maxRot / normRot) - angularVelocity.getX(), (rotY *= maxRot / normRot) - angularVelocity.getY(), (rotZ *= maxRot / normRot) - angularVelocity.getZ());
            angularAccelerationToPack.scale(2.0 / streamIntegrationDuration);
        }
    }

    private static void angularVelocity(MovingReferenceFrame movingFrame, ReferenceFrame outputFrame, boolean enableVelocity, FrameVector3DBasics angularVelocityToPack) {
        if (!enableVelocity) {
            angularVelocityToPack.setToZero(outputFrame);
        } else {
            angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)movingFrame.getTwistOfFrame().getAngularPart());
            angularVelocityToPack.changeFrame(outputFrame);
        }
    }

    private static void angularAcceleration(RigidBodyReadOnly endEffector, ReferenceFrame outputFrame, SpatialAccelerationCalculator spatialAccelerationCalculator, boolean enableAcceleration, FrameVector3DBasics angularAccelerationToPack) {
        if (!enableAcceleration) {
            angularAccelerationToPack.setToZero(outputFrame);
        } else {
            SpatialAccelerationReadOnly endEffectorAcceleration = spatialAccelerationCalculator.getAccelerationOfBody(endEffector);
            angularAccelerationToPack.setIncludingFrame((FrameTuple3DReadOnly)endEffectorAcceleration.getAngularPart());
            angularAccelerationToPack.changeFrame(outputFrame);
        }
    }

    private static void spatialVelocity(MovingReferenceFrame movingFrame, ReferenceFrame outputFrame, boolean enableVelocity, SpatialVectorBasics spatialVelocityToPack) {
        if (!enableVelocity) {
            spatialVelocityToPack.setToZero(outputFrame);
        } else {
            spatialVelocityToPack.setIncludingFrame((SpatialVectorReadOnly)movingFrame.getTwistOfFrame());
            spatialVelocityToPack.changeFrame(outputFrame);
        }
    }

    private static void spatialAcceleration(RigidBodyReadOnly endEffector, FramePoint3DReadOnly controlPoint, ReferenceFrame outputFrame, SpatialAccelerationCalculator spatialAccelerationCalculator, boolean enableAcceleration, SpatialVectorBasics spatialAccelerationToPack) {
        if (!enableAcceleration) {
            spatialAccelerationToPack.setToZero(outputFrame);
        } else {
            SpatialAccelerationReadOnly endEffectorAcceleration = spatialAccelerationCalculator.getAccelerationOfBody(endEffector);
            spatialAccelerationToPack.setReferenceFrame((ReferenceFrame)endEffector.getBodyFixedFrame());
            endEffectorAcceleration.getLinearAccelerationAt(endEffector.getBodyFixedFrame().getTwistOfFrame(), controlPoint, spatialAccelerationToPack.getLinearPart());
            spatialAccelerationToPack.getAngularPart().set((FrameTuple3DReadOnly)endEffectorAcceleration.getAngularPart());
            spatialAccelerationToPack.changeFrame(outputFrame);
        }
    }

    public static void packCustomControlFrame(ReferenceFrame endEffectorFrame, ReferenceFrame controlFrame, SE3StreamingMessage messageToPack) {
        messageToPack.setUseCustomControlFrame(true);
        Pose3D controlFramePose = messageToPack.getControlFramePose();
        controlFramePose.setToZero();
        controlFrame.transformFromThisToDesiredFrame(endEffectorFrame, (Transformable)controlFramePose);
    }

    public static void packSO3TrajectoryPointMessage(Orientation3DReadOnly orientation, Vector3DReadOnly angularVelocity, Vector3DReadOnly angularAcceleration, SO3StreamingMessage messageToPack) {
        messageToPack.getOrientation().set(orientation);
        messageToPack.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        messageToPack.getAngularAcceleration().set((Tuple3DReadOnly)angularAcceleration);
    }

    public static void packSE3TrajectoryPointMessage(Pose3DReadOnly pose, SpatialVectorReadOnly spatialVelocity, SpatialVectorReadOnly spatialAcceleration, SE3StreamingMessage messageToPack) {
        messageToPack.getPosition().set((Tuple3DReadOnly)pose.getPosition());
        messageToPack.getOrientation().set(pose.getOrientation());
        messageToPack.getLinearVelocity().set((Tuple3DReadOnly)spatialVelocity.getLinearPart());
        messageToPack.getAngularVelocity().set((Tuple3DReadOnly)spatialVelocity.getAngularPart());
        messageToPack.getLinearAcceleration().set((Tuple3DReadOnly)spatialAcceleration.getLinearPart());
        messageToPack.getAngularAcceleration().set((Tuple3DReadOnly)spatialAcceleration.getAngularPart());
    }

    public static void packEuclideanTrajectoryPointMessage(Point3DReadOnly position, FrameVector3DReadOnly linearVelocity, EuclideanStreamingMessage messageToPack) {
        messageToPack.getPosition().set((Tuple3DReadOnly)position);
        messageToPack.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    private void checkIfDataHasBeenSet() {
        if (this.output == null) {
            throw new RuntimeException("Need to call setMessageToCreate() first.");
        }
    }

    public FloatingJointBasics getRootJoint() {
        return this.rootJoint;
    }

    public OneDoFJointBasics[] getOneDoFJoints() {
        return this.oneDoFJoints;
    }

    private class YoJointspaceStreamingMessage {
        private final YoDouble[] jointPositions;
        private final YoDouble[] jointVelocities;
        private final YoDouble[] jointAccelerations;

        public YoJointspaceStreamingMessage(OneDoFJointReadOnly[] joints) {
            this.jointPositions = new YoDouble[joints.length];
            this.jointVelocities = new YoDouble[joints.length];
            this.jointAccelerations = new YoDouble[joints.length];
            for (int i = 0; i < joints.length; ++i) {
                this.jointPositions[i] = new YoDouble(joints[i].getName() + "PositionMSG", KSTStreamingMessageFactory.this.registry);
                this.jointVelocities[i] = new YoDouble(joints[i].getName() + "VelocityMSG", KSTStreamingMessageFactory.this.registry);
                this.jointAccelerations[i] = new YoDouble(joints[i].getName() + "AccelerationMSG", KSTStreamingMessageFactory.this.registry);
            }
        }

        public void setFromMessage(JointspaceStreamingMessage message) {
            for (int i = 0; i < this.jointPositions.length; ++i) {
                this.jointPositions[i].set((double)message.getPositions().get(i));
                this.jointVelocities[i].set((double)message.getVelocities().get(i));
                this.jointAccelerations[i].set((double)message.getAccelerations().get(i));
            }
        }
    }

    private class YoSE3StreamingMessage {
        private final YoVector3D position;
        private final YoQuaternion orientation;
        private final YoVector3D rotationVector;
        private final YoVector3D linearVelocity;
        private final YoVector3D angularVelocity;
        private final YoVector3D linearAcceleration;
        private final YoVector3D angularAcceleration;

        public YoSE3StreamingMessage(RigidBodyReadOnly endEffector, YoRegistry registry) {
            String prefix = endEffector.getName();
            this.position = new YoVector3D(prefix + "PositionMSG", registry);
            this.orientation = new YoQuaternion(prefix + "OrientationMSG", registry);
            this.rotationVector = new YoVector3D(prefix + "RotactionVectorMSG", registry);
            this.linearVelocity = new YoVector3D(prefix + "LinearVelocityMSG", registry);
            this.angularVelocity = new YoVector3D(prefix + "AngularVelocityMSG", registry);
            this.linearAcceleration = new YoVector3D(prefix + "LinearAccelerationMSG", registry);
            this.angularAcceleration = new YoVector3D(prefix + "AngularAccelerationMSG", registry);
        }

        public void setFromMessage(SE3StreamingMessage message) {
            this.position.set((Tuple3DReadOnly)message.getPosition());
            this.orientation.set((QuaternionReadOnly)message.getOrientation());
            this.orientation.getRotationVector((Vector3DBasics)this.rotationVector);
            this.linearVelocity.set((Tuple3DReadOnly)message.getLinearVelocity());
            this.angularVelocity.set((Tuple3DReadOnly)message.getAngularVelocity());
            this.linearAcceleration.set((Tuple3DReadOnly)message.getLinearAcceleration());
            this.angularAcceleration.set((Tuple3DReadOnly)message.getAngularAcceleration());
        }
    }

    private class YoEuclideanStreamingMessage {
        private final YoVector3D position;
        private final YoVector3D linearVelocity;

        public YoEuclideanStreamingMessage(String prefix, YoRegistry registry) {
            this.position = new YoVector3D(prefix + "PositionMSG", registry);
            this.linearVelocity = new YoVector3D(prefix + "LinearVelocityMSG", registry);
        }

        public void setFromMessage(EuclideanStreamingMessage message) {
            this.position.set((Tuple3DReadOnly)message.getPosition());
            this.linearVelocity.set((Tuple3DReadOnly)message.getLinearVelocity());
        }
    }

    private class YoSO3StreamingMessage {
        private final YoQuaternion orientation;
        private final YoVector3D rotationVector;
        private final YoVector3D angularVelocity;
        private final YoVector3D angularAcceleration;

        public YoSO3StreamingMessage(RigidBodyReadOnly endEffector, YoRegistry registry) {
            String prefix = endEffector.getName();
            this.orientation = new YoQuaternion(prefix + "OrientationMSG", registry);
            this.rotationVector = new YoVector3D(prefix + "RotactionVectorMSG", registry);
            this.angularVelocity = new YoVector3D(prefix + "AngularVelocityMSG", registry);
            this.angularAcceleration = new YoVector3D(prefix + "AngularAccelerationMSG", registry);
        }

        public void setFromMessage(SO3StreamingMessage message) {
            this.orientation.set((QuaternionReadOnly)message.getOrientation());
            this.orientation.getRotationVector((Vector3DBasics)this.rotationVector);
            this.angularVelocity.set((Tuple3DReadOnly)message.getAngularVelocity());
            this.angularAcceleration.set((Tuple3DReadOnly)message.getAngularAcceleration());
        }
    }
}

