/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import toolbox_msgs.msg.dds.KinematicsStreamingToolboxInputMessage;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.AvatarControllerThreadInterface;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxModule;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.KinematicsStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextRootJointData;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.ControllerNetworkSubscriber;
import us.ihmc.commonWalkingControlModules.controllerCore.command.CrossRobotCommandResolver;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.MessageUnpackingTools;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.sensors.CenterOfMassDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoLong;

public class IKStreamingRTPluginFactory {
    private IKStreamingRTThread ikStreamingRTThread;
    private IKStreamingRTTask ikStreamingRTTask;

    public IKStreamingRTThread createRTThread(String robotName, ROS2Node ros2Node, CommandInputManager walkingInputManager, StatusMessageOutputManager walkingOutputManager, DRCRobotModel robotModel, HumanoidRobotContextDataFactory contextDataFactory, RobotCollisionModel collisionModel, KinematicsStreamingToolboxParameters parameters) {
        if (this.ikStreamingRTThread == null) {
            this.ikStreamingRTThread = new IKStreamingRTThread(robotName, ros2Node, walkingInputManager, walkingOutputManager, robotModel, contextDataFactory, collisionModel, parameters);
        }
        return this.ikStreamingRTThread;
    }

    public IKStreamingRTTask createRTTask(double schedulerDt) {
        if (this.ikStreamingRTThread == null) {
            throw new RuntimeException("Controller has not been created yet.");
        }
        if (this.ikStreamingRTTask == null) {
            this.ikStreamingRTTask = IKStreamingRTPluginFactory.createIKStreamingRTTask(this.ikStreamingRTThread, schedulerDt);
        }
        return this.ikStreamingRTTask;
    }

    public static IKStreamingRTTask createIKStreamingRTTask(IKStreamingRTThread ikStreamingRTThread, double schedulerDT) {
        KinematicsStreamingToolboxParameters parameters = ikStreamingRTThread.kinematicsStreamingToolboxController.getTools().getParameters();
        long divisor = Math.round(parameters.getToolboxUpdatePeriod() / schedulerDT);
        if (!EuclidCoreTools.epsilonEquals((double)((double)divisor * schedulerDT), (double)parameters.getToolboxUpdatePeriod(), (double)1.0E-7) || divisor < 1L) {
            throw new IllegalArgumentException("The schedulerDT (%s) does not divide the toolbox update period (%s).".formatted(schedulerDT, parameters.getToolboxUpdatePeriod()));
        }
        return new IKStreamingRTTask(ikStreamingRTThread, divisor, schedulerDT);
    }

    public static class IKStreamingRTThread
    implements AvatarControllerThreadInterface {
        private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
        private final CommandInputManager commandInputManager;
        private final StatusMessageOutputManager statusOutputManager;
        private final KinematicsStreamingToolboxController kinematicsStreamingToolboxController;
        private final AtomicBoolean receivedInput = new AtomicBoolean();
        private final YoDouble timeWithoutInputsBeforeGoingToSleep = new YoDouble("timeWithoutInputsBeforeGoingToSleep", this.registry);
        private final YoDouble timeOfLastInput = new YoDouble("timeOfLastInput", this.registry);
        private final AtomicReference<ToolboxState> newToolboxStateRequestedRef = new AtomicReference();
        private final YoEnum<ToolboxState> toolboxState = new YoEnum("toolboxState", this.registry, ToolboxState.class);
        private final HumanoidRobotContextData humanoidRobotContextData;
        private long initialTime = -1L;

        public IKStreamingRTThread(String robotName, ROS2Node ros2Node, CommandInputManager walkingInputManager, StatusMessageOutputManager walkingOutputManager, DRCRobotModel robotModel, HumanoidRobotContextDataFactory contextDataFactory, RobotCollisionModel collisionModel, KinematicsStreamingToolboxParameters parameters) {
            this.timeOfLastInput.set(Double.NEGATIVE_INFINITY);
            this.timeWithoutInputsBeforeGoingToSleep.set(parameters.getTimeThresholdForSleeping());
            ROS2Topic<?> inputTopic = KinematicsStreamingToolboxModule.getInputTopic(robotName);
            ROS2Topic<?> outputTopic = KinematicsStreamingToolboxModule.getOutputTopic(robotName);
            FullHumanoidRobotModel desiredFullRobotModel = robotModel.createFullRobotModel(false);
            this.commandInputManager = new CommandInputManager(KinematicsStreamingToolboxModule.supportedCommands());
            this.statusOutputManager = new StatusMessageOutputManager(KinematicsStreamingToolboxModule.supportedStatus());
            ControllerNetworkSubscriber controllerNetworkSubscriber = new ControllerNetworkSubscriber(inputTopic, this.commandInputManager, outputTopic, this.statusOutputManager, ros2Node);
            this.commandInputManager.registerHasReceivedInputListener(commandClass -> this.receivedInput.set(true));
            this.kinematicsStreamingToolboxController = new KinematicsStreamingToolboxController(this.commandInputManager, this.statusOutputManager, parameters, desiredFullRobotModel, robotModel, this.yoGraphicsListRegistry, this.registry);
            List<String> inactiveJoints = parameters.getInactiveJoints();
            for (int i = 0; i < inactiveJoints.size(); ++i) {
                this.kinematicsStreamingToolboxController.getActiveOptimizationSettings().deactivateJoint(desiredFullRobotModel.getOneDoFJointByName(inactiveJoints.get(i)));
            }
            this.kinematicsStreamingToolboxController.setCollisionModel(collisionModel);
            MessageUnpackingTools.MessageUnpacker wholeBodyStreamingMessageUnpacker = MessageUnpackingTools.createWholeBodyStreamingMessageUnpacker();
            ArrayList unpackedMessages = new ArrayList();
            this.kinematicsStreamingToolboxController.setStreamingMessagePublisher(streamingMessage -> {
                wholeBodyStreamingMessageUnpacker.unpackMessage((Object)streamingMessage, unpackedMessages);
                walkingInputManager.submitMessages(unpackedMessages);
                unpackedMessages.clear();
            });
            MessageUnpackingTools.MessageUnpacker wholeBodyTrajectoryMessageUnpacker = MessageUnpackingTools.createWholeBodyTrajectoryMessageUnpacker();
            this.kinematicsStreamingToolboxController.setTrajectoryMessagePublisher(trajectoryMessage -> {
                wholeBodyTrajectoryMessageUnpacker.unpackMessage((Object)trajectoryMessage, unpackedMessages);
                walkingInputManager.submitMessages(unpackedMessages);
                unpackedMessages.clear();
            });
            walkingOutputManager.attachStatusMessageListener(CapturabilityBasedStatus.class, this.kinematicsStreamingToolboxController::updateCapturabilityBasedStatus);
            HumanoidRobotContextJointData processedJointData = new HumanoidRobotContextJointData(desiredFullRobotModel.getOneDoFJoints().length);
            ForceSensorDataHolder forceSensorDataHolderForController = new ForceSensorDataHolder(Arrays.asList(desiredFullRobotModel.getForceSensorDefinitions()));
            CenterOfMassDataHolder centerOfMassDataHolderForController = new CenterOfMassDataHolder();
            CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator = new CenterOfPressureDataHolder(desiredFullRobotModel);
            LowLevelOneDoFJointDesiredDataHolder desiredJointDataHolder = new LowLevelOneDoFJointDesiredDataHolder((OneDoFJointReadOnly[])desiredFullRobotModel.getControllableOneDoFJoints());
            RobotMotionStatusHolder robotMotionStatusHolder = new RobotMotionStatusHolder();
            contextDataFactory.setForceSensorDataHolder(forceSensorDataHolderForController);
            contextDataFactory.setCenterOfMassDataHolder(centerOfMassDataHolderForController);
            contextDataFactory.setCenterOfPressureDataHolder(centerOfPressureDataHolderForEstimator);
            contextDataFactory.setRobotMotionStatusHolder(robotMotionStatusHolder);
            contextDataFactory.setJointDesiredOutputList(desiredJointDataHolder);
            contextDataFactory.setProcessedJointData(processedJointData);
            contextDataFactory.setSensorDataContext(new SensorDataContext((FullRobotModel)desiredFullRobotModel));
            this.humanoidRobotContextData = contextDataFactory.createHumanoidRobotContextData();
            ros2Node.createSubscription(inputTopic.withTypeName(KinematicsStreamingToolboxInputMessage.class), s -> {
                if (robotMotionStatusHolder.getCurrentRobotMotionStatus() != RobotMotionStatus.STANDING) {
                    this.newToolboxStateRequestedRef.set(ToolboxState.WAKE_UP);
                }
            });
            ToolboxStateMessage message = new ToolboxStateMessage();
            ros2Node.createSubscription(inputTopic.withTypeName(ToolboxStateMessage.class), s -> {
                s.takeNextData((Object)message, null);
                if (robotMotionStatusHolder.getCurrentRobotMotionStatus() != RobotMotionStatus.STANDING) {
                    this.newToolboxStateRequestedRef.set(ToolboxState.fromByte((byte)message.getRequestedToolboxState()));
                }
            });
            this.toolboxState.set((Enum)ToolboxState.SLEEP);
            this.kinematicsStreamingToolboxController.setRobotStateUpdater(new ContextBasedRobotStateUpdater(this.humanoidRobotContextData, desiredFullRobotModel, this.kinematicsStreamingToolboxController.getTools().getIKController().getDesiredOneDoFJoints()));
        }

        @Override
        public void run() {
            ToolboxState newToolboxStateRequested = this.newToolboxStateRequestedRef.getAndSet(null);
            if (newToolboxStateRequested != null) {
                this.kinematicsStreamingToolboxController.notifyToolboxStateChange(newToolboxStateRequested);
                switch (newToolboxStateRequested) {
                    case WAKE_UP: {
                        this.receivedInput.set(true);
                        this.toolboxState.set((Enum)ToolboxState.WAKE_UP);
                        break;
                    }
                    case REINITIALIZE: {
                        this.kinematicsStreamingToolboxController.requestInitialize();
                        this.receivedInput.set(true);
                        break;
                    }
                    default: {
                        this.toolboxState.set((Enum)ToolboxState.SLEEP);
                    }
                }
            }
            if (this.humanoidRobotContextData.getRobotMotionStatusHolder().getCurrentRobotMotionStatus() == RobotMotionStatus.IN_MOTION) {
                this.toolboxState.set((Enum)ToolboxState.SLEEP);
            }
            long currentMonotonicClockTime = System.nanoTime();
            if (this.initialTime < 0L) {
                this.initialTime = currentMonotonicClockTime;
            }
            currentMonotonicClockTime -= this.initialTime;
            if (this.receivedInput.getAndSet(false)) {
                this.timeOfLastInput.set(Conversions.nanosecondsToSeconds((long)currentMonotonicClockTime));
            }
            double timeSinceLastInput = Conversions.nanosecondsToSeconds((long)currentMonotonicClockTime) - this.timeOfLastInput.getValue();
            if (this.toolboxState.getValue() == ToolboxState.WAKE_UP) {
                if (timeSinceLastInput > this.timeWithoutInputsBeforeGoingToSleep.getDoubleValue()) {
                    this.toolboxState.set((Enum)ToolboxState.SLEEP);
                    this.kinematicsStreamingToolboxController.notifyToolboxStateChange(ToolboxState.SLEEP);
                }
                this.kinematicsStreamingToolboxController.update();
            }
        }

        @Override
        public YoRegistry getYoVariableRegistry() {
            return this.registry;
        }

        @Override
        public FullHumanoidRobotModel getFullRobotModel() {
            return this.kinematicsStreamingToolboxController.getDesiredFullRobotModel();
        }

        @Override
        public HumanoidRobotContextData getHumanoidRobotContextData() {
            return this.humanoidRobotContextData;
        }

        public YoGraphicsListRegistry getSCS1YoGraphicsListRegistry() {
            return new YoGraphicsListRegistry();
        }

        @Override
        public YoGraphicGroupDefinition getSCS2YoGraphics() {
            return null;
        }
    }

    public static class IKStreamingRTTask
    extends HumanoidRobotControlTask {
        private final CrossRobotCommandResolver controllerResolver;
        private final IKStreamingRTThread ikStreamingThread;
        private final long divisor;
        private final ThreadTimer timer;
        private final YoLong ticksBehindScheduled;
        private final List<Runnable> postControllerCallbacks = new ArrayList<Runnable>();
        private final List<Runnable> schedulerThreadRunnables = new ArrayList<Runnable>();

        public IKStreamingRTTask(IKStreamingRTThread ikStreamingThread, long divisor, double schedulerDt) {
            super(divisor);
            this.divisor = divisor;
            this.ikStreamingThread = ikStreamingThread;
            this.controllerResolver = new CrossRobotCommandResolver(ikStreamingThread.getFullRobotModel());
            String prefix = "IKStreaming";
            this.timer = new ThreadTimer(prefix, schedulerDt * (double)divisor, ikStreamingThread.getYoVariableRegistry());
            this.ticksBehindScheduled = new YoLong(prefix + "TicksBehindScheduled", ikStreamingThread.getYoVariableRegistry());
        }

        @Override
        protected boolean initialize() {
            this.timer.reset();
            this.ticksBehindScheduled.set(0L);
            return super.initialize();
        }

        protected void execute() {
            this.timer.start();
            this.ticksBehindScheduled.set(this.ikStreamingThread.getHumanoidRobotContextData().getSchedulerTick() - this.timer.getTickCount() * this.divisor);
            this.ikStreamingThread.run();
            IKStreamingRTTask.runAll(this.postControllerCallbacks);
            this.timer.stop();
        }

        protected void updateMasterContext(HumanoidRobotContextData masterContext) {
            IKStreamingRTTask.runAll(this.schedulerThreadRunnables);
        }

        protected void updateLocalContext(HumanoidRobotContextData masterContext) {
            this.controllerResolver.resolveHumanoidRobotContextDataScheduler(masterContext, this.ikStreamingThread.getHumanoidRobotContextData());
            this.controllerResolver.resolveHumanoidRobotContextDataEstimator(masterContext, this.ikStreamingThread.getHumanoidRobotContextData());
        }

        @Override
        public void addCallbackPostTask(Runnable runnable) {
            this.postControllerCallbacks.add(runnable);
        }

        @Override
        public void addRunnableOnSchedulerThread(Runnable runnable) {
            this.schedulerThreadRunnables.add(runnable);
        }
    }

    private static class ContextBasedRobotStateUpdater
    implements KinematicsToolboxController.IKRobotStateUpdater {
        private final HumanoidRobotContextData contextData;
        private final int[] jointIndicesInContext;

        public ContextBasedRobotStateUpdater(HumanoidRobotContextData contextData, FullHumanoidRobotModel fullRobotModel, OneDoFJointBasics[] ikOrderedJoints) {
            this.contextData = contextData;
            List<OneDoFJointBasics> contextOrderedJoints = Arrays.asList(fullRobotModel.getOneDoFJoints());
            List<OneDoFJointBasics> ikOrderedJointList = Arrays.asList(ikOrderedJoints);
            this.jointIndicesInContext = new int[ikOrderedJointList.size()];
            for (int i = 0; i < ikOrderedJointList.size(); ++i) {
                this.jointIndicesInContext[i] = contextOrderedJoints.indexOf(ikOrderedJointList.get(i));
            }
        }

        @Override
        public boolean updateRobotConfiguration(FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints) {
            if (!this.contextData.getEstimatorRan()) {
                return false;
            }
            HumanoidRobotContextJointData jointData = this.contextData.getProcessedJointData();
            HumanoidRobotContextRootJointData rootJointData = jointData.getRootJointData();
            rootJoint.setJointOrientation((Orientation3DReadOnly)rootJointData.getRootJointOrientation());
            rootJoint.setJointPosition((Tuple3DReadOnly)rootJointData.getRootJointLocation());
            rootJoint.updateFrame();
            for (int i = 0; i < oneDoFJoints.length; ++i) {
                oneDoFJoints[i].setQ(jointData.getJointQForIndex(this.jointIndicesInContext[i]));
                oneDoFJoints[i].updateFrame();
            }
            return true;
        }
    }
}

