/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule;

import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.SolutionQualityConvergenceSettings;
import us.ihmc.commons.Conversions;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class SolutionQualityConvergenceDetector {
    private final String name = this.getClass().getSimpleName();
    private final YoBoolean useConvergenceDetecting;
    private final YoDouble solutionQuality;
    private final YoDouble solutionQualityLast;
    private final YoDouble solutionQualityBeforeLast;
    private final YoDouble solutionQualityThreshold;
    private final YoDouble solutionStabilityThreshold;
    private final YoDouble solutionMinimumProgression;
    private final YoInteger numberOfIterations;
    private final YoInteger maximumNumberOfIterations;
    private final YoDouble computationTime;
    private final YoBoolean isSolved;
    private final YoBoolean isGoodSolution;
    private final YoBoolean isStucked;
    private long startTime;

    public SolutionQualityConvergenceDetector(SolutionQualityConvergenceSettings settings, YoRegistry parentRegistry) {
        this.useConvergenceDetecting = new YoBoolean("useConvergenceDetecting", parentRegistry);
        this.solutionQuality = new YoDouble(this.name + "solutionQuality", parentRegistry);
        this.solutionQualityLast = new YoDouble(this.name + "solutionQualityLast", parentRegistry);
        this.solutionQualityBeforeLast = new YoDouble(this.name + "solutionQualityBeforeLast", parentRegistry);
        this.solutionQualityThreshold = new YoDouble("solutionQualityThreshold", parentRegistry);
        this.solutionStabilityThreshold = new YoDouble("solutionStabilityThreshold", parentRegistry);
        this.solutionMinimumProgression = new YoDouble("solutionProgressionThreshold", parentRegistry);
        this.numberOfIterations = new YoInteger(this.name + "numberOfIterations", parentRegistry);
        this.maximumNumberOfIterations = new YoInteger("maximumNumberOfIterations", parentRegistry);
        this.computationTime = new YoDouble("computationTime", parentRegistry);
        this.isSolved = new YoBoolean("isSolved", parentRegistry);
        this.isGoodSolution = new YoBoolean("isGoodSolution", parentRegistry);
        this.isStucked = new YoBoolean("isStucked", parentRegistry);
        this.useConvergenceDetecting.set(settings.useConvergenceDetecting());
        this.maximumNumberOfIterations.set(settings.getDefaultTerminalIteration());
        this.solutionQualityThreshold.set(settings.getSolutionQualityThreshold());
        this.solutionStabilityThreshold.set(settings.getSolutionStabilityThreshold());
        this.solutionMinimumProgression.set(settings.getMinimumProgression());
        this.initialize();
    }

    public void initialize() {
        this.startTime = System.nanoTime();
        this.numberOfIterations.set(0);
        this.solutionQuality.set(Double.MAX_VALUE);
        this.solutionQualityLast.setToNaN();
        this.solutionQualityBeforeLast.setToNaN();
        this.isSolved.set(false);
    }

    public void update() {
        this.numberOfIterations.increment();
        double deltaSolutionQualityLast = Math.abs(this.solutionQuality.getDoubleValue() - this.solutionQualityLast.getDoubleValue());
        double deltaSolutionQualityBeforeLast = Math.abs(this.solutionQuality.getDoubleValue() - this.solutionQualityBeforeLast.getDoubleValue());
        boolean isSolutionStable = deltaSolutionQualityLast < this.solutionStabilityThreshold.getDoubleValue();
        boolean isSolutionQualityHigh = this.solutionQuality.getDoubleValue() < this.solutionQualityThreshold.getDoubleValue();
        this.isGoodSolution.set(isSolutionStable && isSolutionQualityHigh);
        if (this.useConvergenceDetecting.getBooleanValue()) {
            boolean isSolverStuck = false;
            if (!isSolutionQualityHigh) {
                boolean stuckLast = deltaSolutionQualityLast / this.solutionQuality.getDoubleValue() < this.solutionMinimumProgression.getDoubleValue();
                boolean stuckBeforeLast = deltaSolutionQualityBeforeLast / this.solutionQuality.getDoubleValue() < this.solutionMinimumProgression.getDoubleValue();
                isSolverStuck = stuckLast || stuckBeforeLast;
            } else {
                isSolverStuck = false;
            }
            this.isStucked.set(isSolverStuck);
            this.solutionQualityBeforeLast.set(this.solutionQualityLast.getDoubleValue());
            this.solutionQualityLast.set(this.solutionQuality.getDoubleValue());
            if (this.isStucked.getBooleanValue()) {
                this.isSolved.set(true);
            }
        }
        if (this.numberOfIterations.getIntegerValue() == this.maximumNumberOfIterations.getIntegerValue() || this.isGoodSolution.getBooleanValue()) {
            this.isSolved.set(true);
        } else {
            this.isSolved.set(false);
        }
        this.computationTime.set(Conversions.nanosecondsToSeconds((long)(System.nanoTime() - this.startTime)));
    }

    public void submitSolutionQuality(double solutionQuality) {
        this.solutionQuality.set(solutionQuality);
    }

    public double getComputationTime() {
        return this.computationTime.getDoubleValue();
    }

    public boolean isValid() {
        return this.isGoodSolution.getBooleanValue();
    }

    public boolean isSolved() {
        return this.isSolved.getBooleanValue();
    }

    public int getNumberOfIteration() {
        return this.numberOfIterations.getIntegerValue();
    }
}

