/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import gnu.trove.TDoubleCollection;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.fest.swing.util.Pair;
import toolbox_msgs.msg.dds.KinematicsPlanningToolboxOutputStatus;
import toolbox_msgs.msg.dds.KinematicsToolboxCenterOfMassMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.KinematicsPlanningToolboxOptimizationSettings;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.SolutionQualityConvergenceDetector;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.WholeBodyTrajectoryPointCalculator;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsPlanningToolboxAPI.KinematicsPlanningToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsPlanningToolboxAPI.KinematicsPlanningToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsPlanningToolboxAPI.KinematicsPlanningToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsPlanningToolboxOutputConverter;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxMessageFactory;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class KinematicsPlanningToolboxController
extends ToolboxController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final boolean DEBUG = true;
    private final AtomicReference<RobotConfigurationData> latestRobotConfigurationDataReference = new AtomicReference<Object>(null);
    private final AtomicReference<CapturabilityBasedStatus> latestCapturabilityBasedStatusReference = new AtomicReference<Object>(null);
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final CommandInputManager commandInputManager;
    private final List<String> armJointNames = new ArrayList<String>();
    private final Map<String, Pair<Double, Double>> armJointVelocityLimitMap;
    private final WholeBodyTrajectoryPointCalculator fullRobotModelTrajectoryCalculator;
    private static final double searchingTimeTickForVelocityBound = 0.002;
    private static final boolean useKeyFrameTimeOptimizerIfJointVelocityExceedLimits = true;
    private final KinematicsPlanningToolboxOutputStatus solution;
    private final KinematicsPlanningToolboxOutputConverter outputConverter;
    private final YoBoolean isDone;
    private final List<KinematicsPlanningToolboxRigidBodyCommand> rigidBodyCommands;
    private final AtomicReference<KinematicsPlanningToolboxCenterOfMassCommand> centerOfMassCommand;
    private final AtomicReference<KinematicsToolboxConfigurationCommand> configurationCommand;
    private final List<RigidBodyBasics> ikRigidBodies;
    private final Map<RigidBodyBasics, List<KinematicsToolboxRigidBodyMessage>> ikRigidBodyMessageMap;
    private final List<KinematicsToolboxCenterOfMassMessage> ikCenterOfMassMessages;
    private final AtomicReference<KinematicsToolboxConfigurationMessage> ikConfigurationMessage;
    private static final double keyFrameTimeEpsilon = 0.01;
    private final TDoubleArrayList keyFrameTimes;
    private final HumanoidKinematicsToolboxController ikController;
    private final KinematicsToolboxOutputStatus initialRobotConfiguration;
    private final CommandInputManager ikCommandInputManager = new CommandInputManager(this.getClass().getSimpleName(), KinematicsToolboxModule.supportedCommands());
    private final YoInteger indexOfCurrentKeyFrame;
    private final YoDouble totalComputationTime;
    private final SolutionQualityConvergenceDetector solutionQualityConvergenceDetector;

    public KinematicsPlanningToolboxController(DRCRobotModel drcRobotModel, FullHumanoidRobotModel fullRobotModel, CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.desiredFullRobotModel = fullRobotModel;
        this.armJointVelocityLimitMap = new HashMap<String, Pair<Double, Double>>();
        this.fullRobotModelTrajectoryCalculator = new WholeBodyTrajectoryPointCalculator(drcRobotModel);
        this.solution = HumanoidMessageTools.createKinematicsPlanningToolboxOutputStatus();
        this.solution.setDestination(-1);
        this.outputConverter = new KinematicsPlanningToolboxOutputConverter((FullHumanoidRobotModelFactory)drcRobotModel);
        this.commandInputManager = commandInputManager;
        this.rigidBodyCommands = new ArrayList<KinematicsPlanningToolboxRigidBodyCommand>();
        this.centerOfMassCommand = new AtomicReference<Object>(null);
        this.configurationCommand = new AtomicReference<Object>(null);
        this.ikRigidBodies = new ArrayList<RigidBodyBasics>();
        this.ikRigidBodyMessageMap = new HashMap<RigidBodyBasics, List<KinematicsToolboxRigidBodyMessage>>();
        this.ikCenterOfMassMessages = new ArrayList<KinematicsToolboxCenterOfMassMessage>();
        this.ikConfigurationMessage = new AtomicReference<Object>(null);
        this.keyFrameTimes = new TDoubleArrayList();
        this.isDone = new YoBoolean("isDone", parentRegistry);
        double updateDT = 0.001;
        this.ikController = new HumanoidKinematicsToolboxController(this.ikCommandInputManager, statusOutputManager, fullRobotModel, updateDT, yoGraphicsListRegistry, parentRegistry);
        this.ikController.setDesiredRobotStateUpdater((rootJoint, oneDoFJoints) -> true);
        this.ikCommandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(fullRobotModel, (ReferenceFrames)this.ikController.getDesiredReferenceFrames()));
        this.initialRobotConfiguration = MessageTools.createKinematicsToolboxOutputStatus((OneDoFJointBasics[])this.ikController.getDesiredOneDoFJoints());
        this.indexOfCurrentKeyFrame = new YoInteger("indexOfCurrentKeyFrame", parentRegistry);
        this.totalComputationTime = new YoDouble("totalComputationTime", parentRegistry);
        KinematicsPlanningToolboxOptimizationSettings optimizationSettings = new KinematicsPlanningToolboxOptimizationSettings();
        this.solutionQualityConvergenceDetector = new SolutionQualityConvergenceDetector(optimizationSettings, parentRegistry);
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        this.indexOfCurrentKeyFrame.set(0);
        this.totalComputationTime.set(0.0);
        this.rigidBodyCommands.clear();
        this.centerOfMassCommand.set(null);
        this.configurationCommand.set(null);
        if (this.commandInputManager.isNewCommandAvailable(KinematicsPlanningToolboxInputCommand.class)) {
            command = (KinematicsPlanningToolboxInputCommand)this.commandInputManager.pollNewestCommand(KinematicsPlanningToolboxInputCommand.class);
            RecyclingArrayList rigidBodyCommands = command.getRigidBodyCommands();
            if (rigidBodyCommands.size() == 0) {
                return false;
            }
            for (int i = 0; i < rigidBodyCommands.size(); ++i) {
                this.rigidBodyCommands.add((KinematicsPlanningToolboxRigidBodyCommand)rigidBodyCommands.get(i));
            }
            KinematicsPlanningToolboxCenterOfMassCommand centerOfMassCommand = command.getCenterOfMassCommand();
            this.centerOfMassCommand.set(centerOfMassCommand);
            KinematicsToolboxConfigurationCommand configurationCommand = command.getKinematicsConfigurationCommand();
            this.configurationCommand.set(configurationCommand);
        } else {
            if (this.commandInputManager.isNewCommandAvailable(KinematicsPlanningToolboxRigidBodyCommand.class)) {
                List commands = this.commandInputManager.pollNewCommands(KinematicsPlanningToolboxRigidBodyCommand.class);
                for (int i = 0; i < commands.size(); ++i) {
                    this.rigidBodyCommands.add((KinematicsPlanningToolboxRigidBodyCommand)commands.get(i));
                }
            } else {
                return false;
            }
            if (this.commandInputManager.isNewCommandAvailable(KinematicsPlanningToolboxCenterOfMassCommand.class)) {
                KinematicsPlanningToolboxCenterOfMassCommand comCommand = (KinematicsPlanningToolboxCenterOfMassCommand)this.commandInputManager.pollNewestCommand(KinematicsPlanningToolboxCenterOfMassCommand.class);
                this.centerOfMassCommand.set(comCommand);
            }
            if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxConfigurationCommand.class)) {
                command = (KinematicsToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxConfigurationCommand.class);
                this.configurationCommand.set((KinematicsToolboxConfigurationCommand)command);
            }
        }
        if (!this.updateInitialRobotConfigurationToIKController()) {
            return false;
        }
        if (!this.updateToolboxConfiguration()) {
            return false;
        }
        if (!this.updateIKMessages()) {
            return false;
        }
        this.ikController.updateFootSupportState(true, true);
        boolean initialized = this.ikController.initialize();
        if (!initialized) {
            throw new RuntimeException("Could not initialize the " + KinematicsToolboxController.class.getSimpleName());
        }
        this.armJointVelocityLimitMap.clear();
        for (RobotSide robotSide : RobotSide.values) {
            JointBasics armJoint = this.desiredFullRobotModel.getHand(robotSide).getParentJoint();
            while (armJoint.getPredecessor() != this.desiredFullRobotModel.getElevator()) {
                String armJointName = armJoint.getName();
                if (armJointName.contains(robotSide.getLowerCaseName())) {
                    this.armJointNames.add(armJointName);
                    OneDoFJointBasics oneDoFJointByName = this.desiredFullRobotModel.getOneDoFJointByName(armJointName);
                    Pair velocityLimit = new Pair((Object)oneDoFJointByName.getVelocityLimitLower(), (Object)oneDoFJointByName.getVelocityLimitUpper());
                    this.armJointVelocityLimitMap.put(armJointName, (Pair<Double, Double>)velocityLimit);
                }
                armJoint = armJoint.getPredecessor().getParentJoint();
            }
        }
        this.solution.setPlanId(-1);
        this.solution.getKeyFrameTimes().clear();
        this.solution.getRobotConfigurations().clear();
        this.solution.setSolutionQuality(0.0);
        this.solution.getKeyFrameTimes().add(0.0);
        ((KinematicsToolboxOutputStatus)this.solution.getRobotConfigurations().add()).set(this.initialRobotConfiguration);
        for (int i = 0; i < this.getNumberOfKeyFrames(); ++i) {
            this.solution.getKeyFrameTimes().add(this.keyFrameTimes.get(i));
        }
        this.solutionQualityConvergenceDetector.initialize();
        this.submitKeyFrameMessages();
        System.out.println("Initializing is done");
        return true;
    }

    private boolean updateIKMessages() {
        int i;
        int numberOfInterpolatedPoints;
        int numberOfKeyFrames = this.keyFrameTimes.size();
        if (numberOfKeyFrames == 1) {
            numberOfInterpolatedPoints = 2;
        } else if (numberOfKeyFrames == 2) {
            numberOfInterpolatedPoints = 1;
        } else {
            return true;
        }
        TDoubleArrayList keyFrameTimesBuffer = new TDoubleArrayList();
        keyFrameTimesBuffer.addAll((TDoubleCollection)this.keyFrameTimes);
        this.keyFrameTimes.clear();
        double t1 = 0.0;
        for (i = 0; i < numberOfKeyFrames; ++i) {
            for (int j = 0; j < numberOfInterpolatedPoints; ++j) {
                double alpha = ((double)j + 1.0) / (double)(numberOfInterpolatedPoints + 1);
                double t2 = keyFrameTimesBuffer.get(i);
                double keyFrameTime = EuclidCoreTools.interpolate((double)t1, (double)t2, (double)alpha);
                this.keyFrameTimes.add(keyFrameTime);
            }
            t1 = keyFrameTimesBuffer.get(i);
            this.keyFrameTimes.add(t1);
        }
        for (i = 0; i < this.ikRigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.ikRigidBodies.get(i);
            List<KinematicsToolboxRigidBodyMessage> ikRigidBodyMessages = this.ikRigidBodyMessageMap.get(rigidBody);
            ArrayList<Pose3D> ikRigidBodyPoses = new ArrayList<Pose3D>();
            Pose3D currentPose = new Pose3D((RigidBodyTransformReadOnly)rigidBody.getBodyFixedFrame().getTransformToDesiredFrame(worldFrame));
            for (int j = 0; j < numberOfKeyFrames; ++j) {
                KinematicsToolboxRigidBodyMessage nextMessage = ikRigidBodyMessages.get(j);
                Pose3D nextDesiredPose = new Pose3D((Tuple3DReadOnly)nextMessage.getDesiredPositionInWorld(), (Orientation3DReadOnly)nextMessage.getDesiredOrientationInWorld());
                for (int k = 0; k < numberOfInterpolatedPoints; ++k) {
                    double alpha = ((double)k + 1.0) / (double)(numberOfInterpolatedPoints + 1);
                    Pose3D interpolatedPose = new Pose3D((Pose3DReadOnly)currentPose);
                    interpolatedPose.interpolate((Pose3DReadOnly)nextDesiredPose, alpha);
                    ikRigidBodyPoses.add(interpolatedPose);
                }
                currentPose.set(nextDesiredPose);
                ikRigidBodyPoses.add(nextDesiredPose);
            }
            KinematicsToolboxRigidBodyMessage rigidBodyMessageBuffer = new KinematicsToolboxRigidBodyMessage();
            rigidBodyMessageBuffer.set(ikRigidBodyMessages.get(0));
            ikRigidBodyMessages.clear();
            for (int j = 0; j < ikRigidBodyPoses.size(); ++j) {
                KinematicsToolboxRigidBodyMessage messageToAdd = new KinematicsToolboxRigidBodyMessage(rigidBodyMessageBuffer);
                messageToAdd.getDesiredPositionInWorld().set(((Pose3D)ikRigidBodyPoses.get(j)).getPosition());
                messageToAdd.getDesiredOrientationInWorld().set(((Pose3D)ikRigidBodyPoses.get(j)).getOrientation());
                ikRigidBodyMessages.add(messageToAdd);
            }
        }
        ArrayList<Point3D> comPoints = new ArrayList<Point3D>();
        CenterOfMassCalculator calculator = new CenterOfMassCalculator((RigidBodyReadOnly)this.getDesiredFullRobotModel().getRootBody(), worldFrame);
        calculator.reset();
        Point3D currentPoint = new Point3D((Tuple3DReadOnly)calculator.getCenterOfMass());
        for (int i2 = 0; i2 < this.ikCenterOfMassMessages.size(); ++i2) {
            Point3D nextDesiredPoint = new Point3D((Tuple3DReadOnly)this.ikCenterOfMassMessages.get(i2).getDesiredPositionInWorld());
            for (int j = 0; j < numberOfInterpolatedPoints; ++j) {
                double alpha = ((double)j + 1.0) / (double)(numberOfInterpolatedPoints + 1);
                Point3D interpolatedPoint = new Point3D((Tuple3DReadOnly)currentPoint);
                interpolatedPoint.interpolate((Tuple3DReadOnly)nextDesiredPoint, alpha);
                comPoints.add(interpolatedPoint);
            }
            currentPoint.set(nextDesiredPoint);
            comPoints.add(nextDesiredPoint);
        }
        KinematicsToolboxCenterOfMassMessage comMessageBuffer = new KinematicsToolboxCenterOfMassMessage();
        comMessageBuffer.set(this.ikCenterOfMassMessages.get(0));
        this.ikCenterOfMassMessages.clear();
        for (int j = 0; j < comPoints.size(); ++j) {
            KinematicsToolboxCenterOfMassMessage messageToAdd = new KinematicsToolboxCenterOfMassMessage(comMessageBuffer);
            messageToAdd.getDesiredPositionInWorld().set((Point3D)comPoints.get(j));
            this.ikCenterOfMassMessages.add(messageToAdd);
        }
        return true;
    }

    private boolean updateToolboxConfiguration() {
        int i;
        if (this.rigidBodyCommands.size() == 0) {
            throw new RuntimeException(this.getClass().getSimpleName() + " needs at least one KinematicsPlanningToolboxRigidBodyMessage.");
        }
        this.ikRigidBodies.clear();
        this.ikRigidBodyMessageMap.clear();
        this.ikCenterOfMassMessages.clear();
        this.keyFrameTimes.clear();
        for (i = 0; i < this.rigidBodyCommands.size(); ++i) {
            int j;
            KinematicsPlanningToolboxRigidBodyCommand command = this.rigidBodyCommands.get(i);
            RigidBodyBasics endEffector = command.getEndEffector();
            this.ikRigidBodies.add(endEffector);
            ArrayList<KinematicsToolboxRigidBodyMessage> rigidBodyMessages = new ArrayList<KinematicsToolboxRigidBodyMessage>();
            int numberOfWayPoints = command.getNumberOfWayPoints();
            for (j = 0; j < numberOfWayPoints; ++j) {
                Pose3D wayPoint = command.getWayPoint(j);
                FramePose3D wayPointFramePose = new FramePose3D(worldFrame, (Pose3DReadOnly)wayPoint);
                KinematicsToolboxRigidBodyMessage rigidBodyMessage = MessageTools.createKinematicsToolboxRigidBodyMessage((RigidBodyReadOnly)endEffector, (Point3DReadOnly)wayPointFramePose.getPosition(), (QuaternionReadOnly)wayPointFramePose.getOrientation());
                rigidBodyMessage.getControlFramePositionInEndEffector().set((Tuple3DReadOnly)command.getControlFramePose().getPosition());
                rigidBodyMessage.getControlFrameOrientationInEndEffector().set((QuaternionReadOnly)command.getControlFramePose().getOrientation());
                rigidBodyMessage.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)command.getSelectionMatrix().getLinearPart()));
                rigidBodyMessage.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)command.getSelectionMatrix().getAngularPart()));
                rigidBodyMessage.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((WeightMatrix3D)command.getWeightMatrix().getLinearPart()));
                rigidBodyMessage.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((WeightMatrix3D)command.getWeightMatrix().getAngularPart()));
                rigidBodyMessages.add(rigidBodyMessage);
            }
            this.ikRigidBodyMessageMap.put(endEffector, rigidBodyMessages);
            if (i == 0) {
                for (j = 0; j < numberOfWayPoints; ++j) {
                    this.keyFrameTimes.add(command.getWayPointTime(j));
                }
                continue;
            }
            if (this.checkKeyFrameTimes(command.getWayPointTimes())) continue;
            throw new RuntimeException(command.getClass().getSimpleName() + " must have same key frame times with the first KinematicsPlanningToolboxRigidBodyMessage.");
        }
        if (this.centerOfMassCommand.get() != null && this.centerOfMassCommand.get().getNumberOfWayPoints() != 0) {
            for (i = 0; i < this.centerOfMassCommand.get().getNumberOfWayPoints(); ++i) {
                FramePoint3D wayPointFramePoint = new FramePoint3D(worldFrame, (Tuple3DReadOnly)this.centerOfMassCommand.get().getWayPoint(i));
                KinematicsToolboxCenterOfMassMessage comMessage = MessageTools.createKinematicsToolboxCenterOfMassMessage((Point3DReadOnly)wayPointFramePoint);
                comMessage.getWeights().set(MessageTools.createWeightMatrix3DMessage((WeightMatrix3D)this.centerOfMassCommand.get().getWeightMatrix()));
                comMessage.getSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)this.centerOfMassCommand.get().getSelectionMatrix()));
                this.ikCenterOfMassMessages.add(comMessage);
            }
            if (!this.checkKeyFrameTimes(this.centerOfMassCommand.get().getWayPointTimes())) {
                throw new RuntimeException(this.centerOfMassCommand.get().getClass().getSimpleName() + " must have same key frame times with KinematicsPlanningToolboxRigidBodyMessage.");
            }
        } else {
            for (i = 0; i < this.getNumberOfKeyFrames(); ++i) {
                this.getDesiredFullRobotModel().updateFrames();
                KinematicsToolboxCenterOfMassMessage comMessage = KinematicsToolboxMessageFactory.holdCenterOfMassCurrentPosition((RigidBodyBasics)this.getDesiredFullRobotModel().getRootBody(), (boolean)true, (boolean)true, (boolean)false);
                this.ikCenterOfMassMessages.add(comMessage);
            }
        }
        if (this.configurationCommand.get() != null) {
            // empty if block
        }
        return true;
    }

    @Override
    public void updateInternal() throws RuntimeException {
        if (this.solutionQualityConvergenceDetector.isSolved()) {
            System.out.println("solved " + this.solutionQualityConvergenceDetector.isValid() + " " + this.solutionQualityConvergenceDetector.getNumberOfIteration());
            this.appendRobotConfigurationOnToolboxSolution();
            if (this.indexOfCurrentKeyFrame.getIntegerValue() == this.getNumberOfKeyFrames()) {
                this.packSolution();
            } else {
                this.totalComputationTime.add(this.solutionQualityConvergenceDetector.getComputationTime());
                this.solutionQualityConvergenceDetector.initialize();
                this.submitKeyFrameMessages();
            }
        } else {
            this.ikController.updateInternal();
            this.solutionQualityConvergenceDetector.submitSolutionQuality(this.ikController.getSolution().getSolutionQuality());
            this.solutionQualityConvergenceDetector.update();
        }
    }

    @Override
    public boolean isDone() {
        return this.isDone.getBooleanValue();
    }

    private void packSolution() {
        this.isDone.set(true);
        boolean isOptimalSolution = this.solution.getPlanId() != 2;
        this.generateTrajectoriesToPreview(false);
        if (this.isVelocityLimitExceeded()) {
            System.out.println("re planning for velocity optimization");
            this.generateTrajectoriesToPreview(true);
        }
        if (this.isVelocityLimitExceeded() && isOptimalSolution) {
            this.solution.setPlanId(1);
            isOptimalSolution = false;
        }
        this.fullRobotModelTrajectoryCalculator.packOptimizedVelocities(this.solution);
        this.convertWholeBodyTrajectoryMessage();
        if (isOptimalSolution) {
            this.solution.setPlanId(0);
        }
        System.out.println("total computation time is " + this.solutionQualityConvergenceDetector.getComputationTime() + ", PlanId = " + this.solution.getPlanId());
        this.reportMessage(this.solution);
    }

    private void generateTrajectoriesToPreview(boolean useKeyFrameOptimizer) {
        this.fullRobotModelTrajectoryCalculator.clear();
        this.fullRobotModelTrajectoryCalculator.addKeyFrames((List<KinematicsToolboxOutputStatus>)this.solution.getRobotConfigurations(), (TDoubleArrayList)this.solution.getKeyFrameTimes());
        this.fullRobotModelTrajectoryCalculator.initializeCalculator();
        if (useKeyFrameOptimizer) {
            this.fullRobotModelTrajectoryCalculator.computeOptimizingKeyFrameTimes();
        } else {
            this.fullRobotModelTrajectoryCalculator.computeForFixedKeyFrameTimes();
        }
        this.fullRobotModelTrajectoryCalculator.computeVelocityBounds(0.002);
    }

    private boolean isVelocityLimitExceeded() {
        for (String armJointName : this.armJointNames) {
            double jointVelocityLowerBound = this.fullRobotModelTrajectoryCalculator.getJointVelocityLowerBound(armJointName);
            double jointVelocityUpperBound = this.fullRobotModelTrajectoryCalculator.getJointVelocityUpperBound(armJointName);
            Pair<Double, Double> velocityLimit = this.armJointVelocityLimitMap.get(armJointName);
            if (!((Double)velocityLimit.i > jointVelocityLowerBound) && !((Double)velocityLimit.ii < jointVelocityUpperBound)) continue;
            System.out.println(armJointName + " trajectory exceeds joint velocity limit. " + jointVelocityLowerBound + " " + jointVelocityUpperBound);
            return true;
        }
        return false;
    }

    private void convertWholeBodyTrajectoryMessage() {
        WholeBodyTrajectoryMessage wholeBodyTrajectoryMessage = new WholeBodyTrajectoryMessage();
        wholeBodyTrajectoryMessage.setDestination(PacketDestination.CONTROLLER.ordinal());
        this.outputConverter.setMessageToCreate(wholeBodyTrajectoryMessage);
        this.outputConverter.computeWholeBodyTrajectoryMessage(this.solution);
        this.solution.getSuggestedControllerMessage().set(wholeBodyTrajectoryMessage);
    }

    private void appendRobotConfigurationOnToolboxSolution() {
        KinematicsToolboxOutputStatus keyFrame = new KinematicsToolboxOutputStatus(this.ikController.getSolution());
        ((KinematicsToolboxOutputStatus)this.solution.getRobotConfigurations().add()).set(keyFrame);
        this.solution.setSolutionQuality(this.solution.getSolutionQuality() + this.ikController.getSolution().getSolutionQuality());
        if (!this.solutionQualityConvergenceDetector.isValid()) {
            this.solution.setPlanId(2);
        }
    }

    private boolean submitKeyFrameMessages() {
        for (int i = 0; i < this.ikRigidBodies.size(); ++i) {
            List<KinematicsToolboxRigidBodyMessage> rigidBodyMessages = this.ikRigidBodyMessageMap.get(this.ikRigidBodies.get(i));
            this.ikCommandInputManager.submitMessage((Settable)rigidBodyMessages.get(this.indexOfCurrentKeyFrame.getIntegerValue()));
        }
        if (this.ikCenterOfMassMessages.get(this.indexOfCurrentKeyFrame.getIntegerValue()) != null) {
            this.ikCommandInputManager.submitMessage((Settable)this.ikCenterOfMassMessages.get(this.indexOfCurrentKeyFrame.getIntegerValue()));
        }
        if (this.ikConfigurationMessage.get() != null) {
            this.ikCommandInputManager.submitMessage((Settable)this.ikConfigurationMessage.get());
        }
        this.indexOfCurrentKeyFrame.increment();
        return true;
    }

    private boolean updateInitialRobotConfigurationToIKController() {
        RobotConfigurationData currentRobotConfiguration = this.latestRobotConfigurationDataReference.getAndSet(null);
        if (currentRobotConfiguration == null) {
            LogTools.warn((String)"latestRobotConfigurationDataReference should be set up.");
            return false;
        }
        FloatingJointBasics rootJoint = this.getDesiredFullRobotModel().getRootJoint();
        OneDoFJointBasics[] allJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.getDesiredFullRobotModel());
        KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(currentRobotConfiguration, rootJoint, allJointsExcludingHands);
        MessageTools.packDesiredJointState((KinematicsToolboxOutputStatus)this.initialRobotConfiguration, (FloatingJointReadOnly)rootJoint, (OneDoFJointReadOnly[])allJointsExcludingHands);
        CapturabilityBasedStatus capturabilityBasedStatus = this.latestCapturabilityBasedStatusReference.get();
        if (capturabilityBasedStatus == null) {
            LogTools.warn((String)"capturabilityBasedStatus should be set up.");
            return false;
        }
        this.ikController.updateCapturabilityBasedStatus(capturabilityBasedStatus);
        return true;
    }

    private boolean checkKeyFrameTimes(TDoubleArrayList wayPointTimes) {
        if (wayPointTimes.size() != this.getNumberOfKeyFrames()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfKeyFrames(); ++i) {
            if (EuclidCoreTools.epsilonEquals((double)wayPointTimes.get(i), (double)this.keyFrameTimes.get(i), (double)0.01)) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfKeyFrames() {
        return this.keyFrameTimes.size();
    }

    public KinematicsPlanningToolboxOutputStatus getSolution() {
        return this.solution;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.desiredFullRobotModel;
    }

    public void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        this.latestRobotConfigurationDataReference.set(newConfigurationData);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        this.latestCapturabilityBasedStatusReference.set(newStatus);
    }

    public CommonHumanoidReferenceFrames getDesiredReferenceFrames() {
        return this.ikController.getDesiredReferenceFrames();
    }
}

