/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.footstepStreamingModule;

import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import java.util.ArrayList;
import java.util.List;
import toolbox_msgs.msg.dds.FootstepStreamingToolboxInputMessage;
import toolbox_msgs.msg.dds.FootstepStreamingToolboxOutputStatus;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FootstepStreamingToolboxController;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FootstepStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.footstepStreamingToolboxAPI.FootstepStreamingToolboxInputCommand;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;

public class FootstepStreamingToolboxModule
extends ToolboxModule {
    protected final FootstepStreamingToolboxController controller;

    public FootstepStreamingToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer) {
        this(robotModel, FootstepStreamingToolboxParameters.defaultParameters(), startYoVariableServer);
    }

    public FootstepStreamingToolboxModule(DRCRobotModel robotModel, FootstepStreamingToolboxParameters parameters, boolean startYoVariableServer) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, (int)(parameters.getToolboxUpdatePeriod() * 1000.0));
        this.setTimeWithoutInputsBeforeGoingToSleep(parameters.getTimeThresholdForSleeping());
        this.controller = new FootstepStreamingToolboxController(this.commandInputManager, this.statusOutputManager, parameters, this.fullRobotModel, (FullHumanoidRobotModelFactory)robotModel, this.yoGraphicsListRegistry, this.registry);
        this.startYoVariableServer();
        if (this.yoVariableServer != null) {
            JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator((RobotVisualizer)this.yoVariableServer);
            jvmStatisticsGenerator.start();
        }
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return FootstepStreamingToolboxModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(FootstepStreamingToolboxInputCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return FootstepStreamingToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(FootstepStreamingToolboxOutputStatus.class);
        status.add(ControllerCrashNotificationPacket.class);
        return status;
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return FootstepStreamingToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ToolboxAPIs.FOOTSTEP_STREAMING_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return FootstepStreamingToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ToolboxAPIs.FOOTSTEP_STREAMING_TOOLBOX.withRobot(robotName).withInput();
    }

    public static ROS2Topic<ToolboxStateMessage> getInputStateTopic(String robotName) {
        return FootstepStreamingToolboxModule.getInputTopic(robotName).withTypeName(ToolboxStateMessage.class);
    }

    public static ROS2Topic<FootstepStreamingToolboxInputMessage> getInputCommandTopic(String robotName) {
        return FootstepStreamingToolboxModule.getInputTopic(robotName).withTypeName(FootstepStreamingToolboxInputMessage.class);
    }

    public static ROS2Topic<FootstepStreamingToolboxOutputStatus> getOutputStatusTopic(String robotName) {
        return FootstepStreamingToolboxModule.getOutputTopic(robotName).withTypeName(FootstepStreamingToolboxOutputStatus.class);
    }
}

