/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.footstepStreamingModule;

import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FSTSleepState;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FSTStreamingState;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FSTTools;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FootstepStreamingToolboxParameters;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FootstepStreamingToolboxController
extends ToolboxController {
    private final FSTTools tools;
    private final ExecutionTimer executionTimer;
    private FSTTimeProvider timeProvider;
    private final YoDouble time;
    private final StateMachine<FSTState, State> stateMachine;
    private final FSTSleepState sleepState;
    private final FSTStreamingState streamingState;
    private final YoBoolean isDone;

    public FootstepStreamingToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FootstepStreamingToolboxParameters parameters, FullHumanoidRobotModel desiredFullRobotModel, FullHumanoidRobotModelFactory fullRobotModelFactory, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.executionTimer = new ExecutionTimer("FSTTimer", this.registry);
        this.time = new YoDouble("time", this.registry);
        this.isDone = new YoBoolean("isDone", this.registry);
        if (parameters.getClockType() == FootstepStreamingToolboxParameters.ClockType.CPU_CLOCK) {
            this.timeProvider = FSTTimeProvider.createCPUClockBased();
        } else if (parameters.getClockType() == FootstepStreamingToolboxParameters.ClockType.FIXED_DT) {
            this.timeProvider = FSTTimeProvider.createFixedDT(parameters.getToolboxUpdatePeriod());
        } else {
            throw new RuntimeException("Unknown clock type: " + String.valueOf((Object)parameters.getClockType()));
        }
        this.tools = new FSTTools(commandInputManager, statusOutputManager, parameters, (DoubleProvider)this.time, yoGraphicsListRegistry, this.registry);
        this.sleepState = new FSTSleepState(this.tools);
        this.streamingState = new FSTStreamingState(this.tools);
        this.stateMachine = this.createStateMachine((DoubleProvider)this.time);
        this.isDone.set(false);
    }

    public void setTimeProvider(FSTTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    private StateMachine<FSTState, State> createStateMachine(DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(FSTState.class);
        factory.setNamePrefix("mainStateMachine").setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addState((Enum)FSTState.SLEEP, (State)this.sleepState);
        factory.addState((Enum)FSTState.STREAMING, (State)this.streamingState);
        factory.addDoneTransition((Enum)FSTState.SLEEP, (Enum)FSTState.STREAMING);
        return factory.build((Enum)FSTState.SLEEP);
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        this.timeProvider.initialize();
        this.time.set(this.timeProvider.getTime());
        return true;
    }

    @Override
    public void updateInternal() {
        try {
            this.executionTimer.startMeasurement();
            this.timeProvider.update();
            this.time.set(this.timeProvider.getTime());
            this.tools.update();
            this.stateMachine.doActionAndTransition();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                this.reportMessage(MessageTools.createControllerCrashNotificationPacket(null, (Throwable)e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.isDone.set(true);
        }
        finally {
            this.executionTimer.stopMeasurement();
        }
    }

    @Override
    public void notifyToolboxStateChange(ToolboxState newState) {
        if (newState == ToolboxState.SLEEP) {
            this.stateMachine.performTransition((Enum)FSTState.SLEEP);
        }
    }

    @Override
    public boolean isDone() {
        return this.isDone.getValue();
    }

    FSTState getCurrentStateKey() {
        return (FSTState)this.stateMachine.getCurrentStateKey();
    }

    public double getTime() {
        return this.time.getDoubleValue();
    }

    public static interface FSTTimeProvider {
        public void initialize();

        public void update();

        public double getTime();

        public static FSTTimeProvider createCPUClockBased() {
            return new FSTTimeProvider(){
                private long initialTimestamp = -1L;
                private double time = 0.0;

                @Override
                public void initialize() {
                    this.initialTimestamp = System.nanoTime();
                    this.time = 0.0;
                }

                @Override
                public void update() {
                    this.time = Conversions.nanosecondsToSeconds((long)(System.nanoTime() - this.initialTimestamp));
                }

                @Override
                public double getTime() {
                    return this.time;
                }
            };
        }

        public static FSTTimeProvider createFixedDT(final double dt) {
            return new FSTTimeProvider(){
                private double time = 0.0;

                @Override
                public void initialize() {
                    this.time = 0.0;
                }

                @Override
                public void update() {
                    this.time += dt;
                }

                @Override
                public double getTime() {
                    return this.time;
                }
            };
        }
    }

    public static enum FSTState {
        SLEEP,
        STREAMING;

        private static final FSTState[] values;

        public byte toByte() {
            return (byte)this.ordinal();
        }

        public static FSTState fromByte(byte enumAsByte) {
            if (enumAsByte == -1) {
                return null;
            }
            return values[enumAsByte];
        }

        static {
            values = FSTState.values();
        }
    }
}

