/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.footstepStreamingModule;

import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FootstepStreamingToolboxParameters;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.footstepStreamingToolboxAPI.FootstepStreamingToolboxInputCommand;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class FSTTools {
    private final CommandInputManager commandInputManager;
    private final StatusMessageOutputManager statusOutputManager;
    private final FootstepStreamingToolboxParameters parameters;
    private final DoubleProvider time;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final YoRegistry registry;
    private final double toolboxControllerPeriod;
    private final YoLong currentMessageId;
    private final YoBoolean hasNewInputCommand;
    private final YoBoolean hasPreviousInput;
    private final YoDouble latestInputReceivedTime;
    private final YoDouble previousInputReceivedTime;
    private FootstepStreamingToolboxInputCommand latestInput = null;
    private FootstepStreamingToolboxInputCommand previousInput = null;
    private final YoLong latestInputTimestampSource;
    private final YoDouble latestInputTimeSource;

    public FSTTools(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FootstepStreamingToolboxParameters parameters, DoubleProvider time, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        this.commandInputManager = commandInputManager;
        this.statusOutputManager = statusOutputManager;
        this.parameters = parameters;
        this.toolboxControllerPeriod = parameters.getToolboxUpdatePeriod();
        this.time = time;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.registry = registry;
        this.currentMessageId = new YoLong("currentMessageId", registry);
        this.currentMessageId.set(1L);
        this.hasNewInputCommand = new YoBoolean("hasNewInputCommand", registry);
        this.hasPreviousInput = new YoBoolean("hasPreviousInput", registry);
        this.latestInputReceivedTime = new YoDouble("latestInputReceivedTime", registry);
        this.previousInputReceivedTime = new YoDouble("previousInputReceivedTime", registry);
        this.flushInputCommands();
        this.latestInputTimestampSource = new YoLong("latestInputTimestampSource", registry);
        this.latestInputTimeSource = new YoDouble("latestInputTimeSource", registry);
    }

    public void update() {
        if (this.commandInputManager.isNewCommandAvailable(FootstepStreamingToolboxInputCommand.class)) {
            if (this.latestInput != null) {
                if (this.previousInput == null) {
                    this.previousInput = new FootstepStreamingToolboxInputCommand();
                }
                this.previousInput.set(this.latestInput);
                this.previousInputReceivedTime.set(this.latestInputReceivedTime.getValue());
                this.hasPreviousInput.set(true);
            }
            if (this.latestInput == null) {
                this.latestInput = new FootstepStreamingToolboxInputCommand();
            }
            this.latestInput.set((FootstepStreamingToolboxInputCommand)this.commandInputManager.pollNewestCommand(FootstepStreamingToolboxInputCommand.class));
            this.latestInputTimestampSource.set(this.latestInput.getInputFor(RobotSide.LEFT).getTimestamp());
            this.latestInputTimeSource.set((double)this.latestInput.getInputFor(RobotSide.LEFT).getTimestamp() * 1.0E-9);
            if (this.latestInput.getInputFor(RobotSide.LEFT).getTimestamp() <= 0L) {
                this.latestInput.getInputFor(RobotSide.LEFT).setTimestamp(Conversions.secondsToNanoseconds((double)this.time.getValue()));
            }
            this.latestInputReceivedTime.set(this.time.getValue());
            this.hasNewInputCommand.set(true);
        } else {
            this.hasNewInputCommand.set(false);
        }
    }

    public FootstepStreamingToolboxParameters getParameters() {
        return this.parameters;
    }

    public double getTime() {
        return this.time.getValue();
    }

    public FootstepStreamingToolboxInputCommand getLatestInput() {
        return this.latestInput;
    }

    public double getLatestInputReceivedTime() {
        return this.latestInputReceivedTime.getValue();
    }

    public boolean hasPreviousInput() {
        return this.hasPreviousInput.getValue();
    }

    public FootstepStreamingToolboxInputCommand getPreviousInput() {
        return this.hasPreviousInput.getValue() ? this.previousInput : null;
    }

    public double getPreviousInputReceivedTime() {
        return this.previousInputReceivedTime.getValue();
    }

    public boolean hasNewInputCommand() {
        return this.hasNewInputCommand.getValue();
    }

    public void flushInputCommands() {
        this.latestInput = null;
        this.commandInputManager.clearAllCommands();
        this.hasNewInputCommand.set(false);
        this.hasPreviousInput.set(false);
        this.latestInputReceivedTime.set(-1.0);
        this.previousInputReceivedTime.set(-1.0);
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }

    public StatusMessageOutputManager getStatusOutputManager() {
        return this.statusOutputManager;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public double getToolboxControllerPeriod() {
        return this.toolboxControllerPeriod;
    }
}

