/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.footstepStreamingModule;

import toolbox_msgs.msg.dds.FootstepStreamingToolboxOutputStatus;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FSTTools;
import us.ihmc.avatar.networkProcessor.footstepStreamingModule.FootstepStreamingToolboxParameters;
import us.ihmc.euclid.referenceFrame.FixedReferenceFrame;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.footstepStreamingToolboxAPI.FootstepStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.footstepStreamingToolboxAPI.FootstepStreamingToolboxSideCommand;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.filters.AlphaFilterTools;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class FSTStreamingState
implements State {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final FSTTools tools;
    private final SideDependentList<Boolean> isUserStepping = new SideDependentList();
    private final SideDependentList<RigidBodyTransform> initialTrackersTransform = new SideDependentList();
    private final SideDependentList<RigidBodyTransform> previousTrackersTransform = new SideDependentList();
    private final SideDependentList<Integer> stableIterationCounts = new SideDependentList();
    private final SideDependentList<FrameVector2D> directionTrackersCtrl = new SideDependentList();
    private final SideDependentList<RigidBodyTransform> initialRobotSwingFootTransformsInWorld = new SideDependentList();
    private final SideDependentList<Double> maxFeetHeight = new SideDependentList((Object)0.0, (Object)0.0);
    private double robotStepDuration = 0.0;
    private double robotSwingDuration = 0.0;
    private double robotElapsedTimeCurrentStep = 0.0;
    private RobotSide robotSwingSide;
    private boolean robotSwingFootIsLanding = false;
    private double currentStrideEstimate;
    private double currentYawEstimate;
    private double velocitySum = 0.0;
    private int velocityCount = 0;
    private double yawDotSum = 0.0;
    private int yawDotCount = 0;
    private boolean latestAdjustmentSent = false;
    private final YoDouble timeOfLastInput = new YoDouble("timeOfLastInput", this.registry);
    private final YoDouble timeSinceLastInput = new YoDouble("timeSinceLastInput", this.registry);
    private final YoDouble rawInputFrequency = new YoDouble("rawInputFrequency", this.registry);
    private final AlphaFilteredYoVariable inputFrequency;
    private final YoBoolean computeStepFromStance = new YoBoolean("computeStepFromStance", this.registry);
    private final YoDouble stepThreshold = new YoDouble("stepThreshold", this.registry);
    private final YoDouble liftThreshold = new YoDouble("liftThreshold", this.registry);
    private final YoDouble stabilityThreshold = new YoDouble("stabilityThreshold", this.registry);
    private final YoInteger stabilityIterations = new YoInteger("stabilityIterations", this.registry);
    private final YoDouble footstepMarginTime = new YoDouble("footstepMarginTime", this.registry);
    private final YoDouble defaultStride = new YoDouble("defaultStride", this.registry);
    private final YoDouble maxStride = new YoDouble("maxStride", this.registry);
    private final YoDouble maxDistanceToStance = new YoDouble("maxDistanceToStance", this.registry);
    private final YoDouble minDistanceToStance = new YoDouble("minDistanceToStance", this.registry);
    private final YoDouble kpDirection = new YoDouble("kpDirection", this.registry);
    private final YoDouble kpStride = new YoDouble("kpStride", this.registry);
    private final YoDouble strideVelocityScalingFactor = new YoDouble("strideVelocityScalingFactor", this.registry);
    private final YoDouble yawVelocityScalingFactor = new YoDouble("yawVelocityScalingFactor", this.registry);
    private final YoDouble defaultTurningThresholdDegrees = new YoDouble("defaultTurningThreshold", this.registry);
    private final YoDouble defaultTurnDegrees = new YoDouble("defaultTurn", this.registry);
    private final YoDouble maxYawRotation = new YoDouble("maxYawRotation", this.registry);
    private final YoDouble kpYaw = new YoDouble("kpYaw", this.registry);
    private final YoDouble maxYawToStance = new YoDouble("maxYawToStance", this.registry);
    private final YoDouble minYawToStance = new YoDouble("minYawToStance", this.registry);
    private final YoDouble yoRobotStepDuration = new YoDouble("robotStepDuration", this.registry);
    private final YoDouble yoRobotElapsedTimeCurrentStep = new YoDouble("robotElapsedTimeCurrentStep", this.registry);
    private final YoInteger yoRobotSwingSide = new YoInteger("robotSwingSide", this.registry);
    private final YoBoolean yoRobotSwingFootIsLanding = new YoBoolean("robotSwingFootIsLanding", this.registry);
    private final YoFramePoint3D yoInitialRobotSwingFootPosition = new YoFramePoint3D("robotInitialSwingPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoDouble yoInitialRobotSwingFootYaw = new YoDouble("robotInitialSwingYaw", this.registry);
    private final YoFramePoint3D yoRobotSwingFootPosition = new YoFramePoint3D("robotSwingPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoDouble yoRobotSwingFootYaw = new YoDouble("robotSwingYaw", this.registry);
    private final SideDependentList<YoFramePoint3D> yoInitialTrackersPosition = new SideDependentList();
    private final SideDependentList<YoDouble> yoInitialTrackersYaw = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> yoTrackersPosition = new SideDependentList();
    private final SideDependentList<YoDouble> yoTrackersYaw = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> yoTrackersTranslation = new SideDependentList();
    private final SideDependentList<YoDouble> yoTrackersYawVariation = new SideDependentList();
    private final SideDependentList<YoBoolean> yoIsUserStepping = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> yoDesiredFootPosition = new SideDependentList();
    private final SideDependentList<YoDouble> yoDesiredFootYaw = new SideDependentList();
    private final YoDouble yoLandingFactorStride = new YoDouble("landingFactorStride", this.registry);
    private final YoDouble yoRawStride = new YoDouble("rawStride", this.registry);
    private final YoDouble yoMeasuredStride = new YoDouble("measuredStride", this.registry);
    private final YoDouble yoDesiredStride = new YoDouble("desiredStride", this.registry);
    private final YoDouble yoErrorStride = new YoDouble("errorStride", this.registry);
    private final YoDouble yoControlledStride = new YoDouble("controlledStride", this.registry);

    public FSTStreamingState(FSTTools tools) {
        FootstepStreamingToolboxParameters parameters = tools.getParameters();
        this.tools = tools;
        double toolboxControllerPeriod = tools.getToolboxControllerPeriod();
        tools.getRegistry().addChild(this.registry);
        YoDouble inputFrequencyAlpha = new YoDouble("inputFrequencyFilter", this.registry);
        inputFrequencyAlpha.set(AlphaFilterTools.computeAlphaGivenBreakFrequencyProperly((double)2.0, (double)toolboxControllerPeriod));
        this.inputFrequency = new AlphaFilteredYoVariable("inputFrequency", this.registry, (DoubleProvider)inputFrequencyAlpha, this.rawInputFrequency);
        this.stepThreshold.set(parameters.getStepThreshold());
        this.liftThreshold.set(parameters.getLiftThreshold());
        this.stabilityThreshold.set(parameters.getStabilityThreshold());
        this.stabilityIterations.set(parameters.getStabilityIterations());
        this.footstepMarginTime.set(parameters.getFootstepMarginTime());
        this.defaultStride.set(parameters.getDefaultStride());
        this.maxStride.set(parameters.getMaxStride());
        this.maxDistanceToStance.set(parameters.getMaxDistanceToStance());
        this.minDistanceToStance.set(parameters.getMinDistanceToStance());
        this.kpDirection.set(parameters.getKpDirection());
        this.kpStride.set(parameters.getKpStride());
        this.strideVelocityScalingFactor.set(parameters.getStrideVelocityScalingFactor());
        this.yawVelocityScalingFactor.set(parameters.getYawVelocityScalingFactor());
        this.defaultTurningThresholdDegrees.set(parameters.getTurningThresholdDegrees());
        this.defaultTurnDegrees.set(parameters.getTurnDegrees());
        this.maxYawRotation.set(Math.toRadians(parameters.getMaxYawRotationDegrees()));
        this.kpYaw.set(parameters.getKpYaw());
        this.maxYawToStance.set(Math.toRadians(parameters.getMaxYawToStanceDegrees()));
        this.minYawToStance.set(Math.toRadians(parameters.getMinYawToStanceDegrees()));
        this.computeStepFromStance.set(parameters.getComputeFromStance());
        for (RobotSide side : RobotSide.values) {
            this.yoInitialTrackersPosition.put((Enum)side, (Object)new YoFramePoint3D(String.valueOf(side) + "_initialTrackerPosition", ReferenceFrame.getWorldFrame(), this.registry));
            this.yoInitialTrackersYaw.put((Enum)side, (Object)new YoDouble(String.valueOf(side) + "_initialTrackerYaw", this.registry));
            this.yoTrackersPosition.put((Enum)side, (Object)new YoFramePoint3D(String.valueOf(side) + "_trackerPosition", ReferenceFrame.getWorldFrame(), this.registry));
            this.yoTrackersYaw.put((Enum)side, (Object)new YoDouble(String.valueOf(side) + "_trackerYaw", this.registry));
            this.yoTrackersTranslation.put((Enum)side, (Object)new YoFramePoint3D(String.valueOf(side) + "_trackerTranslation", ReferenceFrame.getWorldFrame(), this.registry));
            this.yoTrackersYawVariation.put((Enum)side, (Object)new YoDouble(String.valueOf(side) + "_trackerYawVariation", this.registry));
            this.yoIsUserStepping.put((Enum)side, (Object)new YoBoolean(String.valueOf(side) + "_isUserStepping", this.registry));
            this.yoDesiredFootPosition.put((Enum)side, (Object)new YoFramePoint3D(String.valueOf(side) + "_desiredFootPosition", ReferenceFrame.getWorldFrame(), this.registry));
            this.yoDesiredFootYaw.put((Enum)side, (Object)new YoDouble(String.valueOf(side) + "_desiredFootYaw", this.registry));
        }
    }

    public void onEntry() {
        LogTools.debug((String)"Footstep Streaming enabled");
        for (RobotSide side : RobotSide.values()) {
            this.isUserStepping.put((Enum)side, (Object)false);
            ((YoBoolean)this.yoIsUserStepping.get((Enum)side)).set(false);
            this.stableIterationCounts.put((Enum)side, (Object)0);
            this.previousTrackersTransform.put((Enum)side, (Object)new RigidBodyTransform());
            this.directionTrackersCtrl.put((Enum)side, (Object)new FrameVector2D());
            this.currentStrideEstimate = this.defaultStride.getValue();
            this.currentYawEstimate = Math.toRadians(this.defaultTurnDegrees.getValue());
            this.initialTrackersTransform.put((Enum)side, null);
            this.initialRobotSwingFootTransformsInWorld.put((Enum)side, null);
            this.maxFeetHeight.put((Enum)side, (Object)0.0);
        }
        this.velocitySum = 0.0;
        this.velocityCount = 0;
        this.yawDotSum = 0.0;
        this.yawDotCount = 0;
        this.timeOfLastInput.set(Double.NaN);
        this.timeSinceLastInput.set(Double.NaN);
        this.inputFrequency.reset();
    }

    public void doAction(double timeInState) {
        if (this.tools.hasNewInputCommand()) {
            FootstepStreamingToolboxInputCommand latestInput = this.tools.getLatestInput();
            if (latestInput.isCommandValid()) {
                this.robotStepDuration = latestInput.getRobotStepDuration();
                this.robotSwingDuration = latestInput.getRobotStepDuration();
                this.robotElapsedTimeCurrentStep = latestInput.getRobotElapsedTimeCurrentStep();
                this.yoRobotStepDuration.set(this.robotStepDuration);
                this.yoRobotElapsedTimeCurrentStep.set(this.robotElapsedTimeCurrentStep);
                if (this.robotElapsedTimeCurrentStep == 0.0) {
                    this.latestAdjustmentSent = false;
                }
                this.robotSwingSide = latestInput.getRobotSwingSide();
                this.robotSwingFootIsLanding = latestInput.isRobotSwingFootLanding();
                this.yoRobotSwingSide.set((int)this.robotSwingSide.toByte());
                this.yoRobotSwingFootIsLanding.set(this.robotSwingFootIsLanding);
                if (this.robotElapsedTimeCurrentStep > this.robotStepDuration) {
                    this.robotElapsedTimeCurrentStep = this.robotStepDuration;
                }
                for (RobotSide side : RobotSide.values) {
                    FootstepStreamingToolboxSideCommand sideCommand = latestInput.getInputFor(side);
                    if (sideCommand != null) {
                        RigidBodyTransform currentTrackerTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)sideCommand.getCurrentPose());
                        RigidBodyTransform initialTrackerTransform = (RigidBodyTransform)this.initialTrackersTransform.get((Enum)side);
                        RigidBodyTransform currentRobotFootTransformInWorld = new RigidBodyTransform((RigidBodyTransformReadOnly)sideCommand.getRobotFootPose());
                        ((YoFramePoint3D)this.yoTrackersPosition.get((Enum)side)).set((Tuple3DReadOnly)currentTrackerTransform.getTranslation());
                        ((YoDouble)this.yoTrackersYaw.get((Enum)side)).set(currentTrackerTransform.getRotation().getYaw());
                        if (side.equals((Object)this.robotSwingSide)) {
                            this.yoRobotSwingFootPosition.set((Tuple3DReadOnly)currentRobotFootTransformInWorld.getTranslation());
                            this.yoRobotSwingFootYaw.set(currentRobotFootTransformInWorld.getRotation().getYaw());
                        }
                        if (initialTrackerTransform == null) {
                            this.initialTrackersTransform.put((Enum)side, (Object)new RigidBodyTransform((RigidBodyTransformReadOnly)currentTrackerTransform));
                            this.previousTrackersTransform.put((Enum)side, (Object)new RigidBodyTransform((RigidBodyTransformReadOnly)currentTrackerTransform));
                            this.initialRobotSwingFootTransformsInWorld.put((Enum)side, (Object)new RigidBodyTransform((RigidBodyTransformReadOnly)currentRobotFootTransformInWorld));
                            ((YoFramePoint3D)this.yoInitialTrackersPosition.get((Enum)side)).set((Tuple3DReadOnly)((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side)).getTranslation());
                            ((YoDouble)this.yoInitialTrackersYaw.get((Enum)side)).set(((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side)).getRotation().getYaw());
                            if (side.equals((Object)this.robotSwingSide)) {
                                this.yoInitialRobotSwingFootPosition.set((Tuple3DReadOnly)((RigidBodyTransform)this.initialRobotSwingFootTransformsInWorld.get((Enum)side)).getTranslation());
                                this.yoInitialRobotSwingFootYaw.set(((RigidBodyTransform)this.initialRobotSwingFootTransformsInWorld.get((Enum)side)).getRotation().getYaw());
                            }
                        }
                        Vector3D translationTracker = new Vector3D();
                        translationTracker.sub((Tuple3DReadOnly)currentTrackerTransform.getTranslation(), (Tuple3DReadOnly)((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side)).getTranslation());
                        FrameVector2D translationTrackerXY = new FrameVector2D(ReferenceFrame.getWorldFrame(), translationTracker.getX(), translationTracker.getY());
                        if (translationTracker.getZ() > (Double)this.maxFeetHeight.get((Enum)side)) {
                            this.maxFeetHeight.put((Enum)side, (Object)translationTracker.getZ());
                        }
                        double rotationTracker = currentTrackerTransform.getRotation().getYaw() - ((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side)).getRotation().getYaw();
                        ((YoFramePoint3D)this.yoTrackersTranslation.get((Enum)side)).set((Tuple3DReadOnly)translationTracker);
                        ((YoDouble)this.yoTrackersYawVariation.get((Enum)side)).set(rotationTracker);
                        if (!((Boolean)this.isUserStepping.get((Enum)side)).booleanValue()) {
                            if (translationTrackerXY.norm() >= this.stepThreshold.getDoubleValue() && translationTracker.getZ() >= this.liftThreshold.getDoubleValue()) {
                                translationTrackerXY.normalize();
                                this.directionTrackersCtrl.put((Enum)side, (Object)translationTrackerXY);
                                translationTrackerXY.scale(this.defaultStride.getDoubleValue());
                                double defaultYawRotation = Math.abs(rotationTracker) > Math.toRadians(this.defaultTurningThresholdDegrees.getValue()) ? Math.toRadians(this.defaultTurnDegrees.getValue()) * Math.signum(rotationTracker) : 0.0;
                                RigidBodyTransformReadOnly robotFootstepTransformInWorld = this.computeStepFromStance.getValue() ? this.computeTargetFootstepFromStance(latestInput, side, (FrameVector2DReadOnly)translationTrackerXY, defaultYawRotation, (RigidBodyTransformReadOnly)this.initialTrackersTransform.get((Enum)side)) : this.computeTargetFootstepFromInitialSwing(side, (FrameVector2DReadOnly)translationTrackerXY, defaultYawRotation, (RigidBodyTransformReadOnly)this.initialTrackersTransform.get((Enum)side));
                                FootstepStreamingToolboxOutputStatus outputStatus = new FootstepStreamingToolboxOutputStatus();
                                outputStatus.setAdjustmentFootstep(false);
                                outputStatus.setLastAdjustment(false);
                                outputStatus.setRobotSide(side.toByte());
                                outputStatus.getDesiredFootOrientation().set(robotFootstepTransformInWorld.getRotation());
                                outputStatus.getDesiredFootPosition().set(robotFootstepTransformInWorld.getTranslation());
                                this.tools.getStatusOutputManager().reportStatusMessage((Object)outputStatus);
                                this.isUserStepping.put((Enum)side, (Object)true);
                                this.isUserStepping.put((Enum)side.getOppositeSide(), (Object)false);
                                ((YoBoolean)this.yoIsUserStepping.get((Enum)side)).set(true);
                                ((YoBoolean)this.yoIsUserStepping.get((Enum)side.getOppositeSide())).set(false);
                                continue;
                            }
                            this.initialRobotSwingFootTransformsInWorld.put((Enum)side, (Object)new RigidBodyTransform((RigidBodyTransformReadOnly)currentRobotFootTransformInWorld));
                            if (side.equals((Object)this.robotSwingSide)) {
                                this.yoInitialRobotSwingFootPosition.set((Tuple3DReadOnly)((RigidBodyTransform)this.initialRobotSwingFootTransformsInWorld.get((Enum)side)).getTranslation());
                                this.yoInitialRobotSwingFootYaw.set(((RigidBodyTransform)this.initialRobotSwingFootTransformsInWorld.get((Enum)side)).getRotation().getYaw());
                            }
                            this.directionTrackersCtrl.put((Enum)side, (Object)new FrameVector2D());
                            continue;
                        }
                        this.isUserStepping.put((Enum)side.getOppositeSide(), (Object)false);
                        ((YoBoolean)this.yoIsUserStepping.get((Enum)side.getOppositeSide())).set(false);
                        if (initialTrackerTransform == null) continue;
                        Vector3D translationFromPreviousPosition = new Vector3D();
                        translationFromPreviousPosition.sub((Tuple3DReadOnly)currentTrackerTransform.getTranslation(), (Tuple3DReadOnly)((RigidBodyTransform)this.previousTrackersTransform.get((Enum)side)).getTranslation());
                        if (translationFromPreviousPosition.norm() <= this.stabilityThreshold.getDoubleValue() && translationTracker.getZ() < this.liftThreshold.getDoubleValue()) {
                            int stableCount = (Integer)this.stableIterationCounts.get((Enum)side);
                            this.stableIterationCounts.put((Enum)side, (Object)(++stableCount));
                            if (stableCount >= this.stabilityIterations.getIntegerValue()) {
                                if (!this.latestAdjustmentSent) {
                                    FootstepStreamingToolboxOutputStatus outputStatus = new FootstepStreamingToolboxOutputStatus();
                                    outputStatus.setRobotSide(side.toByte());
                                    outputStatus.setAdjustmentFootstep(true);
                                    outputStatus.setLastAdjustment(true);
                                    this.tools.getStatusOutputManager().reportStatusMessage((Object)outputStatus);
                                    this.latestAdjustmentSent = true;
                                    LogTools.debug((String)"Sent last footstep adjustment {}", (Object)side);
                                }
                                this.reset(side, currentTrackerTransform);
                                LogTools.debug((String)"User completed stepping with {}", (Object)side);
                            }
                        } else {
                            this.stableIterationCounts.put((Enum)side, (Object)0);
                            if (!this.tools.hasPreviousInput()) {
                                LogTools.error((String)"Cannot update footstep estimate because previous input is missing");
                            } else {
                                LogTools.debug((String)"side: {}, landing: {}", (Object)this.robotSwingSide, (Object)this.robotSwingFootIsLanding);
                                LogTools.debug((String)"latestAdjustment: {}", (Object)this.latestAdjustmentSent);
                                if (this.robotElapsedTimeCurrentStep < this.robotStepDuration - this.footstepMarginTime.getValue() && !this.latestAdjustmentSent && !this.robotSwingFootIsLanding) {
                                    FrameVector2D adjustedTranslationTrackerXY = new FrameVector2D(ReferenceFrame.getWorldFrame(), translationTracker.getX(), translationTracker.getY());
                                    double stride = this.defaultStride.getDoubleValue();
                                    if (sideCommand.getHasCurrentVelocity()) {
                                        stride = this.computeStrideEstimate(side, adjustedTranslationTrackerXY.norm(), translationTracker.getZ(), sideCommand.getCurrentVelocity().getLinearPart());
                                    }
                                    adjustedTranslationTrackerXY.normalize();
                                    adjustedTranslationTrackerXY.scale(stride);
                                    double adjustedYawRotation = this.computeYawEstimate(side, rotationTracker, translationTracker.getZ(), sideCommand.getCurrentVelocity().getLinearPartZ(), sideCommand.getCurrentVelocity().getAngularPartZ());
                                    RigidBodyTransformReadOnly robotFootstepTransformInWorld = this.computeStepFromStance.getValue() ? this.computeTargetFootstepFromStance(latestInput, side, (FrameVector2DReadOnly)adjustedTranslationTrackerXY, adjustedYawRotation, (RigidBodyTransformReadOnly)initialTrackerTransform) : this.computeTargetFootstepFromInitialSwing(side, (FrameVector2DReadOnly)adjustedTranslationTrackerXY, adjustedYawRotation, (RigidBodyTransformReadOnly)initialTrackerTransform);
                                    FootstepStreamingToolboxOutputStatus outputStatus = new FootstepStreamingToolboxOutputStatus();
                                    outputStatus.setRobotSide(side.toByte());
                                    outputStatus.setAdjustmentFootstep(true);
                                    outputStatus.setLastAdjustment(false);
                                    outputStatus.getDesiredFootOrientation().set(robotFootstepTransformInWorld.getRotation());
                                    outputStatus.getDesiredFootPosition().set(robotFootstepTransformInWorld.getTranslation());
                                    this.tools.getStatusOutputManager().reportStatusMessage((Object)outputStatus);
                                    LogTools.debug((String)"Sent footstep adjustment {}", (Object)side);
                                    ((YoFramePoint3D)this.yoDesiredFootPosition.get((Enum)side)).set(robotFootstepTransformInWorld.getTranslation());
                                    ((YoDouble)this.yoDesiredFootYaw.get((Enum)side)).set(robotFootstepTransformInWorld.getRotation().getYaw());
                                } else if (!this.latestAdjustmentSent) {
                                    FootstepStreamingToolboxOutputStatus outputStatus = new FootstepStreamingToolboxOutputStatus();
                                    outputStatus.setRobotSide(side.toByte());
                                    outputStatus.setAdjustmentFootstep(true);
                                    outputStatus.setLastAdjustment(true);
                                    this.tools.getStatusOutputManager().reportStatusMessage((Object)outputStatus);
                                    this.latestAdjustmentSent = true;
                                    LogTools.debug((String)"Sent last footstep adjustment {}", (Object)side);
                                }
                            }
                        }
                        this.previousTrackersTransform.put((Enum)side, (Object)new RigidBodyTransform((RigidBodyTransformReadOnly)currentTrackerTransform));
                        continue;
                    }
                    LogTools.warn((String)"Did not receive information for side {}", (Object)side.getSideNameFirstLetter());
                }
            }
            if (Double.isFinite(this.timeSinceLastInput.getValue()) && this.timeSinceLastInput.getValue() > 0.0) {
                this.rawInputFrequency.set(1.0 / this.timeSinceLastInput.getValue());
                this.inputFrequency.update();
            }
            this.timeOfLastInput.set(timeInState);
        }
        if (Double.isFinite(this.timeOfLastInput.getValue())) {
            this.timeSinceLastInput.set(timeInState - this.timeOfLastInput.getValue());
        }
    }

    private void reset(RobotSide side, RigidBodyTransform currentTrackerTransform) {
        this.isUserStepping.put((Enum)side, (Object)false);
        ((YoBoolean)this.yoIsUserStepping.get((Enum)side)).set(false);
        this.directionTrackersCtrl.put((Enum)side, (Object)new FrameVector2D());
        this.initialTrackersTransform.put((Enum)side, (Object)new RigidBodyTransform((RigidBodyTransformReadOnly)currentTrackerTransform));
        ((YoFramePoint3D)this.yoInitialTrackersPosition.get((Enum)side)).set((Tuple3DReadOnly)((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side)).getTranslation());
        ((YoDouble)this.yoInitialTrackersYaw.get((Enum)side)).set(((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side)).getRotation().getYaw());
        this.stableIterationCounts.put((Enum)side, (Object)0);
        this.maxFeetHeight.put((Enum)side, (Object)0.0);
        this.velocitySum = 0.0;
        this.velocityCount = 0;
        this.yawDotSum = 0.0;
        this.yawDotCount = 0;
        this.latestAdjustmentSent = false;
    }

    private RigidBodyTransformReadOnly computeTargetFootstepFromInitialSwing(RobotSide side, FrameVector2DReadOnly translationTrackerXY, double yawRotationTracker, RigidBodyTransformReadOnly initialTrackerTransform) {
        FramePoint2D initialTrackerXY = new FramePoint2D(ReferenceFrame.getWorldFrame(), initialTrackerTransform.getTranslationX(), initialTrackerTransform.getTranslationY());
        FramePoint2D predictedTrackerXY = new FramePoint2D((FrameTuple2DReadOnly)initialTrackerXY);
        predictedTrackerXY.add((FrameTuple2DReadOnly)translationTrackerXY);
        FixedReferenceFrame initialSwingTrackerFrame = new FixedReferenceFrame("initialSwingTracker", ReferenceFrame.getWorldFrame(), initialTrackerTransform);
        predictedTrackerXY.changeFrameAndProjectToXYPlane((ReferenceFrame)initialSwingTrackerFrame);
        RigidBodyTransform robotInitialSwingFootTransformInWorld = (RigidBodyTransform)this.initialRobotSwingFootTransformsInWorld.get((Enum)side);
        FixedReferenceFrame robotInitialSwingFootFrame = new FixedReferenceFrame("robotInitialSwingFoot", ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)robotInitialSwingFootTransformInWorld);
        FramePoint2D robotPredictedFootXY = new FramePoint2D(ReferenceFrame.getWorldFrame(), robotInitialSwingFootTransformInWorld.getTranslationX(), robotInitialSwingFootTransformInWorld.getTranslationY());
        robotPredictedFootXY.changeFrameAndProjectToXYPlane((ReferenceFrame)robotInitialSwingFootFrame);
        robotPredictedFootXY.setX(predictedTrackerXY.getX());
        robotPredictedFootXY.setY(predictedTrackerXY.getY());
        robotPredictedFootXY.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        double newYaw = robotInitialSwingFootTransformInWorld.getRotation().getYaw() + yawRotationTracker;
        RigidBodyTransform robotFootstepTransformInWorld = new RigidBodyTransform((RigidBodyTransformReadOnly)robotInitialSwingFootTransformInWorld);
        robotFootstepTransformInWorld.getTranslation().setX(robotPredictedFootXY.getX());
        robotFootstepTransformInWorld.getTranslation().setY(robotPredictedFootXY.getY());
        robotFootstepTransformInWorld.getRotation().setYawPitchRoll(newYaw, robotFootstepTransformInWorld.getRotation().getPitch(), robotFootstepTransformInWorld.getRotation().getRoll());
        return robotFootstepTransformInWorld;
    }

    private RigidBodyTransformReadOnly computeTargetFootstepFromStance(FootstepStreamingToolboxInputCommand latestInput, RobotSide side, FrameVector2DReadOnly translationTrackerXY, double yawRotationTracker, RigidBodyTransformReadOnly initialTrackerTransform) {
        FramePoint2D initialTrackerXY = new FramePoint2D(ReferenceFrame.getWorldFrame(), initialTrackerTransform.getTranslationX(), initialTrackerTransform.getTranslationY());
        FramePoint2D predictedTrackerXY = new FramePoint2D((FrameTuple2DReadOnly)initialTrackerXY);
        predictedTrackerXY.add((FrameTuple2DReadOnly)translationTrackerXY);
        FixedReferenceFrame stanceTrackerFrame = new FixedReferenceFrame("stanceTracker", ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.initialTrackersTransform.get((Enum)side.getOppositeSide()));
        predictedTrackerXY.changeFrameAndProjectToXYPlane((ReferenceFrame)stanceTrackerFrame);
        FramePose3D robotStanceFootTransformInWorld = latestInput.getInputFor(side.getOppositeSide()).getRobotFootPose();
        FixedReferenceFrame robotStanceFootFrame = new FixedReferenceFrame("robotStanceFoot", ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)robotStanceFootTransformInWorld);
        FramePoint2D robotPredictedFootXY = new FramePoint2D(ReferenceFrame.getWorldFrame(), robotStanceFootTransformInWorld.getTranslationX(), robotStanceFootTransformInWorld.getTranslationY());
        robotPredictedFootXY.changeFrameAndProjectToXYPlane((ReferenceFrame)robotStanceFootFrame);
        robotPredictedFootXY.setX(predictedTrackerXY.getX());
        robotPredictedFootXY.setY(predictedTrackerXY.getY());
        if (side == RobotSide.LEFT) {
            robotPredictedFootXY.setY(Math.max(this.minDistanceToStance.getValue(), Math.min(this.maxDistanceToStance.getValue(), robotPredictedFootXY.getY())));
        } else {
            robotPredictedFootXY.setY(Math.max(-this.maxDistanceToStance.getValue(), Math.min(-this.minDistanceToStance.getValue(), robotPredictedFootXY.getY())));
        }
        robotPredictedFootXY.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        double initialSwingTrackerYaw = initialTrackerTransform.getRotation().getYaw();
        double initialStanceTrackerYaw = ((RigidBodyTransform)this.initialTrackersTransform.get((Enum)side.getOppositeSide())).getRotation().getYaw();
        double newYawInStanceFrame = yawRotationTracker + (initialSwingTrackerYaw - initialStanceTrackerYaw);
        newYawInStanceFrame = side == RobotSide.LEFT ? Math.max(this.minYawToStance.getValue(), Math.min(this.maxYawToStance.getValue(), newYawInStanceFrame)) : Math.max(-this.maxYawToStance.getValue(), Math.min(this.minYawToStance.getValue(), newYawInStanceFrame));
        double newYaw = robotStanceFootTransformInWorld.getRotation().getYaw() + newYawInStanceFrame;
        RigidBodyTransform robotFootstepTransformInWorld = new RigidBodyTransform((RigidBodyTransformReadOnly)robotStanceFootTransformInWorld);
        robotFootstepTransformInWorld.getTranslation().setX(robotPredictedFootXY.getX());
        robotFootstepTransformInWorld.getTranslation().setY(robotPredictedFootXY.getY());
        robotFootstepTransformInWorld.getRotation().setYawPitchRoll(newYaw, robotFootstepTransformInWorld.getRotation().getPitch(), robotFootstepTransformInWorld.getRotation().getRoll());
        return robotFootstepTransformInWorld;
    }

    private FrameVector2D computeDirectionAdjustment(RobotSide side, Vector3DReadOnly translationTracker) {
        FrameVector2D directionTrackerDesired = new FrameVector2D(ReferenceFrame.getWorldFrame(), translationTracker.getX(), translationTracker.getY());
        directionTrackerDesired.normalize();
        FrameVector2D directionTrackerCtrl = (FrameVector2D)this.directionTrackersCtrl.get((Enum)side);
        FrameVector2D directionTrackerError = new FrameVector2D((FrameTuple2DReadOnly)directionTrackerDesired);
        directionTrackerError.sub((FrameTuple2DReadOnly)directionTrackerCtrl);
        directionTrackerCtrl.addX(this.kpDirection.getValue() * directionTrackerError.getX());
        directionTrackerCtrl.addY(this.kpDirection.getValue() * directionTrackerError.getY());
        directionTrackerCtrl.normalize();
        this.directionTrackersCtrl.put((Enum)side, (Object)new FrameVector2D((FrameTuple2DReadOnly)directionTrackerCtrl));
        return directionTrackerCtrl;
    }

    public double computeStrideEstimate(RobotSide side, double measuredHorizontalDistance, double verticalPosition, FixedFrameVector3DBasics linearVelocity) {
        double rawStride = measuredHorizontalDistance + this.strideVelocityScalingFactor.getValue() * this.getAverageHorizontalVelocity(linearVelocity) * (this.robotSwingDuration - this.robotElapsedTimeCurrentStep);
        double landingFactor = 1.0;
        if (linearVelocity.getZ() < 0.0) {
            landingFactor = verticalPosition / (Double)this.maxFeetHeight.get((Enum)side);
            landingFactor = Math.max(0.0, Math.min(1.0, landingFactor));
        }
        this.yoLandingFactorStride.set(landingFactor);
        double blendedStride = landingFactor * rawStride + (1.0 - landingFactor) * measuredHorizontalDistance;
        this.yoRawStride.set(rawStride);
        this.yoMeasuredStride.set(measuredHorizontalDistance);
        double desiredStride = Math.max(0.0, Math.min(blendedStride, this.maxStride.getValue()));
        this.yoDesiredStride.set(desiredStride);
        double error = desiredStride - this.currentStrideEstimate;
        this.yoErrorStride.set(error);
        double newStrideEstimate = this.currentStrideEstimate + this.kpStride.getValue() * error;
        this.currentStrideEstimate = newStrideEstimate = Math.max(0.0, Math.min(newStrideEstimate, this.maxStride.getValue()));
        this.yoControlledStride.set(this.currentStrideEstimate);
        return this.currentStrideEstimate;
    }

    private double getAverageHorizontalVelocity(FixedFrameVector3DBasics currentLinearVelocity) {
        FrameVector2D currentXY = new FrameVector2D(ReferenceFrame.getWorldFrame());
        currentXY.set((FrameTuple3DReadOnly)currentLinearVelocity);
        this.velocitySum += currentXY.norm();
        ++this.velocityCount;
        return this.velocitySum / (double)this.velocityCount;
    }

    public double computeYawEstimate(RobotSide side, double measuredYawRotation, double verticalPosition, double linearVerticalVelocity, double angularVelocity) {
        double rawYawRotation = measuredYawRotation + this.yawVelocityScalingFactor.getValue() * this.getAverageAngularVelocity(angularVelocity) * (this.robotSwingDuration - this.robotElapsedTimeCurrentStep);
        double landingFactor = 1.0;
        if (linearVerticalVelocity < 0.0) {
            landingFactor = verticalPosition / (Double)this.maxFeetHeight.get((Enum)side);
            landingFactor = Math.max(0.0, Math.min(1.0, landingFactor));
        }
        double blendedYawRotation = landingFactor * rawYawRotation + (1.0 - landingFactor) * measuredYawRotation;
        double desiredYawRotation = Math.max(-this.maxYawRotation.getValue(), Math.min(blendedYawRotation, this.maxYawRotation.getValue()));
        double error = desiredYawRotation - this.currentYawEstimate;
        double newYawEstimate = this.currentYawEstimate + this.kpYaw.getValue() * error;
        this.currentYawEstimate = newYawEstimate = Math.max(-this.maxYawRotation.getValue(), Math.min(newYawEstimate, this.maxYawRotation.getValue()));
        return this.currentYawEstimate;
    }

    private double getAverageAngularVelocity(double currentAngularVelocity) {
        this.yawDotSum += currentAngularVelocity;
        ++this.yawDotCount;
        return this.yawDotSum / (double)this.yawDotCount;
    }

    public void onExit(double timeInState) {
        LogTools.debug((String)"Footstep Streaming disabled");
        this.tools.flushInputCommands();
    }
}

