/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.footstepPlanningModule;

import controller_msgs.msg.dds.FootstepDataListMessage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import toolbox_msgs.msg.dds.FootstepPlannerActionMessage;
import toolbox_msgs.msg.dds.FootstepPlannerParametersPacket;
import toolbox_msgs.msg.dds.FootstepPlanningRequestPacket;
import toolbox_msgs.msg.dds.FootstepPlanningToolboxOutputStatus;
import toolbox_msgs.msg.dds.SwingPlannerParametersPacket;
import toolbox_msgs.msg.dds.SwingPlanningRequestPacket;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.FootstepPlannerAPI;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.footstepPlanning.FootstepDataMessageConverter;
import us.ihmc.footstepPlanning.FootstepPlan;
import us.ihmc.footstepPlanning.FootstepPlannerRequest;
import us.ihmc.footstepPlanning.FootstepPlannerRequestedAction;
import us.ihmc.footstepPlanning.FootstepPlanningModule;
import us.ihmc.footstepPlanning.graphSearch.parameters.DefaultFootstepPlannerParametersBasics;
import us.ihmc.footstepPlanning.graphSearch.parameters.DefaultFootstepPlannerParametersReadOnly;
import us.ihmc.footstepPlanning.log.FootstepPlannerLogger;
import us.ihmc.footstepPlanning.swing.SwingPlannerParametersBasics;
import us.ihmc.footstepPlanning.swing.SwingPlannerType;
import us.ihmc.footstepPlanning.tools.FootstepPlannerMessageTools;
import us.ihmc.footstepPlanning.tools.PlannerTools;
import us.ihmc.idl.IDLSequence;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class FootstepPlanningModuleLauncher {
    private static final String LOG_DIRECTORY_ENVIRONMENT_VARIABLE = "IHMC_FOOTSTEP_PLANNER_LOG_DIR";
    private static final String LOG_DIRECTORY;
    private static final int defaultFootstepPlanCapacity = 50;
    private static final int footstepPlanCapacity;

    public static FootstepPlanningModule createModule(DRCRobotModel robotModel) {
        return FootstepPlanningModuleLauncher.createModule(robotModel, "");
    }

    public static FootstepPlanningModule createModule(DRCRobotModel robotModel, String suffix) {
        String moduleName = robotModel.getSimpleRobotName();
        DefaultFootstepPlannerParametersBasics footstepPlannerParameters = robotModel.getFootstepPlannerParameters(suffix);
        SwingPlannerParametersBasics swingPlannerParameters = robotModel.getSwingPlannerParameters();
        StepReachabilityData stepReachabilityData = robotModel.getStepReachabilityData();
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        SideDependentList<ConvexPolygon2D> footPolygons = FootstepPlanningModuleLauncher.createFootPolygons(robotModel);
        return new FootstepPlanningModule(moduleName, robotModel.getAStarBodyPathPlannerParameters(), footstepPlannerParameters, swingPlannerParameters, walkingControllerParameters, footPolygons, stepReachabilityData);
    }

    public static FootstepPlanningModule createModule(ROS2Node ros2Node, DRCRobotModel robotModel) {
        return FootstepPlanningModuleLauncher.createModule(ros2Node, robotModel, false);
    }

    private static FootstepPlanningModule createModule(ROS2Node ros2Node, DRCRobotModel robotModel, boolean manageROS2Node) {
        FootstepPlanningModule footstepPlanningModule = FootstepPlanningModuleLauncher.createModule(robotModel);
        footstepPlanningModule.registerRosNode(ros2Node, manageROS2Node);
        String name = footstepPlanningModule.getName();
        ROS2Topic inputTopic = FootstepPlannerAPI.FOOTSTEP_PLANNER.withRobot(name).withInput();
        ROS2Topic outputTopic = FootstepPlannerAPI.FOOTSTEP_PLANNER.withRobot(name).withOutput();
        AtomicBoolean generateLog = new AtomicBoolean();
        FootstepPlanningModuleLauncher.createParametersCallbacks(ros2Node, footstepPlanningModule, inputTopic);
        FootstepPlanningModuleLauncher.createRequestCallback(robotModel.getSimpleRobotName(), ros2Node, footstepPlanningModule, inputTopic, generateLog);
        FootstepPlanningModuleLauncher.createStatusPublisher(robotModel.getSimpleRobotName(), ros2Node, footstepPlanningModule, outputTopic);
        FootstepPlanningModuleLauncher.createPlannerActionCallback(ros2Node, footstepPlanningModule, inputTopic, outputTopic);
        FootstepPlanningModuleLauncher.createLoggerCallback(footstepPlanningModule, generateLog);
        return footstepPlanningModule;
    }

    private static void createParametersCallbacks(ROS2Node ros2Node, FootstepPlanningModule footstepPlanningModule, ROS2Topic<?> inputTopic) {
        ros2Node.createSubscription(inputTopic.withTypeName(FootstepPlannerParametersPacket.class), s -> {
            if (!footstepPlanningModule.isPlanning()) {
                footstepPlanningModule.getFootstepPlannerParameters().set((FootstepPlannerParametersPacket)s.readNextData());
            }
        });
        ros2Node.createSubscription(inputTopic.withTypeName(SwingPlannerParametersPacket.class), s -> {
            if (!footstepPlanningModule.isPlanning()) {
                footstepPlanningModule.getSwingPlannerParameters().set((SwingPlannerParametersPacket)s.takeNextData());
            }
        });
    }

    private static void createRequestCallback(String robotName, ROS2Node ros2Node, FootstepPlanningModule footstepPlanningModule, ROS2Topic<?> inputTopic, AtomicBoolean generateLog) {
        ros2Node.createSubscription(inputTopic.withTypeName(FootstepPlanningRequestPacket.class), s -> {
            FootstepPlannerRequest request = new FootstepPlannerRequest();
            FootstepPlanningRequestPacket requestPacket = (FootstepPlanningRequestPacket)s.takeNextData();
            request.setFromPacket(requestPacket);
            generateLog.set(requestPacket.getGenerateLog());
            new Thread(() -> footstepPlanningModule.handleRequest(request), "FootstepPlanningRequestHandler").start();
        });
        ros2Node.createSubscription(inputTopic.withTypeName(SwingPlanningRequestPacket.class), s -> {
            SwingPlannerType swingPlannerType = SwingPlannerType.fromByte((byte)((SwingPlanningRequestPacket)s.takeNextData()).getRequestedSwingPlanner());
            if (swingPlannerType == SwingPlannerType.NONE) {
                LogTools.info((String)"Received swing replanning request with type NONE, ignoring message");
                return;
            }
            LogTools.info((String)("Replanning swing with " + String.valueOf(swingPlannerType)));
            new Thread(() -> footstepPlanningModule.recomputeSwingTrajectories(swingPlannerType)).start();
        });
    }

    private static void createStatusPublisher(String robotName, ROS2Node ros2Node, FootstepPlanningModule footstepPlanningModule, ROS2Topic outputTopic) {
        ROS2Publisher resultPublisher = ros2Node.createPublisher(outputTopic.withTypeName(FootstepPlanningToolboxOutputStatus.class));
        ROS2Publisher swingReplanPublisher = ros2Node.createPublisher(FootstepPlannerAPI.swingReplanOutputTopic((String)robotName));
        footstepPlanningModule.addStatusCallback(output -> {
            FootstepPlanningModuleLauncher.cropPlanToCapacity(output.getFootstepPlan());
            FootstepPlanningToolboxOutputStatus outputStatus = new FootstepPlanningToolboxOutputStatus();
            output.setPacket(outputStatus);
            resultPublisher.publish((Object)outputStatus);
        });
        footstepPlanningModule.addSwingReplanStatusCallback(footstepPlan -> {
            LogTools.info((String)"Publishing replanned swings");
            FootstepDataListMessage footstepDataListMessage = FootstepDataMessageConverter.createFootstepDataListFromPlan((FootstepPlan)footstepPlan, (double)-1.0, (double)-1.0);
            swingReplanPublisher.publish((Object)footstepDataListMessage);
        });
    }

    private static void cropPlanToCapacity(FootstepPlan footstepPlan) {
        while (footstepPlan.getNumberOfSteps() > footstepPlanCapacity) {
            footstepPlan.remove(footstepPlan.getNumberOfSteps() - 1);
        }
    }

    private static void createPlannerActionCallback(ROS2Node ros2Node, FootstepPlanningModule footstepPlanningModule, ROS2Topic inputTopic, ROS2Topic outputTopic) {
        ROS2Publisher parametersPublisher = ros2Node.createPublisher(outputTopic.withTypeName(FootstepPlannerParametersPacket.class));
        FootstepPlannerActionMessage footstepPlannerActionMessage = new FootstepPlannerActionMessage();
        FootstepPlannerParametersPacket footstepPlannerParametersPacket = new FootstepPlannerParametersPacket();
        Runnable callback = () -> {
            FootstepPlannerRequestedAction requestedAction = FootstepPlannerRequestedAction.fromByte((byte)footstepPlannerActionMessage.getRequestedAction());
            if (requestedAction == FootstepPlannerRequestedAction.HALT) {
                footstepPlanningModule.halt();
            } else if (requestedAction == FootstepPlannerRequestedAction.PUBLISH_PARAMETERS) {
                FootstepPlannerMessageTools.copyParametersToPacket((FootstepPlannerParametersPacket)footstepPlannerParametersPacket, (DefaultFootstepPlannerParametersReadOnly)footstepPlanningModule.getFootstepPlannerParameters());
                parametersPublisher.publish((Object)footstepPlannerParametersPacket);
            }
        };
        ros2Node.createSubscription(inputTopic.withTypeName(FootstepPlannerActionMessage.class), s -> {
            s.takeNextData((Object)footstepPlannerActionMessage, null);
            new Thread(callback, "FootstepPlannerActionCallback").start();
        });
    }

    private static void createLoggerCallback(FootstepPlanningModule footstepPlanningModule, AtomicBoolean generateLog) {
        FootstepPlannerLogger logger = new FootstepPlannerLogger(footstepPlanningModule);
        footstepPlanningModule.addStatusCallback(status -> {
            if (status.getFootstepPlanningResult() != null && status.getFootstepPlanningResult().terminalResult() && generateLog.get()) {
                logger.logSession(LOG_DIRECTORY);
            }
        });
    }

    public static SideDependentList<ConvexPolygon2D> createFootPolygons(DRCRobotModel robotModel) {
        if (robotModel.getContactPointParameters() == null) {
            return PlannerTools.createDefaultFootPolygons();
        }
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        return new SideDependentList(side -> {
            ArrayList footPoints = (ArrayList)contactPointParameters.getFootContactPoints().get((Enum)side);
            return new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)footPoints));
        });
    }

    static {
        int footstepListCapacity = 50;
        try {
            FootstepDataListMessage footstepDataListMessage = new FootstepDataListMessage();
            IDLSequence.Object footstepDataList = footstepDataListMessage.getFootstepDataList();
            Field valuesField = RecyclingArrayList.class.getDeclaredField("values");
            valuesField.setAccessible(true);
            Object[] values = (Object[])valuesField.get(footstepDataList);
            footstepListCapacity = values.length;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        footstepPlanCapacity = footstepListCapacity;
        String requestedLogDirectory = System.getenv(LOG_DIRECTORY_ENVIRONMENT_VARIABLE);
        LOG_DIRECTORY = requestedLogDirectory == null ? FootstepPlannerLogger.getDefaultLogsDirectory() : requestedLogDirectory;
    }
}

