/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import perception_msgs.msg.dds.DetectedFiducialPacket;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox.FiducialDetectorToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;

public class FiducialDetectorToolboxModule
extends ToolboxModule {
    private final FiducialDetectorToolboxController controller;

    public FiducialDetectorToolboxModule(String robotName, RobotTarget target, FullHumanoidRobotModel desiredFullRobotModel, LogModelProvider modelProvider) {
        super(robotName, desiredFullRobotModel, modelProvider, false, 250);
        this.controller = new FiducialDetectorToolboxController(target, this.statusOutputManager, this.registry);
        this.setTimeWithoutInputsBeforeGoingToSleep(1200000.0);
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        ros2Node.createSubscription(PerceptionAPI.VIDEO, videoPacket -> {
            if (this.controller != null) {
                this.controller.receivedPacket((VideoPacket)videoPacket.takeNextData());
                this.receivedInput.set(true);
            }
        });
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        ArrayList commands = new ArrayList();
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return Collections.singletonList(DetectedFiducialPacket.class);
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return FiducialDetectorToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return PerceptionAPI.FIDUCIAL_DETECTOR_TOOLBOX_OUTPUT.withRobot(robotName);
    }

    public static ROS2Topic<DetectedFiducialPacket> getDetectedFiducialOutputTopic(String robotName) {
        return FiducialDetectorToolboxModule.getOutputTopic(robotName).withTypeName(DetectedFiducialPacket.class);
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return FiducialDetectorToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return PerceptionAPI.FIDUCIAL_DETECTOR_TOOLBOX_INPUT.withRobot(robotName);
    }
}

