/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox;

import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import perception_msgs.msg.dds.IntrinsicParametersMessage;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.producers.JPEGDecompressor;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.Timer;
import us.ihmc.yoVariables.registry.YoRegistry;

@Deprecated
public class FiducialDetectorToolboxController
extends ToolboxController {
    private static final RescaleOp imageRescalingForSim = new RescaleOp(3.5f, 35.0f, null);
    private static final RescaleOp imageRescalingForRealRobot = new RescaleOp(1.5f, 35.0f, null);
    private static RescaleOp imageRescalingOperation;
    private final AtomicReference<VideoPacket> videoPacket = new AtomicReference();
    private final Timer statusTimer = new Timer();
    private static final boolean DEBUG = false;
    private JFrame frame;
    private ImageIcon image;
    private final Se3_F64 fiducialToCamera = new Se3_F64();
    private final Polygon2D_F64 bounds = new Polygon2D_F64();
    private final RotationMatrix fiducialRotationMatrix = new RotationMatrix();
    private final Vector3D cameraRigidPosition = new Vector3D();
    private final RigidBodyTransform cameraRigidTransform = new RigidBodyTransform();
    private final ReferenceFrame cameraReferenceFrame;
    private final ReferenceFrame detectorReferenceFrame;
    private final Object detector;
    private final JPEGDecompressor jpegDecompressor = new JPEGDecompressor();
    private final String prefix = "fiducial";
    private static final double expectedFiducialSize = 0.2032;
    private final FramePose3D cameraPose = new FramePose3D(ReferenceFrame.getWorldFrame());
    private final FramePose3D reportedFiducialPoseInWorldFrame = new FramePose3D(ReferenceFrame.getWorldFrame());
    private final AtomicReference<Boolean> inProcessingThread = new AtomicReference();

    public FiducialDetectorToolboxController(RobotTarget target, StatusMessageOutputManager statusOutputManager, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        imageRescalingOperation = target == RobotTarget.REAL_ROBOT ? imageRescalingForRealRobot : imageRescalingForSim;
        this.inProcessingThread.set(false);
        this.detector = new Object();
        this.cameraReferenceFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)"fiducialCameraReferenceFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.cameraRigidTransform);
        this.detectorReferenceFrame = new ReferenceFrame("fiducialDetectorReferenceFrame", this.cameraReferenceFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            }
        };
    }

    @Override
    public boolean initialize() {
        LogTools.info((String)"Initializing");
        return true;
    }

    public void receivedPacket(VideoPacket packet) {
        if (packet != null) {
            this.videoPacket.set(packet);
        }
    }

    @Override
    public void updateInternal() {
        VideoPacket latest;
        if (!this.inProcessingThread.get().booleanValue() && (latest = (VideoPacket)this.videoPacket.getAndSet(null)) != null) {
            Thread packetProcessor = new Thread(() -> {
                this.inProcessingThread.set(true);
                this.detectFromVideoPacket(latest);
                this.inProcessingThread.set(false);
            }, "FiducialDetectorToolboxController image processing");
            packetProcessor.start();
        }
    }

    private void detectFromVideoPacket(VideoPacket videoPacket) {
        BufferedImage bufferedImage = this.jpegDecompressor.decompressJPEGDataToBufferedImage(videoPacket.getData().copyArray());
        this.detect(bufferedImage, (Point3DReadOnly)videoPacket.getPosition(), (QuaternionReadOnly)videoPacket.getOrientation(), HumanoidMessageTools.toIntrinsicParameters((IntrinsicParametersMessage)videoPacket.getIntrinsicParameters()));
    }

    private void detect(BufferedImage bufferedImage, Point3DReadOnly cameraPositionInWorld, QuaternionReadOnly cameraOrientationInWorldXForward, Object intrinsicParameters) {
        imageRescalingOperation.filter(bufferedImage, bufferedImage);
        this.cameraRigidTransform.getRotation().set((Orientation3DReadOnly)cameraOrientationInWorldXForward);
        this.cameraRigidPosition.set((Tuple3DReadOnly)cameraPositionInWorld);
        this.cameraRigidTransform.getTranslation().set((Tuple3DReadOnly)this.cameraRigidPosition);
        this.cameraReferenceFrame.update();
        this.detectorReferenceFrame.update();
        this.cameraPose.getOrientation().set(cameraOrientationInWorldXForward);
        this.cameraPose.getPosition().set((Tuple3DReadOnly)cameraPositionInWorld);
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

