/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule;

import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotDesiredConfigurationData;
import java.util.ArrayList;
import java.util.List;
import toolbox_msgs.msg.dds.ExternalForceEstimationOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule.ExternalForceEstimationToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.externalForceEstimationToolboxAPI.ExternalForceEstimationToolboxConfigurationCommand;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class ExternalForceEstimationToolboxModule
extends ToolboxModule {
    public static final int UPDATE_PERIOD_MILLIS = 60;
    private static final double defaultTimeWithoutInputsBeforeSleep = 60.0;
    private final ExternalForceEstimationToolboxController forceEstimationToolboxController;

    public ExternalForceEstimationToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node ros2Node) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 60, (ROS2Node)ros2Node);
        this.forceEstimationToolboxController = new ExternalForceEstimationToolboxController(robotModel, this.fullRobotModel, this.commandInputManager, this.statusOutputManager, this.yoGraphicsListRegistry, 60, this.registry);
        this.timeWithoutInputsBeforeGoingToSleep.set(60.0);
        this.startYoVariableServer();
    }

    public ExternalForceEstimationToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 60);
        this.forceEstimationToolboxController = new ExternalForceEstimationToolboxController(robotModel, this.fullRobotModel, this.commandInputManager, this.statusOutputManager, this.yoGraphicsListRegistry, 60, this.registry);
        this.timeWithoutInputsBeforeGoingToSleep.set(60.0);
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        ROS2Topic controllerOutputTopic = HumanoidControllerAPI.getOutputTopic((String)this.robotName);
        ros2Node.createSubscription(controllerOutputTopic.withTypeName(RobotConfigurationData.class), s -> {
            if (this.forceEstimationToolboxController != null) {
                this.forceEstimationToolboxController.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
        ros2Node.createSubscription(controllerOutputTopic.withTypeName(RobotDesiredConfigurationData.class), s -> {
            if (this.forceEstimationToolboxController != null) {
                this.forceEstimationToolboxController.updateRobotDesiredConfigurationData((RobotDesiredConfigurationData)s.takeNextData());
            }
        });
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.forceEstimationToolboxController;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return ExternalForceEstimationToolboxModule.getSupportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> getSupportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(ExternalForceEstimationToolboxConfigurationCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return ExternalForceEstimationToolboxModule.getSupportedStatuses();
    }

    public static List<Class<? extends Settable<?>>> getSupportedStatuses() {
        ArrayList status = new ArrayList();
        status.add(ExternalForceEstimationOutputStatus.class);
        return status;
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return ExternalForceEstimationToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ToolboxAPIs.EXTERNAL_FORCE_ESTIMATION_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return ExternalForceEstimationToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ToolboxAPIs.EXTERNAL_FORCE_ESTIMATION_TOOLBOX.withRobot(robotName).withInput();
    }
}

