/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotConfigurationDataPubSubType;
import controller_msgs.msg.dds.RobotDesiredConfigurationData;
import controller_msgs.msg.dds.RobotDesiredConfigurationDataPubSubType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import toolbox_msgs.msg.dds.ExternalForceEstimationConfigurationMessage;
import toolbox_msgs.msg.dds.ToolboxStateMessage;
import us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule.ExternalForceEstimationToolboxModule;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class ExternalForceEstimationMessageReplay {
    static final String timestampName = "Timestamp";
    static final String robotConfigurationDataName = RobotConfigurationData.class.getSimpleName();
    static final String robotDesiredConfigurationDataName = RobotDesiredConfigurationData.class.getSimpleName();
    private final String robotName;
    private final List<MessageSet> messages;
    private final RealtimeROS2Node ros2Node;
    private final JSONSerializer<RobotConfigurationData> robotConfigurationDataSerializer = new JSONSerializer((TopicDataType)new RobotConfigurationDataPubSubType());
    private final JSONSerializer<RobotDesiredConfigurationData> robotDesiredConfigurationDataSerializer = new JSONSerializer((TopicDataType)new RobotDesiredConfigurationDataPubSubType());
    private final ROS2Publisher<RobotConfigurationData> robotConfigurationDataPublisher;
    private final ROS2Publisher<RobotDesiredConfigurationData> robotDesiredConfigurationDataPublisher;
    private final ROS2Publisher<ToolboxStateMessage> toolboxStatePublisher;
    private final ROS2Publisher<ExternalForceEstimationConfigurationMessage> configMessagePublisher;

    public ExternalForceEstimationMessageReplay(String robotName, InputStream inputStream) throws IOException {
        this.robotName = robotName;
        this.messages = this.loadMessages(inputStream);
        String name = this.getClass().getSimpleName();
        this.ros2Node = new ROS2NodeBuilder().buildRealtime("ihmc_" + name);
        ROS2Topic controllerOutputTopic = HumanoidControllerAPI.getOutputTopic((String)robotName);
        this.robotConfigurationDataPublisher = this.ros2Node.createPublisher(controllerOutputTopic.withTypeName(RobotConfigurationData.class));
        this.robotDesiredConfigurationDataPublisher = this.ros2Node.createPublisher(controllerOutputTopic.withTypeName(RobotDesiredConfigurationData.class));
        ROS2Topic<?> toolboxInputTopic = ExternalForceEstimationToolboxModule.getInputTopic(robotName);
        this.configMessagePublisher = this.ros2Node.createPublisher(toolboxInputTopic.withTypeName(ExternalForceEstimationConfigurationMessage.class));
        this.toolboxStatePublisher = this.ros2Node.createPublisher(toolboxInputTopic.withTypeName(ToolboxStateMessage.class));
        this.ros2Node.spin();
    }

    public void replayAllMessages() {
        ExternalForceEstimationConfigurationMessage configurationMessage = new ExternalForceEstimationConfigurationMessage();
        configurationMessage.setEstimatorGain(0.75);
        configurationMessage.getRigidBodyHashCodes().add(601127246);
        ((Point3D)configurationMessage.getContactPointPositions().add()).set(0.0, -0.35, -0.03);
        configurationMessage.setCalculateRootJointWrench(true);
        this.configMessagePublisher.publish((Object)configurationMessage);
        this.sendToolboxStateMessage(ToolboxState.WAKE_UP);
        ThreadTools.sleep((long)1L);
        for (int i = 0; i < this.messages.size(); ++i) {
            this.sendMessagesAtIndex(i);
            if (i == this.messages.size() - 1) continue;
            int timeDifferenceMillis = (int)(1.0E-6 * (double)(this.messages.get((int)(i + 1)).timestamp - this.messages.get((int)i).timestamp));
            ThreadTools.sleep((long)timeDifferenceMillis);
        }
        this.sendToolboxStateMessage(ToolboxState.SLEEP);
    }

    private List<MessageSet> loadMessages(InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(inputStream);
        int size = jsonNode.size();
        ArrayList<MessageSet> allMessages = new ArrayList<MessageSet>();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = jsonNode.get(i);
            MessageSet messageSet = new MessageSet(childNode.get(timestampName).asLong());
            if (childNode.has(robotConfigurationDataName)) {
                messageSet.robotConfigurationData = (RobotConfigurationData)this.robotConfigurationDataSerializer.deserialize(childNode.get(robotConfigurationDataName).toString());
            }
            if (childNode.has(robotDesiredConfigurationDataName)) {
                messageSet.robotDesiredConfigurationData = (RobotDesiredConfigurationData)this.robotDesiredConfigurationDataSerializer.deserialize(childNode.get(robotDesiredConfigurationDataName).toString());
            }
            allMessages.add(messageSet);
        }
        return allMessages;
    }

    private void sendMessagesAtIndex(int i) {
        MessageSet messageSet = this.messages.get(i);
        if (messageSet.robotConfigurationData != null) {
            this.robotConfigurationDataPublisher.publish((Object)messageSet.robotConfigurationData);
        }
        if (messageSet.robotDesiredConfigurationData != null) {
            this.robotDesiredConfigurationDataPublisher.publish((Object)messageSet.robotDesiredConfigurationData);
        }
    }

    private void sendToolboxStateMessage(ToolboxState toolboxState) {
        ToolboxStateMessage toolboxStateMessage = new ToolboxStateMessage();
        toolboxStateMessage.setRequestedToolboxState(toolboxState.toByte());
        this.toolboxStatePublisher.publish((Object)toolboxStateMessage);
    }

    public static void main(String[] args) throws IOException {
        String robotName = "Valkyrie";
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("JSON log", "json"));
        int chooserState = fileChooser.showOpenDialog(null);
        if (chooserState == 0) {
            FileInputStream inputStream = new FileInputStream(fileChooser.getSelectedFile());
            new ExternalForceEstimationMessageReplay(robotName, inputStream).replayAllMessages();
        }
    }

    private class MessageSet {
        private final long timestamp;
        private RobotConfigurationData robotConfigurationData = null;
        private RobotDesiredConfigurationData robotDesiredConfigurationData = null;

        MessageSet(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

