/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.directionalControlToolboxModule;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;

public class RobotModelUpdater {
    private final OneDoFJointBasics[] allJoints;
    private final int jointNameHash;
    private final AtomicReference<RigidBodyTransform> newRootJointPoseReference = new AtomicReference<Object>(null);
    private final AtomicReference<float[]> newJointConfigurationReference = new AtomicReference<Object>(null);
    private FullHumanoidRobotModel fullRobotModel;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(4);
    private final int CONFIG_UPDATE_RATE_MS = 10;

    public RobotModelUpdater(FullHumanoidRobotModel robotModel) {
        this.fullRobotModel = robotModel;
        this.allJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.jointNameHash = RobotModelUpdater.calculateJointNameHash(this.allJoints, this.fullRobotModel.getForceSensorDefinitions(), this.fullRobotModel.getIMUDefinitions());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                float[] newJointConfiguration;
                RigidBodyTransform newRootJointPose = RobotModelUpdater.this.newRootJointPoseReference.getAndSet(null);
                if (newRootJointPose != null) {
                    RobotModelUpdater.this.fullRobotModel.getRootJoint().setJointConfiguration((RigidBodyTransformReadOnly)newRootJointPose);
                }
                if ((newJointConfiguration = (float[])RobotModelUpdater.this.newJointConfigurationReference.getAndSet(null)) != null) {
                    for (int i = 0; i < RobotModelUpdater.this.allJoints.length; ++i) {
                        RobotModelUpdater.this.allJoints[i].setQ((double)newJointConfiguration[i]);
                    }
                }
                RobotModelUpdater.this.fullRobotModel.getElevator().updateFramesRecursively();
            }
        };
        this.scheduler.scheduleAtFixedRate(task, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void updateConfiguration(RobotConfigurationData robotConfigurationData) {
        if (robotConfigurationData.getJointNameHash() != this.jointNameHash) {
            throw new RuntimeException("Joint names do not match for RobotConfigurationData");
        }
        this.newRootJointPoseReference.set(new RigidBodyTransform((Orientation3DReadOnly)robotConfigurationData.getRootOrientation(), (Tuple3DReadOnly)robotConfigurationData.getRootPosition()));
        this.newJointConfigurationReference.set(robotConfigurationData.getJointAngles().toArray());
    }

    public static int calculateJointNameHash(OneDoFJointBasics[] joints, ForceSensorDefinition[] forceSensorDefinitions, IMUDefinition[] imuDefinitions) {
        CRC32 crc = new CRC32();
        for (OneDoFJointBasics oneDoFJointBasics : joints) {
            crc.update(oneDoFJointBasics.getName().getBytes());
        }
        for (OneDoFJointBasics oneDoFJointBasics : forceSensorDefinitions) {
            crc.update(oneDoFJointBasics.getSensorName().getBytes());
        }
        for (OneDoFJointBasics oneDoFJointBasics : imuDefinitions) {
            crc.update(oneDoFJointBasics.getName().getBytes());
        }
        return (int)crc.getValue();
    }

    public FullHumanoidRobotModel getRobot() {
        return this.fullRobotModel;
    }
}

