/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.directionalControlToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingControllerFailureStatusMessage;
import java.util.ArrayList;
import java.util.List;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.directionalControlToolboxModule.DirectionalControlController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.directionalControlToolboxAPI.DirectionalControlConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.directionalControlToolboxAPI.DirectionalControlInputCommand;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class DirectionalControlModule
extends ToolboxModule {
    private ROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;
    private ROS2Publisher<FootstepDataListMessage> footstepPublisher;
    private ROS2Publisher<FootstepDataListMessage> footstepVisualizationPublisher;
    private final DirectionalControlController steppingController;
    private static final int UPDATE_PERIOD_IN_MS = 10;

    public DirectionalControlModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node ros2Node) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 10, (ROS2Node)ros2Node);
        this.steppingController = new DirectionalControlController(this.fullRobotModel, robotModel.getWalkingControllerParameters(), this.statusOutputManager, this.registry);
        this.setup(robotModel);
    }

    public DirectionalControlModule(DRCRobotModel robotModel, boolean startYoVariableServer) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 10);
        this.steppingController = new DirectionalControlController(this.fullRobotModel, robotModel.getWalkingControllerParameters(), this.statusOutputManager, this.registry);
        this.setup(robotModel);
    }

    private void setup(DRCRobotModel robotModel) {
        this.steppingController.setPauseWalkingPublisher(arg_0 -> this.pauseWalkingPublisher.publish(arg_0));
        this.steppingController.setFootstepPublisher(arg_0 -> this.footstepPublisher.publish(arg_0));
        this.steppingController.setFootstepVisualizationPublisher(arg_0 -> this.footstepVisualizationPublisher.publish(arg_0));
        this.commandInputManager.registerHasReceivedInputListener(commandClass -> {
            DirectionalControlInputCommand inputCommand;
            DirectionalControlConfigurationCommand configCommand = (DirectionalControlConfigurationCommand)this.commandInputManager.pollNewestCommand(DirectionalControlConfigurationCommand.class);
            if (configCommand != null) {
                this.steppingController.updateConfiguration(configCommand);
            }
            if ((inputCommand = (DirectionalControlInputCommand)this.commandInputManager.pollNewestCommand(DirectionalControlInputCommand.class)) != null) {
                this.steppingController.updateInputs(inputCommand);
            }
        });
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        ROS2Topic controllerPubGenerator = HumanoidControllerAPI.getOutputTopic((String)this.robotName);
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(RobotConfigurationData.class), s -> {
            if (this.steppingController != null) {
                this.steppingController.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(FootstepStatusMessage.class), s -> {
            if (this.steppingController != null) {
                this.steppingController.updateFootstepStatusMessage((FootstepStatusMessage)s.takeNextData());
            }
        });
        ros2Node.createSubscription(REACommunicationProperties.outputTopic.withTypeName(PlanarRegionsListMessage.class), s -> {
            if (this.steppingController != null) {
                this.steppingController.updatePlanarRegionsListMessage((PlanarRegionsListMessage)s.takeNextData());
            }
        });
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(WalkingControllerFailureStatusMessage.class), s -> {
            if (this.steppingController != null) {
                this.steppingController.updateWalkingControllerFailureStatusMessage((WalkingControllerFailureStatusMessage)s.takeNextData());
            }
        });
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(CapturabilityBasedStatus.class), s -> {
            if (this.steppingController != null) {
                this.steppingController.updateCapturabilityBasedStatus((CapturabilityBasedStatus)s.takeNextData());
            }
        });
        ROS2Topic controllerSubGenerator = HumanoidControllerAPI.getInputTopic((String)this.robotName);
        this.pauseWalkingPublisher = ros2Node.createPublisher(controllerSubGenerator.withTypeName(PauseWalkingMessage.class));
        this.footstepPublisher = ros2Node.createPublisher(controllerSubGenerator.withTypeName(FootstepDataListMessage.class));
        this.footstepVisualizationPublisher = ros2Node.createPublisher(DirectionalControlModule.getOutputTopic(this.robotName).withTypeName(FootstepDataListMessage.class));
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.steppingController;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return DirectionalControlModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(DirectionalControlConfigurationCommand.class);
        commands.add(DirectionalControlInputCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return DirectionalControlModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        return status;
    }

    @Override
    public void sleep() {
        LogTools.info((String)"Directional control toolbox told to sleep");
        super.sleep();
    }

    @Override
    public void wakeUp() {
        LogTools.info((String)"Directional control toolbox told to wake up");
        super.wakeUp();
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return DirectionalControlModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ToolboxAPIs.DIRECTIONAL_CONTROL_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return DirectionalControlModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ToolboxAPIs.DIRECTIONAL_CONTROL_TOOLBOX.withRobot(robotName).withInput();
    }
}

