/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessagePubSubType;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;

public class SixDoFMotionControlAnchorDescription {
    public static final String ANCHOR_JSON = SixDoFMotionControlAnchorDescription.class.getSimpleName();
    public static final String RIGID_BODY_NAME_JSON = "rigidBodyName";
    public static final String IS_CONTACT_STATE_JSON = "isContactState";
    public static final String IS_TRACKING_CONTROLLER_JSON = "isTrackingController";
    public static final String ANCHOR_ID_JSON = "anchorId";
    public static final String CONTACT_NORMAL_JSON = "contactNormalInWorld";
    public static final String IK_SOLVER_MESSAGE_JSON = "ikSolverMessage";
    private static final ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
    private static final JSONSerializer<KinematicsToolboxRigidBodyMessage> messageSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxRigidBodyMessagePubSubType());
    private String rigidBodyName;
    private boolean isContactState;
    private boolean isTrackingController;
    private int anchorId = -1;
    private FrameVector3DReadOnly contactNormal;
    private KinematicsToolboxRigidBodyMessage inputMessage;

    public SixDoFMotionControlAnchorDescription() {
    }

    public SixDoFMotionControlAnchorDescription(SixDoFMotionControlAnchorDescription other) {
        this.rigidBodyName = other.rigidBodyName;
        this.isContactState = other.isContactState;
        this.isTrackingController = other.isTrackingController;
        this.anchorId = other.anchorId;
        this.contactNormal = other.contactNormal;
        this.inputMessage = new KinematicsToolboxRigidBodyMessage(other.inputMessage);
    }

    public static SixDoFMotionControlAnchorDescription fromJSON(JsonNode node) {
        JsonNode anchorNode = node.get(ANCHOR_JSON);
        try {
            SixDoFMotionControlAnchorDescription description = new SixDoFMotionControlAnchorDescription();
            description.setRigidBodyName(anchorNode.get(RIGID_BODY_NAME_JSON).asText());
            description.setContactState(anchorNode.get(IS_CONTACT_STATE_JSON).asBoolean());
            description.setTrackingController(anchorNode.get(IS_TRACKING_CONTROLLER_JSON).asBoolean());
            description.setInputMessage((KinematicsToolboxRigidBodyMessage)messageSerializer.deserialize(anchorNode.get(IK_SOLVER_MESSAGE_JSON).toString()));
            if (anchorNode.has(ANCHOR_ID_JSON)) {
                description.setAnchorId(anchorNode.get(ANCHOR_ID_JSON).asInt());
            }
            if (anchorNode.has(CONTACT_NORMAL_JSON)) {
                description.setContactNormal(SixDoFMotionControlAnchorDescription.stringToTuple3D(anchorNode.get(CONTACT_NORMAL_JSON).textValue()));
            }
            return description;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode toJSON(ObjectMapper objectMapper) {
        ObjectNode root = objectMapper.createObjectNode();
        ObjectNode anchorJSON = root.putObject(ANCHOR_JSON);
        anchorJSON.put(RIGID_BODY_NAME_JSON, this.rigidBodyName);
        anchorJSON.put(IS_CONTACT_STATE_JSON, this.isContactState);
        anchorJSON.put(IS_TRACKING_CONTROLLER_JSON, this.isTrackingController);
        anchorJSON.put(ANCHOR_ID_JSON, this.anchorId);
        if (this.contactNormal != null) {
            anchorJSON.put(CONTACT_NORMAL_JSON, SixDoFMotionControlAnchorDescription.tuple3DToString((Tuple3DReadOnly)this.contactNormal));
        }
        try {
            anchorJSON.set(IK_SOLVER_MESSAGE_JSON, SixDoFMotionControlAnchorDescription.messageToJSON(messageSerializer, this.inputMessage));
            return root;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String tuple3DToString(Tuple3DReadOnly vector) {
        return vector.getX() + "," + vector.getY() + "," + vector.getZ();
    }

    private static FrameVector3DReadOnly stringToTuple3D(String string) {
        String[] tupleValues = string.split(",");
        return new FrameVector3D(ReferenceFrame.getWorldFrame(), Double.parseDouble(tupleValues[0]), Double.parseDouble(tupleValues[1]), Double.parseDouble(tupleValues[2]));
    }

    private static <T> JsonNode messageToJSON(JSONSerializer<T> serializer, T message) throws IOException {
        return objectMapper.readTree(serializer.serializeToString(message));
    }

    public String getRigidBodyName() {
        return this.rigidBodyName;
    }

    public boolean isContactState() {
        return this.isContactState;
    }

    public boolean isTrackingController() {
        return this.isTrackingController;
    }

    public int getAnchorId() {
        return this.anchorId;
    }

    public FrameVector3DReadOnly getContactNormal() {
        return this.contactNormal;
    }

    public KinematicsToolboxRigidBodyMessage getInputMessage() {
        return this.inputMessage;
    }

    public void setRigidBodyName(String rigidBodyName) {
        this.rigidBodyName = rigidBodyName;
    }

    public void setContactState(boolean isContactState) {
        this.isContactState = isContactState;
    }

    public void setTrackingController(boolean isTrackingController) {
        this.isTrackingController = isTrackingController;
    }

    public void setAnchorId(int anchorId) {
        this.anchorId = anchorId;
    }

    public void setContactNormal(FrameVector3DReadOnly contactNormal) {
        if (contactNormal != null) {
            contactNormal.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
            this.contactNormal = new FrameVector3D((FrameTuple3DReadOnly)contactNormal);
        }
    }

    public void setInputMessage(KinematicsToolboxRigidBodyMessage inputMessage) {
        this.inputMessage = inputMessage;
    }

    public void applyTransform(Transform transform) {
        this.inputMessage.getDesiredPositionInWorld().applyTransform(transform);
        this.inputMessage.getDesiredOrientationInWorld().applyTransform(transform);
    }

    public String toString() {
        return String.format("[%s=%s, %s=%s, %s=%s, %s=%s]", RIGID_BODY_NAME_JSON, this.rigidBodyName, IS_CONTACT_STATE_JSON, this.isContactState, IS_TRACKING_CONTROLLER_JSON, this.isTrackingController, IK_SOLVER_MESSAGE_JSON, this.inputMessage);
    }
}

