/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import controller_msgs.msg.dds.OneDoFJointTrajectoryMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyJointspaceTrajectoryMessage;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import ihmc_common_msgs.msg.dds.TrajectoryPoint1DMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;

public class MultiContactScriptPostProcessor {
    private final RigidBodyBasics rootBody;
    private final FloatingJointBasics rootJoint;
    private final int jointNameHash;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final TDoubleArrayList waypointTimes = new TDoubleArrayList();

    public MultiContactScriptPostProcessor(FullHumanoidRobotModelFactory fullRobotModelFactory) {
        FullHumanoidRobotModel fullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.rootBody = fullRobotModel.getElevator();
        this.rootJoint = fullRobotModel.getRootJoint();
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        this.jointNameHash = Arrays.hashCode(this.oneDoFJoints);
    }

    public WholeBodyJointspaceTrajectoryMessage process1(List<KinematicsToolboxSnapshotDescription> rawScript) {
        this.checkJointNameHash(rawScript);
        this.computeRegularizedWaypointTimes(rawScript);
        List desiredRobotConfigurations = rawScript.stream().map(KinematicsToolboxSnapshotDescription::getIkSolution).collect(Collectors.toList());
        RobotConfigurationData startDesiredConfiguration = rawScript.get(0).getControllerConfiguration();
        KinematicsToolboxOutputStatus targetDesiredConfiguration = (KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(desiredRobotConfigurations.size() - 1);
        double totalTrajectoryTime = 0.0;
        for (int i = 0; i < rawScript.size(); ++i) {
            totalTrajectoryTime += rawScript.get(i).getExecutionDuration();
        }
        int numberOfJoints = startDesiredConfiguration.getJointAngles().size();
        int numberOfConfigurations = 1 + desiredRobotConfigurations.size();
        TDoubleArrayList startPosition = MultiContactScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)startDesiredConfiguration.getJointAngles());
        TDoubleArrayList startVelocity = MultiContactScriptPostProcessor.zeros(numberOfJoints);
        TDoubleArrayList targetPosition = MultiContactScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)targetDesiredConfiguration.getDesiredJointAngles());
        TDoubleArrayList targetVelocity = MultiContactScriptPostProcessor.zeros(numberOfJoints);
        ArrayList<TDoubleArrayList> waypoints = new ArrayList<TDoubleArrayList>();
        for (int i = 0; i < desiredRobotConfigurations.size() - 1; ++i) {
            waypoints.add(MultiContactScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)((KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(i)).getDesiredJointAngles()));
        }
        TrajectoryPointOptimizer trajectoryPointOptimizer = new TrajectoryPointOptimizer(numberOfJoints);
        trajectoryPointOptimizer.setEndPoints(startPosition, startVelocity, targetPosition, targetVelocity);
        trajectoryPointOptimizer.setWaypoints(waypoints);
        trajectoryPointOptimizer.computeForFixedTime(this.waypointTimes);
        WholeBodyJointspaceTrajectoryMessage message = new WholeBodyJointspaceTrajectoryMessage();
        for (int jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
            message.getJointHashCodes().add(this.oneDoFJoints[jointIndex].hashCode());
            OneDoFJointTrajectoryMessage jointTrajectory = (OneDoFJointTrajectoryMessage)message.getJointTrajectoryMessages().add();
            TrajectoryPoint1DMessage startTrajectoryPoint = (TrajectoryPoint1DMessage)jointTrajectory.getTrajectoryPoints().add();
            startTrajectoryPoint.setTime(0.0);
            startTrajectoryPoint.setPosition(startPosition.get(jointIndex));
            startTrajectoryPoint.setVelocity(startVelocity.get(jointIndex));
            for (int waypointIndex = 0; waypointIndex < numberOfConfigurations - 2; ++waypointIndex) {
                TrajectoryPoint1DMessage trajectoryPoint = (TrajectoryPoint1DMessage)jointTrajectory.getTrajectoryPoints().add();
                double time = trajectoryPointOptimizer.getWaypointTime(waypointIndex) * totalTrajectoryTime;
                trajectoryPoint.setTime(time);
                trajectoryPoint.setPosition(((TDoubleArrayList)waypoints.get(waypointIndex)).get(jointIndex));
                trajectoryPoint.setVelocity(trajectoryPointOptimizer.getWaypointTime(waypointIndex) / totalTrajectoryTime);
            }
            TrajectoryPoint1DMessage targetTrajectoryPoint = (TrajectoryPoint1DMessage)jointTrajectory.getTrajectoryPoints().add();
            targetTrajectoryPoint.setTime(totalTrajectoryTime);
            targetTrajectoryPoint.setPosition(targetPosition.get(jointIndex));
            targetTrajectoryPoint.setVelocity(targetVelocity.get(jointIndex));
        }
        return message;
    }

    public WholeBodyJointspaceTrajectoryMessage process2(List<KinematicsToolboxSnapshotDescription> rawScript) {
        this.checkJointNameHash(rawScript);
        CenterOfMassCalculator centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)this.rootBody, ReferenceFrame.getWorldFrame());
        ArrayList<TDoubleArrayList> centroidalConfigurations = new ArrayList<TDoubleArrayList>();
        for (KinematicsToolboxSnapshotDescription item2 : rawScript) {
            KinematicsToolboxOutputStatus ikSolution = item2.getIkSolution();
            this.rootJoint.getJointPose().set((Tuple3DReadOnly)ikSolution.getDesiredRootPosition(), (Orientation3DReadOnly)ikSolution.getDesiredRootOrientation());
            for (int i = 0; i < ikSolution.getDesiredJointAngles().size(); ++i) {
                this.oneDoFJoints[i].setQ((double)ikSolution.getDesiredJointAngles().get(i));
            }
            this.rootBody.updateFramesRecursively();
            centerOfMassCalculator.reset();
            centroidalConfigurations.add(MultiContactScriptPostProcessor.toTDoubleArrayList(centerOfMassCalculator.getCenterOfMass().getX(), centerOfMassCalculator.getCenterOfMass().getY()));
        }
        int dimensions = 2;
        TrajectoryPointOptimizer trajectoryPointOptimizer = new TrajectoryPointOptimizer(dimensions);
        trajectoryPointOptimizer.setEndPoints((TDoubleArrayList)centroidalConfigurations.get(0), MultiContactScriptPostProcessor.zeros(dimensions), (TDoubleArrayList)centroidalConfigurations.get(centroidalConfigurations.size() - 1), MultiContactScriptPostProcessor.zeros(dimensions));
        trajectoryPointOptimizer.setWaypoints(centroidalConfigurations.subList(1, centroidalConfigurations.size() - 1));
        trajectoryPointOptimizer.compute();
        TDoubleArrayList waypointTimes = new TDoubleArrayList();
        trajectoryPointOptimizer.getWaypointTimes(waypointTimes);
        System.out.println(waypointTimes);
        List desiredRobotConfigurations = rawScript.stream().map(item -> item.getIkSolution()).collect(Collectors.toList());
        KinematicsToolboxOutputStatus startDesiredConfiguration = (KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(0);
        KinematicsToolboxOutputStatus targetDesiredConfiguration = (KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(desiredRobotConfigurations.size() - 1);
        int numberOfJoints = startDesiredConfiguration.getDesiredJointAngles().size();
        int numberOfConfigurations = desiredRobotConfigurations.size();
        TDoubleArrayList startPosition = MultiContactScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)startDesiredConfiguration.getDesiredJointAngles());
        TDoubleArrayList startVelocity = MultiContactScriptPostProcessor.zeros(numberOfJoints);
        TDoubleArrayList targetPosition = MultiContactScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)targetDesiredConfiguration.getDesiredJointAngles());
        TDoubleArrayList targetVelocity = MultiContactScriptPostProcessor.zeros(numberOfJoints);
        ArrayList<TDoubleArrayList> waypoints = new ArrayList<TDoubleArrayList>();
        for (int i = 1; i < desiredRobotConfigurations.size() - 1; ++i) {
            waypoints.add(MultiContactScriptPostProcessor.toTDoubleArrayList((TFloatArrayList)((KinematicsToolboxOutputStatus)desiredRobotConfigurations.get(i)).getDesiredJointAngles()));
        }
        trajectoryPointOptimizer = new TrajectoryPointOptimizer(numberOfJoints);
        trajectoryPointOptimizer.setEndPoints(startPosition, startVelocity, targetPosition, targetVelocity);
        trajectoryPointOptimizer.setWaypoints(waypoints);
        trajectoryPointOptimizer.computeForFixedTime(waypointTimes);
        WholeBodyJointspaceTrajectoryMessage message = new WholeBodyJointspaceTrajectoryMessage();
        double trajectoryTimeOffset = 0.0;
        double totalTrajectoryTime = 0.5 * (double)numberOfConfigurations;
        for (int jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
            message.getJointHashCodes().add(this.oneDoFJoints[jointIndex].hashCode());
            OneDoFJointTrajectoryMessage jointTrajectory = (OneDoFJointTrajectoryMessage)message.getJointTrajectoryMessages().add();
            TrajectoryPoint1DMessage startTrajectoryPoint = (TrajectoryPoint1DMessage)jointTrajectory.getTrajectoryPoints().add();
            startTrajectoryPoint.setTime(trajectoryTimeOffset);
            startTrajectoryPoint.setPosition(startPosition.get(jointIndex));
            startTrajectoryPoint.setVelocity(startVelocity.get(jointIndex));
            for (int waypointIndex = 0; waypointIndex < numberOfConfigurations - 2; ++waypointIndex) {
                TrajectoryPoint1DMessage trajectoryPoint = (TrajectoryPoint1DMessage)jointTrajectory.getTrajectoryPoints().add();
                trajectoryPoint.setTime(trajectoryTimeOffset + trajectoryPointOptimizer.getWaypointTime(waypointIndex) * totalTrajectoryTime);
                trajectoryPoint.setPosition(((TDoubleArrayList)waypoints.get(waypointIndex)).get(jointIndex));
                trajectoryPoint.setVelocity(trajectoryPointOptimizer.getWaypointTime(waypointIndex) / totalTrajectoryTime);
            }
            TrajectoryPoint1DMessage targetTrajectoryPoint = (TrajectoryPoint1DMessage)jointTrajectory.getTrajectoryPoints().add();
            targetTrajectoryPoint.setTime(trajectoryTimeOffset + totalTrajectoryTime);
            targetTrajectoryPoint.setPosition(targetPosition.get(jointIndex));
            targetTrajectoryPoint.setVelocity(targetVelocity.get(jointIndex));
        }
        return message;
    }

    private void checkJointNameHash(List<KinematicsToolboxSnapshotDescription> rawScript) {
        for (KinematicsToolboxSnapshotDescription item : rawScript) {
            if (item.getIkSolution().getJointNameHash() == this.jointNameHash) continue;
            throw new IllegalArgumentException("Incompatible script");
        }
    }

    private void computeRegularizedWaypointTimes(List<KinematicsToolboxSnapshotDescription> script) {
        this.waypointTimes.clear();
        double trajectoryDuration = 0.0;
        for (int i = 0; i < script.size(); ++i) {
            trajectoryDuration += script.get(i).getExecutionDuration();
        }
        double runningTotal = 0.0;
        for (int i = 0; i < script.size() - 1; ++i) {
            this.waypointTimes.add((runningTotal += script.get(i).getExecutionDuration()) / trajectoryDuration);
        }
    }

    private static TDoubleArrayList toTDoubleArrayList(double ... values) {
        return new TDoubleArrayList(values);
    }

    private static TDoubleArrayList toTDoubleArrayList(TFloatArrayList input) {
        TDoubleArrayList output = new TDoubleArrayList(input.size());
        for (int i = 0; i < input.size(); ++i) {
            output.add((double)input.get(i));
        }
        return output;
    }

    private static TDoubleArrayList zeros(int size) {
        TDoubleArrayList output = new TDoubleArrayList(size);
        for (int i = 0; i < size; ++i) {
            output.add(0.0);
        }
        return output;
    }
}

