/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ihmc_common_msgs.msg.dds.Box3DMessage;
import ihmc_common_msgs.msg.dds.Box3DMessagePubSubType;
import ihmc_common_msgs.msg.dds.Capsule3DMessage;
import ihmc_common_msgs.msg.dds.Capsule3DMessagePubSubType;
import ihmc_common_msgs.msg.dds.ConvexPolytope3DMessage;
import ihmc_common_msgs.msg.dds.ConvexPolytope3DMessagePubSubType;
import ihmc_common_msgs.msg.dds.Cylinder3DMessage;
import ihmc_common_msgs.msg.dds.Cylinder3DMessagePubSubType;
import ihmc_common_msgs.msg.dds.Ellipsoid3DMessage;
import ihmc_common_msgs.msg.dds.Ellipsoid3DMessagePubSubType;
import ihmc_common_msgs.msg.dds.Ramp3DMessage;
import ihmc_common_msgs.msg.dds.Ramp3DMessagePubSubType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FrameCapsule3D;
import us.ihmc.euclid.referenceFrame.FrameCylinder3D;
import us.ihmc.euclid.referenceFrame.FrameEllipsoid3D;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.FrameConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DBasics;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;

public class MultiContactEnvironmentDescription {
    public static final String ENVIRONMENT_JSON = "environment";
    private static final ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
    private static final JSONSerializer<Box3DMessage> boxSerializer = new JSONSerializer((TopicDataType)new Box3DMessagePubSubType());
    private static final JSONSerializer<Capsule3DMessage> capsuleSerializer = new JSONSerializer((TopicDataType)new Capsule3DMessagePubSubType());
    private static final JSONSerializer<ConvexPolytope3DMessage> polytopeSerializer = new JSONSerializer((TopicDataType)new ConvexPolytope3DMessagePubSubType());
    private static final JSONSerializer<Cylinder3DMessage> cylinderSerializer = new JSONSerializer((TopicDataType)new Cylinder3DMessagePubSubType());
    private static final JSONSerializer<Ellipsoid3DMessage> ellipsoidSerializer = new JSONSerializer((TopicDataType)new Ellipsoid3DMessagePubSubType());
    private static final JSONSerializer<Ramp3DMessage> rampSerializer = new JSONSerializer((TopicDataType)new Ramp3DMessagePubSubType());

    public static JsonNode toJSON(FrameShape3DReadOnly environmentShape) {
        try {
            if (environmentShape instanceof Box3DReadOnly) {
                return MultiContactEnvironmentDescription.messageToJSON(boxSerializer, MessageTools.createBox3DMessage((Box3DReadOnly)((Box3DReadOnly)environmentShape)));
            }
            if (environmentShape instanceof Capsule3DMessage) {
                return MultiContactEnvironmentDescription.messageToJSON(capsuleSerializer, MessageTools.createCapsule3DMessage((Capsule3DReadOnly)((Capsule3DReadOnly)environmentShape)));
            }
            if (environmentShape instanceof ConvexPolytope3DReadOnly) {
                return MultiContactEnvironmentDescription.messageToJSON(polytopeSerializer, MessageTools.createConvexPolytope3DMessage((ConvexPolytope3DReadOnly)((ConvexPolytope3DReadOnly)environmentShape)));
            }
            throw new RuntimeException("Shape type not supported: " + environmentShape.getClass().getSimpleName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FrameShape3DBasics fromJSON(JsonNode jsonNode) {
        try {
            ObjectNode environmentShape = (ObjectNode)jsonNode;
            String messageClassName = MultiContactEnvironmentDescription.getMessageClassName(environmentShape);
            if (messageClassName.equals(Box3DMessage.class.getSimpleName())) {
                FrameBox3D box = new FrameBox3D(ReferenceFrame.getWorldFrame());
                MessageTools.unpackBox3DMessage((Box3DMessage)((Box3DMessage)boxSerializer.deserialize(environmentShape.toString())), (Box3DBasics)box);
                return box;
            }
            if (messageClassName.equals(Capsule3DMessage.class.getSimpleName())) {
                FrameCapsule3D capsule = new FrameCapsule3D(ReferenceFrame.getWorldFrame());
                MessageTools.unpackCapsule3DMessage((Capsule3DMessage)((Capsule3DMessage)capsuleSerializer.deserialize(environmentShape.toString())), (Capsule3DBasics)capsule);
                return capsule;
            }
            if (messageClassName.equals(ConvexPolytope3DMessage.class.getSimpleName())) {
                FrameConvexPolytope3D polytope = new FrameConvexPolytope3D(ReferenceFrame.getWorldFrame());
                MessageTools.unpackConvexPolytope3DMessage((ConvexPolytope3DMessage)((ConvexPolytope3DMessage)polytopeSerializer.deserialize(environmentShape.toString())), (FrameConvexPolytope3D)polytope);
                return polytope;
            }
            if (messageClassName.equals(Cylinder3DMessage.class.getSimpleName())) {
                FrameCylinder3D cylinder = new FrameCylinder3D(ReferenceFrame.getWorldFrame());
                MessageTools.unpackCylinder3DMessage((Cylinder3DMessage)((Cylinder3DMessage)cylinderSerializer.deserialize(environmentShape.toString())), (Cylinder3DBasics)cylinder);
                return cylinder;
            }
            if (messageClassName.equals(Ellipsoid3DMessage.class.getSimpleName())) {
                FrameEllipsoid3D ellipsoid = new FrameEllipsoid3D(ReferenceFrame.getWorldFrame());
                MessageTools.unpackEllipsoid3DMessage((Ellipsoid3DMessage)((Ellipsoid3DMessage)ellipsoidSerializer.deserialize(environmentShape.toString())), (Ellipsoid3DBasics)ellipsoid);
                return ellipsoid;
            }
            if (messageClassName.equals(Ramp3DMessage.class.getSimpleName())) {
                FrameRamp3D ramp = new FrameRamp3D(ReferenceFrame.getWorldFrame());
                MessageTools.unpackRamp3DMessage((Ramp3DMessage)((Ramp3DMessage)rampSerializer.deserialize(environmentShape.toString())), (Ramp3DBasics)ramp);
                return ramp;
            }
            throw new RuntimeException("Unknown shape message: " + messageClassName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> JsonNode messageToJSON(JSONSerializer<T> serializer, T message) throws IOException {
        return objectMapper.readTree(serializer.serializeToString(message));
    }

    private static FrameShape3DReadOnly stringToShape(String serializedMessage) throws IOException {
        JsonNode jsonNode = objectMapper.readTree(serializedMessage);
        return MultiContactEnvironmentDescription.fromJSON(jsonNode);
    }

    private static String getMessageClassName(ObjectNode jsonNode) {
        String field = (String)jsonNode.fieldNames().next();
        String[] messagePath = field.split("::");
        String messageNameWithUnderbar = messagePath[messagePath.length - 1];
        return messageNameWithUnderbar.substring(0, messageNameWithUnderbar.length() - 1);
    }

    public static String serializeEnvironmentData(List<FrameShape3DReadOnly> environmentShapes) {
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (int i = 0; i < environmentShapes.size(); ++i) {
            arrayNode.add(MultiContactEnvironmentDescription.toJSON(environmentShapes.get(i)));
        }
        return arrayNode.toString();
    }

    public static List<FrameShape3DBasics> deserializeEnvironmentData(String serializedEnvironmentData) {
        try {
            ArrayNode arrayNode = (ArrayNode)objectMapper.readTree(serializedEnvironmentData);
            ArrayList<FrameShape3DBasics> environmentData = new ArrayList<FrameShape3DBasics>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                environmentData.add(MultiContactEnvironmentDescription.fromJSON(arrayNode.get(i)));
            }
            return environmentData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

