/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.FramePlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionsListLogger {
    private final String logName;
    private final int maxTicksToRecord;
    private boolean started = false;
    private OutputStream out = null;
    private BufferedWriter writer = null;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final String logDirectory = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "logs" + File.separator;

    public static String getLogDirectory() {
        return logDirectory;
    }

    public PlanarRegionsListLogger(String logName, int maxTicksToRecord) {
        this.logName = logName;
        this.maxTicksToRecord = maxTicksToRecord;
    }

    public void start() {
        LogTools.info((String)"Storing PlanarRegionLog File at: {}", (Object)(logDirectory + dateFormat.format(new Date()) + "_" + this.getClass().getSimpleName() + ".prllog"));
        File file = new File(logDirectory + dateFormat.format(new Date()) + "_" + this.getClass().getSimpleName() + ".prllog");
        try {
            this.out = new FileOutputStream(file);
            this.writer = new BufferedWriter(new OutputStreamWriter(this.out));
        }
        catch (IOException ioException) {
            LogTools.error((String)"Could not start PlanarRegionsListLogger!");
            LogTools.error((String)ioException.getMessage());
            for (StackTraceElement element : ioException.getStackTrace()) {
                LogTools.error((String)element.toString());
            }
            return;
        }
        try {
            this.writer.write("PlanarRegionsListLogger (PRLLOG) file\n");
            this.writer.write("Name: " + this.logName + "\n");
            this.writer.write("Generated on " + dateFormat.format(new Date()) + "\n");
            this.writer.write("Generated by " + new Throwable().getStackTrace()[1].getClassName() + "\n");
            this.writer.flush();
        }
        catch (IOException ioException) {
            LogTools.error((String)ioException.getMessage());
        }
        LogTools.info((String)"Started PlanarRegionsListLogger");
        this.started = true;
    }

    public void update(long time, PlanarRegionsList list) {
        if (!this.started) {
            return;
        }
        try {
            this.writer.write("##\n");
            this.writer.write(time + "\n");
            this.writer.flush();
            PlanarRegionFileTools.exportPlanarRegionDataToStream((OutputStream)this.out, (PlanarRegionsList)list);
        }
        catch (IOException ioException) {
            LogTools.error((String)"Failed to write to planar regions log");
            LogTools.error((String)ioException.getMessage());
        }
    }

    public void update(long time, FramePlanarRegionsList frameRegions) {
        if (!this.started) {
            return;
        }
        try {
            this.writer.write("##\n");
            this.writer.write(time + "\n");
            this.writer.flush();
            PlanarRegionFileTools.exportFramePlanarRegionDataToStream((OutputStream)this.out, (FramePlanarRegionsList)frameRegions);
        }
        catch (IOException ioException) {
            LogTools.error((String)"Failed to write to planar regions log");
            LogTools.error((String)ioException.getMessage());
        }
    }

    public void finalize() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

