/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logging;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import us.ihmc.commons.ContinuousIntegrationTools;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.idl.serializers.extra.YAMLSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.HandshakePubSubType;
import us.ihmc.robotDataLogger.JointDefinition;
import us.ihmc.robotDataLogger.JointType;
import us.ihmc.robotDataLogger.VariableChangedMessage;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.handshake.YoVariableHandShakeBuilder;
import us.ihmc.robotDataLogger.jointState.JointHolder;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.robotDataLogger.logger.LogPropertiesWriter;
import us.ihmc.tools.compression.SnappyUtils;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class IntraprocessYoVariableLogger {
    private static final String INTRAPROCESS_LOG_POSTFIX = "_IntraprocessLogger";
    public static final String PROPERTY_FILE = "robotData.log";
    public static final String HANDSHAKE_FILENAME = "handshake.yaml";
    public static final String DATA_FILENAME = "robotData.bsz";
    public static final String MODEL_FILENAME = "model.sdf";
    public static final String MODEL_RESOURCE_BUNDLE = "resources.zip";
    public static final String INDEX_FILENAME = "robotData.dat";
    public static final String SUMMARY_FILENAME = "summary.csv";
    public static final Path DEFAULT_INCOMING_LOGS_DIRECTORY;
    private final String logName;
    private final LogModelProvider logModelProvider;
    private final List<RegistrySendBufferBuilder> registrySendBufferBuilders;
    private final int maxTicksToRecord;
    private final double dt;
    private final Path incomingLogsFolder;
    private String timestamp;
    private Path logFolder;
    private ByteBuffer compressedBuffer;
    private ByteBuffer indexBuffer = ByteBuffer.allocate(16);
    private ArrayList<YoVariable> variables = new ArrayList();
    private List<JointHolder> jointHolders;
    private ByteBuffer dataBuffer;
    private LongBuffer dataBufferAsLong;
    private FileChannel dataChannel;
    private FileChannel indexChannel;
    private volatile boolean shutdown = false;
    private static final int CHANGED_BUFFER_CAPACITY = 128;
    private ConcurrentRingBuffer<VariableChangedMessage> variableChanged = new ConcurrentRingBuffer((Builder)new VariableChangedMessage.Builder(), 128);

    public IntraprocessYoVariableLogger(String logName, LogModelProvider logModelProvider, YoRegistry registry, RigidBodyBasics rootBody, YoGraphicsListRegistry yoGraphicsListRegistry, int maxTicksToRecord, double dt) {
        this(logName, logModelProvider, Lists.newArrayList((Object[])new RegistrySendBufferBuilder[]{new RegistrySendBufferBuilder(registry, rootBody, yoGraphicsListRegistry)}), maxTicksToRecord, dt);
    }

    public IntraprocessYoVariableLogger(String logName, YoRegistry registry, int maxTicksToRecord, double dt) {
        this(logName, null, Lists.newArrayList((Object[])new RegistrySendBufferBuilder[]{new RegistrySendBufferBuilder(registry)}), maxTicksToRecord, dt);
    }

    public IntraprocessYoVariableLogger(String logName, LogModelProvider logModelProvider, List<RegistrySendBufferBuilder> registrySendBufferBuilders, int maxTicksToRecord, double dt) {
        this.logName = logName;
        this.logModelProvider = logModelProvider;
        this.registrySendBufferBuilders = registrySendBufferBuilders;
        this.maxTicksToRecord = maxTicksToRecord;
        this.dt = dt;
        this.incomingLogsFolder = DEFAULT_INCOMING_LOGS_DIRECTORY;
    }

    public void start() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        Calendar calendar = Calendar.getInstance();
        this.timestamp = dateFormat.format(calendar.getTime());
        this.logFolder = this.incomingLogsFolder.resolve(this.timestamp + INTRAPROCESS_LOG_POSTFIX);
        this.deleteOldLogs(this.incomingLogsFolder, 10);
        YoVariableHandShakeBuilder handshakeBuilder = new YoVariableHandShakeBuilder("main", this.dt);
        handshakeBuilder.setFrames(ReferenceFrame.getWorldFrame());
        for (RegistrySendBufferBuilder registrySendBufferBuilder : this.registrySendBufferBuilders) {
            handshakeBuilder.addRegistryBuffer(registrySendBufferBuilder);
        }
        Handshake handshake = handshakeBuilder.getHandShake();
        try {
            YAMLSerializer serializer = new YAMLSerializer((TopicDataType)new HandshakePubSubType());
            serializer.serialize(this.createFileInLogFolder(HANDSHAKE_FILENAME), (Object)handshake);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogPropertiesWriter logProperties = new LogPropertiesWriter(this.createFileInLogFolder(PROPERTY_FILE));
        logProperties.getVariables().setHandshake(HANDSHAKE_FILENAME);
        logProperties.getVariables().setData(DATA_FILENAME);
        logProperties.getVariables().setCompressed(true);
        logProperties.getVariables().setTimestamped(true);
        logProperties.getVariables().setIndex(INDEX_FILENAME);
        logProperties.getVariables().setHandshakeFileType(HandshakeFileType.IDL_YAML);
        logProperties.setName(this.logName);
        logProperties.setTimestamp(this.timestamp);
        if (this.logModelProvider != null) {
            logProperties.getModel().setLoader(this.logModelProvider.getLoader().getCanonicalName());
            logProperties.getModel().setName(this.logModelProvider.getModelName());
            for (String resourceDirectory : this.logModelProvider.getTopLevelResourceDirectories()) {
                logProperties.getModel().getResourceDirectoriesList().add(resourceDirectory);
            }
            logProperties.getModel().setPath(MODEL_FILENAME);
            logProperties.getModel().setResourceBundle(MODEL_RESOURCE_BUNDLE);
            File modelFile = this.createFileInLogFolder(MODEL_FILENAME);
            File resourceFile = this.createFileInLogFolder(MODEL_RESOURCE_BUNDLE);
            try {
                FileOutputStream modelStream = new FileOutputStream(modelFile, false);
                modelStream.write(this.logModelProvider.getModel());
                modelStream.getFD().sync();
                modelStream.close();
                FileOutputStream resourceStream = new FileOutputStream(resourceFile, false);
                resourceStream.write(this.logModelProvider.getResourceZip());
                resourceStream.getFD().sync();
                resourceStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            logProperties.store();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int numberOfJointStates = 0;
        for (int i = 0; i < handshake.getJoints().size(); ++i) {
            JointDefinition joint = (JointDefinition)handshake.getJoints().get(i);
            numberOfJointStates += JointState.getNumberOfVariables((JointType)joint.getType());
        }
        int stateVariables = 1 + this.maxTicksToRecord + numberOfJointStates;
        int bufferSize = stateVariables * 8;
        this.dataBuffer = ByteBuffer.allocate(bufferSize);
        this.dataBufferAsLong = this.dataBuffer.asLongBuffer();
        this.compressedBuffer = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)bufferSize));
        for (RegistrySendBufferBuilder registrySendBufferBuilder : this.registrySendBufferBuilders) {
            this.variables.addAll(registrySendBufferBuilder.getYoRegistry().collectSubtreeVariables());
        }
        this.jointHolders = handshakeBuilder.getJointHolders();
        long numberOfYoGraphics = 0L;
        for (RegistrySendBufferBuilder registrySendBufferBuilder : this.registrySendBufferBuilders) {
            if (registrySendBufferBuilder.getSCS1YoGraphics() == null) continue;
            for (YoGraphicsList yoGraphicsList : registrySendBufferBuilder.getSCS1YoGraphics().getYoGraphicsLists()) {
                numberOfYoGraphics += (long)yoGraphicsList.getYoGraphics().size();
            }
        }
        LogTools.info((String)"Buffer size: {}", (Object)bufferSize);
        LogTools.info((String)"Number of YoVariables: {}", (Object)this.variables.size());
        LogTools.info((String)"Number of YoGraphics: {}", (Object)numberOfYoGraphics);
        LogTools.info((String)"Number of joint states: {}", (Object)numberOfJointStates);
        try {
            this.dataChannel = new FileOutputStream(this.createFileInLogFolder(DATA_FILENAME), false).getChannel();
            this.indexChannel = new FileOutputStream(this.createFileInLogFolder(INDEX_FILENAME), false).getChannel();
            this.dataChannel.force(true);
            this.indexChannel.force(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.shutdown = true;
            IntraprocessYoVariableLogger intraprocessYoVariableLogger = this;
            synchronized (intraprocessYoVariableLogger) {
                try {
                    LogTools.info((String)"Closing data channel...");
                    this.dataChannel.close();
                    LogTools.info((String)"Data channel closed.");
                    LogTools.info((String)"Closing index channel...");
                    this.indexChannel.close();
                    LogTools.info((String)"Index channel closed.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, this.getClass().getSimpleName() + "Shutdown"));
    }

    public synchronized void update(long timestamp) {
        if (this.shutdown) {
            LogTools.error((String)"Logger has already shutdown!");
            return;
        }
        this.dataBuffer.clear();
        this.dataBufferAsLong.clear();
        this.dataBufferAsLong.put(timestamp);
        for (int i = 0; i < this.variables.size(); ++i) {
            try {
                this.dataBufferAsLong.put(this.variables.get(i).getValueAsLongBits());
                continue;
            }
            catch (BufferOverflowException e) {
                LogTools.error((String)"Increase buffer size! yoVar # {}:  size: {}  {}", (Object)i, (Object)this.variables.size(), (Object)e.getMessage());
            }
        }
        double[] jointData = new double[13];
        for (JointHolder jointHolder : this.jointHolders) {
            jointHolder.get(jointData, 0);
            for (int i = 0; i < jointHolder.getNumberOfStateVariables(); ++i) {
                this.dataBufferAsLong.put(Double.doubleToLongBits(jointData[i]));
            }
        }
        this.dataBufferAsLong.flip();
        this.dataBuffer.position(0);
        this.dataBuffer.limit(this.dataBufferAsLong.limit() * 8);
        try {
            this.compressedBuffer.clear();
            SnappyUtils.compress((ByteBuffer)this.dataBuffer, (ByteBuffer)this.compressedBuffer);
            this.compressedBuffer.flip();
            this.indexBuffer.clear();
            this.indexBuffer.putLong(timestamp);
            this.indexBuffer.putLong(this.dataChannel.position());
            this.indexBuffer.flip();
            this.indexChannel.write(this.indexBuffer);
            this.dataChannel.write(this.compressedBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteOldLogs(Path incomingLogsFolder, int numberOflogsToKeep) {
        TreeSet<Path> sortedSet = new TreeSet<Path>(Comparator.comparing(path1 -> path1.getFileName().toString()));
        PathTools.walkFlat((Path)incomingLogsFolder, (path, type) -> {
            if (type == BasicPathVisitor.PathType.DIRECTORY && path.getFileName().toString().endsWith(INTRAPROCESS_LOG_POSTFIX)) {
                sortedSet.add(path);
            }
            return FileVisitResult.CONTINUE;
        });
        while (sortedSet.size() > numberOflogsToKeep) {
            Path earliestLogDirectory = (Path)sortedSet.first();
            LogTools.warn((String)"Deleting old log {}", (Object)earliestLogDirectory);
            FileTools.deleteQuietly((Path)earliestLogDirectory);
            sortedSet.remove(earliestLogDirectory);
        }
    }

    private File createFileInLogFolder(String filename) {
        FileTools.ensureDirectoryExists((Path)this.logFolder, (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        return this.logFolder.resolve(filename).toFile();
    }

    static {
        Path incomingLogsDirectory = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ihmc");
        if (!ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer()) {
            incomingLogsDirectory = incomingLogsDirectory.resolve("logs");
        }
        DEFAULT_INCOMING_LOGS_DIRECTORY = incomingLogsDirectory;
    }
}

