/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor.leRobot;

import gnu.trove.list.array.TIntArrayList;
import java.nio.file.Path;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetEpisodeStatistics;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.scs2.session.log.ZEDSVOScrubber;
import us.ihmc.zed.global.zed;

public class LeRobotDatasetVideoWriter {
    private final RobotSide side;
    private final FFmpegFrameRecorder recorder;
    private final ZEDSVOScrubber zedSVOScrubber;
    private final OpenCVFrameConverter.ToMat frameConverter = new OpenCVFrameConverter.ToMat();
    private final TIntArrayList redMeans = new TIntArrayList();

    public LeRobotDatasetVideoWriter(RobotSide side, Path mp4Path, ZEDSVOScrubber zedSVOScrubber) {
        this.side = side;
        this.zedSVOScrubber = zedSVOScrubber;
        this.recorder = new FFmpegFrameRecorder(mp4Path.toString(), 640, 480);
        this.recorder.setFormat("mp4");
        this.recorder.setPixelFormat(0);
        this.recorder.setFrameRate((double)zedSVOScrubber.getFps());
        this.recorder.setVideoBitrate(1352000);
        ExceptionTools.handle(() -> this.recorder.start(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public void writeFrame(long videoTimestampMs, LeRobotDatasetEpisodeStatistics statistics) {
        int imageHeight = this.zedSVOScrubber.getImageHeight();
        int imageWidth = this.zedSVOScrubber.getImageWidth();
        Pointer zedColorImageSLMatPointer = this.side == RobotSide.LEFT ? this.zedSVOScrubber.getLeftColorImageSlMatPointer() : this.zedSVOScrubber.getRightColorImageSlMatPointer();
        Mat bgra8Mat = new Mat(imageHeight, imageWidth, opencv_core.CV_8UC4, (Pointer)zed.sl_mat_get_ptr((Pointer)zedColorImageSLMatPointer, (int)0), (long)zed.sl_mat_get_step_bytes((Pointer)zedColorImageSLMatPointer, (int)0));
        Size size = new Size(853, 480);
        Mat resized = new Mat(size, opencv_core.CV_8UC4);
        opencv_imgproc.resize((Mat)bgra8Mat, (Mat)resized, (Size)size);
        size.close();
        int cropWidth = 640;
        int cropHeight = 480;
        int x = (resized.cols() - cropWidth) / 2;
        int y = (resized.rows() - cropHeight) / 2;
        Rect roi = new Rect(x, y, cropWidth, cropHeight);
        Mat cropped = new Mat(resized, roi);
        resized.close();
        statistics.submitFrame(this.side, cropped);
        opencv_imgproc.cvtColor((Mat)cropped, (Mat)cropped, (int)2);
        opencv_imgproc.cvtColor((Mat)cropped, (Mat)cropped, (int)3);
        Frame frame = this.frameConverter.convert(cropped);
        cropped.close();
        this.recorder.setTimestamp(videoTimestampMs);
        ExceptionTools.handle(() -> this.recorder.record(frame), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        frame.close();
    }

    public void close() {
        ExceptionTools.handle(() -> ((FFmpegFrameRecorder)this.recorder).stop(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        this.frameConverter.close();
    }
}

