/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor.leRobot;

import java.nio.file.Path;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.opencv_core.Mat;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;

public class LeRobotDatasetVideoReader {
    private final FFmpegFrameGrabber grabber;
    private final OpenCVFrameConverter.ToMat frameConverter = new OpenCVFrameConverter.ToMat();
    private Frame currentFrame;
    private long currentTimestamp = -1L;
    private boolean hasMoreFrames = true;

    public LeRobotDatasetVideoReader(Path mp4Path) {
        this.grabber = new FFmpegFrameGrabber(mp4Path.toFile());
        ExceptionTools.handle(() -> this.grabber.start(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public Mat readFrame() {
        try {
            this.currentFrame = this.grabber.grabFrame();
            this.currentTimestamp = this.grabber.getTimestamp();
            if (this.currentFrame != null) {
                return this.frameConverter.convert(this.currentFrame);
            }
            this.hasMoreFrames = false;
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error grabbing next frame", e);
        }
    }

    public long getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public boolean hasMoreFrames() {
        return this.hasMoreFrames;
    }

    public int getImageWidth() {
        return this.grabber.getImageWidth();
    }

    public int getImageHeight() {
        return this.grabber.getImageHeight();
    }

    public double getFrameRate() {
        return this.grabber.getFrameRate();
    }

    public int getLengthInFrames() {
        return this.grabber.getLengthInFrames();
    }

    public long getLengthInTime() {
        return this.grabber.getLengthInTime();
    }

    public void close() {
        if (this.currentFrame != null) {
            this.currentFrame.close();
            this.currentFrame = null;
        }
        ExceptionTools.handle(() -> ((FFmpegFrameGrabber)this.grabber).stop(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        ExceptionTools.handle(() -> ((FFmpegFrameGrabber)this.grabber).release(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        this.frameConverter.close();
    }
}

