/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor.leRobot;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jerolba.carpet.CarpetReader;
import com.jerolba.carpet.FieldMatchingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bytedeco.opencv.opencv_core.Mat;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetDataWriter;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetEpisodeStatistics;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetTools;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetVideoReader;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetVideoWriter;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotEpisodeRecord;
import us.ihmc.avatar.scs2.SCS2LogSessionWithVideo;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.UnitConversions;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.scs2.session.log.ZEDSVOScrubber;
import us.ihmc.tools.io.JSONFileTools;

public class LeRobotDatasetEpisode {
    private final int episodeIndex;
    private final String episodeName;
    private final String taskName;
    private final long datasetLengthSoFar;
    private final Path episodesJsonlPath;
    private final Path episodeStatsJsonlPath;
    private final Path dataChunk0Path;
    private final SideDependentList<Path> zedVideoDirs;
    private long length = 0L;
    private float fps;
    private SCS2LogSessionWithVideo session;
    private Runnable writeMetaJson;
    private Consumer<Runnable> frameProcessingQueue;
    private boolean usePerfectTimestamps;
    private long startVideoTimestamp;
    private long lastVideoTimestamp;
    private double episodeFrameTimestampMicros;
    private SideDependentList<LeRobotDatasetVideoWriter> ffmpegRecorders;
    private LeRobotDatasetDataWriter dataWriter;
    private LeRobotDatasetEpisodeStatistics statistics;
    private List<LeRobotEpisodeRecord> records = new ArrayList<LeRobotEpisodeRecord>();

    public LeRobotDatasetEpisode(int episodeIndex, String taskName, long length, long datasetLengthSoFar, Path episodesJsonlPath, Path episodeStatsJsonlPath, Path dataChunk0Path, SideDependentList<Path> zedVideoDirs) {
        this.episodeIndex = episodeIndex;
        this.taskName = taskName;
        this.length = length;
        this.datasetLengthSoFar = datasetLengthSoFar;
        this.episodesJsonlPath = episodesJsonlPath;
        this.episodeStatsJsonlPath = episodeStatsJsonlPath;
        this.dataChunk0Path = dataChunk0Path;
        this.zedVideoDirs = zedVideoDirs;
        this.episodeName = "episode_%06d".formatted(episodeIndex);
    }

    public void startGeneratingEpisode(SCS2LogSessionWithVideo session, Runnable writeMetaJson, Consumer<Runnable> frameProcessingQueue, boolean usePerfectTimestamps) {
        this.session = session;
        this.writeMetaJson = writeMetaJson;
        this.frameProcessingQueue = frameProcessingQueue;
        this.usePerfectTimestamps = usePerfectTimestamps;
        this.records.clear();
        int inPoint = session.getBufferProperties().getInPoint();
        double sessionDTSeconds = session.getSessionDTSeconds();
        LogTools.info((String)"Generating episode {}: dt: {}", (Object)this.episodeName, (Object)sessionDTSeconds);
        session.submitBufferIndexRequestAndWait(inPoint);
        ZEDSVOScrubber zedSVOScrubber = session.getZedSVOScrubbers().get(0);
        this.fps = zedSVOScrubber.getFps();
        this.ffmpegRecorders = new SideDependentList();
        for (RobotSide side : RobotSide.values) {
            this.ffmpegRecorders.put((Enum)side, (Object)new LeRobotDatasetVideoWriter(side, ((Path)this.zedVideoDirs.get((Enum)side)).resolve(this.episodeName + ".mp4"), zedSVOScrubber));
        }
        this.dataWriter = new LeRobotDatasetDataWriter(this.episodeIndex, this.datasetLengthSoFar, session.getRootRegistry());
        this.statistics = new LeRobotDatasetEpisodeStatistics();
        this.length = 0L;
        this.startVideoTimestamp = -1L;
        this.lastVideoTimestamp = -1L;
        this.episodeFrameTimestampMicros = -Math.round(UnitConversions.hertzToSeconds((double)this.fps));
        frameProcessingQueue.accept(this::processFrame);
    }

    private void processFrame() {
        int previousIndex = this.session.getBufferProperties().getCurrentIndex();
        this.session.playbackTick();
        int currentBufferIndex = this.session.getBufferProperties().getCurrentIndex();
        if (currentBufferIndex < previousIndex) {
            this.frameProcessingQueue.accept(this::finalizeEpisodeGeneration);
            return;
        }
        this.frameProcessingQueue.accept(this::processFrame);
        int inPoint = this.session.getBufferProperties().getInPoint();
        int outPoint = this.session.getBufferProperties().getOutPoint();
        System.out.printf("\rTraversing buffer: %d -> %d / %d", inPoint, currentBufferIndex, outPoint);
        long timestamp = this.session.getLogDataReader().getTimestamp().getLongValue();
        ZEDSVOScrubber zedSVOScrubber = this.session.getZedSVOScrubbers().get(0);
        zedSVOScrubber.scrub(timestamp);
        long currentVideoTimestamp = zedSVOScrubber.getTimestampScrubber().getCurrentVideoTimestamp();
        if (this.startVideoTimestamp < 0L) {
            this.startVideoTimestamp = currentVideoTimestamp;
        }
        if (currentVideoTimestamp > this.lastVideoTimestamp) {
            double frequency = this.lastVideoTimestamp >= 0L ? Conversions.secondsToHertz((double)Conversions.nanosecondsToSeconds((long)(currentVideoTimestamp - this.lastVideoTimestamp))) : Double.NaN;
            this.lastVideoTimestamp = currentVideoTimestamp;
            if (this.usePerfectTimestamps) {
                int round = Math.round(this.fps);
                double seconds = UnitConversions.hertzToSeconds((double)round);
                double micros = seconds * 1000000.0;
                this.episodeFrameTimestampMicros += micros;
            } else {
                this.episodeFrameTimestampMicros = Math.round((double)(currentVideoTimestamp - this.startVideoTimestamp) / 1000.0);
            }
            long roundedTimestamp = Math.round(this.episodeFrameTimestampMicros);
            for (RobotSide side : RobotSide.values) {
                ((LeRobotDatasetVideoWriter)this.ffmpegRecorders.get((Enum)side)).writeFrame(roundedTimestamp, this.statistics);
            }
            this.records.add(this.dataWriter.addFrame(roundedTimestamp, this.length, this.statistics, this.session.getLogDataReader().getCurrentLogPosition()));
            ++this.length;
        }
    }

    private void finalizeEpisodeGeneration() {
        System.out.println();
        LogTools.info((String)"Wrote episode with %d frames.".formatted(this.length));
        for (RobotSide side : RobotSide.values) {
            ((LeRobotDatasetVideoWriter)this.ffmpegRecorders.get((Enum)side)).close();
        }
        Path parquetPath = this.dataChunk0Path.resolve(this.episodeName + ".parquet");
        this.dataWriter.writeFile(parquetPath);
        this.writeEpisodeJsonlLine();
        this.writeMetaJson.run();
        this.statistics.calculate();
        this.writeStatsJsonlLine(this.statistics);
    }

    public void writeEpisodeJsonlLine() {
        LeRobotDatasetTools.appendLine(this.episodesJsonlPath, JSONFileTools.getAsSingleLine(node -> {
            node.put("episode_index", this.episodeIndex);
            ArrayNode tasksArray = node.putArray("tasks");
            tasksArray.add(this.taskName);
            node.put("length", this.length);
        }));
    }

    private void writeStatsJsonlLine(LeRobotDatasetEpisodeStatistics statistics) {
        LeRobotDatasetTools.appendLine(this.episodeStatsJsonlPath, JSONFileTools.getAsSingleLine(node -> {
            node.put("episode_index", this.episodeIndex);
            ObjectNode stats = node.putObject("stats");
            statistics.writeJson(stats, this.zedVideoDirs);
        }));
    }

    public void readDataAndWriteStatisticsJsonlLine() {
        LeRobotDatasetEpisodeStatistics statistics = new LeRobotDatasetEpisodeStatistics();
        for (RobotSide side : RobotSide.values) {
            Path videoPath = ((Path)this.zedVideoDirs.get((Enum)side)).resolve(this.episodeName + ".mp4");
            LogTools.info((String)"Reading video from: %s".formatted(videoPath));
            LeRobotDatasetVideoReader videoReader = new LeRobotDatasetVideoReader(videoPath);
            Mat bgrMat = videoReader.readFrame();
            while (bgrMat != null) {
                statistics.submitFrame(side, bgrMat);
                bgrMat = videoReader.readFrame();
            }
            videoReader.close();
        }
        this.loadParquetData();
        for (LeRobotEpisodeRecord record : this.records) {
            statistics.processParquetRecord(record);
        }
        statistics.calculate();
        this.writeStatsJsonlLine(statistics);
    }

    public void loadParquetData() {
        Path parquetPath = this.dataChunk0Path.resolve(this.episodeName + ".parquet");
        LogTools.info((String)"Reading parquet data from: %s".formatted(parquetPath));
        try {
            File parquetFile = parquetPath.toFile();
            CarpetReader carpetReader = new CarpetReader(parquetFile, LeRobotEpisodeRecord.class).withFieldMatchingStrategy(FieldMatchingStrategy.SNAKE_CASE).withFailOnMissingColumn(false);
            this.records.clear();
            this.records.addAll(carpetReader.toList());
            LogTools.info((String)"Read %d records from parquet file".formatted(this.records.size()));
        }
        catch (IOException e) {
            LogTools.error((String)("Failed to read parquet file: " + e.getMessage()));
        }
    }

    public void writeParquetData() {
        Path parquetPath = this.dataChunk0Path.resolve(this.episodeName + ".parquet");
        LogTools.info((String)"Writing parquet data to: %s".formatted(parquetPath));
        LeRobotDatasetDataWriter.writeParquetFile(parquetPath, this.records);
    }

    public List<LeRobotEpisodeRecord> getRecords() {
        return this.records;
    }

    public String getEpisodeName() {
        return this.episodeName;
    }

    public int getLength() {
        return (int)this.length;
    }

    public float getFps() {
        return this.fps;
    }
}

